﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ecs/ECS_EXPORTS.h>
#include <aws/ecs/model/ManagedAgentName.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ECS {
namespace Model {

/**
 * <p>An object representing a change in state for a managed agent.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/ManagedAgentStateChange">AWS
 * API Reference</a></p>
 */
class ManagedAgentStateChange {
 public:
  AWS_ECS_API ManagedAgentStateChange() = default;
  AWS_ECS_API ManagedAgentStateChange(Aws::Utils::Json::JsonView jsonValue);
  AWS_ECS_API ManagedAgentStateChange& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ECS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the container that's associated with the managed agent.</p>
   */
  inline const Aws::String& GetContainerName() const { return m_containerName; }
  inline bool ContainerNameHasBeenSet() const { return m_containerNameHasBeenSet; }
  template <typename ContainerNameT = Aws::String>
  void SetContainerName(ContainerNameT&& value) {
    m_containerNameHasBeenSet = true;
    m_containerName = std::forward<ContainerNameT>(value);
  }
  template <typename ContainerNameT = Aws::String>
  ManagedAgentStateChange& WithContainerName(ContainerNameT&& value) {
    SetContainerName(std::forward<ContainerNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the managed agent.</p>
   */
  inline ManagedAgentName GetManagedAgentName() const { return m_managedAgentName; }
  inline bool ManagedAgentNameHasBeenSet() const { return m_managedAgentNameHasBeenSet; }
  inline void SetManagedAgentName(ManagedAgentName value) {
    m_managedAgentNameHasBeenSet = true;
    m_managedAgentName = value;
  }
  inline ManagedAgentStateChange& WithManagedAgentName(ManagedAgentName value) {
    SetManagedAgentName(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the managed agent.</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  ManagedAgentStateChange& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The reason for the status of the managed agent.</p>
   */
  inline const Aws::String& GetReason() const { return m_reason; }
  inline bool ReasonHasBeenSet() const { return m_reasonHasBeenSet; }
  template <typename ReasonT = Aws::String>
  void SetReason(ReasonT&& value) {
    m_reasonHasBeenSet = true;
    m_reason = std::forward<ReasonT>(value);
  }
  template <typename ReasonT = Aws::String>
  ManagedAgentStateChange& WithReason(ReasonT&& value) {
    SetReason(std::forward<ReasonT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_containerName;

  ManagedAgentName m_managedAgentName{ManagedAgentName::NOT_SET};

  Aws::String m_status;

  Aws::String m_reason;
  bool m_containerNameHasBeenSet = false;
  bool m_managedAgentNameHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_reasonHasBeenSet = false;
};

}  // namespace Model
}  // namespace ECS
}  // namespace Aws
