﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/s3control/S3Control_EXPORTS.h>
#include <aws/s3control/model/ListAccessGrantEntry.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace S3Control {
namespace Model {
class ListAccessGrantsResult {
 public:
  AWS_S3CONTROL_API ListAccessGrantsResult() = default;
  AWS_S3CONTROL_API ListAccessGrantsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_S3CONTROL_API ListAccessGrantsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>A pagination token to request the next page of results. Pass this value into
   * a subsequent <code>List Access Grants</code> request in order to retrieve the
   * next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListAccessGrantsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A container for a list of grants in an S3 Access Grants instance.</p>
   */
  inline const Aws::Vector<ListAccessGrantEntry>& GetAccessGrantsList() const { return m_accessGrantsList; }
  template <typename AccessGrantsListT = Aws::Vector<ListAccessGrantEntry>>
  void SetAccessGrantsList(AccessGrantsListT&& value) {
    m_accessGrantsListHasBeenSet = true;
    m_accessGrantsList = std::forward<AccessGrantsListT>(value);
  }
  template <typename AccessGrantsListT = Aws::Vector<ListAccessGrantEntry>>
  ListAccessGrantsResult& WithAccessGrantsList(AccessGrantsListT&& value) {
    SetAccessGrantsList(std::forward<AccessGrantsListT>(value));
    return *this;
  }
  template <typename AccessGrantsListT = ListAccessGrantEntry>
  ListAccessGrantsResult& AddAccessGrantsList(AccessGrantsListT&& value) {
    m_accessGrantsListHasBeenSet = true;
    m_accessGrantsList.emplace_back(std::forward<AccessGrantsListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * AWS Request Id value
   */
  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListAccessGrantsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * x-amz-id-2 header value, also known as Host Id
   */
  inline const Aws::String& GetHostId() const { return m_hostId; }
  template <typename HostIdT = Aws::String>
  void SetHostId(HostIdT&& value) {
    m_hostIdHasBeenSet = true;
    m_hostId = std::forward<HostIdT>(value);
  }
  template <typename HostIdT = Aws::String>
  ListAccessGrantsResult& WithHostId(HostIdT&& value) {
    SetHostId(std::forward<HostIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<ListAccessGrantEntry> m_accessGrantsList;

  Aws::String m_requestId;

  Aws::String m_hostId;
  bool m_nextTokenHasBeenSet = false;
  bool m_accessGrantsListHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
  bool m_hostIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace S3Control
}  // namespace Aws
