/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDDataReceiverInteractive;
import org.jkiss.dbeaver.model.sql.SQLParametersProviderBase;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorFeatures;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLQueryParameterBindDialog;

public class SQLEditorParametersProvider
extends SQLParametersProviderBase {
    private final IWorkbenchPartSite site;

    public SQLEditorParametersProvider(IWorkbenchPartSite site) {
        this.site = site;
    }

    @Nullable
    protected Boolean collectAndAssignVariables(@NotNull SQLScriptContext scriptContext, @NotNull SQLQuery sqlStatement, @NotNull List<SQLQueryParameter> parameters, @NotNull Supplier<DBDDataReceiver> dataReceiverSupplier) {
        int paramsResult = (Integer)UITask.run(() -> {
            SQLQueryParameterBindDialog dialog = new SQLQueryParameterBindDialog(this.site, sqlStatement, parameters);
            DBDDataReceiver dataReceiver = (DBDDataReceiver)dataReceiverSupplier.get();
            try {
                if (dataReceiver instanceof DBDDataReceiverInteractive) {
                    DBDDataReceiverInteractive dri = (DBDDataReceiverInteractive)dataReceiver;
                    dri.setDataReceivePaused(true);
                }
                Integer n = dialog.open();
                return n;
            }
            finally {
                if (dataReceiver instanceof DBDDataReceiverInteractive) {
                    DBDDataReceiverInteractive dri = (DBDDataReceiverInteractive)dataReceiver;
                    dri.setDataReceivePaused(false);
                }
            }
        });
        if (paramsResult == 0) {
            for (SQLQueryParameter param : parameters) {
                if (!param.isNamed()) continue;
                String strValue = param.getValue();
                if (scriptContext.hasVariable(param.getName())) {
                    scriptContext.setVariable(param.getName(), (Object)strValue);
                    continue;
                }
                if (scriptContext.hasVariable(param.getVarName())) {
                    scriptContext.setVariable(param.getVarName(), (Object)strValue);
                    continue;
                }
                scriptContext.setParameterDefaultValue(param.getName(), (Object)strValue);
            }
            SQLEditorFeatures.SQL_EDITOR_QUERY_PARAMS.use();
            return true;
        }
        if (paramsResult == 9) {
            scriptContext.setIgnoreParameters(true);
            return null;
        }
        return false;
    }
}

