/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.PostgreUIUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreBackupAllSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupAllInfo;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupAllWizard;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeToolWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeToolWizardPage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreBackupAllWizardPageObjects
extends AbstractNativeToolWizardPage<PostgreBackupAllWizard> {
    private Table databasesTable;
    private PostgreDataSource dataSource;
    private Set<PostgreDatabase> checkedObjects = new HashSet<PostgreDatabase>();

    protected PostgreBackupAllWizardPageObjects(PostgreBackupAllWizard wizard) {
        super((AbstractNativeToolWizard)wizard, PostgreMessages.wizard_backup_all_page_global_backup_name);
        this.setTitle(PostgreMessages.wizard_backup_page_object_title);
        this.setDescription(PostgreMessages.wizard_backup_all_page_global_backup_tip);
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Composite objectsGroup = UIUtils.createTitledComposite((Composite)composite, (String)PostgreMessages.wizard_backup_page_object_group_object, (int)1, (int)768);
        objectsGroup.setLayoutData((Object)new GridData(1808));
        this.connInfo = new CLabel(objectsGroup, 64);
        this.connInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.connInfo.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.DATABASE_DEFAULT));
        Composite catPanel = UIUtils.createComposite((Composite)objectsGroup, (int)1);
        catPanel.setLayoutData((Object)new GridData(1808));
        this.databasesTable = new Table(catPanel, 2080);
        this.databasesTable.addListener(13, event -> {
            TableItem item = (TableItem)event.item;
            if (event.detail == 32) {
                this.databasesTable.select(this.databasesTable.indexOf(item));
            }
            this.updateState();
        });
        GridData gd = new GridData(1808);
        this.databasesTable.setLayoutData((Object)gd);
        Composite buttonsPanel = UIUtils.createComposite((Composite)catPanel, (int)3);
        buttonsPanel.setLayoutData((Object)new GridData(768));
        new Label(buttonsPanel, 0).setLayoutData((Object)new GridData(512));
        this.createCheckButtons(buttonsPanel, this.databasesTable);
        PostgreUIUtils.addCompatibilityInfoLabelForForks(composite, this.wizard, this.dataSource);
        this.setControl((Control)composite);
    }

    protected boolean determinePageCompletion() {
        boolean complete = false;
        if (!this.checkedObjects.isEmpty()) {
            complete = true;
        }
        for (TableItem item : this.databasesTable.getItems()) {
            if (!item.getChecked()) continue;
            complete = true;
            break;
        }
        return complete && super.determinePageCompletion();
    }

    public void activatePage() {
        super.activatePage();
        this.loadSettings();
        this.updateState();
    }

    public void deactivatePage() {
        this.saveState();
    }

    private void loadSettings() {
        this.checkedObjects.clear();
        this.databasesTable.removeAll();
        HashSet activeDatabases = new HashSet();
        for (PostgreDatabaseBackupAllInfo info : ((PostgreBackupAllSettings)((PostgreBackupAllWizard)this.wizard).getSettings()).getExportObjects()) {
            this.dataSource = info.getDataSource();
            List databases = info.getDatabases();
            if (CommonUtils.isEmpty((Collection)databases)) continue;
            activeDatabases.addAll(databases);
        }
        if (this.dataSource != null) {
            this.setConnectionInfo(this.dataSource.getContainer(), null);
            for (PostgreDatabase database : this.dataSource.getDatabases()) {
                TableItem item = new TableItem(this.databasesTable, 0);
                item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_DATABASE));
                item.setText(0, database.getName());
                item.setData((Object)database);
                if (!activeDatabases.contains(database)) continue;
                item.setChecked(true);
                this.databasesTable.select(this.databasesTable.indexOf(item));
            }
        }
    }

    public void saveState() {
        super.saveState();
        List objects = ((PostgreBackupAllSettings)((PostgreBackupAllWizard)this.wizard).getSettings()).getExportObjects();
        objects.clear();
        ArrayList<PostgreDatabase> databases = new ArrayList<PostgreDatabase>();
        for (TableItem item : this.databasesTable.getItems()) {
            PostgreDatabase database;
            if (!item.getChecked() || databases.contains(database = (PostgreDatabase)item.getData())) continue;
            databases.add(database);
        }
        PostgreDatabaseBackupAllInfo info = new PostgreDatabaseBackupAllInfo(this.dataSource, databases);
        objects.add(info);
    }

    protected void updateState() {
        this.updatePageCompletion();
        this.getContainer().updateButtons();
    }

    protected void updateTableCheckedStatus(@NotNull Table table, boolean check) {
        TableItem[] items;
        if (table == this.databasesTable && (items = this.databasesTable.getItems()).length != 0) {
            for (TableItem tableItem : items) {
                tableItem.setChecked(check);
                Object data = tableItem.getData();
                if (!(data instanceof PostgreDatabase)) continue;
                if (check) {
                    this.checkedObjects.add((PostgreDatabase)data);
                    continue;
                }
                this.checkedObjects.remove((PostgreDatabase)data);
            }
        }
    }
}

