/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraint;
import org.jkiss.dbeaver.ext.generic.model.GenericTableTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintInfo;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DamengTable
extends GenericTable
implements DBPObjectStatistics {
    private long tableSize = -1L;

    public DamengTable(GenericStructContainer container, String tableName, String tableType, JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
    }

    public DamengTable(GenericStructContainer container, String tableName, String tableCatalogName, String tableSchemaName) {
        super(container, tableName, tableCatalogName, tableSchemaName);
    }

    @NotNull
    public List<DBSEntityConstraintInfo> getSupportedConstraints() {
        return List.of(DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.PRIMARY_KEY, GenericTableConstraint.class), DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.UNIQUE_KEY, GenericTableConstraint.class), DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.CHECK, GenericTableConstraint.class));
    }

    public boolean hasStatistics() {
        return this.tableSize != -1L;
    }

    public long getStatObjectSize() {
        return this.tableSize;
    }

    void fetchStatistics(JDBCResultSet dbResult) throws SQLException {
        this.tableSize = dbResult.getLong("DISK_SIZE");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<? extends GenericTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this.getSchema(), (String)"Read table triggers");){
            ArrayList<GenericTableTrigger> arrayList;
            block22: {
                JDBCPreparedStatement dbStat = session.prepareStatement("SELECT TABTRIG_OBJ_INNER.NAME FROM SYSOBJECTS TABTRIG_OBJ_INNER, SYSOBJECTS TAB_OBJ_INNER, SYSOBJECTS SCH_OBJ_INNER WHERE TABTRIG_OBJ_INNER.SUBTYPE$ = 'TRIG' AND TABTRIG_OBJ_INNER.PID = TAB_OBJ_INNER.ID AND SCH_OBJ_INNER.ID = TABTRIG_OBJ_INNER.SCHID AND SCH_OBJ_INNER.NAME = ? AND TAB_OBJ_INNER.NAME = ?");
                try {
                    dbStat.setString(1, this.getSchema().getName());
                    dbStat.setString(2, this.getName());
                    ArrayList<GenericTableTrigger> result = new ArrayList<GenericTableTrigger>();
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                            result.add(new GenericTableTrigger((GenericTableBase)this, name, null));
                        }
                    }
                    arrayList = result;
                    if (dbStat == null) break block22;
                }
                catch (Throwable throwable) {
                    if (dbStat != null) {
                        try {
                            dbStat.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dbStat.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new DBException("Read table triggers failed", (Throwable)e);
        }
    }
}

