/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.util;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class SQLWordFinder {
    public static IRegion findWord(IDocument document, int offset) {
        int start = SQLWordFinder.getWordStartOffset(document.get(), offset);
        int end = SQLWordFinder.getWordEndOffset(document.get(), offset);
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public static int getWordStartOffset(String text, int startIndex) {
        if (text == null || startIndex >= text.length()) {
            return -1;
        }
        for (int offset = startIndex; offset >= 0; --offset) {
            char c = text.charAt(offset);
            if (!SQLWordFinder.isWhiteSpace(c)) continue;
            return offset;
        }
        return -1;
    }

    public static int getWordEndOffset(String text, int startIndex) {
        char c;
        int pos;
        int length = text.length();
        for (pos = startIndex; pos < length && !SQLWordFinder.isWhiteSpace(c = text.charAt(pos)); ++pos) {
        }
        return pos;
    }

    public static boolean isWhiteSpace(char c) {
        return Character.isWhitespace(c) || c == '(' || c == ')' || c == ',' || c == ';' || c == '\n' || c == '\r' || c == '=' || c == '>' || c == '<' || c == '+' || c == '-' || c == '*' || c == '/';
    }
}

