/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.dbeaver.ui.navigator.project.ProjectExplorerView;
import org.jkiss.dbeaver.ui.navigator.project.ProjectNavigatorView;

public class NavigatorHandlerLinkEditor
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage activePage = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor == null) {
            return null;
        }
        NavigatorViewBase navigatorView = NavigatorUtils.getActiveNavigatorView(event);
        if (navigatorView == null) {
            return null;
        }
        if (navigatorView instanceof ProjectExplorerView || navigatorView instanceof ProjectNavigatorView && activeEditor instanceof ITextEditor) {
            IFile file = EditorUtils.getFileFromInput((IEditorInput)activeEditor.getEditorInput());
            if (file != null) {
                this.showResourceInNavigator(navigatorView, file);
            }
        } else {
            DBNModel globalNavigatorModel = navigatorView.getGlobalNavigatorModel();
            IEditorInput iEditorInput = activeEditor.getEditorInput();
            if (iEditorInput instanceof IDatabaseEditorInput) {
                DBSObject databaseObject;
                IDatabaseEditorInput editorInput = (IDatabaseEditorInput)iEditorInput;
                DBNDatabaseNode dbnNode = editorInput.getNavigatorNode();
                if (dbnNode == null && (databaseObject = editorInput.getDatabaseObject()) != null) {
                    dbnNode = globalNavigatorModel.findNode(databaseObject);
                }
                if (dbnNode != null) {
                    navigatorView.showNode((DBNNode)dbnNode);
                }
            } else if (activeEditor instanceof DBPDataSourceContainerProvider) {
                DBPDataSourceContainerProvider provider = (DBPDataSourceContainerProvider)activeEditor;
                DBPDataSourceContainer dsContainer = provider.getDataSourceContainer();
                Object activeObject = null;
                if (dsContainer != null) {
                    DBCExecutionContextDefaults contextDefaults;
                    DBPContextProvider contextProvider;
                    DBCExecutionContext executionContext;
                    if (activeEditor instanceof DBPContextProvider && (executionContext = (contextProvider = (DBPContextProvider)activeEditor).getExecutionContext()) != null && (contextDefaults = executionContext.getContextDefaults()) != null && (activeObject = contextDefaults.getDefaultSchema()) == null) {
                        activeObject = contextDefaults.getDefaultCatalog();
                    }
                    if (activeObject == null) {
                        DBPDataSource dataSource = dsContainer.getDataSource();
                        activeObject = dataSource != null ? DBUtils.getDefaultOrActiveObject((DBSInstance)dataSource.getDefaultInstance()) : dsContainer;
                    }
                    DBPDataSourceContainer objectToSelect = activeObject;
                    NavigatorViewBase view = navigatorView;
                    UIUtils.runInUI((IRunnableContext)activePage.getWorkbenchWindow(), arg_0 -> NavigatorHandlerLinkEditor.lambda$execute$0((DBSObject)objectToSelect, globalNavigatorModel, view, arg_0));
                }
            }
        }
        activePage.activate((IWorkbenchPart)navigatorView);
        return null;
    }

    private void showResourceInNavigator(NavigatorViewBase activePart, IFile editorFile) {
        DBNProject projectNode = NavigatorResources.getProjectNode((DBNRoot)NavigatorViewBase.getGlobalNavigatorModel().getRoot(), (IProject)editorFile.getProject());
        DBNResource resource = NavigatorResources.findResource((DBNNode)projectNode, (IResource)editorFile);
        if (resource != null) {
            activePart.showNode((DBNNode)resource);
        }
    }

    private static /* synthetic */ void lambda$execute$0(DBSObject objectToSelect, DBNModel globalNavigatorModel, NavigatorViewBase view, DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        DBNDatabaseNode objectNode;
        DBSObject showObject = objectToSelect;
        if (showObject instanceof DBSInstance && !(showObject instanceof DBPDataSourceContainer)) {
            showObject = objectToSelect.getParentObject();
        }
        if (showObject instanceof DBPDataSource) {
            DBPDataSource dataSource = (DBPDataSource)showObject;
            showObject = dataSource.getContainer();
        }
        if ((objectNode = globalNavigatorModel.getNodeByObject(monitor, showObject, true)) != null) {
            view.showNode((DBNNode)objectNode);
        }
    }
}

