/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

public enum AltibaseTriggerType {
    BEFORE_INSERT(1),
    AFTER_INSERT(2),
    BEFORE_UPDATE(3),
    AFTER_UPDATE(4),
    BEFORE_DELETE(5),
    AFTER_DELETE(6),
    BEFORE_INSERT_OR_UPDATE(17),
    AFTER_INSERT_OR_UPDATE(18),
    BEFORE_INSERT_OR_DELETE(25),
    AFTER_INSERT_OR_DELETE(26),
    BEFORE_UPDATE_OR_DELETE(27),
    AFTER_UPDATE_OR_DELETE(28),
    BEFORE_INSERT_OR_UPDATE_OR_DELETE(113),
    AFTER_INSERT_OR_UPDATE_OR_DELETE(114),
    ON_CONNECT(8192, true),
    ON_DISCONNECT(8193, true),
    ON_TRANSACTION_START(8194, true),
    ON_TRANSACTION_COMMIT(8195, true),
    ON_TRANSACTION_ROLLBACK(8196, true);

    private final int type;
    private final boolean dbEvent;

    private AltibaseTriggerType(int type) {
        this(type, false);
    }

    private AltibaseTriggerType(int type, boolean dbEvent) {
        this.type = type;
        this.dbEvent = dbEvent;
    }

    public String getDisplayName() {
        return this.name().replace('_', ' ');
    }

    public int getType() {
        return this.type;
    }

    public boolean isDbEvent() {
        return this.dbEvent;
    }

    static AltibaseTriggerType getByType(int type) {
        for (AltibaseTriggerType tt : AltibaseTriggerType.values()) {
            if (tt.type != type) continue;
            return tt;
        }
        return null;
    }
}

