/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.mcpserver;

import com.sun.net.httpserver.Headers;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.ui.ViewController;

class MCPAuthenticator {
    private static final int UNAUTHORIZED_ERROR_CODE = -32001;
    private static final String UNAUTHORIZED_MESSAGE = "Unauthorized";
    private static final String GENERATED_MCP_TOKEN_MESSAGE = "ai_mcp_token_generated_message";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_PREFIX = "Bearer ";
    private final ResourceController resourceController;
    private final String apiKeyPropertyName;
    private final String apiKeyHeaderName;
    private final EventDispatchInvoker eventDispatchInvoker;

    MCPAuthenticator(ResourceController resourceController, ViewController viewController, String apiKeyPropertyName, String apiKeyHeaderName) {
        this(resourceController, apiKeyPropertyName, apiKeyHeaderName, arg_0 -> ((ViewController)viewController).invokeAndWait(arg_0));
    }

    MCPAuthenticator(ResourceController resourceController, String apiKeyPropertyName, String apiKeyHeaderName, EventDispatchInvoker eventDispatchInvoker) {
        this.resourceController = resourceController;
        this.apiKeyPropertyName = apiKeyPropertyName;
        this.apiKeyHeaderName = apiKeyHeaderName;
        this.eventDispatchInvoker = eventDispatchInvoker;
    }

    Object authenticateRequest(Headers requestHeaders) {
        AtomicReference responseReference = new AtomicReference();
        AtomicReference errorReference = new AtomicReference();
        Runnable runnable = () -> {
            try {
                responseReference.set(this.authenticateOnEdt(requestHeaders));
            }
            catch (Throwable throwable) {
                errorReference.set(throwable);
            }
        };
        try {
            this.eventDispatchInvoker.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("MCP authentication was interrupted.", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.toRuntimeException(invocationTargetException.getCause(), "MCP authentication failed.");
        }
        Throwable error = (Throwable)errorReference.get();
        if (error != null) {
            throw this.toRuntimeException(error, "MCP authentication failed.");
        }
        return responseReference.get();
    }

    private Object authenticateOnEdt(Headers requestHeaders) {
        String providedApiKey;
        String configuredApiKey = this.trimToEmpty(this.resourceController.getProperty(this.apiKeyPropertyName, ""));
        if (configuredApiKey.isEmpty()) {
            String generatedApiKey = this.generateToken();
            this.resourceController.setProperty(this.apiKeyPropertyName, generatedApiKey);
            this.notifyTokenGenerated(generatedApiKey);
            return this.buildUnauthorizedResponse();
        }
        String legacyHeaderToken = this.trimToEmpty(requestHeaders == null ? null : requestHeaders.getFirst(this.apiKeyHeaderName));
        BearerToken bearerToken = this.parseBearerToken(requestHeaders);
        if (!bearerToken.valid) {
            return this.buildUnauthorizedResponse();
        }
        if (!(legacyHeaderToken.isEmpty() || bearerToken.token.isEmpty() || legacyHeaderToken.equals(bearerToken.token))) {
            return this.buildUnauthorizedResponse();
        }
        String string = providedApiKey = !bearerToken.token.isEmpty() ? bearerToken.token : legacyHeaderToken;
        if (!configuredApiKey.equals(providedApiKey)) {
            return this.buildUnauthorizedResponse();
        }
        return null;
    }

    private BearerToken parseBearerToken(Headers requestHeaders) {
        String authorizationHeader = this.trimToEmpty(requestHeaders == null ? null : requestHeaders.getFirst(AUTHORIZATION_HEADER));
        if (authorizationHeader.isEmpty()) {
            return BearerToken.missing();
        }
        if (!authorizationHeader.startsWith(BEARER_PREFIX)) {
            return BearerToken.invalid();
        }
        String tokenValue = this.trimToEmpty(authorizationHeader.substring(BEARER_PREFIX.length()));
        if (tokenValue.isEmpty()) {
            return BearerToken.invalid();
        }
        return BearerToken.valid(tokenValue);
    }

    String generateToken() {
        return UUID.randomUUID().toString();
    }

    void notifyTokenGenerated(String generatedApiKey) {
        UITools.showMessage((String)TextUtils.format((String)GENERATED_MCP_TOKEN_MESSAGE, (Object[])new Object[]{generatedApiKey}), (int)1);
    }

    private RuntimeException toRuntimeException(Throwable throwable, String fallbackMessage) {
        if (throwable instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)throwable;
            return runtimeException;
        }
        return new IllegalStateException(fallbackMessage, throwable);
    }

    private String trimToEmpty(String value) {
        return value == null ? "" : value.trim();
    }

    private Object buildUnauthorizedResponse() {
        LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>();
        error.put("code", -32001);
        error.put("message", UNAUTHORIZED_MESSAGE);
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("jsonrpc", "2.0");
        response.put("id", null);
        response.put("error", error);
        return response;
    }

    @FunctionalInterface
    static interface EventDispatchInvoker {
        public void invokeAndWait(Runnable var1) throws InterruptedException, InvocationTargetException;
    }

    private static class BearerToken {
        private final boolean valid;
        private final String token;

        private BearerToken(boolean valid, String token) {
            this.valid = valid;
            this.token = token;
        }

        static BearerToken missing() {
            return new BearerToken(true, "");
        }

        static BearerToken valid(String token) {
            return new BearerToken(true, token);
        }

        static BearerToken invalid() {
            return new BearerToken(false, "");
        }
    }
}

