/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.VectorSTL;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.slghpatexpress.OperandValue;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghsymbol.ContextChange;
import ghidra.pcodeCPort.utils.MutableInt;
import ghidra.pcodeCPort.utils.Utils;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class ContextOp
extends ContextChange {
    public final Location location;
    private PatternExpression patexp;
    private int num;
    private int mask;
    private int shift;

    public ContextOp(Location location) {
        this.location = location;
    }

    @Override
    public void dispose() {
        PatternExpression.release(this.patexp);
    }

    public ContextOp(Location location, int startbit, int endbit, PatternExpression pe) {
        this.location = location;
        MutableInt n = new MutableInt();
        MutableInt s = new MutableInt();
        MutableInt m = new MutableInt();
        Utils.calc_maskword(location, startbit, endbit, n, s, m);
        this.num = n.get();
        this.shift = s.get();
        this.mask = m.get();
        this.patexp = pe;
        this.patexp.layClaim();
    }

    @Override
    public void validate() {
        VectorSTL values = new VectorSTL();
        this.patexp.listValues((VectorSTL<PatternValue>)values);
        for (int i = 0; i < values.size(); ++i) {
            OperandValue val;
            if (!(values.get(i) instanceof OperandValue) || (val = (OperandValue)values.get(i)).isConstructorRelative()) continue;
            throw new SleighError(val.getName() + ": cannot be used in context expression", val.location);
        }
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_CONTEXT_OP);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_I, this.num);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_SHIFT, this.shift);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_MASK, Utils.unsignedInt(this.mask));
        this.patexp.encode(encoder);
        encoder.closeElement(SlaFormat.ELEM_CONTEXT_OP);
    }
}

