/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBRecord;
import ghidra.docking.settings.Settings;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.code.CodeManager;
import ghidra.program.database.code.DataDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.mem.MemoryAccessException;

class DataComponent
extends DataDB {
    DataDB parent;
    DataTypeComponent component;
    private int indexInParent;
    private int offset;
    private int[] path;

    public DataComponent(CodeManager codeMgr, DBObjectCache<DataDB> componentCache, Address address, long addr, DataDB parent, DataTypeComponent component) {
        super(codeMgr, componentCache, (long)component.getOrdinal(), address, addr, component.getDataType());
        this.indexInParent = component.getOrdinal();
        this.parent = parent;
        this.component = component;
        this.level = parent.level + 1;
        this.offset = component.getOffset();
        this.length = component.getLength();
        if (this.length == 0) {
            this.length = 1;
        }
    }

    DataComponent(CodeManager codeMgr, DBObjectCache<DataDB> componentCache, Address address, long addr, DataDB parent, Array array, int ordinal) {
        super(codeMgr, componentCache, (long)ordinal, address, addr, array.getDataType());
        int elementLength = array.getElementLength();
        this.indexInParent = ordinal;
        this.parent = parent;
        this.offset = ordinal * elementLength;
        this.level = parent.level + 1;
        this.length = elementLength;
    }

    @Override
    protected boolean hasBeenDeleted(DBRecord rec) {
        if (this.parent.hasBeenDeleted(null)) {
            return true;
        }
        DataType pdt = this.parent.getBaseDataType();
        if (pdt instanceof Composite) {
            DataTypeComponent c;
            Composite composite = (Composite)pdt;
            if (this.indexInParent >= composite.getNumComponents()) {
                return true;
            }
            this.component = c = composite.getComponent(this.indexInParent);
            this.dataType = c.getDataType();
            this.offset = this.component.getOffset();
            this.length = this.component.getLength();
            if (this.length == 0) {
                this.length = 1;
            }
        } else if (pdt instanceof Array) {
            Array a = (Array)pdt;
            if (this.indexInParent >= a.getNumElements()) {
                return true;
            }
            this.component = null;
            this.dataType = ((Array)pdt).getDataType();
            this.length = a.getElementLength();
            this.offset = this.length * this.indexInParent;
        } else {
            return true;
        }
        this.address = this.parent.getAddress().add(this.offset);
        this.addr = this.parent.addr + (long)this.offset;
        this.baseDataType = DataComponent.getBaseDataType(this.dataType);
        this.bytes = null;
        return false;
    }

    @Override
    public int[] getComponentPath() {
        if (this.path == null) {
            this.path = new int[this.level];
            int parentLevel = this.level - 1;
            this.path[parentLevel--] = this.indexInParent;
            DataDB parentData = this.parent;
            while (parentData instanceof DataComponent) {
                DataComponent dc = (DataComponent)parentData;
                this.path[parentLevel--] = dc.indexInParent;
                parentData = dc.parent;
            }
        }
        return this.path;
    }

    @Override
    public String getFieldName() {
        if (this.component == null) {
            return "[" + this.indexInParent + "]";
        }
        String myName = this.component.getFieldName();
        if (myName == null || myName.length() == 0) {
            myName = this.component.getDefaultFieldName();
        }
        return myName;
    }

    @Override
    public String getPathName() {
        String parentPath = this.parent.getPathName();
        return this.getComponentName(parentPath);
    }

    @Override
    public String getComponentPathName() {
        String parentPath = this.parent.getComponentPathName();
        return this.getComponentName(parentPath);
    }

    private String getComponentName(String parentPath) {
        StringBuffer stringBuffer = new StringBuffer();
        if (parentPath != null && parentPath.length() > 0) {
            stringBuffer.append(parentPath);
            if (this.component != null) {
                stringBuffer.append('.');
            }
        }
        String myName = this.getFieldName();
        stringBuffer.append(myName);
        return stringBuffer.toString();
    }

    @Override
    public Data getParent() {
        return this.parent;
    }

    @Override
    public Data getRoot() {
        return this.parent.getRoot();
    }

    @Override
    public int getRootOffset() {
        return this.parent.getRootOffset() + this.getParentOffset();
    }

    @Override
    public int getParentOffset() {
        return this.offset;
    }

    @Override
    public int getComponentIndex() {
        return this.indexInParent;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != DataComponent.class) {
            return false;
        }
        DataComponent data = (DataComponent)obj;
        if (this.indexInParent != data.indexInParent || this.offset != data.offset) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected int getPreferredCacheLength() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBytes(byte[] b, int off) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.parent.getBytes(b, this.offset + off);
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public byte[] getBytes() throws MemoryAccessException {
        this.lock.acquire();
        try {
            this.checkIsValid();
            byte[] b = new byte[this.length];
            if (this.parent.getBytes(b, this.offset) != this.length) {
                throw new MemoryAccessException("Couldn't get all bytes for CodeUnit");
            }
            byte[] byArray = b;
            return byArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public byte getByte(int n) throws MemoryAccessException {
        this.lock.acquire();
        try {
            this.checkIsValid();
            byte by = this.parent.getByte(this.offset + n);
            return by;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getComment(CommentType commentType) {
        String cmt = super.getComment(commentType);
        if (cmt == null && commentType == CommentType.EOL && this.component != null) {
            cmt = this.component.getComment();
        }
        return cmt;
    }

    @Override
    public Settings getDefaultSettings() {
        if (this.component != null) {
            return this.component.getDefaultSettings();
        }
        if (this.parent instanceof DataComponent) {
            return this.parent.getDefaultSettings();
        }
        return super.getDefaultSettings();
    }
}

