/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.filter.MultitermEvaluationMode;
import docking.widgets.filter.TextFilter;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.util.FilterTransformer;
import java.util.List;
import java.util.stream.Stream;

public class MultiTextFilterTreeFilter
implements GTreeFilter {
    private final List<TextFilter> filters;
    private final FilterTransformer<GTreeNode> transformer;
    private final MultitermEvaluationMode evalMode;

    public MultiTextFilterTreeFilter(List<TextFilter> filters, FilterTransformer<GTreeNode> transformer, MultitermEvaluationMode evalMode) {
        this.filters = filters;
        this.transformer = transformer;
        this.evalMode = evalMode;
    }

    @Override
    public boolean acceptsNode(GTreeNode node) {
        if (this.filters.isEmpty()) {
            return true;
        }
        List nodeData = this.transformer.transform((Object)node);
        Stream stream = this.filters.stream();
        if (this.evalMode == MultitermEvaluationMode.AND) {
            return stream.allMatch(f -> MultiTextFilterTreeFilter.matches(f, nodeData));
        }
        return stream.anyMatch(f -> MultiTextFilterTreeFilter.matches(f, nodeData));
    }

    @Override
    public boolean showFilterMatches() {
        return true;
    }

    private static boolean matches(TextFilter filter, List<String> nodeData) {
        return nodeData.stream().anyMatch(data -> filter.matches((String)data));
    }
}

