/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.validator;

import docking.widgets.conditiontestpanel.ConditionResult;
import docking.widgets.conditiontestpanel.ConditionStatus;
import docking.widgets.conditiontestpanel.ConditionTester;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.program.model.listing.Program;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public abstract class VTPreconditionValidator
implements ConditionTester,
ExtensionPoint {
    protected final Program sourceProgram;
    protected final Program destinationProgram;
    protected final VTSession existingResults;

    public VTPreconditionValidator(Program sourceProgram, Program destinationProgram, VTSession existingResults) {
        this.sourceProgram = sourceProgram;
        this.destinationProgram = destinationProgram;
        this.existingResults = existingResults;
    }

    public String toString() {
        return this.getName();
    }

    public final ConditionResult run(TaskMonitor monitor) throws CancelledException {
        if (!this.sourceProgram.addConsumer((Object)this)) {
            return new ConditionResult(ConditionStatus.Cancelled);
        }
        if (!this.destinationProgram.addConsumer((Object)this)) {
            this.sourceProgram.release((Object)this);
            return new ConditionResult(ConditionStatus.Cancelled);
        }
        try {
            ConditionResult conditionResult = this.doRun(monitor);
            return conditionResult;
        }
        finally {
            this.sourceProgram.release((Object)this);
            this.destinationProgram.release((Object)this);
        }
    }

    public abstract ConditionResult doRun(TaskMonitor var1) throws CancelledException;
}

