/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.DialogComponentProvider;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.label.GLabel;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.RetypeLocalAction;
import ghidra.app.util.datatype.DataTypeSelectionDialog;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.database.data.PointerTypedefInspector;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.ComponentOffsetSettingsDefinition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.data.DataTypeParser;
import ghidra.util.layout.VerticalLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;

public class CreatePointerRelative
extends RetypeLocalAction {
    private DataType initialParent;
    private int initialOffset;
    private DataType userDataType = null;
    private CategoryPath userPath;
    private int userOffset;
    private String userName;
    private HighSymbol highSymbol;
    private Varnode userVarnode;
    private int pointerSize;
    private TypeDef relativePointer;

    public CreatePointerRelative() {
        super("Create Relative Pointer");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionPointerOffset"));
        this.setPopupMenuData(new MenuData(new String[]{"Adjust Pointer Offset"}, "Decompile"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (!tokenAtCursor.isVariableRef()) {
            return false;
        }
        HighVariable high = tokenAtCursor.getHighVariable();
        if (high == null || high.getSymbol() == null) {
            return false;
        }
        this.highSymbol = high.getSymbol();
        DataType dataType = high.getDataType();
        if (dataType instanceof TypeDef) {
            dataType = ((TypeDef)dataType).getBaseDataType();
        }
        return dataType instanceof Pointer;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        this.clearInfo();
        this.collectInitialInfo(context);
        Program program = context.getProgram();
        PluginTool tool = context.getTool();
        RelativePointerDialog dialog = new RelativePointerDialog(tool, program);
        dialog.setTabCommitsEdit(false);
        if (this.initialParent != null) {
            dialog.setInitialDataType(this.initialParent);
            dialog.setInitialOffset(this.initialOffset);
            dialog.setInitialName(CreatePointerRelative.buildDefaultName(this.initialParent, this.initialOffset));
        }
        tool.showDialog((DialogComponentProvider)dialog);
        if (this.userDataType == null) {
            return;
        }
        this.createTypeDef(program, tool);
        this.retypeSymbol(program, this.highSymbol, this.userVarnode, (DataType)this.relativePointer, tool);
    }

    private String testNameValidity(String name) {
        if (name == null || name.length() == 0) {
            return "Must provide a name for the data-type";
        }
        return null;
    }

    private TypeDef findPreexistingTypeDef(Program program) throws InvalidDataTypeException {
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        DataType dt = dtm.getDataType(this.userPath, this.userName);
        if (dt == null) {
            return null;
        }
        if (!(dt instanceof TypeDef)) {
            throw new InvalidDataTypeException("Data-type " + this.userName + " already exists");
        }
        TypeDef res = (TypeDef)dt;
        if (!(res.getDataType() instanceof Pointer)) {
            throw new InvalidDataTypeException("Data-type " + this.userName + " already exists and is not a pointer TypeDef");
        }
        DataType baseType = ((Pointer)res.getDataType()).getDataType();
        if (!this.userDataType.getName().equals(baseType.getName()) || !this.userDataType.getCategoryPath().equals((Object)baseType.getCategoryPath())) {
            throw new InvalidDataTypeException("Data-type " + this.userName + " already exists and has a different base");
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTypeDef(Program program, PluginTool tool) {
        int transaction = program.startTransaction("Create Relative Pointer");
        try {
            if (this.relativePointer == null) {
                PointerDataType ptr = new PointerDataType(this.userDataType, this.pointerSize);
                TypedefDataType typedef = new TypedefDataType(this.userPath, this.userName, (DataType)ptr);
                this.relativePointer = (TypeDef)program.getDataTypeManager().resolve((DataType)typedef, null);
            }
            ComponentOffsetSettingsDefinition.DEF.setValue(this.relativePointer.getDefaultSettings(), (long)this.userOffset);
        }
        catch (IllegalArgumentException e) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Relative TypeDef Failed", (Object)("Failed to create relative TypeDef: " + e.getMessage()));
        }
        finally {
            program.endTransaction(transaction, true);
        }
    }

    private void clearInfo() {
        this.userDataType = null;
        this.userPath = null;
        this.userOffset = 0;
        this.userName = null;
        this.initialParent = null;
        this.initialOffset = 0;
    }

    private void collectInitialInfo(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        HighVariable high = tokenAtCursor.getHighVariable();
        this.highSymbol = high.getSymbol();
        DataType dataType = high.getDataType();
        if (dataType instanceof TypeDef) {
            dataType = ((TypeDef)dataType).getBaseDataType();
        }
        if (!(dataType instanceof Pointer)) {
            return;
        }
        this.pointerSize = dataType.getLength();
        Varnode vn = tokenAtCursor.getVarnode();
        if (vn == null) {
            return;
        }
        TreeSearch node = TreeSearch.searchBackward(vn, 5);
        if (node != null) {
            this.initialParent = node.dataType;
            this.initialOffset = node.offset;
            return;
        }
        node = TreeSearch.searchForward(vn, 5);
        if (node != null) {
            this.initialParent = node.dataType;
            this.initialOffset = -node.offset;
        }
    }

    public static String buildDefaultName(DataType dt, int off) {
        DataType inner = PcodeDataTypeManager.findPointerRelativeInner((DataType)dt, (int)off);
        StringBuilder buffer = new StringBuilder();
        buffer.append(dt.getName());
        int val = off;
        if (val < 0) {
            buffer.append("_ptrminus_");
            val = -val;
        } else {
            buffer.append("_ptr_");
        }
        buffer.append(val);
        buffer.append('_').append(inner.getName());
        return buffer.toString();
    }

    public class RelativePointerDialog
    extends DataTypeSelectionDialog {
        private Program program;
        private JPanel updatedPanel;
        private JTextField offsetField;
        private JTextField nameField;

        public RelativePointerDialog(PluginTool pluginTool, Program prog) {
            super((ServiceProvider)pluginTool, (DataTypeManager)prog.getDataTypeManager(), -1, DataTypeParser.AllowedDataTypes.FIXED_LENGTH);
            this.program = prog;
            DataTypeSelectionEditor editor = this.getEditor();
            CellEditorListener[] listeners = editor.getCellEditorListeners();
            if (listeners.length != 0) {
                CellEditorListener lastListen = listeners[listeners.length - 1];
                editor.removeCellEditorListener(lastListen);
            }
        }

        public void setInitialOffset(int off) {
            this.offsetField.setText(Integer.toString(off));
        }

        public void setInitialName(String nm) {
            this.nameField.setText(nm);
        }

        protected void okCallback() {
            String valueString = this.offsetField.getText();
            try {
                CreatePointerRelative.this.userOffset = Integer.decode(valueString);
            }
            catch (NumberFormatException ex) {
                this.setStatusText("Invalid offset");
                return;
            }
            CreatePointerRelative.this.userName = this.nameField.getText();
            String errMessage = CreatePointerRelative.this.testNameValidity(CreatePointerRelative.this.userName);
            if (errMessage != null) {
                this.setStatusText(errMessage);
                return;
            }
            DataTypeSelectionEditor editor = this.getEditor();
            try {
                int yesno;
                if (!editor.validateUserSelection()) {
                    this.setStatusText("Unrecognized data type of \"" + editor.getCellEditorValueAsText() + "\" entered.");
                    return;
                }
                CreatePointerRelative.this.userDataType = (DataType)editor.getCellEditorValue();
                CreatePointerRelative.this.userPath = CreatePointerRelative.this.userDataType.getCategoryPath();
                CreatePointerRelative.this.relativePointer = CreatePointerRelative.this.findPreexistingTypeDef(this.program);
                if (CreatePointerRelative.this.relativePointer != null && PointerTypedefInspector.getPointerComponentOffset((TypeDef)CreatePointerRelative.this.relativePointer) != (long)CreatePointerRelative.this.userOffset && (yesno = OptionDialog.showYesNoDialog((Component)this.updatedPanel, (String)"Data-type already exists", (String)("Data-type " + CreatePointerRelative.this.userName + " already exists with a different offset\nand may be used in other places.\n\nDo you want to change the offset?"))) != 1) {
                    CreatePointerRelative.this.userDataType = null;
                    CreatePointerRelative.this.userPath = null;
                    return;
                }
            }
            catch (InvalidDataTypeException e) {
                this.setStatusText(e.getMessage());
                return;
            }
            this.clearStatusText();
            this.close();
        }

        protected JComponent createEditorPanel(DataTypeSelectionEditor dtEditor) {
            this.setTitle("Create Relative Pointer");
            this.updatedPanel = new JPanel();
            this.updatedPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 0));
            this.updatedPanel.setLayout((LayoutManager)new VerticalLayout(5));
            JPanel dataTypePanel = new JPanel();
            dataTypePanel.setLayout(new BoxLayout(dataTypePanel, 2));
            dataTypePanel.add((Component)new GLabel(" Data-type:"), "West");
            dataTypePanel.add(Box.createHorizontalStrut(5));
            dataTypePanel.add((Component)dtEditor.getEditorComponent(), "Center");
            this.offsetField = new JTextField();
            JPanel offsetPanel = new JPanel();
            offsetPanel.setLayout(new BoxLayout(offsetPanel, 2));
            offsetPanel.add((Component)new GLabel("       Offset:"), "West");
            offsetPanel.add(Box.createHorizontalStrut(5));
            offsetPanel.add((Component)this.offsetField, "Center");
            this.nameField = new JTextField(15);
            JPanel namePanel = new JPanel();
            namePanel.setLayout(new BoxLayout(namePanel, 2));
            namePanel.add((Component)new GLabel("       Name:"), "West");
            namePanel.add(Box.createHorizontalStrut(5));
            namePanel.add((Component)this.nameField, "Center");
            this.updatedPanel.add(dataTypePanel);
            this.updatedPanel.add(offsetPanel);
            this.updatedPanel.add(namePanel);
            return this.updatedPanel;
        }
    }

    private static class TreeSearch {
        public PcodeOp op;
        public int slot;
        public int offset;
        public Iterator<PcodeOp> iterForward;
        public DataType dataType;

        public TreeSearch(PcodeOp o, int s, int off) {
            this.op = o;
            this.slot = s;
            this.offset = off;
            this.dataType = null;
        }

        public TreeSearch(Varnode vn, int off) {
            this.iterForward = vn.getDescendants();
            this.offset = off;
            this.dataType = null;
        }

        public Varnode nextVarnode() {
            if (this.slot != 0 && this.op.getOpcode() != 60) {
                return null;
            }
            if (this.slot >= this.op.getNumInputs()) {
                return null;
            }
            Varnode res = this.op.getInput(this.slot);
            ++this.slot;
            return res;
        }

        public boolean isDoneBackward(DataType origType) {
            return this.dataType != null && this.dataType != origType && this.offset > 0;
        }

        public boolean isDoneForward(DataType origType) {
            return this.dataType != null && this.dataType != origType && this.offset < 0;
        }

        public void stripTypeDef() {
            if (this.dataType instanceof TypeDef) {
                TypeDef typedef = (TypeDef)this.dataType;
                this.offset = (int)((long)this.offset + PointerTypedefInspector.getPointerComponentOffset((TypeDef)typedef));
                this.dataType = ((Pointer)typedef.getDataType()).getDataType();
            }
        }

        public static DataType getValidDataType(Varnode vn) {
            DataType dt = vn.getHigh().getDataType();
            while (dt instanceof TypeDef) {
                TypeDef typedef = (TypeDef)dt;
                if (typedef.isPointer() && PointerTypedefInspector.getPointerComponentOffset((TypeDef)typedef) != 0L) {
                    return typedef;
                }
                dt = typedef.getDataType();
            }
            if (!(dt instanceof Pointer)) {
                return null;
            }
            if ((dt = ((Pointer)dt).getDataType()) instanceof Structure) {
                return dt;
            }
            return null;
        }

        public static TreeSearch searchBackward(Varnode vn, int depth) {
            ArrayList<TreeSearch> stack = new ArrayList<TreeSearch>();
            HashSet<SequenceNumber> marked = new HashSet<SequenceNumber>();
            TreeSearch currentNode = new TreeSearch(null, 0, 0);
            DataType origType = TreeSearch.getValidDataType(vn);
            if (origType instanceof TypeDef) {
                origType = null;
            }
            while (true) {
                if (vn != null) {
                    currentNode.dataType = TreeSearch.getValidDataType(vn);
                    if (currentNode.isDoneBackward(origType)) {
                        currentNode.stripTypeDef();
                        return currentNode;
                    }
                    PcodeOp op = vn.getDef();
                    if (op != null && stack.size() < depth && marked.add(op.getSeqnum())) {
                        switch (op.getOpcode()) {
                            case 1: 
                            case 61: 
                            case 64: {
                                stack.add(new TreeSearch(op, 0, currentNode.offset));
                                break;
                            }
                            case 66: {
                                stack.add(new TreeSearch(op, 0, currentNode.offset + (int)op.getInput(1).getOffset()));
                                break;
                            }
                            case 60: {
                                stack.add(new TreeSearch(op, 0, currentNode.offset));
                                break;
                            }
                        }
                    }
                }
                if (stack.isEmpty()) break;
                currentNode = (TreeSearch)stack.get(stack.size() - 1);
                vn = currentNode.nextVarnode();
                if (vn != null) continue;
                stack.remove(stack.size() - 1);
            }
            return null;
        }

        public static TreeSearch searchForward(Varnode vn, int depth) {
            ArrayList<TreeSearch> stack = new ArrayList<TreeSearch>();
            HashSet<SequenceNumber> marked = new HashSet<SequenceNumber>();
            TreeSearch currentNode = new TreeSearch(vn, 0);
            stack.add(currentNode);
            DataType origType = TreeSearch.getValidDataType(vn);
            if (origType instanceof TypeDef) {
                origType = null;
            }
            while (!stack.isEmpty()) {
                currentNode = (TreeSearch)stack.get(stack.size() - 1);
                if (currentNode.iterForward.hasNext()) {
                    PcodeOp op = currentNode.iterForward.next();
                    if (stack.size() >= depth || !marked.add(op.getSeqnum())) continue;
                    TreeSearch nextNode = null;
                    switch (op.getOpcode()) {
                        case 1: 
                        case 60: 
                        case 61: 
                        case 64: {
                            nextNode = new TreeSearch(op.getOutput(), currentNode.offset);
                            break;
                        }
                        case 66: {
                            nextNode = new TreeSearch(op.getOutput(), currentNode.offset + (int)op.getInput(1).getOffset());
                            break;
                        }
                        case 65: {
                            if (!op.getInput(1).isConstant()) break;
                            long off = op.getInput(1).getOffset() * op.getInput(2).getOffset();
                            nextNode = new TreeSearch(op.getOutput(), currentNode.offset + (int)off);
                            break;
                        }
                    }
                    if (nextNode == null) continue;
                    nextNode.dataType = TreeSearch.getValidDataType(op.getOutput());
                    if (nextNode.isDoneForward(origType)) {
                        nextNode.stripTypeDef();
                        return nextNode;
                    }
                    stack.add(nextNode);
                    continue;
                }
                stack.remove(stack.size() - 1);
            }
            return null;
        }
    }
}

