/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.annotations.AnnotatingGraphMousePlugin;
import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.DefaultModalGraphMouse;
import org.jungrapht.visualization.control.EditingGraphMousePlugin;
import org.jungrapht.visualization.control.EditingPopupGraphMousePlugin;
import org.jungrapht.visualization.control.LabelEditingGraphMousePlugin;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.RegionSelectingGraphMousePlugin;
import org.jungrapht.visualization.control.RotatingGraphMousePlugin;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;
import org.jungrapht.visualization.control.SelectingGraphMousePlugin;
import org.jungrapht.visualization.control.ShearingGraphMousePlugin;
import org.jungrapht.visualization.control.TranslatingGraphMousePlugin;
import org.jungrapht.visualization.control.modal.Modal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditingModalGraphMouse<V, E>
extends DefaultModalGraphMouse<V, E>
implements ModalGraphMouse {
    private static final Logger log = LoggerFactory.getLogger(EditingModalGraphMouse.class);
    protected Supplier<V> vertexFactory;
    protected Supplier<E> edgeFactory;
    protected Supplier<MultiLayerTransformer> multiLayerTransformerSupplier;
    protected Map<V, String> vertexLabelMap;
    protected Map<E, String> edgeLabelMap;
    protected EditingGraphMousePlugin<V, E> editingPlugin;
    protected LabelEditingGraphMousePlugin<V, E> labelEditingPlugin;
    protected EditingPopupGraphMousePlugin<V, E> popupEditingPlugin;
    protected AnnotatingGraphMousePlugin<V, E> annotatingPlugin;
    protected MultiLayerTransformer basicTransformer;
    protected RenderContext<V, E> rc;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public EditingModalGraphMouse(Builder<V, E, ?, ?> builder) {
        super(builder);
        this.vertexFactory = builder.vertexFactory;
        this.edgeFactory = builder.edgeFactory;
        this.multiLayerTransformerSupplier = builder.multiLayerTransformerSupplier;
        this.vertexLabelMap = builder.vertexLabelMapSupplier.get();
        this.edgeLabelMap = builder.edgeLabelMapSupplier.get();
        this.basicTransformer = builder.multiLayerTransformerSupplier.get();
        this.rc = builder.renderContextSupplier.get();
    }

    @Override
    public void loadPlugins() {
        this.selectingPlugin = ((SelectingGraphMousePlugin.Builder)((SelectingGraphMousePlugin.Builder)SelectingGraphMousePlugin.builder().singleSelectionMask(1024)).toggleSingleSelectionMask(1088)).build();
        this.regionSelectingPlugin = ((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)RegionSelectingGraphMousePlugin.builder().regionSelectionMask(1024)).toggleRegionSelectionMask(1088)).regionSelectionCompleteMask(0)).toggleRegionSelectionCompleteMask(64)).build();
        this.translatingPlugin = ((TranslatingGraphMousePlugin.Builder)TranslatingGraphMousePlugin.builder().translatingMask(this.translatingMask)).build();
        this.scalingPlugin = ScalingGraphMousePlugin.builder().scalingControl(new CrossoverScalingControl()).build();
        this.rotatingPlugin = new RotatingGraphMousePlugin();
        this.shearingPlugin = new ShearingGraphMousePlugin();
        this.editingPlugin = EditingGraphMousePlugin.builder(this.vertexFactory, this.edgeFactory).build();
        this.labelEditingPlugin = new LabelEditingGraphMousePlugin<Object, Object>(this.vertexLabelMap::put, this.edgeLabelMap::put);
        this.annotatingPlugin = new AnnotatingGraphMousePlugin<V, E>(this.rc);
        this.popupEditingPlugin = new EditingPopupGraphMousePlugin<V, E>(this.vertexFactory, this.edgeFactory);
        this.setMode(this.mode);
    }

    @Override
    public void setMode(Modal.Mode mode) {
        this.mode = mode;
        if (mode == Modal.Mode.TRANSFORMING) {
            this.setTransformingMode();
        } else if (mode == Modal.Mode.PICKING) {
            this.setPickingMode();
        } else if (mode == Modal.Mode.EDITING) {
            this.setEditingMode();
        } else if (mode == Modal.Mode.ANNOTATING) {
            this.setAnnotatingMode();
        }
    }

    @Override
    protected void setPickingMode() {
        this.clear();
        this.add(this.scalingPlugin);
        this.add(this.selectingPlugin);
        this.add(this.regionSelectingPlugin);
        this.add(this.animatedPickingPlugin);
        this.add(this.labelEditingPlugin);
        this.add(this.popupEditingPlugin);
    }

    @Override
    protected void setTransformingMode() {
        this.clear();
        this.add(this.scalingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.rotatingPlugin);
        this.add(this.shearingPlugin);
        this.add(this.labelEditingPlugin);
        this.add(this.popupEditingPlugin);
    }

    protected void setEditingMode() {
        this.clear();
        this.add(this.scalingPlugin);
        this.add(this.labelEditingPlugin);
        this.add(this.editingPlugin);
        this.add(this.popupEditingPlugin);
    }

    protected void setAnnotatingMode() {
        this.clear();
        this.add(this.scalingPlugin);
        this.add(this.annotatingPlugin);
    }

    public AnnotatingGraphMousePlugin<V, E> getAnnotatingPlugin() {
        return this.annotatingPlugin;
    }

    public EditingGraphMousePlugin<V, E> getEditingPlugin() {
        return this.editingPlugin;
    }

    public LabelEditingGraphMousePlugin<V, E> getLabelEditingPlugin() {
        return this.labelEditingPlugin;
    }

    public EditingPopupGraphMousePlugin<V, E> getPopupEditingPlugin() {
        return this.popupEditingPlugin;
    }

    public static class Builder<V, E, T extends EditingModalGraphMouse<V, E>, B extends Builder<V, E, T, B>>
    extends DefaultModalGraphMouse.Builder<V, E, T, B> {
        protected Supplier<V> vertexFactory;
        protected Supplier<E> edgeFactory;
        protected Supplier<Map<V, String>> vertexLabelMapSupplier = HashMap::new;
        protected Supplier<Map<E, String>> edgeLabelMapSupplier = HashMap::new;
        protected Supplier<MultiLayerTransformer> multiLayerTransformerSupplier;
        protected Supplier<RenderContext<V, E>> renderContextSupplier;

        public B vertexFactory(Supplier<V> vertexFactory) {
            this.vertexFactory = vertexFactory;
            return (B)((Builder)this.self());
        }

        public B edgeFactory(Supplier<E> edgeFactory) {
            this.edgeFactory = edgeFactory;
            return (B)((Builder)this.self());
        }

        public B vertexLabelMapSupplier(Supplier<Map<V, String>> vertexLabelMapSupplier) {
            this.vertexLabelMapSupplier = vertexLabelMapSupplier;
            return (B)((Builder)this.self());
        }

        public B edgeLabelMapSupplier(Supplier<Map<E, String>> edgeLabelMapSupplier) {
            this.edgeLabelMapSupplier = edgeLabelMapSupplier;
            return (B)((Builder)this.self());
        }

        public B multiLayerTransformerSupplier(Supplier<MultiLayerTransformer> multiLayerTransformerSupplier) {
            this.multiLayerTransformerSupplier = multiLayerTransformerSupplier;
            return (B)((Builder)this.self());
        }

        public B renderContextSupplier(Supplier<RenderContext<V, E>> renderContextSupplier) {
            this.renderContextSupplier = renderContextSupplier;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new EditingModalGraphMouse(this);
        }
    }

    public static class ModeKeyAdapter
    extends KeyAdapter {
        private char t = (char)116;
        private char p = (char)112;
        private char e = (char)101;
        private char a = (char)97;
        protected ModalGraphMouse graphMouse;

        public ModeKeyAdapter(ModalGraphMouse graphMouse) {
            this.graphMouse = graphMouse;
        }

        public ModeKeyAdapter(char t, char p, char e, char a, ModalGraphMouse graphMouse) {
            this.t = t;
            this.p = p;
            this.e = e;
            this.a = a;
            this.graphMouse = graphMouse;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == this.t) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.graphMouse.setMode(Modal.Mode.TRANSFORMING);
            } else if (keyChar == this.p) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                this.graphMouse.setMode(Modal.Mode.PICKING);
            } else if (keyChar == this.e) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(1));
                this.graphMouse.setMode(Modal.Mode.EDITING);
            } else if (keyChar == this.a) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(1));
                this.graphMouse.setMode(Modal.Mode.ANNOTATING);
            }
        }
    }
}

