/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.debug.api.platform.DebuggerPlatformMapper;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import ghidra.trace.model.Trace;

public interface DebuggerPlatformOffer {
    public String getDescription();

    public int getConfidence();

    default public boolean isOverride() {
        return this.getConfidence() < 0;
    }

    default public Language getLanguage() {
        CompilerSpec cSpec = this.getCompilerSpec();
        return cSpec == null ? null : cSpec.getLanguage();
    }

    default public LanguageID getLanguageID() {
        Language language = this.getLanguage();
        return language == null ? null : language.getLanguageID();
    }

    public CompilerSpec getCompilerSpec();

    default public CompilerSpecID getCompilerSpecID() {
        CompilerSpec cSpec = this.getCompilerSpec();
        return cSpec == null ? null : cSpec.getCompilerSpecID();
    }

    default public CompilerSpec getCompilerSpec(LanguageID langID, CompilerSpecID cSpecID) {
        try {
            LanguageService langServ = DefaultLanguageService.getLanguageService();
            Language lang = langServ.getLanguage(langID);
            return cSpecID == null ? lang.getDefaultCompilerSpec() : lang.getCompilerSpecByID(cSpecID);
        }
        catch (CompilerSpecNotFoundException | LanguageNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public DebuggerPlatformMapper take(PluginTool var1, Trace var2);

    public boolean isCreatorOf(DebuggerPlatformMapper var1);
}

