/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GLabel;
import ghidra.bitpatterns.gui.AlignmentPanelBuilder;
import ghidra.bitpatterns.gui.ByteSequencePanelBuilder;
import ghidra.bitpatterns.gui.ClipboardPanel;
import ghidra.bitpatterns.gui.ContextRegisterPanelBuilder;
import ghidra.bitpatterns.gui.DataGatheringParamsDialog;
import ghidra.bitpatterns.gui.FunctionBitPatternsExplorerPlugin;
import ghidra.bitpatterns.gui.InstructionSequenceTreePanelBuilder;
import ghidra.bitpatterns.gui.PatternEvalTableProvider;
import ghidra.bitpatterns.gui.PatternInfoRowObject;
import ghidra.bitpatterns.gui.PatternMiningAnalyzerProvider;
import ghidra.bitpatterns.gui.SimpleByteSequenceAnalyzerProvider;
import ghidra.bitpatterns.info.ByteSequenceRowObject;
import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.bitpatterns.info.DataGatheringParams;
import ghidra.bitpatterns.info.FileBitPatternInfoReader;
import ghidra.bitpatterns.info.FunctionBitPatternsGTree;
import ghidra.bitpatterns.info.InstructionSequenceTreePathFilter;
import ghidra.bitpatterns.info.PatternEvaluationStats;
import ghidra.bitpatterns.info.PatternType;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.preferences.Preferences;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.tree.TreePath;

public class FunctionBitPatternsMainProvider
extends ComponentProviderAdapter
implements OptionsChangeListener {
    private static final String NUM_FUNCS_FIELD_LABEL = "Total Number of Functions   ";
    private static final String NUM_FILES_FIELD_LABEL = "Total Number of Files   ";
    private static final String DATA_GATHERING_TEXT = "Set Data Gathering Parameters";
    private static final String DATA_SOURCE_FIELD_LABEL = "Data Source";
    private static final String FIRST_INSTRUCTIONS_LABEL = "Number of First Instructions";
    private static final String PRE_INSTRUCTIONS_LABEL = "Number of Pre-Instructions";
    private static final String RETURN_INSTRUCTIONS_LABEL = "Number of Return Instructions";
    private static final String FIRST_BYTES_LABEL = "Number of First Bytes";
    private static final String PRE_BYTES_LABEL = "Number of Pre-Bytes";
    private static final String RETURN_BYTES_LABEL = "Number of Return Bytes";
    public static final String EXPLORE_FUNCTION_PATTERNS_TEXT = "Explore Function Bit Patterns";
    private FunctionBitPatternsExplorerPlugin plugin;
    private FileBitPatternInfoReader patternReader = null;
    private JComponent component;
    private JTextField numFunctionsField;
    private JTextField numFilesField;
    private JTextField dataSourceField;
    private JTextField firstInstructionsField;
    private JTextField preInstructionsField;
    private JTextField returnInstructionsField;
    private JTextField firstBytesField;
    private JTextField preBytesField;
    private JTextField returnBytesField;
    private JTabbedPane tabbedPane;
    private static final int FIRST_INSTRUCTION_PANEL_INDEX = 0;
    private InstructionSequenceTreePanelBuilder firstInstPanel;
    private static final String FIRST_INST_TITLE = "First Instructions Tree";
    private static final int PRE_INSTRUCTION_PANEL_INDEX = 1;
    private InstructionSequenceTreePanelBuilder preInstPanel;
    private static final String PRE_INST_TITLE = "Pre-Instructions Tree";
    private static final int RETURN_INSTRUCTION_PANEL_INDEX = 2;
    private InstructionSequenceTreePanelBuilder returnInstPanel;
    private static final String RETURN_INST_TITLE = "Return Instructions Tree";
    private static final int FIRST_BYTES_PANEL_INDEX = 3;
    private ByteSequencePanelBuilder firstBytesPanel;
    private static final String FIRST_BYTES_TITLE = "First Bytes";
    private static final int PRE_BYTES_PANEL_INDEX = 4;
    private ByteSequencePanelBuilder preBytesPanel;
    private static final String PRE_BYTES_TITLE = "Pre-Bytes";
    private static final int RETURN_BYTES_PANEL_INDEX = 5;
    private ByteSequencePanelBuilder returnBytesPanel;
    private static final String RETURN_BYTES_TITLE = "Return Bytes";
    private static final int ALIGNMENT_PANEL_INDEX = 6;
    private static final String ALIGNMENT_PANEL_TITLE = "Function Start Alignment";
    private AlignmentPanelBuilder alignmentPanel;
    private ContextRegisterPanelBuilder contextRegisterPanel;
    private static final int CONTEXT_REGISTER_PANEL_INDEX = 7;
    private static final String CONTEXT_REGISTER_TITLE = "Context Register Information";
    private ClipboardPanel clipboard;
    private static final int CLIPBOARD_PANEL_INDEX = 8;
    private static final String CLIPBOARD_TITLE = "Pattern Clipboard";
    private boolean resetTableData;
    private static final String PATTERN_INFO_DIR = "FunctionBitPatternsMainProvider_PATTERN_INFO_DIR";
    private DockingAction gatherDataFromProgramAction;

    public FunctionBitPatternsMainProvider(FunctionBitPatternsExplorerPlugin plugin) {
        super(plugin.getTool(), "Function Bit Patterns Explorer", plugin.getName());
        this.plugin = plugin;
        this.component = this.build();
        this.tool = plugin.getTool();
        this.tool.addComponentProvider((ComponentProvider)this, false);
        this.initializeOptions();
        this.createActions();
        HelpLocation helpLocation = new HelpLocation("FunctionBitPatternsExplorerPlugin", "Function_Bit_Patterns_Explorer_Plugin");
        this.setHelpLocation(helpLocation);
    }

    public void updateClipboard() {
        this.clipboard.updateClipboard();
        this.clipboard.updateUI();
    }

    private JComponent build() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildControlPanel(), "North");
        this.tabbedPane = new JTabbedPane();
        this.firstInstPanel = new InstructionSequenceTreePanelBuilder(PatternType.FIRST);
        this.preInstPanel = new InstructionSequenceTreePanelBuilder(PatternType.PRE);
        this.alignmentPanel = new AlignmentPanelBuilder();
        this.firstBytesPanel = new ByteSequencePanelBuilder(this.plugin, PatternType.FIRST);
        this.preBytesPanel = new ByteSequencePanelBuilder(this.plugin, PatternType.PRE);
        this.returnBytesPanel = new ByteSequencePanelBuilder(this.plugin, PatternType.RETURN);
        this.contextRegisterPanel = new ContextRegisterPanelBuilder(null);
        this.tabbedPane.insertTab(FIRST_INST_TITLE, null, this.firstInstPanel.buildMainPanel(), null, 0);
        this.firstInstPanel.enableFilterButtons(false);
        this.firstInstPanel.enablePercentageFilterButtons(false);
        this.tabbedPane.insertTab(PRE_INST_TITLE, null, this.preInstPanel.buildMainPanel(), null, 1);
        this.preInstPanel.enableFilterButtons(false);
        this.preInstPanel.enablePercentageFilterButtons(false);
        this.returnInstPanel = new InstructionSequenceTreePanelBuilder(PatternType.RETURN);
        this.returnInstPanel.enableFilterButtons(false);
        this.returnInstPanel.enablePercentageFilterButtons(false);
        this.tabbedPane.insertTab(RETURN_INST_TITLE, null, this.returnInstPanel.buildMainPanel(), null, 2);
        this.tabbedPane.insertTab(FIRST_BYTES_TITLE, null, this.firstBytesPanel.buildMainPanel(), null, 3);
        this.firstBytesPanel.enableFilterButtons(false);
        this.firstBytesPanel.enableLengthFilterButtons(false);
        this.tabbedPane.insertTab(PRE_BYTES_TITLE, null, this.preBytesPanel.buildMainPanel(), null, 4);
        this.preBytesPanel.enableFilterButtons(false);
        this.preBytesPanel.enableLengthFilterButtons(false);
        this.tabbedPane.insertTab(RETURN_BYTES_TITLE, null, this.returnBytesPanel.buildMainPanel(), null, 5);
        this.tabbedPane.insertTab(ALIGNMENT_PANEL_TITLE, null, this.alignmentPanel.buildAlignmentPanel(), null, 6);
        this.alignmentPanel.enableFilterButtons(false);
        this.tabbedPane.insertTab(CONTEXT_REGISTER_TITLE, null, this.contextRegisterPanel.buildContextRegisterPanel(), null, 7);
        this.clipboard = new ClipboardPanel(this.plugin);
        this.tabbedPane.insertTab(CLIPBOARD_TITLE, null, this.clipboard, null, 8);
        panel.add((Component)this.tabbedPane, "Center");
        return panel;
    }

    private Component buildControlPanel() {
        JPanel controlPanel = new JPanel();
        BoxLayout controlLayout = new BoxLayout(controlPanel, 1);
        controlPanel.setLayout(controlLayout);
        JPanel infoPanel = new JPanel(new FlowLayout(0));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPanel = new JPanel();
        FlowLayout buttonPanelLayout = new FlowLayout(1);
        buttonPanel.setLayout(buttonPanelLayout);
        JButton readXMLButton = new JButton("Read XML Files");
        readXMLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File dir;
                GhidraFileChooser fileChooser = new GhidraFileChooser((Component)FunctionBitPatternsMainProvider.this.component);
                fileChooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
                fileChooser.setTitle("Select Directory Containing XML Files");
                String baseDir = Preferences.getProperty((String)FunctionBitPatternsMainProvider.PATTERN_INFO_DIR);
                if (baseDir != null && (dir = new File(baseDir)).isDirectory()) {
                    fileChooser.setCurrentDirectory(dir);
                }
                File xmlDir = fileChooser.getSelectedFile();
                fileChooser.dispose();
                if (xmlDir == null) {
                    return;
                }
                Preferences.setProperty((String)FunctionBitPatternsMainProvider.PATTERN_INFO_DIR, (String)xmlDir.getAbsolutePath());
                Preferences.store();
                FunctionBitPatternsMainProvider.this.patternReader = new FileBitPatternInfoReader(xmlDir, FunctionBitPatternsMainProvider.this.component);
                if (FunctionBitPatternsMainProvider.this.patternReader.getDataGatheringParams() == null) {
                    Msg.showWarn((Object)this, (Component)FunctionBitPatternsMainProvider.this.component, (String)"Missing Data Gathering Parameters", (Object)"No Data Gathering Parameters Read");
                    return;
                }
                FunctionBitPatternsMainProvider.this.dataSourceField.setText(xmlDir.getAbsolutePath());
                FunctionBitPatternsMainProvider.this.updatePanel();
            }
        });
        buttonPanel.add(readXMLButton);
        JButton mineProgramButton = new JButton(EXPLORE_FUNCTION_PATTERNS_TEXT);
        mineProgramButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Program program = FunctionBitPatternsMainProvider.this.plugin.getCurrentProgram();
                if (program == null) {
                    Msg.showWarn((Object)this, (Component)FunctionBitPatternsMainProvider.this.component, (String)"Current program null", (Object)"Please open a program");
                } else {
                    DataGatheringParamsDialog paramDialog = new DataGatheringParamsDialog(FunctionBitPatternsMainProvider.DATA_GATHERING_TEXT, FunctionBitPatternsMainProvider.this.component);
                    if (paramDialog.isCanceled) {
                        return;
                    }
                    DataGatheringParams params = paramDialog.getDataGatheringParams();
                    FunctionBitPatternsMainProvider.this.dataSourceField.setText(program.getName());
                    FunctionBitPatternsMainProvider.this.patternReader = new FileBitPatternInfoReader(program, params, FunctionBitPatternsMainProvider.this.component);
                    FunctionBitPatternsMainProvider.this.updatePanel();
                    FunctionBitPatternsMainProvider.this.tabbedPane.setSelectedIndex(0);
                }
            }
        });
        buttonPanel.add(mineProgramButton);
        JPanel dataInfoPanel = new JPanel();
        PairLayout pairLayout = new PairLayout();
        dataInfoPanel.setLayout((LayoutManager)pairLayout);
        dataInfoPanel.add((Component)new GLabel(DATA_SOURCE_FIELD_LABEL));
        this.dataSourceField = new JTextField(70);
        this.dataSourceField.setEditable(false);
        dataInfoPanel.add(this.dataSourceField);
        dataInfoPanel.add((Component)new GLabel(NUM_FUNCS_FIELD_LABEL));
        this.numFunctionsField = new JTextField(10);
        this.numFunctionsField.setEditable(false);
        dataInfoPanel.add(this.numFunctionsField);
        dataInfoPanel.add((Component)new GLabel(NUM_FILES_FIELD_LABEL));
        this.numFilesField = new JTextField(10);
        this.numFilesField.setEditable(false);
        dataInfoPanel.add(this.numFilesField);
        JPanel instructionInfoPanel = new JPanel();
        PairLayout instructionLayout = new PairLayout();
        instructionInfoPanel.setLayout((LayoutManager)instructionLayout);
        instructionInfoPanel.add((Component)new GLabel(FIRST_INSTRUCTIONS_LABEL));
        this.firstInstructionsField = new JTextField(10);
        this.firstInstructionsField.setEditable(false);
        instructionInfoPanel.add(this.firstInstructionsField);
        instructionInfoPanel.add((Component)new GLabel(PRE_INSTRUCTIONS_LABEL));
        this.preInstructionsField = new JTextField(10);
        this.preInstructionsField.setEditable(false);
        instructionInfoPanel.add(this.preInstructionsField);
        instructionInfoPanel.add((Component)new GLabel(RETURN_INSTRUCTIONS_LABEL));
        this.returnInstructionsField = new JTextField(10);
        this.returnInstructionsField.setEditable(false);
        instructionInfoPanel.add(this.returnInstructionsField);
        JPanel bytesInfoPanel = new JPanel();
        PairLayout bytesLayout = new PairLayout();
        bytesInfoPanel.setLayout((LayoutManager)bytesLayout);
        bytesInfoPanel.add((Component)new GLabel(FIRST_BYTES_LABEL));
        this.firstBytesField = new JTextField(10);
        this.firstBytesField.setEditable(false);
        bytesInfoPanel.add(this.firstBytesField);
        bytesInfoPanel.add((Component)new GLabel(PRE_BYTES_LABEL));
        this.preBytesField = new JTextField(10);
        this.preBytesField.setEditable(false);
        bytesInfoPanel.add(this.preBytesField);
        bytesInfoPanel.add((Component)new GLabel(RETURN_BYTES_LABEL));
        this.returnBytesField = new JTextField(10);
        this.returnBytesField.setEditable(false);
        bytesInfoPanel.add(this.returnBytesField);
        infoPanel.add(instructionInfoPanel);
        infoPanel.add(bytesInfoPanel);
        infoPanel.add(dataInfoPanel);
        controlPanel.add(infoPanel);
        controlPanel.add(buttonPanel);
        return controlPanel;
    }

    public JComponent getComponent() {
        return this.component;
    }

    private void createActions() {
        DockingAction analyzeInstructionsAction = new DockingAction(this, "Analyze Selected Node", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                InstructionTreeContext iTreeContext = (InstructionTreeContext)context;
                iTreeContext.analyze();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context instanceof InstructionTreeContext;
            }
        };
        analyzeInstructionsAction.setPopupMenuData(new MenuData(new String[]{"Analyze Node"}));
        analyzeInstructionsAction.setDescription("Analyze all byte sequences corresponding to this instruction sequence.");
        analyzeInstructionsAction.setHelpLocation(new HelpLocation("FunctionBitPatternsExplorerPlugin", "Analyzing_Byte_Sequences"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)analyzeInstructionsAction);
        DockingAction analyzeByteSeqAction = new DockingAction(this, "Analyze Selected Sequences", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ByteSequenceContext byteSeqContext = (ByteSequenceContext)context;
                byteSeqContext.analyze();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context instanceof ByteSequenceContext;
            }
        };
        analyzeByteSeqAction.setPopupMenuData(new MenuData(new String[]{"Analyze Sequences"}));
        analyzeByteSeqAction.setHelpLocation(new HelpLocation("FunctionBitPatternsExplorerPlugin", "Analyzing_Byte_Sequences"));
        analyzeByteSeqAction.setDescription("Analyze Selected Byte Sequences");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)analyzeByteSeqAction);
        DockingAction evaluateSelectedAction = new DockingAction(this, "Evaluate Selected Sequences", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EvaluateContext evalContext = (EvaluateContext)context;
                evalContext.analyze();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context instanceof EvaluateContext;
            }
        };
        evaluateSelectedAction.setPopupMenuData(new MenuData(new String[]{"Evaluate Selected Patterns"}));
        evaluateSelectedAction.setDescription("Evalute Selected Patterns");
        evaluateSelectedAction.setHelpLocation(new HelpLocation("FunctionBitPatternsExplorerPlugin", "Evaluating_Patterns"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)evaluateSelectedAction);
        this.gatherDataFromProgramAction = new DockingAction(EXPLORE_FUNCTION_PATTERNS_TEXT, this.tool.getName()){

            public void actionPerformed(ActionContext context) {
                Program program = FunctionBitPatternsMainProvider.this.plugin.getCurrentProgram();
                DataGatheringParamsDialog paramDialog = new DataGatheringParamsDialog(FunctionBitPatternsMainProvider.DATA_GATHERING_TEXT, FunctionBitPatternsMainProvider.this.component);
                if (paramDialog.isCanceled) {
                    return;
                }
                DataGatheringParams params = paramDialog.getDataGatheringParams();
                FunctionBitPatternsMainProvider.this.dataSourceField.setText(program.getName());
                FunctionBitPatternsMainProvider.this.tool.showComponentProvider((ComponentProvider)FunctionBitPatternsMainProvider.this, true);
                FunctionBitPatternsMainProvider.this.patternReader = new FileBitPatternInfoReader(program, params, FunctionBitPatternsMainProvider.this.component);
                FunctionBitPatternsMainProvider.this.updatePanel();
                FunctionBitPatternsMainProvider.this.tabbedPane.setSelectedIndex(0);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return FunctionBitPatternsMainProvider.this.plugin.getCurrentProgram() != null;
            }
        };
        this.gatherDataFromProgramAction.setMenuBarData(new MenuData(new String[]{"&Tools", EXPLORE_FUNCTION_PATTERNS_TEXT}));
        HelpLocation helpLocation = new HelpLocation("FunctionBitPatternsExplorerPlugin", "Function_Bit_Patterns_Explorer_Plugin");
        this.gatherDataFromProgramAction.setHelpLocation(helpLocation);
        this.tool.addAction((DockingActionIf)this.gatherDataFromProgramAction);
    }

    public void dispose() {
        this.firstBytesPanel.dispose();
        this.clipboard.dispose();
        this.tool.removeAction((DockingActionIf)this.gatherDataFromProgramAction);
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (event == null) {
            return null;
        }
        int selectedTab = this.tabbedPane.getSelectedIndex();
        switch (selectedTab) {
            case 0: {
                return new InstructionTreeContext(this.firstInstPanel);
            }
            case 1: {
                return new InstructionTreeContext(this.preInstPanel);
            }
            case 2: {
                return new InstructionTreeContext(this.returnInstPanel);
            }
            case 3: {
                return new ByteSequenceContext(this.firstBytesPanel);
            }
            case 4: {
                return new ByteSequenceContext(this.preBytesPanel);
            }
            case 5: {
                return new ByteSequenceContext(this.returnBytesPanel);
            }
            case 8: {
                return new EvaluateContext(this.clipboard.getLastSelectedObjects());
            }
        }
        return super.getActionContext(event);
    }

    public boolean resetExistingTableData() {
        return this.resetTableData;
    }

    private void updatePanel() {
        int selectedTab = this.tabbedPane.getSelectedIndex();
        this.numFunctionsField.setText(Integer.toString(this.patternReader.getNumFuncs()));
        this.numFilesField.setText(Integer.toString(this.patternReader.getNumFiles()));
        DataGatheringParams params = this.patternReader.getDataGatheringParams();
        this.firstInstructionsField.setText(Integer.toString(params.getNumFirstInstructions()));
        this.preInstructionsField.setText(Integer.toString(params.getNumPreInstructions()));
        this.returnInstructionsField.setText(Integer.toString(params.getNumReturnInstructions()));
        this.firstBytesField.setText(Integer.toString(params.getNumFirstBytes()));
        this.preBytesField.setText(Integer.toString(params.getNumPreBytes()));
        this.returnBytesField.setText(Integer.toString(params.getNumReturnBytes()));
        this.tabbedPane.removeTabAt(7);
        this.contextRegisterPanel = new ContextRegisterPanelBuilder(this.patternReader.getContextRegisterExtent().toString());
        this.tabbedPane.insertTab(CONTEXT_REGISTER_TITLE, null, this.contextRegisterPanel.buildContextRegisterPanel(), null, 7);
        this.firstInstPanel.setFsReaderAndUpdateExtent(this.patternReader);
        this.preInstPanel.setFsReaderAndUpdateExtent(this.patternReader);
        this.returnInstPanel.setFsReaderAndUpdateExtent(this.patternReader);
        if (!this.firstInstPanel.isTreeEmpty()) {
            this.firstInstPanel.enablePercentageFilterButtons(true);
        }
        if (!this.preInstPanel.isTreeEmpty()) {
            this.preInstPanel.enablePercentageFilterButtons(true);
        }
        this.firstBytesPanel.setFsReader(this.patternReader);
        this.firstBytesPanel.enableLengthFilterButtons(true);
        this.preBytesPanel.setFsReader(this.patternReader);
        this.preBytesPanel.enableLengthFilterButtons(true);
        this.returnBytesPanel.setFsReader(this.patternReader);
        this.returnBytesPanel.enableLengthFilterButtons(true);
        this.alignmentPanel.resetModulus();
        this.alignmentPanel.updateExtentAndClearFilter(this.patternReader.getContextRegisterExtent());
        this.alignmentPanel.setFsReader(this.patternReader);
        this.alignmentPanel.updateAlignmentPanel();
        boolean shouldBeOn = !this.patternReader.getContextRegisterExtent().getContextRegisters().isEmpty();
        this.firstInstPanel.enableFilterButtons(shouldBeOn);
        this.preInstPanel.enableFilterButtons(shouldBeOn);
        this.alignmentPanel.enableFilterButtons(shouldBeOn);
        this.firstBytesPanel.enableFilterButtons(shouldBeOn);
        this.preBytesPanel.enableFilterButtons(shouldBeOn);
        this.returnInstPanel.enableFilterButtons(shouldBeOn);
        this.returnBytesPanel.enableFilterButtons(shouldBeOn);
        this.tabbedPane.setSelectedIndex(selectedTab);
        this.plugin.clearPatterns();
        this.clipboard.updateClipboard();
    }

    private void initializeOptions() {
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
    }

    class InstructionTreeContext
    extends DefaultActionContext {
        private FunctionBitPatternsGTree tree;
        private TreePath path;

        InstructionTreeContext(InstructionSequenceTreePanelBuilder panelBuilder) {
            this.tree = panelBuilder.getGTree();
            this.path = panelBuilder.getSelectionPath();
        }

        void analyze() {
            if (this.tree == null) {
                return;
            }
            if (this.path == null) {
                return;
            }
            PatternType type = this.tree.getType();
            InstructionSequenceTreePathFilter pathFilter = new InstructionSequenceTreePathFilter(this.path, type);
            ContextRegisterFilter cRegFilter = null;
            switch (type) {
                case FIRST: {
                    cRegFilter = FunctionBitPatternsMainProvider.this.firstInstPanel.getContextRegisterFilter();
                    break;
                }
                case PRE: {
                    cRegFilter = FunctionBitPatternsMainProvider.this.preInstPanel.getContextRegisterFilter();
                    break;
                }
                case RETURN: {
                    cRegFilter = FunctionBitPatternsMainProvider.this.returnInstPanel.getContextRegisterFilter();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type " + type.name());
                }
            }
            List<ByteSequenceRowObject> rowObjects = ByteSequenceRowObject.getRowObjectsFromInstructionSequences(FunctionBitPatternsMainProvider.this.patternReader.getFInfoList(), pathFilter, cRegFilter);
            new SimpleByteSequenceAnalyzerProvider(FunctionBitPatternsMainProvider.this.plugin, pathFilter.toString(), cRegFilter, rowObjects, FunctionBitPatternsMainProvider.this.component, type);
        }
    }

    class ByteSequenceContext
    extends DefaultActionContext {
        ByteSequencePanelBuilder builder;
        List<ByteSequenceRowObject> selectedRows;

        ByteSequenceContext(ByteSequencePanelBuilder builder) {
            this.builder = builder;
            this.selectedRows = builder.getLastSelectedRows();
        }

        void analyze() {
            if (!this.builder.isLengthFiltered()) {
                Msg.showWarn((Object)((Object)this), (Component)FunctionBitPatternsMainProvider.this.component, (String)"Set Length Filter", (Object)"You must apply a length filter before analyzing sequences of bytes.");
                return;
            }
            new PatternMiningAnalyzerProvider(FunctionBitPatternsMainProvider.this.plugin, this.selectedRows, FunctionBitPatternsMainProvider.this.component, this.builder.getType(), this.builder.getContextRegisterFilter());
        }
    }

    class EvaluateContext
    extends DefaultActionContext {
        List<PatternInfoRowObject> selectedRows;

        public EvaluateContext(List<PatternInfoRowObject> selectedRowObjects) {
            this.selectedRows = selectedRowObjects;
        }

        void analyze() {
            if (FunctionBitPatternsMainProvider.this.plugin.getCurrentProgram() == null) {
                Msg.showWarn((Object)((Object)this), (Component)FunctionBitPatternsMainProvider.this.component, (String)"Null Program", (Object)"Please open a program");
                return;
            }
            if (this.selectedRows.isEmpty()) {
                return;
            }
            PatternEvaluationStats currentStats = FunctionBitPatternsMainProvider.this.clipboard.evaluatePatterns(this.selectedRows);
            new PatternEvalTableProvider(currentStats, FunctionBitPatternsMainProvider.this.component, FunctionBitPatternsMainProvider.this.plugin, FunctionBitPatternsMainProvider.this.plugin.getCurrentProgram());
        }
    }
}

