/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xml;

import generic.concurrent.GThreadPool;
import generic.jar.ResourceFile;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.AbstractXmlPullParser;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlElementImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class ThreadedXmlPullParserImpl
extends AbstractXmlPullParser {
    private static final XmlElement XML_END_TOKEN = new XmlElementImpl(false, false, "END TOKEN", -1, null, null, 0, 0);
    private final String name;
    private final LinkedBlockingQueue<XmlElement> queue;
    private Locator locator;
    private final HashMap<String, HashMap<String, String>> processingInstructions = new HashMap();
    private final Future<?> parsingTask;
    private XmlElement nextElement;
    private volatile boolean isParsing = false;
    private volatile Exception exception;
    private volatile boolean disposed;
    private GThreadPool threadPool;

    ThreadedXmlPullParserImpl(File file, ErrorHandler errHandler, boolean validate, int capacity) throws SAXException, IOException {
        this(new ResourceFile(file), errHandler, validate, capacity);
    }

    ThreadedXmlPullParserImpl(ResourceFile file, ErrorHandler errHandler, boolean validate, int capacity) throws SAXException, IOException {
        this.name = file.getName();
        this.queue = new LinkedBlockingQueue(capacity);
        ContentHandlerRunnable runnable = new ContentHandlerRunnable(file.getParentFile(), file.getInputStream(), errHandler, validate);
        this.threadPool = GThreadPool.getSharedThreadPool((String)"XMLParser");
        this.parsingTask = this.threadPool.submit((Runnable)runnable);
    }

    ThreadedXmlPullParserImpl(InputStream input, String inputName, ErrorHandler errHandler, boolean validate, int capacity) throws SAXException {
        this.name = inputName;
        this.queue = new LinkedBlockingQueue(capacity);
        ContentHandlerRunnable runnable = new ContentHandlerRunnable(null, input, errHandler, validate);
        this.threadPool = GThreadPool.getSharedThreadPool((String)"XMLParser");
        this.parsingTask = this.threadPool.submit((Runnable)runnable);
    }

    private void checkForException() {
        if (this.exception != null) {
            throw new RuntimeException(this.exception);
        }
        if (this.disposed) {
            throw new RuntimeException("Xml Parser was disposed!");
        }
    }

    public String getProcessingInstruction(String piName, String attribute) {
        this.hasNext();
        Map map = this.processingInstructions.get(piName.toUpperCase());
        if (map == null) {
            return null;
        }
        return (String)map.get(attribute.toUpperCase());
    }

    public boolean hasNext() {
        this.nextElement = this.waitForNextElement(this.nextElement);
        return this.nextElement != XML_END_TOKEN;
    }

    private XmlElement waitForNextElement(XmlElement element) {
        this.checkForException();
        while (element == null) {
            try {
                element = this.queue.poll(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkForException();
        }
        return element;
    }

    public XmlElement peek() {
        if (this.hasNext()) {
            return this.nextElement;
        }
        return null;
    }

    public XmlElement next() {
        if (this.hasNext()) {
            XmlElement elementToReturn = this.nextElement;
            this.nextElement = null;
            return elementToReturn;
        }
        return null;
    }

    public void dispose() {
        this.disposed = true;
        this.parsingTask.cancel(true);
    }

    private void closeQueue() {
        this.addElement(XML_END_TOKEN);
    }

    private void addElement(XmlElement element) {
        while (!this.disposed) {
            try {
                this.queue.put(element);
                return;
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isPullingContent() {
        return false;
    }

    public void setPullingContent(boolean pullingContent) {
        if (pullingContent) {
            throw new RuntimeException("this impl can't inject content");
        }
    }

    boolean isParsing() {
        return this.isParsing;
    }

    private class ContentHandlerRunnable
    implements Runnable {
        private InputStream input;
        private DefaultContentHandlerWrapper contentHandler;
        private SAXParser saxParser;
        private ResourceFile resolveDir;

        ContentHandlerRunnable(ResourceFile parent, InputStream input, ErrorHandler errHandler, boolean validate) throws SAXException {
            this.resolveDir = parent;
            this.input = input;
            this.contentHandler = new DefaultContentHandlerWrapper(errHandler);
            try {
                SAXParserFactory saxParserFactory = XmlUtilities.createSecureSAXParserFactory(true);
                saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", false);
                saxParserFactory.setFeature("http://xml.org/sax/features/validation", validate);
                this.saxParser = saxParserFactory.newSAXParser();
                this.saxParser.getXMLReader().setEntityResolver((publicId, systemId) -> {
                    if (this.resolveDir == null) {
                        return null;
                    }
                    ResourceFile resolvedFile = new ResourceFile(this.resolveDir, new File(systemId).getName());
                    InputSource inputSource = new InputSource();
                    inputSource.setPublicId(publicId);
                    inputSource.setSystemId(resolvedFile.toURI().toString());
                    return inputSource;
                });
            }
            catch (ParserConfigurationException e) {
                Msg.error((Object)this, (Object)e.getMessage());
                throw new SAXException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ThreadedXmlPullParserImpl.this.isParsing = true;
            Thread thread = Thread.currentThread();
            String originalThreadName = thread.getName();
            try {
                thread.setName(originalThreadName + " - " + ThreadedXmlPullParserImpl.this.name);
                InputSource inputSource = new InputSource(this.input);
                XMLReader reader = this.saxParser.getXMLReader();
                reader.setContentHandler(this.contentHandler);
                reader.setErrorHandler(this.contentHandler);
                reader.setDTDHandler(this.contentHandler);
                reader.parse(inputSource);
            }
            catch (Exception e) {
                ThreadedXmlPullParserImpl.this.exception = e;
            }
            finally {
                ThreadedXmlPullParserImpl.this.isParsing = false;
                thread.setName(originalThreadName);
                ThreadedXmlPullParserImpl.this.closeQueue();
            }
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class DefaultContentHandlerWrapper
    extends DefaultHandler {
        private StringBuilder textBuf = new StringBuilder();
        private final ErrorHandler errorHandler;
        private int level = -1;

        public DefaultContentHandlerWrapper(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return null;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            if (this.errorHandler == null) {
                return;
            }
            this.errorHandler.error(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            if (this.errorHandler == null) {
                return;
            }
            this.errorHandler.fatalError(e);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (this.errorHandler == null) {
                return;
            }
            this.errorHandler.warning(e);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.textBuf.append(ch, start, length);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            ThreadedXmlPullParserImpl.this.locator = locator;
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            HashMap<String, String> map = ThreadedXmlPullParserImpl.this.processingInstructions.get(target = target.toUpperCase());
            if (map == null) {
                map = new HashMap();
                ThreadedXmlPullParserImpl.this.processingInstructions.put(target, map);
            }
            StringTokenizer st = new StringTokenizer(data);
            while (st.hasMoreTokens()) {
                this.parseAttributeValue(map, st.nextToken());
            }
        }

        private void parseAttributeValue(HashMap<String, String> map, String attrValuePair) {
            String value;
            int ix = attrValuePair.indexOf(61);
            if (ix < 1 || ix == attrValuePair.length() - 1) {
                return;
            }
            String attr = attrValuePair.substring(0, ix);
            if ((value = attrValuePair.substring(++ix)).startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            map.put(attr.toUpperCase(), value.toUpperCase());
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            ThreadedXmlPullParserImpl.this.addElement((XmlElement)new XmlElementImpl(false, true, qName, this.level, null, this.textBuf.toString(), ThreadedXmlPullParserImpl.this.locator.getColumnNumber(), ThreadedXmlPullParserImpl.this.locator.getLineNumber()));
            this.textBuf = new StringBuilder();
            --this.level;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            ++this.level;
            this.textBuf.setLength(0);
            LinkedHashMap<String, String> attrMap = new LinkedHashMap<String, String>();
            int length = atts.getLength();
            for (int ii = 0; ii < length; ++ii) {
                attrMap.put(atts.getQName(ii), atts.getValue(ii));
            }
            ThreadedXmlPullParserImpl.this.addElement((XmlElement)new XmlElementImpl(true, false, qName, this.level, attrMap, null, ThreadedXmlPullParserImpl.this.locator.getColumnNumber(), ThreadedXmlPullParserImpl.this.locator.getLineNumber()));
        }
    }
}

