/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.validator;

import docking.widgets.conditiontestpanel.ConditionResult;
import docking.widgets.conditiontestpanel.ConditionStatus;
import ghidra.app.plugin.core.analysis.validator.PostAnalysisValidator;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;

public class RedFlagsValidator
extends PostAnalysisValidator {
    private static final String NAME = "Red Flags Validator";

    public RedFlagsValidator(Program program) {
        super(program);
    }

    @Override
    public ConditionResult doRun(TaskMonitor monitor) {
        StringBuilder warnings = new StringBuilder();
        int flags = this.checkRedFlags(this.program, warnings, monitor);
        ConditionStatus status = flags > 0 ? ConditionStatus.Warning : ConditionStatus.Passed;
        return new ConditionResult(status, warnings.toString());
    }

    private int checkRedFlags(Program prog, StringBuilder warnings, TaskMonitor monitor) {
        Iterator bookmarkIter = prog.getBookmarkManager().getBookmarksIterator("Error");
        int count = 0;
        monitor.setIndeterminate(true);
        while (bookmarkIter.hasNext() && !monitor.isCancelled()) {
            monitor.incrementProgress(1L);
            bookmarkIter.next();
            ++count;
        }
        if (count > 0) {
            warnings.append(prog.getDomainFile().getName() + " has " + count + " error bookmarks.\n");
        }
        return count;
    }

    public String getDescription() {
        return "Look for red flags -- errors in disassembly, etc.";
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return this.getName();
    }
}

