/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.context.FunctionSupplierContext;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.calltree.CallTreeOptions;
import ghidra.app.plugin.core.calltree.CallTreeProvider;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.StringUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import resources.Icons;
import util.CollectionUtils;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Graph", shortDescription="Call Trees Plugin", description="This plugin shows incoming and outgoing calls and function references for a given function foo. More specifically, one tree of the plugin will show all callers and function referring to foo and the other tree of the plugin will show all calls and references to functions made by foo.")
public class CallTreePlugin
extends ProgramPlugin {
    static final Icon PROVIDER_ICON = Icons.ARROW_DOWN_RIGHT_ICON;
    private List<CallTreeProvider> providers = new ArrayList<CallTreeProvider>();
    private DockingAction showCallTreeFromMenuAction;
    private CallTreeProvider primaryProvider;

    public CallTreePlugin(PluginTool tool) {
        super(tool);
        this.createActions();
        this.primaryProvider = new CallTreeProvider(this, true);
        this.providers.add(this.primaryProvider);
    }

    @Override
    protected void locationChanged(ProgramLocation loc) {
        for (CallTreeProvider provider : this.providers) {
            provider.setLocation(loc);
        }
    }

    @Override
    protected void programActivated(Program program) {
        for (CallTreeProvider provider : this.providers) {
            provider.programActivated(program);
        }
    }

    @Override
    protected void programDeactivated(Program program) {
        for (CallTreeProvider provider : this.providers) {
            provider.programDeactivated(program);
        }
    }

    @Override
    protected void programClosed(Program program) {
        for (CallTreeProvider provider : this.providers) {
            provider.programClosed(program);
        }
    }

    public void readConfigState(SaveState saveState) {
        this.primaryProvider.readConfigState(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.primaryProvider.writeConfigState(saveState);
    }

    protected void dispose() {
        ArrayList<CallTreeProvider> copy = new ArrayList<CallTreeProvider>(this.providers);
        for (CallTreeProvider provider : copy) {
            this.removeProvider(provider);
        }
    }

    private CallTreeProvider findTransientProviderForLocation(Function function) {
        for (CallTreeProvider provider : this.providers) {
            if (!provider.isTransient() || !provider.isShowingFunction(function)) continue;
            return provider;
        }
        return null;
    }

    CallTreeProvider findTransientProviderForLocation(ProgramLocation location) {
        for (CallTreeProvider provider : this.providers) {
            if (!provider.isTransient() || !provider.isShowingLocation(location)) continue;
            return provider;
        }
        return null;
    }

    private void createActions() {
        String actionName = "Static Function Call Trees";
        final String group = "ShowReferencesTo";
        this.showCallTreeFromMenuAction = new DockingAction(actionName, this.getName()){

            public void actionPerformed(ActionContext context) {
                Function f = CallTreePlugin.this.getFunction(context);
                CallTreePlugin.this.showNewCallTree(f);
            }

            public boolean isEnabledForContext(ActionContext context) {
                Function f = CallTreePlugin.this.getFunction(context);
                if (f == null) {
                    return false;
                }
                String menuText = "Show Call Trees for " + f.getName();
                String trimmedMenuText = StringUtilities.trim((String)menuText, (int)50);
                this.setPopupMenuData(new MenuData(new String[]{"References", trimmedMenuText}, PROVIDER_ICON, group));
                return true;
            }
        };
        this.showCallTreeFromMenuAction.setPopupMenuData(new MenuData(new String[]{"References", "Show Call Trees"}, PROVIDER_ICON, group));
        this.showCallTreeFromMenuAction.setHelpLocation(new HelpLocation("CallTreePlugin", "Call_Tree_Plugin"));
        this.showCallTreeFromMenuAction.setDescription("Shows the Function Call Trees window for the item under the cursor.  The new window will not change along with the Listing cursor.");
        this.tool.addAction((DockingActionIf)this.showCallTreeFromMenuAction);
    }

    private Function getFunction(ActionContext context) {
        FunctionSupplierContext functionContext;
        if (context instanceof ListingActionContext) {
            return this.getFunction(this.currentLocation);
        }
        if (context instanceof FunctionSupplierContext && (functionContext = (FunctionSupplierContext)context).hasFunctions()) {
            Set<Function> functions = functionContext.getFunctions();
            return (Function)CollectionUtils.any(functions);
        }
        ComponentProvider provider = context.getComponentProvider();
        if (!(provider instanceof CallTreeProvider)) {
            return null;
        }
        return this.getFunction(this.currentLocation);
    }

    private void createAndShowProvider(Function function) {
        CallTreeProvider provider = new CallTreeProvider(this, false);
        CallTreeOptions callTreeOptions = this.primaryProvider.getCallTreeOptions();
        provider.setCallTreeOptions(callTreeOptions);
        this.providers.add(provider);
        provider.initialize(this.currentProgram, function);
        this.tool.showComponentProvider((ComponentProvider)provider, true);
    }

    CallTreeProvider getPrimaryProvider() {
        return this.primaryProvider;
    }

    DockingAction getShowCallTreeFromMenuAction() {
        return this.showCallTreeFromMenuAction;
    }

    ProgramLocation getCurrentLocation() {
        return this.currentLocation;
    }

    void removeProvider(CallTreeProvider provider) {
        if (!this.providers.contains((Object)provider)) {
            return;
        }
        this.providers.remove((Object)provider);
        this.tool.removeComponentProvider((ComponentProvider)provider);
        provider.dispose();
    }

    void showNewCallTree(Function function) {
        if (this.currentProgram == null) {
            return;
        }
        CallTreeProvider provider = this.findTransientProviderForLocation(function);
        if (provider != null) {
            this.tool.showComponentProvider((ComponentProvider)provider, true);
            return;
        }
        this.createAndShowProvider(function);
    }

    private Function getFunction(ProgramLocation location) {
        if (location == null) {
            return null;
        }
        FunctionManager functionManager = this.currentProgram.getFunctionManager();
        Address address = location.getAddress();
        Function destinationFunction = this.getReferencedFunction(address);
        if (destinationFunction != null) {
            return destinationFunction;
        }
        return functionManager.getFunctionContaining(address);
    }

    Function getReferencedFunction(Address address) {
        Reference[] references;
        FunctionManager functionManager = this.currentProgram.getFunctionManager();
        ReferenceManager referenceManager = this.currentProgram.getReferenceManager();
        for (Reference reference : references = referenceManager.getReferencesFrom(address)) {
            Address toAddress = reference.getToAddress();
            Function toFunction = functionManager.getFunctionAt(toAddress);
            if (toFunction == null) continue;
            return toFunction;
        }
        return null;
    }
}

