/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import ghidra.app.plugin.core.compositeeditor.CompEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.compositeeditor.StructureEditorProvider;
import ghidra.util.exception.AssertException;

public class AddBitFieldAction
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Add Bitfield";
    private static final String GROUP_NAME = "5_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Add a bitfield at the position of a selected component";
    private static String[] POPUP_PATH = new String[]{"Add Bitfield"};

    public AddBitFieldAction(CompositeEditorProvider<?, ?> provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, null, null);
        this.setDescription(DESCRIPTION);
        if (!(this.model instanceof CompEditorModel)) {
            throw new AssertException("unsupported use");
        }
    }

    public void actionPerformed(ActionContext context) {
        StructureEditorProvider structProvider = (StructureEditorProvider)this.provider;
        structProvider.showAddBitFieldEditor();
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (this.hasIncompleteFieldEntry()) {
            return false;
        }
        boolean enabled = true;
        CompEditorModel editorModel = (CompEditorModel)this.model;
        if (!(this.provider instanceof StructureEditorProvider) || editorModel.isPackingEnabled() || editorModel.getNumSelectedRows() != 1) {
            enabled = false;
        }
        return enabled;
    }
}

