/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.cmd.refs.AddMemRefCmd;
import ghidra.app.cmd.refs.AddMemRefsCmd;
import ghidra.app.cmd.refs.AddOffsetMemRefCmd;
import ghidra.app.cmd.refs.AddRegisterRefCmd;
import ghidra.app.cmd.refs.AddStackRefCmd;
import ghidra.app.cmd.refs.RemoveExternalNameCmd;
import ghidra.app.cmd.refs.RemoveReferenceCmd;
import ghidra.app.cmd.refs.SetExternalNameCmd;
import ghidra.app.cmd.refs.SetExternalRefCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.core.references.CreateDefaultReferenceAction;
import ghidra.app.plugin.core.references.DeleteReferencesAction;
import ghidra.app.plugin.core.references.EditReferenceDialog;
import ghidra.app.plugin.core.references.EditReferencesProvider;
import ghidra.app.plugin.core.references.ExternalReferencesProvider;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.SymbolInspector;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.StackReference;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="View/Edit references", description="Provides a dockable window for adding, removing, and editing references from an instruction or data location.", servicesRequired={GoToService.class, ProgramManager.class}, eventsConsumed={ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class, ProgramLocationPluginEvent.class})
public class ReferencesPlugin
extends Plugin {
    static final String REFS_GROUP = "references";
    static final String SHOW_REFS_GROUP = "ShowReferences";
    static final String SUBMENU_NAME = "References";
    private Program currentProgram;
    private ProgramLocation currentLocation;
    private GoToService goToService;
    private ProgramManager programMgr;
    private BrowserCodeUnitFormat cuFormat;
    private SymbolInspector symbolInspector;
    private DockingAction showAction;
    private DeleteReferencesAction deleteAction;
    private CreateDefaultReferenceAction createAction;
    private DockingAction addAction;
    private List<EditReferencesProvider> editRefProviders = new ArrayList<EditReferencesProvider>();
    private EditReferenceDialog editRefDialog;
    private ExternalReferencesProvider externalReferencesProvider;
    private boolean defaultFollowOnLocation = false;
    private boolean defaultGotoReferenceLocation;

    public ReferencesPlugin(PluginTool tool) {
        super(tool);
        this.setupActions();
        this.externalReferencesProvider = new ExternalReferencesProvider(this);
    }

    protected void init() {
        this.goToService = (GoToService)this.tool.getService(GoToService.class);
        this.programMgr = (ProgramManager)this.tool.getService(ProgramManager.class);
        this.cuFormat = new BrowserCodeUnitFormat((ServiceProvider)this.tool);
        this.symbolInspector = new SymbolInspector((ServiceProvider)this.tool, null);
    }

    public void dispose() {
        this.disposeAllDialogs();
        this.disposeAllProviders();
        this.showAction.dispose();
        this.createAction.dispose();
        this.deleteAction.dispose();
        this.addAction.dispose();
        this.externalReferencesProvider.dispose();
        this.symbolInspector.dispose();
        super.dispose();
    }

    private void disposeAllProviders() {
        for (EditReferencesProvider provider : this.editRefProviders) {
            provider.dispose();
        }
        this.editRefProviders.clear();
    }

    private void disposeProvider(EditReferencesProvider provider) {
        this.editRefProviders.remove(provider);
        provider.dispose();
    }

    private void cleanupProviders(Program p, boolean closed) {
        boolean keepOne = true;
        Iterator<EditReferencesProvider> iter = this.editRefProviders.iterator();
        while (iter.hasNext()) {
            EditReferencesProvider provider = iter.next();
            if (p != provider.getCurrentProgram() || !closed && provider.isLocationLocked()) continue;
            if (keepOne && !provider.isLocationLocked()) {
                provider.show(null, null);
                keepOne = false;
                continue;
            }
            provider.dispose();
            iter.remove();
        }
    }

    private void disposeAllDialogs() {
        if (this.editRefDialog != null) {
            this.editRefDialog.dispose();
            this.editRefDialog = null;
        }
    }

    private void setupActions() {
        this.tool.setMenuGroup(new String[]{SUBMENU_NAME}, REFS_GROUP);
        this.showAction = new ListingContextAction("View/Edit References From", this.getName()){

            @Override
            protected boolean isEnabledForContext(ListingActionContext context) {
                return context.getLocation() instanceof CodeUnitLocation;
            }

            @Override
            protected void actionPerformed(ListingActionContext context) {
                ReferencesPlugin.this.editReferenceAtLocation(context.getProgram(), context.getLocation());
            }
        };
        this.showAction.setPopupMenuData(new MenuData(new String[]{SUBMENU_NAME, "Add/Edit..."}, null, SHOW_REFS_GROUP));
        this.showAction.setKeyBindingData(new KeyBindingData(82, 0));
        this.showAction.setDescription("View, add, remove, or edit all types of references from a code unit");
        this.tool.addAction((DockingActionIf)this.showAction);
        this.createAction = new CreateDefaultReferenceAction(this);
        this.createAction.setPopupMenuData(new MenuData(new String[]{SUBMENU_NAME, CreateDefaultReferenceAction.DEFAULT_MENU_ITEM_NAME}, null, SHOW_REFS_GROUP));
        this.createAction.setKeyBindingData(new KeyBindingData(82, 640));
        this.createAction.setDescription("Create default forward reference");
        this.tool.addAction((DockingActionIf)this.createAction);
        this.addAction = new ListingContextAction("Add Reference From", this.getName()){

            @Override
            protected boolean isEnabledForContext(ListingActionContext context) {
                ProgramLocation loc = context.getLocation();
                return loc instanceof CodeUnitLocation && context.getCodeUnit() != null;
            }

            @Override
            protected void actionPerformed(ListingActionContext context) {
                ProgramLocation loc = context.getLocation();
                CodeUnit cu = context.getCodeUnit();
                int opIndex = -1;
                int subIndex = -1;
                if (loc instanceof OperandFieldLocation) {
                    opIndex = ((OperandFieldLocation)loc).getOperandIndex();
                    subIndex = ((OperandFieldLocation)loc).getSubOperandIndex();
                }
                if (cu != null) {
                    ReferencesPlugin.this.popupAddReferenceDialog(cu, opIndex, subIndex, null);
                }
            }
        };
        this.addAction.setPopupMenuData(new MenuData(new String[]{SUBMENU_NAME, "Add Reference from..."}, null, SHOW_REFS_GROUP));
        this.addAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)this.addAction);
        this.tool.addAction((DockingActionIf)new CreateRefActionWrapper(0, "Add Default Memory Reference", 77));
        this.tool.addAction((DockingActionIf)new CreateRefActionWrapper(1, "Set Default Stack Reference", 83));
        this.tool.addAction((DockingActionIf)new CreateRefActionWrapper(2, "Set Default Register Reference", 82));
        this.deleteAction = new DeleteReferencesAction(this);
        this.tool.addAction((DockingActionIf)this.deleteAction);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent evt = (ProgramActivatedPluginEvent)event;
            Program newProg = evt.getActiveProgram();
            if (this.currentProgram != null) {
                this.programDeactivated(this.currentProgram);
            }
            if (newProg != null) {
                this.programActivated(newProg);
            }
        } else if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent evt = (ProgramClosedPluginEvent)event;
            this.programClosed(evt.getProgram());
        } else if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent evt = (ProgramLocationPluginEvent)event;
            this.locationChanged(evt.getLocation());
        }
    }

    private void locationChanged(ProgramLocation loc) {
        if (loc == null) {
            return;
        }
        this.currentLocation = loc;
        for (EditReferencesProvider referencesProvider : this.editRefProviders) {
            if (!this.tool.isVisible((ComponentProvider)referencesProvider) || referencesProvider.isLocationLocked()) continue;
            referencesProvider.updateForLocation(this.currentProgram, loc);
        }
    }

    EditReferenceDialog popupAddReferenceDialog(CodeUnit cu, int opIndex, int subIndex, EditReferencesProvider provider) {
        if (this.editRefDialog == null) {
            this.editRefDialog = new EditReferenceDialog(this);
        }
        this.editRefDialog.initDialog(cu, opIndex, subIndex, null);
        this.tool.showDialog((DialogComponentProvider)this.editRefDialog, (ComponentProvider)provider);
        return this.editRefDialog;
    }

    EditReferenceDialog popupEditReferenceDialog(CodeUnit cu, Reference ref, EditReferencesProvider provider) {
        if (this.editRefDialog == null) {
            this.editRefDialog = new EditReferenceDialog(this);
        }
        this.editRefDialog.initDialog(cu, ref.getOperandIndex(), -1, ref);
        this.tool.showDialog((DialogComponentProvider)this.editRefDialog, (ComponentProvider)provider);
        return this.editRefDialog;
    }

    private void programActivated(Program program) {
        this.currentProgram = program;
        this.externalReferencesProvider.setProgram(program);
    }

    private void programDeactivated(Program program) {
        this.currentProgram = null;
        this.currentLocation = null;
        this.externalReferencesProvider.setProgram(null);
        if (this.editRefDialog != null) {
            this.editRefDialog.close();
        }
        this.cleanupProviders(program, false);
    }

    private void programClosed(Program program) {
        if (this.editRefDialog != null) {
            this.editRefDialog.close();
        }
        this.cleanupProviders(program, true);
    }

    Program getCurrentProgram() {
        return this.currentProgram;
    }

    ProgramLocation getCurrentLocation() {
        return this.currentLocation;
    }

    private void editReferenceAtLocation(Program program, ProgramLocation location) {
        EditReferencesProvider openProvider = this.findOpenProvider(program, location);
        if (openProvider != null) {
            openProvider.show(openProvider.getCurrentProgram(), openProvider.getInitLocation());
        } else {
            EditReferencesProvider provider = new EditReferencesProvider(this);
            provider.show(program, location);
            this.editRefProviders.add(provider);
        }
    }

    private EditReferencesProvider findOpenProvider(Program program, ProgramLocation location) {
        for (EditReferencesProvider provider : this.editRefProviders) {
            if (!this.isProviderCodeUnitMatch(program, location, provider)) continue;
            return provider;
        }
        return null;
    }

    private boolean isProviderCodeUnitMatch(Program program, ProgramLocation location, EditReferencesProvider provider) {
        ProgramLocation existingProviderLocation = provider.getInitLocation();
        if (existingProviderLocation == null) {
            return false;
        }
        Address address = existingProviderLocation.getAddress();
        if (address == null) {
            return false;
        }
        if (!address.equals((Object)location.getAddress())) {
            return false;
        }
        CodeUnit previousCodeUnit = provider.getCodeUnit();
        if (previousCodeUnit == null) {
            return false;
        }
        CodeUnit newCodeUnit = provider.getCodeUnit(program, location);
        return previousCodeUnit.equals((Object)newCodeUnit);
    }

    void providerClosed(ComponentProvider provider) {
        if (provider instanceof EditReferencesProvider) {
            this.disposeProvider((EditReferencesProvider)provider);
        }
    }

    void goTo(Program program, Address addr) {
        this.goToService.goTo(addr, program);
    }

    void goTo(Program program, ProgramLocation loc) {
        this.goToService.goTo(loc, program);
    }

    Address checkMemoryAddress(Component c, Program p, Address addr, long refOffset) {
        AddressSpace baseSpace;
        long offset;
        OverlayAddressSpace overlaySpace;
        AddressSpace space;
        Object warningMsg = "";
        Object refOffStr = "";
        if (refOffset != 0L) {
            boolean neg = refOffset < 0L;
            refOffStr = (neg ? "-" : "+") + "0x" + Long.toHexString(neg ? -refOffset : refOffset);
        }
        if ((space = addr.getAddressSpace()) instanceof OverlayAddressSpace && !(overlaySpace = (OverlayAddressSpace)space).contains(offset = (baseSpace = p.getAddressFactory().getAddressSpace(overlaySpace.getBaseSpaceID())).truncateOffset(addr.getOffset() + refOffset))) {
            Address newAddr = overlaySpace.translateAddress(addr, true);
            warningMsg = (String)warningMsg + "The overlay address " + addr.toString(true) + (String)refOffStr + " is not contained within the overlay space '" + overlaySpace.getName() + "'\nand will get mapped into the underlying address space (" + newAddr.toString(true) + (String)refOffStr + ").\n \n";
            addr = newAddr;
        }
        Address testAddr = addr;
        String wrapStr = "";
        if (refOffset != 0L) {
            try {
                testAddr = addr.addNoWrap(refOffset);
            }
            catch (AddressOverflowException e) {
                warningMsg = (String)warningMsg + "The address " + addr.toString(true) + (String)refOffStr + " must be wrapped within the address space.\n \n";
                testAddr = addr.addWrap(refOffset);
                wrapStr = "wrapped ";
            }
        }
        if (!p.getMemory().contains(testAddr)) {
            warningMsg = (String)warningMsg + "The equivalent " + wrapStr + "address " + testAddr.toString(true) + " is not contained within the Program's defined memory blocks.\n \n";
        }
        if (((String)warningMsg).length() != 0) {
            int rc;
            if (c == null) {
                c = this.tool.getToolFrame();
            }
            if ((rc = OptionDialog.showOptionDialog((Component)c, (String)"Set Memory Reference", (String)((String)warningMsg + "Do you wish to continue?"), (String)"Continue", (int)2)) != 1) {
                return null;
            }
        }
        return addr;
    }

    void addMemoryReferences(Component c, AddressSetView set, CodeUnit cu, int opIndex, boolean alwaysConfirm) {
        if (set == null || set.isEmpty()) {
            return;
        }
        Address cuAddr = cu.getMinAddress();
        ReferenceManager refMgr = cu.getProgram().getReferenceManager();
        Reference ref = refMgr.getPrimaryReferenceFrom(cuAddr, opIndex);
        String nonMemType = null;
        if (ref != null) {
            if (ref.isStackReference()) {
                nonMemType = "Stack";
            } else if (ref.getToAddress().isRegisterAddress()) {
                nonMemType = "Register";
            } else if (ref.isExternalReference()) {
                nonMemType = "External";
            }
        }
        String setSize = null;
        long cnt = set.getNumAddresses();
        if (cnt > 100L) {
            setSize = "large";
        }
        if (cnt > 200L) {
            setSize = "very large";
        }
        RefType rt = RefTypeFactory.getDefaultMemoryRefType((CodeUnit)cu, (int)opIndex, null, (boolean)false);
        if (alwaysConfirm || nonMemType != null || setSize != null) {
            int rc;
            Object op = opIndex == -1 ? "MNEMONIC" : "OP-" + opIndex;
            String msg = "Add memory references from " + (String)op + " at " + String.valueOf(cu.getMinAddress()) + " to all code units in your selection?\nReference Type: " + rt.toString();
            if (setSize != null) {
                msg = msg + "\n \nWarning! A " + setSize + " number of addresses have been selected!\n";
            }
            if (nonMemType != null) {
                msg = msg + "\n \nWarning! Existing " + nonMemType + " reference(s) will be deleted!";
            }
            if ((rc = OptionDialog.showOptionDialog((Component)c, (String)"Add Memory References", (String)msg, (String)"OK", (int)2)) != 1) {
                return;
            }
        }
        AddMemRefsCmd cmd = new AddMemRefsCmd(cuAddr, set, rt, SourceType.USER_DEFINED, opIndex);
        this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (DomainObject)cu.getProgram());
    }

    boolean addDefaultReference(Program program, Address fromAddr, int opIndex, Address toAddr, RefType refType) {
        AddMemRefCmd cmd = new AddMemRefCmd(fromAddr, toAddr, refType, SourceType.USER_DEFINED, opIndex, true);
        return this.tool.execute((Command)cmd, (DomainObject)program);
    }

    boolean addDefaultReference(Program program, Address fromAddr, int opIndex, int stackOffset) {
        AddStackRefCmd cmd = new AddStackRefCmd(fromAddr, opIndex, stackOffset, SourceType.USER_DEFINED);
        return this.tool.execute((Command)cmd, (DomainObject)program);
    }

    boolean addDefaultReference(Program program, Address fromAddr, int opIndex, Register reg) {
        AddRegisterRefCmd cmd = new AddRegisterRefCmd(fromAddr, opIndex, reg, SourceType.USER_DEFINED);
        return this.tool.execute((Command)cmd, (DomainObject)program);
    }

    void deleteReference(Program program, Reference ref) {
        RemoveReferenceCmd cmd = new RemoveReferenceCmd(ref);
        this.tool.execute((Command)cmd, (DomainObject)program);
    }

    void deleteReferences(Program program, Reference[] refs) {
        CompoundCmd cmd = new CompoundCmd("Remove Reference(s)");
        for (Reference ref : refs) {
            cmd.add((Command)new RemoveReferenceCmd(ref));
        }
        this.tool.execute((Command)cmd, (DomainObject)program);
    }

    boolean updateReference(Reference editRef, CodeUnit fromCodeUnit, Address toAddr, boolean isOffsetRef, long offset, RefType refType) {
        CompoundCmd cmd = new CompoundCmd("Update Memory Reference");
        int opIndex = editRef.getOperandIndex();
        cmd.add((Command)new RemoveReferenceCmd(editRef));
        if (isOffsetRef) {
            cmd.add((Command)new AddOffsetMemRefCmd(fromCodeUnit.getMinAddress(), toAddr, false, refType, SourceType.USER_DEFINED, opIndex, offset));
        } else {
            cmd.add((Command)new AddMemRefCmd(fromCodeUnit.getMinAddress(), toAddr, refType, SourceType.USER_DEFINED, opIndex, editRef.isPrimary()));
        }
        return this.tool.execute((Command)cmd, (DomainObject)fromCodeUnit.getProgram());
    }

    boolean addReference(CodeUnit fromCodeUnit, int opIndex, Address toAddr, boolean isOffsetRef, long offset, RefType refType) {
        Address fromAddr = fromCodeUnit.getMinAddress();
        Reference[] refs = fromCodeUnit.getProgram().getReferenceManager().getReferencesFrom(fromAddr, opIndex);
        if (refs.length != 0 && !refs[0].isMemoryReference() && !this.confirmPossibleReferenceRemoval(fromCodeUnit, opIndex, refs[0])) {
            return false;
        }
        Object cmd = isOffsetRef ? new AddOffsetMemRefCmd(fromAddr, toAddr, false, refType, SourceType.USER_DEFINED, opIndex, offset) : new AddMemRefCmd(fromAddr, toAddr, refType, SourceType.USER_DEFINED, opIndex);
        return this.tool.execute((Command)cmd, (DomainObject)fromCodeUnit.getProgram());
    }

    boolean updateReference(Reference editRef, CodeUnit fromCodeUnit, Register reg, RefType refType) {
        Program p = fromCodeUnit.getProgram();
        Address fromAddr = fromCodeUnit.getMinAddress();
        Function f = p.getFunctionManager().getFunctionContaining(fromAddr);
        if (f == null) {
            return false;
        }
        CompoundCmd cmd = new CompoundCmd("Update Register Reference");
        cmd.add((Command)new RemoveReferenceCmd(editRef));
        cmd.add((Command)new AddRegisterRefCmd(fromAddr, editRef.getOperandIndex(), reg, refType, SourceType.USER_DEFINED));
        return this.tool.execute((Command)cmd, (DomainObject)p);
    }

    boolean addReference(CodeUnit fromCodeUnit, int opIndex, Register reg, RefType refType) {
        if (!this.confirmPossibleReferenceRemoval(fromCodeUnit, opIndex, null)) {
            return false;
        }
        Program p = fromCodeUnit.getProgram();
        Address fromAddr = fromCodeUnit.getMinAddress();
        Function f = p.getFunctionManager().getFunctionContaining(fromAddr);
        if (f == null) {
            return false;
        }
        AddRegisterRefCmd cmd = new AddRegisterRefCmd(fromAddr, opIndex, reg, refType, SourceType.USER_DEFINED);
        return this.tool.execute((Command)cmd, (DomainObject)p);
    }

    public boolean updateReference(StackReference editRef, CodeUnit fromCodeUnit, int stackOffset, RefType refType) {
        Program p = fromCodeUnit.getProgram();
        Address fromAddr = fromCodeUnit.getMinAddress();
        Function f = p.getFunctionManager().getFunctionContaining(fromAddr);
        if (f == null) {
            return false;
        }
        CompoundCmd cmd = new CompoundCmd("Update Stack Reference");
        cmd.add((Command)new RemoveReferenceCmd((Reference)editRef));
        cmd.add((Command)new AddStackRefCmd(fromAddr, editRef.getOperandIndex(), stackOffset, refType, SourceType.USER_DEFINED));
        return this.tool.execute((Command)cmd, (DomainObject)p);
    }

    public boolean addReference(CodeUnit fromCodeUnit, int opIndex, int stackOffset, RefType refType) {
        if (!this.confirmPossibleReferenceRemoval(fromCodeUnit, opIndex, null)) {
            return false;
        }
        Program p = fromCodeUnit.getProgram();
        Address fromAddr = fromCodeUnit.getMinAddress();
        Function f = p.getFunctionManager().getFunctionContaining(fromAddr);
        if (f == null) {
            return false;
        }
        AddStackRefCmd cmd = new AddStackRefCmd(fromAddr, opIndex, stackOffset, refType, SourceType.USER_DEFINED);
        return this.tool.execute((Command)cmd, (DomainObject)p);
    }

    private void buildAddExtRefCmd(CompoundCmd<Program> cmd, Program p, Address fromAddr, int opIndex, String extName, String path, Address addr, String label, RefType refType) {
        cmd.add((Command)new SetExternalRefCmd(fromAddr, opIndex, extName, label, addr, refType, SourceType.USER_DEFINED));
        String existingPath = p.getExternalManager().getExternalLibraryPath(extName);
        if (path != null && path.length() > 0 && !path.equals(existingPath)) {
            cmd.add((Command)new SetExternalNameCmd(extName, path));
        }
    }

    public boolean updateReference(ExternalReference editRef, CodeUnit fromCodeUnit, String extName, String path, Address addr, String label) {
        Program p = fromCodeUnit.getProgram();
        ExternalLocation oldExtLoc = editRef.getExternalLocation();
        String oldExtName = oldExtLoc.getLibraryName();
        CompoundCmd cmd = new CompoundCmd("Update External Reference");
        this.buildAddExtRefCmd((CompoundCmd<Program>)cmd, p, fromCodeUnit.getMinAddress(), editRef.getOperandIndex(), extName, path, addr, label, editRef.getReferenceType());
        if (this.tool.execute((Command)cmd, (DomainObject)p)) {
            if (!p.getReferenceManager().getReferencesTo(oldExtLoc.getExternalSpaceAddress()).hasNext() && 1 == OptionDialog.showYesNoDialog((Component)this.tool.getActiveWindow(), (String)"Delete Unused External Location?", (String)("Remove unused external location symbol '" + oldExtLoc.toString() + "'?"))) {
                this.deleteExternalLocation(p, oldExtLoc);
                if (!p.getExternalManager().getExternalLocations(oldExtName).hasNext() && 1 == OptionDialog.showYesNoDialog((Component)this.tool.getActiveWindow(), (String)"Delete Unused Library Name?", (String)("Remove unused library symbol '" + oldExtName + "'?"))) {
                    RemoveExternalNameCmd rmCmd = new RemoveExternalNameCmd(oldExtName);
                    this.tool.execute((Command)rmCmd, (DomainObject)p);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteExternalLocation(Program p, ExternalLocation extLoc) {
        int txId = p.startTransaction("Delete External Location");
        try {
            p.getSymbolTable().removeSymbolSpecial(extLoc.getSymbol());
        }
        finally {
            p.endTransaction(txId, true);
        }
    }

    public boolean addReference(CodeUnit fromCodeUnit, int opIndex, String extName, String path, Address addr, String label) {
        if (!this.confirmPossibleReferenceRemoval(fromCodeUnit, opIndex, null)) {
            return false;
        }
        Program p = fromCodeUnit.getProgram();
        RefType refType = RefType.DATA;
        if (fromCodeUnit instanceof Instruction) {
            FlowType flowType = ((Instruction)fromCodeUnit).getFlowType();
            if (flowType.isComputed()) {
                if (flowType.isCall()) {
                    refType = RefType.COMPUTED_CALL;
                } else if (flowType.isJump()) {
                    refType = RefType.COMPUTED_JUMP;
                }
            } else if (flowType.isCall()) {
                refType = RefType.UNCONDITIONAL_CALL;
            } else if (flowType.isJump()) {
                refType = RefType.UNCONDITIONAL_JUMP;
            }
        }
        CompoundCmd cmd = new CompoundCmd("Add External Reference");
        this.buildAddExtRefCmd((CompoundCmd<Program>)cmd, p, fromCodeUnit.getMinAddress(), opIndex, extName, path, addr, label, refType);
        return this.tool.execute((Command)cmd, (DomainObject)p);
    }

    private boolean confirmPossibleReferenceRemoval(CodeUnit fromCodeUnit, int opIndex, Reference oldRef) {
        if (oldRef == null) {
            Reference[] refs = fromCodeUnit.getProgram().getReferenceManager().getReferencesFrom(fromCodeUnit.getMinAddress(), opIndex);
            if (refs.length != 0) {
                oldRef = refs[0];
            } else {
                return true;
            }
        }
        String curType = oldRef.isStackReference() ? "Stack reference" : (oldRef.getToAddress().isRegisterAddress() ? "Register reference" : (oldRef.isExternalReference() ? "External reference" : "Memory reference(s)"));
        JComponent parent = this.editRefDialog.getComponent();
        int choice = OptionDialog.showOptionDialog((Component)parent, (String)"Reference Removal Confirmation", (String)("Warning! existing " + curType + " will be removed."), (String)"Continue", (int)2);
        return choice != 0;
    }

    public void readDataState(SaveState saveState) {
        Element element = saveState.getXmlElement("EditReferenceDialogState");
        if (element != null) {
            if (this.editRefDialog == null) {
                this.editRefDialog = new EditReferenceDialog(this);
            }
            SaveState state = new SaveState(element);
            this.editRefDialog.readDataState(state);
        }
    }

    public void writeDataState(SaveState saveState) {
        if (this.editRefDialog != null) {
            SaveState state = new SaveState("EditReferenceDialogState");
            this.editRefDialog.writeDataState(state);
            saveState.putXmlElement("EditReferenceDialogState", state.saveToXml());
        }
    }

    ProgramManager getProgramManager() {
        return this.programMgr;
    }

    public BrowserCodeUnitFormat getCodeUnitFormat() {
        return this.cuFormat;
    }

    public SymbolInspector getSymbolInspector() {
        return this.symbolInspector;
    }

    void setDefaultFollowOnLocation(boolean state) {
        this.defaultFollowOnLocation = state;
    }

    boolean getDefaultFollowOnLocation() {
        return this.defaultFollowOnLocation;
    }

    void setDefaultGotoReferenceLocation(boolean state) {
        this.defaultGotoReferenceLocation = state;
    }

    boolean getDefaultGotoReferenceLocation() {
        return this.defaultGotoReferenceLocation;
    }

    private class CreateRefActionWrapper
    extends ListingContextAction {
        final int refClass;

        CreateRefActionWrapper(int refClass, String name, int keyCode) {
            super(name, ReferencesPlugin.this.getName());
            this.refClass = refClass;
            this.setKeyBindingData(new KeyBindingData(77, 0));
            this.setHelpLocation(new HelpLocation("ReferencesPlugin", "Create_Default_Reference"));
        }

        @Override
        protected boolean isEnabledForContext(ListingActionContext context) {
            return ReferencesPlugin.this.createAction.isEnabledForContext(context) && this.refClass == ReferencesPlugin.this.createAction.getDefaultRefClass();
        }

        @Override
        protected void actionPerformed(ListingActionContext context) {
            ReferencesPlugin.this.createAction.actionPerformed(context);
        }
    }
}

