/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macos.rm;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.macos.asd.Entry;
import ghidra.app.util.bin.format.macos.asd.EntryDescriptor;
import ghidra.app.util.bin.format.macos.rm.ResourceMap;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ResourceHeader
extends Entry
implements StructConverter {
    private int resourceDataOffset;
    private int resourceMapOffset;
    private int resourceDataLength;
    private int resourceMapLength;
    private ResourceMap _map;

    public ResourceHeader(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, false), new EntryDescriptor(2, 0, (int)provider.length()));
    }

    public ResourceHeader(BinaryReader reader, EntryDescriptor entry) throws IOException {
        this(reader, entry, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceHeader(BinaryReader reader, EntryDescriptor entry, boolean onlyDoShallowParsing) throws IOException {
        super(entry);
        long beginningOfResourceFork = reader.getPointerIndex();
        this.resourceDataOffset = reader.readNextInt();
        this.resourceMapOffset = reader.readNextInt();
        this.resourceDataLength = reader.readNextInt();
        this.resourceMapLength = reader.readNextInt();
        if (onlyDoShallowParsing) {
            return;
        }
        long oldIndex = reader.getPointerIndex();
        try {
            reader.setPointerIndex(beginningOfResourceFork + (long)this.resourceMapOffset);
            this._map = new ResourceMap(reader, this);
        }
        finally {
            reader.setPointerIndex(oldIndex);
        }
    }

    public int getResourceMapOffset() {
        return this.resourceMapOffset;
    }

    public int getResourceMapLength() {
        return this.resourceMapLength;
    }

    public int getResourceDataOffset() {
        return this.resourceDataOffset;
    }

    public int getResourceDataLength() {
        return this.resourceDataLength;
    }

    public ResourceMap getMap() {
        return this._map;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(ResourceHeader.class);
    }
}

