/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexMemberForwarded;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableImplMap
extends CliAbstractTable {
    public CliTableImplMap(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliImplMapRow row = new CliImplMapRow(reader.readNextShort(), CliIndexMemberForwarded.readCodedIndex(reader, stream), this.readStringIndex(reader), this.readTableIndex(reader, CliTypeTable.ModuleRef));
            this.rows.add(row);
            this.strings.add(row.importNameIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "ImplMap Row", 0);
        rowDt.add((DataType)CliFlags.CliEnumPInvokeAttributes.dataType, "MappingFlags", "Bitmask of type PInvokeAttributes");
        rowDt.add(CliIndexMemberForwarded.toDataType(this.metadataStream), "MemberForwarded", "MemberForwarded Coded Index");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "ImportName", "index into String heap");
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.ModuleRef), "ImportScope", "Index into ModuleRef table");
        return rowDt;
    }

    public class CliImplMapRow
    extends CliAbstractTableRow {
        public short mappingFlags;
        public int memberForwardedIndex;
        public int importNameIndex;
        public int importScopeIndex;

        public CliImplMapRow(short mappingFlags, int memberForwardedIndex, int importNameIndex, int importScopeIndex) {
            this.mappingFlags = mappingFlags;
            this.memberForwardedIndex = memberForwardedIndex;
            this.importNameIndex = importNameIndex;
            this.importScopeIndex = importScopeIndex;
        }

        @Override
        public String getRepresentation() {
            String memberRep;
            try {
                memberRep = CliTableImplMap.this.getRowRepresentationSafe(CliIndexMemberForwarded.getTableName(this.memberForwardedIndex), CliIndexMemberForwarded.getRowIndex(this.memberForwardedIndex));
            }
            catch (InvalidInputException e) {
                memberRep = Integer.toHexString(this.memberForwardedIndex);
            }
            return String.format("MemberForwarded %s Routine ImportName %s Unmanaged ImportScope %s Flags %s", memberRep, CliTableImplMap.this.metadataStream.getStringsStream().getString(this.importNameIndex), CliTableImplMap.this.getRowRepresentationSafe(CliTypeTable.ModuleRef, this.importScopeIndex), CliFlags.CliEnumPInvokeAttributes.dataType.getName(this.mappingFlags & 0xFFFF));
        }
    }
}

