/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import generic.theme.GThemeDefaults;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.database.sourcemap.SourceFileIdType;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.sourcemap.SourceFileManager;
import ghidra.program.model.sourcemap.SourceMapEntry;
import ghidra.program.model.sourcemap.SourceMapEntryIterator;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.SourceMapFieldLocation;
import ghidra.util.HelpLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class SourceMapFieldFactory
extends FieldFactory {
    static final String FIELD_NAME = "Source Map";
    private static final String GROUP_TITLE = "Source Map";
    static final String SHOW_FILENAME_ONLY_OPTION_NAME = "Source Map.Show Filename Only";
    static final String SHOW_INFO_AT_ALL_ADDRESSES_OPTION_NAME = "Source Map.Show Source Info at Every Address";
    static final String MAX_ENTRIES_PER_ADDRESS_OPTION_NAME = "Source Map.Maximum Number of Source Map Entries to Display";
    static final String SHOW_IDENTIFIER_OPTION_NAME = "Source Map.Show Identifier";
    static final String NO_SOURCE_INFO = "unknown:??";
    private boolean showOnlyFileNames = true;
    private boolean showInfoAtAllAddresses = false;
    private boolean showIdentifier = false;
    private static final int DEFAULT_MAX_ENTRIES = 4;
    private int maxEntries = 4;
    static Color OFFCUT_COLOR = GThemeDefaults.Colors.Palette.GRAY;

    public SourceMapFieldFactory() {
        super("Source Map");
    }

    protected SourceMapFieldFactory(FieldFormatModel model, ListingHighlightProvider highlightProvider, Options displayOptions, Options fieldOptions) {
        super("Source Map", model, highlightProvider, displayOptions, fieldOptions);
        this.registerOptions(fieldOptions);
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider highlightProvider, ToolOptions options, ToolOptions fieldOptions) {
        return new SourceMapFieldFactory(formatModel, highlightProvider, (Options)options, (Options)fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> obj, int varWidth) {
        if (!this.enabled) {
            return null;
        }
        Object obj2 = obj.getObject();
        if (!(obj2 instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj2;
        List<SourceMapEntry> entriesToShow = this.getSourceMapEntries(cu);
        if (entriesToShow.isEmpty()) {
            if (!this.showInfoAtAllAddresses) {
                return null;
            }
            AttributedString attrString = new AttributedString(NO_SOURCE_INFO, (Color)GThemeDefaults.Colors.Palette.BLACK, this.getMetrics());
            return ListingTextField.createSingleLineTextField(this, obj, (FieldElement)new TextFieldElement(attrString, 0, 0), this.startX + varWidth, this.width, this.hlProvider);
        }
        ArrayList<FieldElement> fieldElements = new ArrayList<FieldElement>();
        Address cuAddr = cu.getAddress();
        if (!this.showInfoAtAllAddresses) {
            ArrayList<SourceMapEntry> entriesStartingWithinCu = new ArrayList<SourceMapEntry>();
            for (SourceMapEntry entry : entriesToShow) {
                if (entry.getBaseAddress().compareTo((Object)cuAddr) < 0) continue;
                entriesStartingWithinCu.add(entry);
            }
            if (entriesStartingWithinCu.isEmpty()) {
                return null;
            }
            entriesToShow = entriesStartingWithinCu;
        }
        int entriesShown = 0;
        for (SourceMapEntry entry : entriesToShow) {
            StringBuilder sb = new StringBuilder();
            if (this.showOnlyFileNames) {
                sb.append(entry.getSourceFile().getFilename());
            } else {
                sb.append(entry.getSourceFile().getPath());
            }
            sb.append(":");
            sb.append(entry.getLineNumber());
            sb.append(" (");
            sb.append(entry.getLength());
            sb.append(")");
            if (this.showIdentifier) {
                SourceFile sourceFile = entry.getSourceFile();
                if (sourceFile.getIdType().equals((Object)SourceFileIdType.NONE)) {
                    sb.append(" [no id]");
                } else {
                    sb.append(" [");
                    sb.append(sourceFile.getIdType().name());
                    sb.append("=");
                    sb.append(sourceFile.getIdAsString());
                    sb.append("]");
                }
            }
            Object color = entry.getBaseAddress().compareTo((Object)cuAddr) <= 0 ? GThemeDefaults.Colors.Palette.BLACK : OFFCUT_COLOR;
            AttributedString attrString = new AttributedString(sb.toString(), (Color)color, this.getMetrics());
            fieldElements.add((FieldElement)new TextFieldElement(attrString, 0, 0));
            if (++entriesShown != this.maxEntries) continue;
            int entriesLeft = entriesToShow.size() - this.maxEntries;
            if (entriesLeft == 0) break;
            String singularOrPlural = entriesLeft == 1 ? " entry " : " entries ";
            AttributedString truncatedMessage = new AttributedString("-- " + entriesLeft + singularOrPlural + "omitted --", OFFCUT_COLOR, this.getMetrics());
            fieldElements.add((FieldElement)new TextFieldElement(truncatedMessage, 0, 0));
            break;
        }
        return ListingTextField.createMultilineTextField(this, obj, fieldElements, this.startX + varWidth, this.width, this.maxEntries + 1, this.hlProvider);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (loc instanceof SourceMapFieldLocation) {
            SourceMapFieldLocation sourceField = (SourceMapFieldLocation)loc;
            return new FieldLocation(index, fieldNum, sourceField.getRow(), sourceField.getCharOffset());
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        List<SourceMapEntry> entriesToShow = this.getSourceMapEntries(cu);
        if (entriesToShow == null || entriesToShow.size() <= row) {
            return null;
        }
        return new SourceMapFieldLocation(cu.getProgram(), cu.getAddress(), row, col, entriesToShow.get(row));
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        return category == 4;
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.fieldOptionsChanged(options, optionName, oldValue, newValue);
        if (options.getName().equals("Listing Fields")) {
            if (optionName.equals(SHOW_FILENAME_ONLY_OPTION_NAME)) {
                this.showOnlyFileNames = options.getBoolean(SHOW_FILENAME_ONLY_OPTION_NAME, true);
            }
            if (optionName.equals(SHOW_INFO_AT_ALL_ADDRESSES_OPTION_NAME)) {
                this.showInfoAtAllAddresses = options.getBoolean(SHOW_INFO_AT_ALL_ADDRESSES_OPTION_NAME, false);
            }
            if (optionName.equals(MAX_ENTRIES_PER_ADDRESS_OPTION_NAME)) {
                this.maxEntries = options.getInt(MAX_ENTRIES_PER_ADDRESS_OPTION_NAME, 4);
            }
            if (optionName.equals(SHOW_IDENTIFIER_OPTION_NAME)) {
                this.showIdentifier = options.getBoolean(SHOW_IDENTIFIER_OPTION_NAME, false);
            }
            this.model.update();
        }
    }

    private void registerOptions(Options fieldOptions) {
        HelpLocation helpLoc = new HelpLocation("CodeBrowserPlugin", "Source_Map_Field");
        fieldOptions.registerOption(SHOW_FILENAME_ONLY_OPTION_NAME, (Object)true, helpLoc, "Show only source file name (rather than absolute path)");
        this.showOnlyFileNames = fieldOptions.getBoolean(SHOW_FILENAME_ONLY_OPTION_NAME, true);
        fieldOptions.registerOption(SHOW_INFO_AT_ALL_ADDRESSES_OPTION_NAME, (Object)false, helpLoc, "Show source info at every address (rather than only at beginning of source map entries)");
        this.showInfoAtAllAddresses = fieldOptions.getBoolean(SHOW_INFO_AT_ALL_ADDRESSES_OPTION_NAME, false);
        fieldOptions.registerOption(MAX_ENTRIES_PER_ADDRESS_OPTION_NAME, (Object)4, helpLoc, "Maximum number of source map entries to display");
        this.maxEntries = fieldOptions.getInt(MAX_ENTRIES_PER_ADDRESS_OPTION_NAME, 4);
        fieldOptions.registerOption(SHOW_IDENTIFIER_OPTION_NAME, (Object)false, helpLoc, "Show source file identifier info");
        this.showIdentifier = fieldOptions.getBoolean(SHOW_IDENTIFIER_OPTION_NAME, false);
        fieldOptions.getOptions("Source Map").setOptionsHelpLocation(helpLoc);
    }

    private List<SourceMapEntry> getSourceMapEntries(CodeUnit cu) {
        ArrayList<SourceMapEntry> entries = new ArrayList<SourceMapEntry>();
        SourceFileManager sourceManager = cu.getProgram().getSourceFileManager();
        Address cuMinAddr = cu.getMinAddress();
        Address cuMaxAddr = cu.getMaxAddress();
        SourceMapEntryIterator entryIter = sourceManager.getSourceMapEntryIterator(cuMaxAddr, false);
        while (entryIter.hasNext()) {
            long adjusted;
            SourceMapEntry entry = (SourceMapEntry)entryIter.next();
            long entryLength = entry.getLength();
            long l = adjusted = entryLength == 0L ? 0L : entryLength - 1L;
            if (entry.getBaseAddress().add(adjusted).compareTo((Object)cuMinAddr) >= 0) {
                entries.add(entry);
                continue;
            }
            if (entryLength == 0L) continue;
            break;
        }
        return entries.reversed();
    }
}

