/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.frontend;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/recentFiles/frontend/SwitcherListFocusAction;", "Ljava/awt/event/FocusListener;", "Ljavax/swing/AbstractAction;", "fromList", "Ljavax/swing/JList;", "toList", "listActionIds", "", "", "<init>", "(Ljavax/swing/JList;Ljavax/swing/JList;[Ljava/lang/String;)V", "getFromList", "()Ljavax/swing/JList;", "getToList", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "focusLost", "Ljava/awt/event/FocusEvent;", "focusGained", "index", "", "toIndex", "getToIndex", "()I", "setToIndex", "(I)V", "intellij.platform.recentFiles.frontend"})
@SourceDebugExtension(value={"SMAP\nSwitcherActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwitcherActions.kt\ncom/intellij/platform/recentFiles/frontend/SwitcherListFocusAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,252:1\n13805#2,2:253\n23#3:255\n23#3:256\n*S KotlinDebug\n*F\n+ 1 SwitcherActions.kt\ncom/intellij/platform/recentFiles/frontend/SwitcherListFocusAction\n*L\n210#1:253,2\n182#1:255\n190#1:256\n*E\n"})
public final class SwitcherListFocusAction
extends AbstractAction
implements FocusListener {
    @NotNull
    private final JList<?> fromList;
    @NotNull
    private final JList<?> toList;

    public SwitcherListFocusAction(@NotNull JList<?> fromList, @NotNull JList<?> toList, String ... listActionIds) {
        Intrinsics.checkNotNullParameter(fromList, (String)"fromList");
        Intrinsics.checkNotNullParameter(toList, (String)"toList");
        Intrinsics.checkNotNullParameter((Object)listActionIds, (String)"listActionIds");
        this.fromList = fromList;
        this.toList = toList;
        String[] $this$forEach$iv = listActionIds;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.fromList.getActionMap().put(it, this);
        }
        this.toList.addFocusListener(this);
        this.toList.addListSelectionListener(arg_0 -> SwitcherListFocusAction._init_$lambda$1(this, arg_0));
    }

    @NotNull
    public final JList<?> getFromList() {
        return this.fromList;
    }

    @NotNull
    public final JList<?> getToList() {
        return this.toList;
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SwitcherListFocusAction $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(SwitcherListFocusAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("SwitcherListFocusAction.actionPerformed: isShowing = " + this.toList.isShowing() + ", target list = " + this.toList + ", some element from the list: " + (this.toList.getModel().getSize() > 0 ? this.toList.getModel().getElementAt(0) : null));
        if (this.toList.isShowing()) {
            this.toList.requestFocusInWindow();
        }
    }

    @Override
    public void focusLost(@NotNull FocusEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void focusGained(@NotNull FocusEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SwitcherListFocusAction $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(SwitcherListFocusAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("SwitcherListFocusAction.focusGained: isShowing = " + this.toList.isShowing() + ", target list = " + this.toList + ", target list size = " + this.toList.getModel().getSize());
        int size = this.toList.getModel().getSize();
        if (size > 0) {
            int fromIndex = this.fromList.getSelectedIndex();
            if (fromIndex >= 0) {
                this.setToIndex(RangesKt.coerceAtMost((int)fromIndex, (int)(size - 1)));
            } else if (this.getToIndex() < 0) {
                this.setToIndex(0);
            }
        }
    }

    private final int getToIndex() {
        return this.toList.getSelectedIndex();
    }

    private final void setToIndex(int index) {
        this.fromList.clearSelection();
        this.toList.setSelectedIndex(index);
        this.toList.ensureIndexIsVisible(index);
    }

    private static final void _init_$lambda$1(SwitcherListFocusAction this$0, ListSelectionEvent it) {
        if (!this$0.fromList.isSelectionEmpty() && !this$0.toList.isSelectionEmpty()) {
            this$0.fromList.getSelectionModel().clearSelection();
        }
    }
}

