/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.google.common.primitives.Chars;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.textCompletion.ValuesCompletionProvider;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsLogBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultilinePopupBuilder {
    static final char[] SEPARATORS = new char[]{'|', '\n'};
    @NotNull
    private final EditorTextField myTextField;
    private final char[] mySeparators;

    MultilinePopupBuilder(@NotNull Project project, @NotNull Collection<String> values, @NotNull String initialValue, @Nullable CompletionPrefixProvider completionPrefixProvider) {
        if (project == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(0);
        }
        if (values == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(1);
        }
        if (initialValue == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(2);
        }
        this.myTextField = new TextFieldWithCompletion(project, (TextCompletionProvider)new MyCompletionProvider(values, completionPrefixProvider), initialValue, false, true, false);
        MultilinePopupBuilder.setupTextField(this.myTextField);
        this.mySeparators = SEPARATORS;
    }

    MultilinePopupBuilder(@NotNull Project project, @NotNull String initialValue, char[] separators) {
        if (project == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(3);
        }
        if (initialValue == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(4);
        }
        this.myTextField = new LanguageTextField((Language)PlainTextLanguage.INSTANCE, project, initialValue, (LanguageTextField.DocumentCreator)new LanguageTextField.SimpleDocumentCreator(), false);
        MultilinePopupBuilder.setupTextField(this.myTextField);
        this.mySeparators = separators;
    }

    @NotNull
    JBPopup createPopup() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myTextField, "Center");
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)this.myTextField).setCancelOnClickOutside(true).setAdText(this.getAdText()).setRequestFocus(true).setResizable(true).setMayBeParent(true);
        final JBPopup popup = builder.createPopup();
        popup.setMinimumSize((Dimension)new JBDimension(200, 90));
        DumbAwareAction okAction = new DumbAwareAction(this){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.unregisterCustomShortcutSet(popup.getContent());
                popup.closeOk(e.getInputEvent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$1", "actionPerformed"));
            }
        };
        okAction.registerCustomShortcutSet(CommonShortcuts.getCtrlEnter(), popup.getContent());
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(5);
        }
        return jBPopup;
    }

    @NlsContexts.PopupAdvertisement
    @NotNull
    private String getAdText() {
        String string = VcsLogBundle.message("vcs.log.filter.popup.advertisement.with.key.text", MultilinePopupBuilder.getSeparatorsText(this.mySeparators), KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.getCtrlEnter().getShortcuts()));
        if (string == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    List<String> getSelectedValues() {
        List list = ContainerUtil.mapNotNull((Iterable)StringUtil.tokenize((String)this.myTextField.getText(), (String)new String(this.mySeparators)), value -> {
            String trimmed = value.trim();
            return trimmed.isEmpty() ? null : trimmed;
        });
        if (list == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static String getSeparatorsText(char[] separators) {
        StringBuilder s = new StringBuilder();
        for (char c : separators) {
            String separator;
            String string = separator = c == '\n' ? VcsLogBundle.message("vcs.log.filter.popup.advertisement.text.new.lines", new Object[0]) : Character.toString(c);
            if (s.isEmpty()) {
                s.append(separator);
                continue;
            }
            s.append(" ").append(VcsLogBundle.message("vcs.log.filter.popup.advertisement.text.or.suffix", separator));
        }
        String string = s.toString();
        if (string == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static void setupTextField(@NotNull EditorTextField textField) {
        if (textField == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(9);
        }
        textField.addSettingsProvider(editor -> SoftWrapsEditorCustomization.ENABLED.customize(editor));
        textField.setBorder((Border)new CompoundBorder(JBUI.Borders.empty((int)2), textField.getBorder()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialValue";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedValues";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorsText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupTextField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    private static class MyCompletionProvider
    extends ValuesCompletionProvider.ValuesCompletionProviderDumbAware<String> {
        @Nullable
        private final CompletionPrefixProvider myCompletionPrefixProvider;

        MyCompletionProvider(@NotNull Collection<String> values, @Nullable CompletionPrefixProvider completionPrefixProvider) {
            if (values == null) {
                MyCompletionProvider.$$$reportNull$$$0(0);
            }
            super((TextCompletionValueDescriptor)new DefaultTextCompletionValueDescriptor.StringValueDescriptor(), Chars.asList((char[])SEPARATORS), values, false);
            this.myCompletionPrefixProvider = completionPrefixProvider;
        }

        @Nullable
        public String getPrefix(@NotNull String text, int offset) {
            if (text == null) {
                MyCompletionProvider.$$$reportNull$$$0(1);
            }
            if (this.myCompletionPrefixProvider != null) {
                return this.myCompletionPrefixProvider.getPrefix(text, offset);
            }
            return super.getPrefix(text, offset);
        }

        @Nullable
        public String getAdvertisement() {
            return VcsLogBundle.message("vcs.log.filter.popup.advertisement.text", MultilinePopupBuilder.getSeparatorsText(SEPARATORS));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPrefix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.OverrideOnly
    public static interface CompletionPrefixProvider {
        @NotNull
        public String getPrefix(@NotNull String var1, int var2);
    }
}

