/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public final class DelegateAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        PsiElement owner;
        if (holder == null) {
            DelegateAnnotationChecker.$$$reportNull$$$0(0);
        }
        if (annotation == null) {
            DelegateAnnotationChecker.$$$reportNull$$$0(1);
        }
        if (!"groovy.lang.Delegate".equals(annotation.getQualifiedName())) {
            return false;
        }
        PsiElement annoParent = annotation.getParent();
        PsiElement psiElement = owner = annoParent instanceof PsiModifierList ? annoParent.getParent() : annoParent;
        if (!(owner instanceof GrMethod)) {
            return false;
        }
        if (((GrMethod)owner).getParameterList().getParametersCount() > 0) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("delegate.annotation.is.only.for.methods.without.arguments", new Object[0])).range((PsiElement)annotation).create();
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "annotation";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/annotator/checkers/DelegateAnnotationChecker";
        objectArray[2] = "checkApplicability";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

