/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.tokenexchange;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Base64Url;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenExchangeContext;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.endpoints.TokenEndpoint;
import org.keycloak.protocol.oidc.tokenexchange.AbstractTokenExchangeProvider;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.fgap.AdminPermissions;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.TokenUtil;

public class V1TokenExchangeProvider
extends AbstractTokenExchangeProvider {
    private static final Logger logger = Logger.getLogger(V1TokenExchangeProvider.class);

    public int getVersion() {
        return 1;
    }

    public boolean supports(TokenExchangeContext context) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response tokenExchange() {
        String requestedIssuer;
        KeycloakSession session = this.context.getSession();
        RealmModel realm = this.context.getRealm();
        ClientConnection clientConnection = this.context.getClientConnection();
        Cors cors = this.context.getCors();
        ClientModel client = this.context.getClient();
        EventBuilder event = this.context.getEvent();
        UserModel tokenUser = null;
        UserSessionModel tokenSession = null;
        AccessToken token = null;
        String subjectToken = this.context.getParams().getSubjectToken();
        if (subjectToken != null) {
            String subjectTokenType = this.context.getParams().getSubjectTokenType();
            if (this.isExternalInternalTokenExchangeRequest(this.context)) {
                String subjectIssuer = this.getSubjectIssuer(this.context, subjectToken, subjectTokenType);
                return this.exchangeExternalToken(subjectIssuer, subjectToken);
            }
            if (subjectTokenType != null && !subjectTokenType.equals("urn:ietf:params:oauth:token-type:access_token")) {
                event.detail("reason", "subject_token supports access tokens only");
                event.error("invalid_token");
                throw new CorsErrorResponseException(cors, "invalid_request", "Invalid token type, must be access token", Response.Status.BAD_REQUEST);
            }
            AuthenticationManager.AuthResult authResult = AuthenticationManager.verifyIdentityToken(session, realm, (UriInfo)session.getContext().getUri(), clientConnection, true, true, null, false, subjectToken, this.context.getHeaders(), verifier -> {});
            if (authResult == null) {
                event.detail("reason", "subject_token validation failure");
                event.error("invalid_token");
                throw new CorsErrorResponseException(cors, "invalid_request", "Invalid token", Response.Status.BAD_REQUEST);
            }
            tokenUser = authResult.user();
            tokenSession = authResult.session();
            token = authResult.token();
        }
        String requestedSubject = (String)this.context.getFormParams().getFirst((Object)"requested_subject");
        boolean disallowOnHolderOfTokenMismatch = true;
        if (requestedSubject != null) {
            event.detail("requested_subject", requestedSubject);
            UserModel requestedUser = session.users().getUserByUsername(realm, requestedSubject);
            if (requestedUser == null) {
                requestedUser = session.users().getUserById(realm, requestedSubject);
            }
            if (requestedUser == null || !requestedUser.isEnabled()) {
                event.detail("reason", "requested_subject not found");
                event.error("not_allowed");
                throw new CorsErrorResponseException(cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
            }
            if (token != null) {
                event.detail("impersonator", tokenUser.getUsername());
                AdminAuth auth = new AdminAuth(realm, token, tokenUser, client);
                if (!AdminPermissions.evaluator(session, realm, auth).users().canImpersonate(requestedUser, client)) {
                    event.detail("reason", "subject not allowed to impersonate");
                    event.error("not_allowed");
                    throw new CorsErrorResponseException(cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
                }
            } else {
                if (client.isPublicClient()) {
                    event.detail("reason", "public clients not allowed");
                    event.error("not_allowed");
                    throw new CorsErrorResponseException(cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
                }
                if (!AdminPermissions.management(session, realm).users().canClientImpersonate(client, requestedUser)) {
                    event.detail("reason", "client not allowed to impersonate");
                    event.error("not_allowed");
                    throw new CorsErrorResponseException(cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
                }
                disallowOnHolderOfTokenMismatch = false;
            }
            tokenSession = new UserSessionManager(session).createUserSession(realm, requestedUser, requestedUser.getUsername(), clientConnection.getRemoteHost(), "impersonate", false, null, null);
            if (tokenUser != null) {
                tokenSession.setNote(ImpersonationSessionNote.IMPERSONATOR_ID.toString(), tokenUser.getId());
                tokenSession.setNote(ImpersonationSessionNote.IMPERSONATOR_USERNAME.toString(), tokenUser.getUsername());
            }
            tokenUser = requestedUser;
        }
        if ((requestedIssuer = (String)this.context.getFormParams().getFirst((Object)"requested_issuer")) == null) {
            return this.exchangeClientToClient(tokenUser, tokenSession, token, disallowOnHolderOfTokenMismatch);
        }
        try {
            Response response = this.exchangeToIdentityProvider(tokenUser, tokenSession, requestedIssuer);
            return response;
        }
        finally {
            if (subjectToken == null) {
                try {
                    session.sessions().removeUserSession(realm, tokenSession);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected String getRequestedTokenType() {
        String requestedTokenType = this.context.getParams().getRequestedTokenType();
        if (requestedTokenType == null) {
            requestedTokenType = "urn:ietf:params:oauth:token-type:refresh_token";
            return requestedTokenType;
        }
        if (requestedTokenType.equals("urn:ietf:params:oauth:token-type:access_token") || requestedTokenType.equals("urn:ietf:params:oauth:token-type:refresh_token") || requestedTokenType.equals("urn:ietf:params:oauth:token-type:saml2")) {
            return requestedTokenType;
        }
        this.event.detail("reason", "requested_token_type unsupported");
        this.event.error("invalid_request");
        throw new CorsErrorResponseException(this.cors, "invalid_request", "requested_token_type unsupported", Response.Status.BAD_REQUEST);
    }

    @Override
    protected void validateAudience(AccessToken token, boolean disallowOnHolderOfTokenMismatch, List<ClientModel> targetAudienceClients) {
        ClientModel tokenHolder = token == null ? null : this.realm.getClientByClientId(token.getIssuedFor());
        for (ClientModel targetClient : targetAudienceClients) {
            if (targetClient.isConsentRequired()) {
                this.event.detail("reason", "audience requires consent");
                this.event.detail("audience", targetClient.getClientId());
                this.event.error("consent_denied");
                throw new CorsErrorResponseException(this.cors, "invalid_client", "Client requires user consent", Response.Status.BAD_REQUEST);
            }
            if (!targetClient.isEnabled()) {
                this.event.detail("reason", "audience client disabled");
                this.event.detail("audience", targetClient.getClientId());
                this.event.error("client_disabled");
                throw new CorsErrorResponseException(this.cors, "invalid_client", "Client disabled", Response.Status.BAD_REQUEST);
            }
            boolean isClientTheAudience = targetClient.equals((Object)this.client);
            if (isClientTheAudience) {
                if (this.client.isPublicClient()) {
                    this.forbiddenIfClientIsNotTokenHolder(disallowOnHolderOfTokenMismatch, tokenHolder);
                    continue;
                }
                if (this.client.equals((Object)tokenHolder)) continue;
                this.forbiddenIfClientIsNotWithinTokenAudience(token);
                continue;
            }
            if (this.client.isPublicClient()) {
                this.forbiddenIfClientIsNotTokenHolder(disallowOnHolderOfTokenMismatch, tokenHolder);
            }
            if (AdminPermissions.management(this.session, this.realm).clients().canExchangeTo(this.client, targetClient, token)) continue;
            this.event.detail("reason", "client not allowed to exchange to audience");
            this.event.detail("audience", targetClient.getClientId());
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
        }
    }

    @Override
    protected List<String> getSupportedOAuthResponseTokenTypes() {
        return Arrays.asList("urn:ietf:params:oauth:token-type:access_token", "urn:ietf:params:oauth:token-type:refresh_token");
    }

    @Override
    protected String getRequestedScope(AccessToken token, List<ClientModel> targetAudienceClients) {
        ClientModel targetClient = targetAudienceClients.get(0);
        if (targetAudienceClients.size() > 1) {
            logger.warnf("Only one value of audience parameter currently supported for token exchange. Using audience '%s' and ignoring the other audiences provided", (Object)targetClient.getClientId());
        }
        String scope = (String)this.formParams.getFirst((Object)"scope");
        if (token != null && token.getScope() != null && scope == null) {
            scope = token.getScope();
            HashSet targetClientScopes = new HashSet();
            targetClientScopes.addAll(targetClient.getClientScopes(true).keySet());
            targetClientScopes.addAll(targetClient.getClientScopes(false).keySet());
            scope = Arrays.stream(scope.split(" ")).filter(s -> "openid".equals(s) || targetClientScopes.contains(Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES) ? s.split(":")[0] : s)).collect(Collectors.joining(" "));
        } else if (token != null && token.getScope() != null) {
            String subjectTokenScopes = token.getScope();
            if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES)) {
                subjectTokenScopesSet = Arrays.stream(subjectTokenScopes.split(" ")).map(s -> s.split(":")[0]).collect(Collectors.toSet());
                scope = Arrays.stream(scope.split(" ")).filter(sc -> subjectTokenScopesSet.contains(sc.split(":")[0])).collect(Collectors.joining(" "));
            } else {
                subjectTokenScopesSet = Arrays.stream(subjectTokenScopes.split(" ")).collect(Collectors.toSet());
                scope = Arrays.stream(scope.split(" ")).filter(sc -> subjectTokenScopesSet.contains(sc)).collect(Collectors.joining(" "));
            }
            HashSet targetClientScopes = new HashSet();
            targetClientScopes.addAll(targetClient.getClientScopes(true).keySet());
            targetClientScopes.addAll(targetClient.getClientScopes(false).keySet());
            scope = Arrays.stream(scope.split(" ")).filter(s -> "openid".equals(s) || targetClientScopes.contains(Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES) ? s.split(":")[0] : s)).collect(Collectors.joining(" "));
        }
        return scope;
    }

    @Override
    protected void setClientToContext(List<ClientModel> targetAudienceClients) {
        ClientModel targetClient = this.getTargetClient(targetAudienceClients);
        this.session.getContext().setClient(targetClient);
    }

    protected ClientModel getTargetClient(List<ClientModel> targetAudienceClients) {
        return targetAudienceClients.get(0);
    }

    @Override
    protected Response exchangeClientToOIDCClient(UserModel targetUser, UserSessionModel targetUserSession, String requestedTokenType, List<ClientModel> targetAudienceClients, String scope, AccessToken subjectToken) {
        String issuedTokenType;
        ClientModel targetClient = this.getTargetClient(targetAudienceClients);
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, false);
        AuthenticationSessionModel authSession = this.createSessionModel(targetUserSession, rootAuthSession, targetUser, targetClient, scope);
        AuthenticationManager.setClientScopesInSession(this.session, authSession);
        ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, targetUserSession, authSession);
        if (!AuthenticationManager.isClientSessionValid(this.realm, this.client, targetUserSession, targetUserSession.getAuthenticatedClientSessionByClient(this.client.getId()))) {
            AuthenticationSessionModel clientAuthSession = this.createSessionModel(targetUserSession, rootAuthSession, targetUser, this.client, scope);
            TokenManager.attachAuthenticationSession(this.session, targetUserSession, clientAuthSession);
        }
        this.updateUserSessionFromClientAuth(targetUserSession);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, targetClient, this.event, this.session, targetUserSession, clientSessionCtx).generateAccessToken();
        responseBuilder.getAccessToken().issuedFor(this.client.getClientId());
        if (targetClient != null && !targetClient.equals((Object)this.client)) {
            responseBuilder.getAccessToken().addAudience(targetClient.getClientId());
        }
        if (this.formParams.containsKey((Object)"requested_subject")) {
            targetUserSession.setNote(ImpersonationSessionNote.IMPERSONATOR_CLIENT.toString(), this.client.getId());
        }
        if (targetUserSession.getPersistenceState() == UserSessionModel.SessionPersistenceState.TRANSIENT) {
            responseBuilder.getAccessToken().setSessionId(null);
        }
        if (requestedTokenType.equals("urn:ietf:params:oauth:token-type:refresh_token") && OIDCAdvancedConfigWrapper.fromClientModel(this.client).isUseRefreshToken() && targetUserSession.getPersistenceState() != UserSessionModel.SessionPersistenceState.TRANSIENT) {
            responseBuilder.generateRefreshToken();
            responseBuilder.getRefreshToken().issuedFor(this.client.getClientId());
            issuedTokenType = "urn:ietf:params:oauth:token-type:refresh_token";
        } else {
            issuedTokenType = "urn:ietf:params:oauth:token-type:access_token";
        }
        String scopeParam = clientSessionCtx.getClientSession().getNote("scope");
        if (TokenUtil.isOIDCRequest((String)scopeParam)) {
            responseBuilder.generateIDToken().generateAccessTokenHash();
        }
        AccessTokenResponse res = responseBuilder.build();
        res.setOtherClaims("issued_token_type", (Object)issuedTokenType);
        this.event.detail("audience", targetClient.getClientId()).user(targetUser);
        this.event.success();
        return this.cors.add(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    protected Response exchangeClientToSAML2Client(UserModel targetUser, UserSessionModel targetUserSession, String requestedTokenType, List<ClientModel> targetAudienceClients) {
        ClientModel targetClient = this.getTargetClient(targetAudienceClients);
        LoginProtocolFactory factory = (LoginProtocolFactory)this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, "saml");
        SamlService samlService = (SamlService)factory.createProtocolEndpoint(this.session, this.event);
        AuthenticationSessionModel authSession = samlService.getOrCreateLoginSessionForIdpInitiatedSso(this.session, this.realm, targetClient, null);
        if (authSession == null) {
            logger.error((Object)"SAML assertion consumer url not set up");
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Client requires assertion consumer url set up", Response.Status.BAD_REQUEST);
        }
        authSession.setAuthenticatedUser(targetUser);
        this.event.session(targetUserSession);
        AuthenticationManager.setClientScopesInSession(this.session, authSession);
        ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, targetUserSession, authSession);
        this.updateUserSessionFromClientAuth(targetUserSession);
        SamlClient samlClient = new SamlClient(targetClient);
        SamlProtocol samlProtocol = new TokenEndpoint.TokenExchangeSamlProtocol(samlClient).setEventBuilder(this.event).setHttpHeaders(this.headers).setRealm(this.realm).setSession(this.session).setUriInfo((UriInfo)this.session.getContext().getUri());
        Response samlAssertion = samlProtocol.authenticated(authSession, targetUserSession, clientSessionCtx);
        if (samlAssertion.getStatus() != 200) {
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Can not get SAML 2.0 token", Response.Status.BAD_REQUEST);
        }
        String xmlString = (String)samlAssertion.getEntity();
        String encodedXML = Base64Url.encode((byte[])xmlString.getBytes(GeneralConstants.SAML_CHARSET));
        int assertionLifespan = samlClient.getAssertionLifespan();
        AccessTokenResponse res = new AccessTokenResponse();
        res.setToken(encodedXML);
        res.setTokenType("Bearer");
        res.setExpiresIn(assertionLifespan <= 0 ? (long)this.realm.getAccessCodeLifespan() : (long)assertionLifespan);
        res.setOtherClaims("issued_token_type", (Object)requestedTokenType);
        this.event.detail("audience", targetClient.getClientId()).user(targetUser);
        this.event.success();
        return this.cors.add(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }
}

