/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.config;

import io.quarkus.micrometer.runtime.config.GrpcClientConfigGroup;
import io.quarkus.micrometer.runtime.config.GrpcServerConfigGroup;
import io.quarkus.micrometer.runtime.config.HttpClientConfigGroup;
import io.quarkus.micrometer.runtime.config.HttpServerConfigGroup;
import io.quarkus.micrometer.runtime.config.JsonConfigGroup;
import io.quarkus.micrometer.runtime.config.KafkaConfigGroup;
import io.quarkus.micrometer.runtime.config.MPMetricsConfigGroup;
import io.quarkus.micrometer.runtime.config.NettyConfigGroup;
import io.quarkus.micrometer.runtime.config.PrometheusConfigGroup;
import io.quarkus.micrometer.runtime.config.ReactiveMessagingConfigGroup;
import io.quarkus.micrometer.runtime.config.RedisConfigGroup;
import io.quarkus.micrometer.runtime.config.StorkConfigGroup;
import io.quarkus.micrometer.runtime.config.VertxConfigGroup;
import io.quarkus.micrometer.runtime.config.VirtualThreadsConfigGroup;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.micrometer")
@ConfigRoot(phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public interface MicrometerConfig {
    @WithDefault(value="true")
    public boolean enabled();

    @WithDefault(value="true")
    public boolean registryEnabledDefault();

    @WithDefault(value="true")
    public boolean binderEnabledDefault();

    public BinderConfig binder();

    public ExportConfig export();

    default public boolean checkRegistryEnabledWithDefault(CapabilityEnabled config) {
        if (this.enabled()) {
            Optional<Boolean> configValue = config.enabled();
            return configValue.orElseGet(this::registryEnabledDefault);
        }
        return false;
    }

    default public boolean checkBinderEnabledWithDefault(CapabilityEnabled config) {
        if (this.enabled()) {
            Optional<Boolean> configValue = config.enabled();
            return configValue.orElseGet(this::binderEnabledDefault);
        }
        return false;
    }

    public static interface CapabilityEnabled {
        public Optional<Boolean> enabled();
    }

    @ConfigGroup
    public static interface ExportConfig {
        public JsonConfigGroup json();

        public PrometheusConfigGroup prometheus();
    }

    @ConfigGroup
    public static interface BinderConfig {
        public HttpClientConfigGroup httpClient();

        public HttpServerConfigGroup httpServer();

        public Optional<Boolean> jvm();

        public KafkaConfigGroup kafka();

        public RedisConfigGroup redis();

        public StorkConfigGroup stork();

        public GrpcServerConfigGroup grpcServer();

        public GrpcClientConfigGroup grpcClient();

        public ReactiveMessagingConfigGroup messaging();

        public MPMetricsConfigGroup mpMetrics();

        public VirtualThreadsConfigGroup virtualThreads();

        public Optional<Boolean> system();

        public VertxConfigGroup vertx();

        public NettyConfigGroup netty();
    }
}

