/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.*;

import java.nio.charset.StandardCharsets;


public class Lib3MFWrapper {

	public static final int PROPERTYTYPE_NOPROPERTYTYPE = 0;
	public static final int PROPERTYTYPE_BASEMATERIAL = 1;
	public static final int PROPERTYTYPE_TEXCOORD = 2;
	public static final int PROPERTYTYPE_COLORS = 3;
	public static final int PROPERTYTYPE_COMPOSITE = 4;
	public static final int PROPERTYTYPE_MULTI = 5;

	public enum PropertyType {
		eNoPropertyType,
		eBaseMaterial,
		eTexCoord,
		eColors,
		eComposite,
		eMulti
	}

	public static final int SLICESMESHRESOLUTION_FULLRES = 0;
	public static final int SLICESMESHRESOLUTION_LOWRES = 1;

	public enum SlicesMeshResolution {
		eFullres,
		eLowres
	}

	public static final int MODELUNIT_MICROMETER = 0;
	public static final int MODELUNIT_MILLIMETER = 1;
	public static final int MODELUNIT_CENTIMETER = 2;
	public static final int MODELUNIT_INCH = 3;
	public static final int MODELUNIT_FOOT = 4;
	public static final int MODELUNIT_METER = 5;

	public enum ModelUnit {
		eMicroMeter,
		eMilliMeter,
		eCentiMeter,
		eInch,
		eFoot,
		eMeter
	}

	public static final int OBJECTTYPE_OTHER = 0;
	public static final int OBJECTTYPE_MODEL = 1;
	public static final int OBJECTTYPE_SUPPORT = 2;
	public static final int OBJECTTYPE_SOLIDSUPPORT = 3;
	public static final int OBJECTTYPE_SURFACE = 4;

	public enum ObjectType {
		eOther,
		eModel,
		eSupport,
		eSolidSupport,
		eSurface
	}

	public static final int TEXTURETYPE_UNKNOWN = 0;
	public static final int TEXTURETYPE_PNG = 1;
	public static final int TEXTURETYPE_JPEG = 2;

	public enum TextureType {
		eUnknown,
		ePNG,
		eJPEG
	}

	public static final int TEXTURETILESTYLE_WRAP = 0;
	public static final int TEXTURETILESTYLE_MIRROR = 1;
	public static final int TEXTURETILESTYLE_CLAMP = 2;
	public static final int TEXTURETILESTYLE_NOTILESTYLE = 3;

	public enum TextureTileStyle {
		eWrap,
		eMirror,
		eClamp,
		eNoTileStyle
	}

	public static final int TEXTUREFILTER_AUTO = 0;
	public static final int TEXTUREFILTER_LINEAR = 1;
	public static final int TEXTUREFILTER_NEAREST = 2;

	public enum TextureFilter {
		eAuto,
		eLinear,
		eNearest
	}

	public static final int BEAMLATTICECAPMODE_SPHERE = 0;
	public static final int BEAMLATTICECAPMODE_HEMISPHERE = 1;
	public static final int BEAMLATTICECAPMODE_BUTT = 2;

	public enum BeamLatticeCapMode {
		eSphere,
		eHemiSphere,
		eButt
	}

	public static final int BEAMLATTICECLIPMODE_NOCLIPMODE = 0;
	public static final int BEAMLATTICECLIPMODE_INSIDE = 1;
	public static final int BEAMLATTICECLIPMODE_OUTSIDE = 2;

	public enum BeamLatticeClipMode {
		eNoClipMode,
		eInside,
		eOutside
	}

	public static final int BEAMLATTICEBALLMODE_BEAMLATTICEBALLMODENONE = 0;
	public static final int BEAMLATTICEBALLMODE_MIXED = 1;
	public static final int BEAMLATTICEBALLMODE_ALL = 2;

	public enum BeamLatticeBallMode {
		eBeamLatticeBallModeNone,
		eMixed,
		eAll
	}

	public static final int PROGRESSIDENTIFIER_QUERYCANCELED = 0;
	public static final int PROGRESSIDENTIFIER_DONE = 1;
	public static final int PROGRESSIDENTIFIER_CLEANUP = 2;
	public static final int PROGRESSIDENTIFIER_READSTREAM = 3;
	public static final int PROGRESSIDENTIFIER_EXTRACTOPCPACKAGE = 4;
	public static final int PROGRESSIDENTIFIER_READNONROOTMODELS = 5;
	public static final int PROGRESSIDENTIFIER_READROOTMODEL = 6;
	public static final int PROGRESSIDENTIFIER_READRESOURCES = 7;
	public static final int PROGRESSIDENTIFIER_READMESH = 8;
	public static final int PROGRESSIDENTIFIER_READSLICES = 9;
	public static final int PROGRESSIDENTIFIER_READBUILD = 10;
	public static final int PROGRESSIDENTIFIER_READCUSTOMATTACHMENT = 11;
	public static final int PROGRESSIDENTIFIER_READTEXTURETACHMENTS = 12;
	public static final int PROGRESSIDENTIFIER_CREATEOPCPACKAGE = 13;
	public static final int PROGRESSIDENTIFIER_WRITEMODELSTOSTREAM = 14;
	public static final int PROGRESSIDENTIFIER_WRITEROOTMODEL = 15;
	public static final int PROGRESSIDENTIFIER_WRITENONROOTMODELS = 16;
	public static final int PROGRESSIDENTIFIER_WRITEATTACHMENTS = 17;
	public static final int PROGRESSIDENTIFIER_WRITECONTENTTYPES = 18;
	public static final int PROGRESSIDENTIFIER_WRITENOBJECTS = 19;
	public static final int PROGRESSIDENTIFIER_WRITENODES = 20;
	public static final int PROGRESSIDENTIFIER_WRITETRIANGLES = 21;
	public static final int PROGRESSIDENTIFIER_WRITESLICES = 22;
	public static final int PROGRESSIDENTIFIER_WRITEKEYSTORE = 23;

	public enum ProgressIdentifier {
		eQUERYCANCELED,
		eDONE,
		eCLEANUP,
		eREADSTREAM,
		eEXTRACTOPCPACKAGE,
		eREADNONROOTMODELS,
		eREADROOTMODEL,
		eREADRESOURCES,
		eREADMESH,
		eREADSLICES,
		eREADBUILD,
		eREADCUSTOMATTACHMENT,
		eREADTEXTURETACHMENTS,
		eCREATEOPCPACKAGE,
		eWRITEMODELSTOSTREAM,
		eWRITEROOTMODEL,
		eWRITENONROOTMODELS,
		eWRITEATTACHMENTS,
		eWRITECONTENTTYPES,
		eWRITENOBJECTS,
		eWRITENODES,
		eWRITETRIANGLES,
		eWRITESLICES,
		eWRITEKEYSTORE
	}

	public static final int BLENDMETHOD_NOBLENDMETHOD = 0;
	public static final int BLENDMETHOD_MIX = 1;
	public static final int BLENDMETHOD_MULTIPLY = 2;

	public enum BlendMethod {
		eNoBlendMethod,
		eMix,
		eMultiply
	}

	public static final int CHANNELNAME_RED = 0;
	public static final int CHANNELNAME_GREEN = 1;
	public static final int CHANNELNAME_BLUE = 2;
	public static final int CHANNELNAME_ALPHA = 3;

	public enum ChannelName {
		eRed,
		eGreen,
		eBlue,
		eAlpha
	}

	public static final int COMPOSITIONMETHOD_WEIGHTEDSUM = 0;
	public static final int COMPOSITIONMETHOD_MULTIPLY = 1;
	public static final int COMPOSITIONMETHOD_MIN = 2;
	public static final int COMPOSITIONMETHOD_MAX = 3;
	public static final int COMPOSITIONMETHOD_MASK = 4;

	public enum CompositionMethod {
		eWeightedSum,
		eMultiply,
		eMin,
		eMax,
		eMask
	}

	public static final int COMPOSITIONSPACE_RAW = 0;
	public static final int COMPOSITIONSPACE_LINEARCOLOR = 1;

	public enum CompositionSpace {
		eRaw,
		eLinearColor
	}

	public static final int IMPLICITNODETYPE_ADDITION = 0;
	public static final int IMPLICITNODETYPE_SUBTRACTION = 1;
	public static final int IMPLICITNODETYPE_MULTIPLICATION = 2;
	public static final int IMPLICITNODETYPE_DIVISION = 3;
	public static final int IMPLICITNODETYPE_CONSTANT = 4;
	public static final int IMPLICITNODETYPE_CONSTVEC = 5;
	public static final int IMPLICITNODETYPE_CONSTMAT = 6;
	public static final int IMPLICITNODETYPE_COMPOSEVECTOR = 7;
	public static final int IMPLICITNODETYPE_DECOMPOSEVECTOR = 8;
	public static final int IMPLICITNODETYPE_COMPOSEMATRIX = 9;
	public static final int IMPLICITNODETYPE_MATRIXFROMCOLUMNS = 10;
	public static final int IMPLICITNODETYPE_MATRIXFROMROWS = 11;
	public static final int IMPLICITNODETYPE_DOT = 12;
	public static final int IMPLICITNODETYPE_CROSS = 13;
	public static final int IMPLICITNODETYPE_MATVECMULTIPLICATION = 14;
	public static final int IMPLICITNODETYPE_TRANSPOSE = 15;
	public static final int IMPLICITNODETYPE_INVERSE = 16;
	public static final int IMPLICITNODETYPE_SINUS = 17;
	public static final int IMPLICITNODETYPE_COSINUS = 18;
	public static final int IMPLICITNODETYPE_TAN = 19;
	public static final int IMPLICITNODETYPE_ARCSIN = 20;
	public static final int IMPLICITNODETYPE_ARCCOS = 21;
	public static final int IMPLICITNODETYPE_ARCTAN = 22;
	public static final int IMPLICITNODETYPE_ARCTAN2 = 23;
	public static final int IMPLICITNODETYPE_MIN = 24;
	public static final int IMPLICITNODETYPE_MAX = 25;
	public static final int IMPLICITNODETYPE_ABS = 26;
	public static final int IMPLICITNODETYPE_FMOD = 27;
	public static final int IMPLICITNODETYPE_POW = 28;
	public static final int IMPLICITNODETYPE_SQRT = 29;
	public static final int IMPLICITNODETYPE_EXP = 30;
	public static final int IMPLICITNODETYPE_LOG = 31;
	public static final int IMPLICITNODETYPE_LOG2 = 32;
	public static final int IMPLICITNODETYPE_LOG10 = 33;
	public static final int IMPLICITNODETYPE_SELECT = 34;
	public static final int IMPLICITNODETYPE_CLAMP = 35;
	public static final int IMPLICITNODETYPE_SINH = 36;
	public static final int IMPLICITNODETYPE_COSH = 37;
	public static final int IMPLICITNODETYPE_TANH = 38;
	public static final int IMPLICITNODETYPE_ROUND = 39;
	public static final int IMPLICITNODETYPE_CEIL = 40;
	public static final int IMPLICITNODETYPE_FLOOR = 41;
	public static final int IMPLICITNODETYPE_SIGN = 42;
	public static final int IMPLICITNODETYPE_FRACT = 43;
	public static final int IMPLICITNODETYPE_FUNCTIONCALL = 44;
	public static final int IMPLICITNODETYPE_MESH = 45;
	public static final int IMPLICITNODETYPE_LENGTH = 46;
	public static final int IMPLICITNODETYPE_CONSTRESOURCEID = 47;
	public static final int IMPLICITNODETYPE_VECTORFROMSCALAR = 48;
	public static final int IMPLICITNODETYPE_UNSIGNEDMESH = 49;
	public static final int IMPLICITNODETYPE_MOD = 50;
	public static final int IMPLICITNODETYPE_BEAMLATTICE = 51;
	public static final int IMPLICITNODETYPE_FUNCTIONGRADIENT = 52;
	public static final int IMPLICITNODETYPE_NORMALIZEDISTANCE = 53;

	public enum ImplicitNodeType {
		eAddition,
		eSubtraction,
		eMultiplication,
		eDivision,
		eConstant,
		eConstVec,
		eConstMat,
		eComposeVector,
		eDecomposeVector,
		eComposeMatrix,
		eMatrixFromColumns,
		eMatrixFromRows,
		eDot,
		eCross,
		eMatVecMultiplication,
		eTranspose,
		eInverse,
		eSinus,
		eCosinus,
		eTan,
		eArcSin,
		eArcCos,
		eArcTan,
		eArcTan2,
		eMin,
		eMax,
		eAbs,
		eFmod,
		ePow,
		eSqrt,
		eExp,
		eLog,
		eLog2,
		eLog10,
		eSelect,
		eClamp,
		eSinh,
		eCosh,
		eTanh,
		eRound,
		eCeil,
		eFloor,
		eSign,
		eFract,
		eFunctionCall,
		eMesh,
		eLength,
		eConstResourceID,
		eVectorFromScalar,
		eUnsignedMesh,
		eMod,
		eBeamLattice,
		eFunctionGradient,
		eNormalizeDistance
	}

	public static final int IMPLICITPORTTYPE_SCALAR = 0;
	public static final int IMPLICITPORTTYPE_VECTOR = 1;
	public static final int IMPLICITPORTTYPE_MATRIX = 2;
	public static final int IMPLICITPORTTYPE_RESOURCEID = 3;

	public enum ImplicitPortType {
		eScalar,
		eVector,
		eMatrix,
		eResourceID
	}

	public static final int IMPLICITNODECONFIGURATION_DEFAULT = 0;
	public static final int IMPLICITNODECONFIGURATION_SCALARTOSCALAR = 1;
	public static final int IMPLICITNODECONFIGURATION_VECTORTOVECTOR = 2;
	public static final int IMPLICITNODECONFIGURATION_MATRIXTOMATRIX = 3;

	public enum ImplicitNodeConfiguration {
		eDefault,
		eScalarToScalar,
		eVectorToVector,
		eMatrixToMatrix
	}

	public static final int ENCRYPTIONALGORITHM_AES256_GCM = 1;

	public enum EncryptionAlgorithm {
		eAES256_GCM
	}

	public static final int WRAPPINGALGORITHM_RSA_OAEP = 0;

	public enum WrappingAlgorithm {
		eRSA_OAEP
	}

	public static final int MGFALGORITHM_MGF1_SHA1 = 160;
	public static final int MGFALGORITHM_MGF1_SHA224 = 224;
	public static final int MGFALGORITHM_MGF1_SHA256 = 256;
	public static final int MGFALGORITHM_MGF1_SHA384 = 384;
	public static final int MGFALGORITHM_MGF1_SHA512 = 512;

	public enum MgfAlgorithm {
		eMGF1_SHA1,
		eMGF1_SHA224,
		eMGF1_SHA256,
		eMGF1_SHA384,
		eMGF1_SHA512
	}

	public static final int DIGESTMETHOD_SHA1 = 160;
	public static final int DIGESTMETHOD_SHA256 = 256;

	public enum DigestMethod {
		eSHA1,
		eSHA256
	}

	public static final int COMPRESSION_NOCOMPRESSION = 0;
	public static final int COMPRESSION_DEFLATE = 1;

	public enum Compression {
		eNoCompression,
		eDeflate
	}

	public static class EnumConversion {
		public static int convertPropertyTypeToConst (PropertyType value) throws Lib3MFException {
			switch (value) {
				case eNoPropertyType: return PROPERTYTYPE_NOPROPERTYTYPE;
				case eBaseMaterial: return PROPERTYTYPE_BASEMATERIAL;
				case eTexCoord: return PROPERTYTYPE_TEXCOORD;
				case eColors: return PROPERTYTYPE_COLORS;
				case eComposite: return PROPERTYTYPE_COMPOSITE;
				case eMulti: return PROPERTYTYPE_MULTI;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static PropertyType convertConstToPropertyType (int value) throws Lib3MFException {
			switch (value) {
				case PROPERTYTYPE_NOPROPERTYTYPE: return PropertyType.eNoPropertyType;
				case PROPERTYTYPE_BASEMATERIAL: return PropertyType.eBaseMaterial;
				case PROPERTYTYPE_TEXCOORD: return PropertyType.eTexCoord;
				case PROPERTYTYPE_COLORS: return PropertyType.eColors;
				case PROPERTYTYPE_COMPOSITE: return PropertyType.eComposite;
				case PROPERTYTYPE_MULTI: return PropertyType.eMulti;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertSlicesMeshResolutionToConst (SlicesMeshResolution value) throws Lib3MFException {
			switch (value) {
				case eFullres: return SLICESMESHRESOLUTION_FULLRES;
				case eLowres: return SLICESMESHRESOLUTION_LOWRES;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static SlicesMeshResolution convertConstToSlicesMeshResolution (int value) throws Lib3MFException {
			switch (value) {
				case SLICESMESHRESOLUTION_FULLRES: return SlicesMeshResolution.eFullres;
				case SLICESMESHRESOLUTION_LOWRES: return SlicesMeshResolution.eLowres;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertModelUnitToConst (ModelUnit value) throws Lib3MFException {
			switch (value) {
				case eMicroMeter: return MODELUNIT_MICROMETER;
				case eMilliMeter: return MODELUNIT_MILLIMETER;
				case eCentiMeter: return MODELUNIT_CENTIMETER;
				case eInch: return MODELUNIT_INCH;
				case eFoot: return MODELUNIT_FOOT;
				case eMeter: return MODELUNIT_METER;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static ModelUnit convertConstToModelUnit (int value) throws Lib3MFException {
			switch (value) {
				case MODELUNIT_MICROMETER: return ModelUnit.eMicroMeter;
				case MODELUNIT_MILLIMETER: return ModelUnit.eMilliMeter;
				case MODELUNIT_CENTIMETER: return ModelUnit.eCentiMeter;
				case MODELUNIT_INCH: return ModelUnit.eInch;
				case MODELUNIT_FOOT: return ModelUnit.eFoot;
				case MODELUNIT_METER: return ModelUnit.eMeter;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertObjectTypeToConst (ObjectType value) throws Lib3MFException {
			switch (value) {
				case eOther: return OBJECTTYPE_OTHER;
				case eModel: return OBJECTTYPE_MODEL;
				case eSupport: return OBJECTTYPE_SUPPORT;
				case eSolidSupport: return OBJECTTYPE_SOLIDSUPPORT;
				case eSurface: return OBJECTTYPE_SURFACE;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static ObjectType convertConstToObjectType (int value) throws Lib3MFException {
			switch (value) {
				case OBJECTTYPE_OTHER: return ObjectType.eOther;
				case OBJECTTYPE_MODEL: return ObjectType.eModel;
				case OBJECTTYPE_SUPPORT: return ObjectType.eSupport;
				case OBJECTTYPE_SOLIDSUPPORT: return ObjectType.eSolidSupport;
				case OBJECTTYPE_SURFACE: return ObjectType.eSurface;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertTextureTypeToConst (TextureType value) throws Lib3MFException {
			switch (value) {
				case eUnknown: return TEXTURETYPE_UNKNOWN;
				case ePNG: return TEXTURETYPE_PNG;
				case eJPEG: return TEXTURETYPE_JPEG;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static TextureType convertConstToTextureType (int value) throws Lib3MFException {
			switch (value) {
				case TEXTURETYPE_UNKNOWN: return TextureType.eUnknown;
				case TEXTURETYPE_PNG: return TextureType.ePNG;
				case TEXTURETYPE_JPEG: return TextureType.eJPEG;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertTextureTileStyleToConst (TextureTileStyle value) throws Lib3MFException {
			switch (value) {
				case eWrap: return TEXTURETILESTYLE_WRAP;
				case eMirror: return TEXTURETILESTYLE_MIRROR;
				case eClamp: return TEXTURETILESTYLE_CLAMP;
				case eNoTileStyle: return TEXTURETILESTYLE_NOTILESTYLE;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static TextureTileStyle convertConstToTextureTileStyle (int value) throws Lib3MFException {
			switch (value) {
				case TEXTURETILESTYLE_WRAP: return TextureTileStyle.eWrap;
				case TEXTURETILESTYLE_MIRROR: return TextureTileStyle.eMirror;
				case TEXTURETILESTYLE_CLAMP: return TextureTileStyle.eClamp;
				case TEXTURETILESTYLE_NOTILESTYLE: return TextureTileStyle.eNoTileStyle;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertTextureFilterToConst (TextureFilter value) throws Lib3MFException {
			switch (value) {
				case eAuto: return TEXTUREFILTER_AUTO;
				case eLinear: return TEXTUREFILTER_LINEAR;
				case eNearest: return TEXTUREFILTER_NEAREST;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static TextureFilter convertConstToTextureFilter (int value) throws Lib3MFException {
			switch (value) {
				case TEXTUREFILTER_AUTO: return TextureFilter.eAuto;
				case TEXTUREFILTER_LINEAR: return TextureFilter.eLinear;
				case TEXTUREFILTER_NEAREST: return TextureFilter.eNearest;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertBeamLatticeCapModeToConst (BeamLatticeCapMode value) throws Lib3MFException {
			switch (value) {
				case eSphere: return BEAMLATTICECAPMODE_SPHERE;
				case eHemiSphere: return BEAMLATTICECAPMODE_HEMISPHERE;
				case eButt: return BEAMLATTICECAPMODE_BUTT;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static BeamLatticeCapMode convertConstToBeamLatticeCapMode (int value) throws Lib3MFException {
			switch (value) {
				case BEAMLATTICECAPMODE_SPHERE: return BeamLatticeCapMode.eSphere;
				case BEAMLATTICECAPMODE_HEMISPHERE: return BeamLatticeCapMode.eHemiSphere;
				case BEAMLATTICECAPMODE_BUTT: return BeamLatticeCapMode.eButt;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertBeamLatticeClipModeToConst (BeamLatticeClipMode value) throws Lib3MFException {
			switch (value) {
				case eNoClipMode: return BEAMLATTICECLIPMODE_NOCLIPMODE;
				case eInside: return BEAMLATTICECLIPMODE_INSIDE;
				case eOutside: return BEAMLATTICECLIPMODE_OUTSIDE;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static BeamLatticeClipMode convertConstToBeamLatticeClipMode (int value) throws Lib3MFException {
			switch (value) {
				case BEAMLATTICECLIPMODE_NOCLIPMODE: return BeamLatticeClipMode.eNoClipMode;
				case BEAMLATTICECLIPMODE_INSIDE: return BeamLatticeClipMode.eInside;
				case BEAMLATTICECLIPMODE_OUTSIDE: return BeamLatticeClipMode.eOutside;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertBeamLatticeBallModeToConst (BeamLatticeBallMode value) throws Lib3MFException {
			switch (value) {
				case eBeamLatticeBallModeNone: return BEAMLATTICEBALLMODE_BEAMLATTICEBALLMODENONE;
				case eMixed: return BEAMLATTICEBALLMODE_MIXED;
				case eAll: return BEAMLATTICEBALLMODE_ALL;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static BeamLatticeBallMode convertConstToBeamLatticeBallMode (int value) throws Lib3MFException {
			switch (value) {
				case BEAMLATTICEBALLMODE_BEAMLATTICEBALLMODENONE: return BeamLatticeBallMode.eBeamLatticeBallModeNone;
				case BEAMLATTICEBALLMODE_MIXED: return BeamLatticeBallMode.eMixed;
				case BEAMLATTICEBALLMODE_ALL: return BeamLatticeBallMode.eAll;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertProgressIdentifierToConst (ProgressIdentifier value) throws Lib3MFException {
			switch (value) {
				case eQUERYCANCELED: return PROGRESSIDENTIFIER_QUERYCANCELED;
				case eDONE: return PROGRESSIDENTIFIER_DONE;
				case eCLEANUP: return PROGRESSIDENTIFIER_CLEANUP;
				case eREADSTREAM: return PROGRESSIDENTIFIER_READSTREAM;
				case eEXTRACTOPCPACKAGE: return PROGRESSIDENTIFIER_EXTRACTOPCPACKAGE;
				case eREADNONROOTMODELS: return PROGRESSIDENTIFIER_READNONROOTMODELS;
				case eREADROOTMODEL: return PROGRESSIDENTIFIER_READROOTMODEL;
				case eREADRESOURCES: return PROGRESSIDENTIFIER_READRESOURCES;
				case eREADMESH: return PROGRESSIDENTIFIER_READMESH;
				case eREADSLICES: return PROGRESSIDENTIFIER_READSLICES;
				case eREADBUILD: return PROGRESSIDENTIFIER_READBUILD;
				case eREADCUSTOMATTACHMENT: return PROGRESSIDENTIFIER_READCUSTOMATTACHMENT;
				case eREADTEXTURETACHMENTS: return PROGRESSIDENTIFIER_READTEXTURETACHMENTS;
				case eCREATEOPCPACKAGE: return PROGRESSIDENTIFIER_CREATEOPCPACKAGE;
				case eWRITEMODELSTOSTREAM: return PROGRESSIDENTIFIER_WRITEMODELSTOSTREAM;
				case eWRITEROOTMODEL: return PROGRESSIDENTIFIER_WRITEROOTMODEL;
				case eWRITENONROOTMODELS: return PROGRESSIDENTIFIER_WRITENONROOTMODELS;
				case eWRITEATTACHMENTS: return PROGRESSIDENTIFIER_WRITEATTACHMENTS;
				case eWRITECONTENTTYPES: return PROGRESSIDENTIFIER_WRITECONTENTTYPES;
				case eWRITENOBJECTS: return PROGRESSIDENTIFIER_WRITENOBJECTS;
				case eWRITENODES: return PROGRESSIDENTIFIER_WRITENODES;
				case eWRITETRIANGLES: return PROGRESSIDENTIFIER_WRITETRIANGLES;
				case eWRITESLICES: return PROGRESSIDENTIFIER_WRITESLICES;
				case eWRITEKEYSTORE: return PROGRESSIDENTIFIER_WRITEKEYSTORE;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static ProgressIdentifier convertConstToProgressIdentifier (int value) throws Lib3MFException {
			switch (value) {
				case PROGRESSIDENTIFIER_QUERYCANCELED: return ProgressIdentifier.eQUERYCANCELED;
				case PROGRESSIDENTIFIER_DONE: return ProgressIdentifier.eDONE;
				case PROGRESSIDENTIFIER_CLEANUP: return ProgressIdentifier.eCLEANUP;
				case PROGRESSIDENTIFIER_READSTREAM: return ProgressIdentifier.eREADSTREAM;
				case PROGRESSIDENTIFIER_EXTRACTOPCPACKAGE: return ProgressIdentifier.eEXTRACTOPCPACKAGE;
				case PROGRESSIDENTIFIER_READNONROOTMODELS: return ProgressIdentifier.eREADNONROOTMODELS;
				case PROGRESSIDENTIFIER_READROOTMODEL: return ProgressIdentifier.eREADROOTMODEL;
				case PROGRESSIDENTIFIER_READRESOURCES: return ProgressIdentifier.eREADRESOURCES;
				case PROGRESSIDENTIFIER_READMESH: return ProgressIdentifier.eREADMESH;
				case PROGRESSIDENTIFIER_READSLICES: return ProgressIdentifier.eREADSLICES;
				case PROGRESSIDENTIFIER_READBUILD: return ProgressIdentifier.eREADBUILD;
				case PROGRESSIDENTIFIER_READCUSTOMATTACHMENT: return ProgressIdentifier.eREADCUSTOMATTACHMENT;
				case PROGRESSIDENTIFIER_READTEXTURETACHMENTS: return ProgressIdentifier.eREADTEXTURETACHMENTS;
				case PROGRESSIDENTIFIER_CREATEOPCPACKAGE: return ProgressIdentifier.eCREATEOPCPACKAGE;
				case PROGRESSIDENTIFIER_WRITEMODELSTOSTREAM: return ProgressIdentifier.eWRITEMODELSTOSTREAM;
				case PROGRESSIDENTIFIER_WRITEROOTMODEL: return ProgressIdentifier.eWRITEROOTMODEL;
				case PROGRESSIDENTIFIER_WRITENONROOTMODELS: return ProgressIdentifier.eWRITENONROOTMODELS;
				case PROGRESSIDENTIFIER_WRITEATTACHMENTS: return ProgressIdentifier.eWRITEATTACHMENTS;
				case PROGRESSIDENTIFIER_WRITECONTENTTYPES: return ProgressIdentifier.eWRITECONTENTTYPES;
				case PROGRESSIDENTIFIER_WRITENOBJECTS: return ProgressIdentifier.eWRITENOBJECTS;
				case PROGRESSIDENTIFIER_WRITENODES: return ProgressIdentifier.eWRITENODES;
				case PROGRESSIDENTIFIER_WRITETRIANGLES: return ProgressIdentifier.eWRITETRIANGLES;
				case PROGRESSIDENTIFIER_WRITESLICES: return ProgressIdentifier.eWRITESLICES;
				case PROGRESSIDENTIFIER_WRITEKEYSTORE: return ProgressIdentifier.eWRITEKEYSTORE;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertBlendMethodToConst (BlendMethod value) throws Lib3MFException {
			switch (value) {
				case eNoBlendMethod: return BLENDMETHOD_NOBLENDMETHOD;
				case eMix: return BLENDMETHOD_MIX;
				case eMultiply: return BLENDMETHOD_MULTIPLY;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static BlendMethod convertConstToBlendMethod (int value) throws Lib3MFException {
			switch (value) {
				case BLENDMETHOD_NOBLENDMETHOD: return BlendMethod.eNoBlendMethod;
				case BLENDMETHOD_MIX: return BlendMethod.eMix;
				case BLENDMETHOD_MULTIPLY: return BlendMethod.eMultiply;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertChannelNameToConst (ChannelName value) throws Lib3MFException {
			switch (value) {
				case eRed: return CHANNELNAME_RED;
				case eGreen: return CHANNELNAME_GREEN;
				case eBlue: return CHANNELNAME_BLUE;
				case eAlpha: return CHANNELNAME_ALPHA;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static ChannelName convertConstToChannelName (int value) throws Lib3MFException {
			switch (value) {
				case CHANNELNAME_RED: return ChannelName.eRed;
				case CHANNELNAME_GREEN: return ChannelName.eGreen;
				case CHANNELNAME_BLUE: return ChannelName.eBlue;
				case CHANNELNAME_ALPHA: return ChannelName.eAlpha;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertCompositionMethodToConst (CompositionMethod value) throws Lib3MFException {
			switch (value) {
				case eWeightedSum: return COMPOSITIONMETHOD_WEIGHTEDSUM;
				case eMultiply: return COMPOSITIONMETHOD_MULTIPLY;
				case eMin: return COMPOSITIONMETHOD_MIN;
				case eMax: return COMPOSITIONMETHOD_MAX;
				case eMask: return COMPOSITIONMETHOD_MASK;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static CompositionMethod convertConstToCompositionMethod (int value) throws Lib3MFException {
			switch (value) {
				case COMPOSITIONMETHOD_WEIGHTEDSUM: return CompositionMethod.eWeightedSum;
				case COMPOSITIONMETHOD_MULTIPLY: return CompositionMethod.eMultiply;
				case COMPOSITIONMETHOD_MIN: return CompositionMethod.eMin;
				case COMPOSITIONMETHOD_MAX: return CompositionMethod.eMax;
				case COMPOSITIONMETHOD_MASK: return CompositionMethod.eMask;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertCompositionSpaceToConst (CompositionSpace value) throws Lib3MFException {
			switch (value) {
				case eRaw: return COMPOSITIONSPACE_RAW;
				case eLinearColor: return COMPOSITIONSPACE_LINEARCOLOR;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static CompositionSpace convertConstToCompositionSpace (int value) throws Lib3MFException {
			switch (value) {
				case COMPOSITIONSPACE_RAW: return CompositionSpace.eRaw;
				case COMPOSITIONSPACE_LINEARCOLOR: return CompositionSpace.eLinearColor;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertImplicitNodeTypeToConst (ImplicitNodeType value) throws Lib3MFException {
			switch (value) {
				case eAddition: return IMPLICITNODETYPE_ADDITION;
				case eSubtraction: return IMPLICITNODETYPE_SUBTRACTION;
				case eMultiplication: return IMPLICITNODETYPE_MULTIPLICATION;
				case eDivision: return IMPLICITNODETYPE_DIVISION;
				case eConstant: return IMPLICITNODETYPE_CONSTANT;
				case eConstVec: return IMPLICITNODETYPE_CONSTVEC;
				case eConstMat: return IMPLICITNODETYPE_CONSTMAT;
				case eComposeVector: return IMPLICITNODETYPE_COMPOSEVECTOR;
				case eDecomposeVector: return IMPLICITNODETYPE_DECOMPOSEVECTOR;
				case eComposeMatrix: return IMPLICITNODETYPE_COMPOSEMATRIX;
				case eMatrixFromColumns: return IMPLICITNODETYPE_MATRIXFROMCOLUMNS;
				case eMatrixFromRows: return IMPLICITNODETYPE_MATRIXFROMROWS;
				case eDot: return IMPLICITNODETYPE_DOT;
				case eCross: return IMPLICITNODETYPE_CROSS;
				case eMatVecMultiplication: return IMPLICITNODETYPE_MATVECMULTIPLICATION;
				case eTranspose: return IMPLICITNODETYPE_TRANSPOSE;
				case eInverse: return IMPLICITNODETYPE_INVERSE;
				case eSinus: return IMPLICITNODETYPE_SINUS;
				case eCosinus: return IMPLICITNODETYPE_COSINUS;
				case eTan: return IMPLICITNODETYPE_TAN;
				case eArcSin: return IMPLICITNODETYPE_ARCSIN;
				case eArcCos: return IMPLICITNODETYPE_ARCCOS;
				case eArcTan: return IMPLICITNODETYPE_ARCTAN;
				case eArcTan2: return IMPLICITNODETYPE_ARCTAN2;
				case eMin: return IMPLICITNODETYPE_MIN;
				case eMax: return IMPLICITNODETYPE_MAX;
				case eAbs: return IMPLICITNODETYPE_ABS;
				case eFmod: return IMPLICITNODETYPE_FMOD;
				case ePow: return IMPLICITNODETYPE_POW;
				case eSqrt: return IMPLICITNODETYPE_SQRT;
				case eExp: return IMPLICITNODETYPE_EXP;
				case eLog: return IMPLICITNODETYPE_LOG;
				case eLog2: return IMPLICITNODETYPE_LOG2;
				case eLog10: return IMPLICITNODETYPE_LOG10;
				case eSelect: return IMPLICITNODETYPE_SELECT;
				case eClamp: return IMPLICITNODETYPE_CLAMP;
				case eSinh: return IMPLICITNODETYPE_SINH;
				case eCosh: return IMPLICITNODETYPE_COSH;
				case eTanh: return IMPLICITNODETYPE_TANH;
				case eRound: return IMPLICITNODETYPE_ROUND;
				case eCeil: return IMPLICITNODETYPE_CEIL;
				case eFloor: return IMPLICITNODETYPE_FLOOR;
				case eSign: return IMPLICITNODETYPE_SIGN;
				case eFract: return IMPLICITNODETYPE_FRACT;
				case eFunctionCall: return IMPLICITNODETYPE_FUNCTIONCALL;
				case eMesh: return IMPLICITNODETYPE_MESH;
				case eLength: return IMPLICITNODETYPE_LENGTH;
				case eConstResourceID: return IMPLICITNODETYPE_CONSTRESOURCEID;
				case eVectorFromScalar: return IMPLICITNODETYPE_VECTORFROMSCALAR;
				case eUnsignedMesh: return IMPLICITNODETYPE_UNSIGNEDMESH;
				case eMod: return IMPLICITNODETYPE_MOD;
				case eBeamLattice: return IMPLICITNODETYPE_BEAMLATTICE;
				case eFunctionGradient: return IMPLICITNODETYPE_FUNCTIONGRADIENT;
				case eNormalizeDistance: return IMPLICITNODETYPE_NORMALIZEDISTANCE;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static ImplicitNodeType convertConstToImplicitNodeType (int value) throws Lib3MFException {
			switch (value) {
				case IMPLICITNODETYPE_ADDITION: return ImplicitNodeType.eAddition;
				case IMPLICITNODETYPE_SUBTRACTION: return ImplicitNodeType.eSubtraction;
				case IMPLICITNODETYPE_MULTIPLICATION: return ImplicitNodeType.eMultiplication;
				case IMPLICITNODETYPE_DIVISION: return ImplicitNodeType.eDivision;
				case IMPLICITNODETYPE_CONSTANT: return ImplicitNodeType.eConstant;
				case IMPLICITNODETYPE_CONSTVEC: return ImplicitNodeType.eConstVec;
				case IMPLICITNODETYPE_CONSTMAT: return ImplicitNodeType.eConstMat;
				case IMPLICITNODETYPE_COMPOSEVECTOR: return ImplicitNodeType.eComposeVector;
				case IMPLICITNODETYPE_DECOMPOSEVECTOR: return ImplicitNodeType.eDecomposeVector;
				case IMPLICITNODETYPE_COMPOSEMATRIX: return ImplicitNodeType.eComposeMatrix;
				case IMPLICITNODETYPE_MATRIXFROMCOLUMNS: return ImplicitNodeType.eMatrixFromColumns;
				case IMPLICITNODETYPE_MATRIXFROMROWS: return ImplicitNodeType.eMatrixFromRows;
				case IMPLICITNODETYPE_DOT: return ImplicitNodeType.eDot;
				case IMPLICITNODETYPE_CROSS: return ImplicitNodeType.eCross;
				case IMPLICITNODETYPE_MATVECMULTIPLICATION: return ImplicitNodeType.eMatVecMultiplication;
				case IMPLICITNODETYPE_TRANSPOSE: return ImplicitNodeType.eTranspose;
				case IMPLICITNODETYPE_INVERSE: return ImplicitNodeType.eInverse;
				case IMPLICITNODETYPE_SINUS: return ImplicitNodeType.eSinus;
				case IMPLICITNODETYPE_COSINUS: return ImplicitNodeType.eCosinus;
				case IMPLICITNODETYPE_TAN: return ImplicitNodeType.eTan;
				case IMPLICITNODETYPE_ARCSIN: return ImplicitNodeType.eArcSin;
				case IMPLICITNODETYPE_ARCCOS: return ImplicitNodeType.eArcCos;
				case IMPLICITNODETYPE_ARCTAN: return ImplicitNodeType.eArcTan;
				case IMPLICITNODETYPE_ARCTAN2: return ImplicitNodeType.eArcTan2;
				case IMPLICITNODETYPE_MIN: return ImplicitNodeType.eMin;
				case IMPLICITNODETYPE_MAX: return ImplicitNodeType.eMax;
				case IMPLICITNODETYPE_ABS: return ImplicitNodeType.eAbs;
				case IMPLICITNODETYPE_FMOD: return ImplicitNodeType.eFmod;
				case IMPLICITNODETYPE_POW: return ImplicitNodeType.ePow;
				case IMPLICITNODETYPE_SQRT: return ImplicitNodeType.eSqrt;
				case IMPLICITNODETYPE_EXP: return ImplicitNodeType.eExp;
				case IMPLICITNODETYPE_LOG: return ImplicitNodeType.eLog;
				case IMPLICITNODETYPE_LOG2: return ImplicitNodeType.eLog2;
				case IMPLICITNODETYPE_LOG10: return ImplicitNodeType.eLog10;
				case IMPLICITNODETYPE_SELECT: return ImplicitNodeType.eSelect;
				case IMPLICITNODETYPE_CLAMP: return ImplicitNodeType.eClamp;
				case IMPLICITNODETYPE_SINH: return ImplicitNodeType.eSinh;
				case IMPLICITNODETYPE_COSH: return ImplicitNodeType.eCosh;
				case IMPLICITNODETYPE_TANH: return ImplicitNodeType.eTanh;
				case IMPLICITNODETYPE_ROUND: return ImplicitNodeType.eRound;
				case IMPLICITNODETYPE_CEIL: return ImplicitNodeType.eCeil;
				case IMPLICITNODETYPE_FLOOR: return ImplicitNodeType.eFloor;
				case IMPLICITNODETYPE_SIGN: return ImplicitNodeType.eSign;
				case IMPLICITNODETYPE_FRACT: return ImplicitNodeType.eFract;
				case IMPLICITNODETYPE_FUNCTIONCALL: return ImplicitNodeType.eFunctionCall;
				case IMPLICITNODETYPE_MESH: return ImplicitNodeType.eMesh;
				case IMPLICITNODETYPE_LENGTH: return ImplicitNodeType.eLength;
				case IMPLICITNODETYPE_CONSTRESOURCEID: return ImplicitNodeType.eConstResourceID;
				case IMPLICITNODETYPE_VECTORFROMSCALAR: return ImplicitNodeType.eVectorFromScalar;
				case IMPLICITNODETYPE_UNSIGNEDMESH: return ImplicitNodeType.eUnsignedMesh;
				case IMPLICITNODETYPE_MOD: return ImplicitNodeType.eMod;
				case IMPLICITNODETYPE_BEAMLATTICE: return ImplicitNodeType.eBeamLattice;
				case IMPLICITNODETYPE_FUNCTIONGRADIENT: return ImplicitNodeType.eFunctionGradient;
				case IMPLICITNODETYPE_NORMALIZEDISTANCE: return ImplicitNodeType.eNormalizeDistance;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertImplicitPortTypeToConst (ImplicitPortType value) throws Lib3MFException {
			switch (value) {
				case eScalar: return IMPLICITPORTTYPE_SCALAR;
				case eVector: return IMPLICITPORTTYPE_VECTOR;
				case eMatrix: return IMPLICITPORTTYPE_MATRIX;
				case eResourceID: return IMPLICITPORTTYPE_RESOURCEID;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static ImplicitPortType convertConstToImplicitPortType (int value) throws Lib3MFException {
			switch (value) {
				case IMPLICITPORTTYPE_SCALAR: return ImplicitPortType.eScalar;
				case IMPLICITPORTTYPE_VECTOR: return ImplicitPortType.eVector;
				case IMPLICITPORTTYPE_MATRIX: return ImplicitPortType.eMatrix;
				case IMPLICITPORTTYPE_RESOURCEID: return ImplicitPortType.eResourceID;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertImplicitNodeConfigurationToConst (ImplicitNodeConfiguration value) throws Lib3MFException {
			switch (value) {
				case eDefault: return IMPLICITNODECONFIGURATION_DEFAULT;
				case eScalarToScalar: return IMPLICITNODECONFIGURATION_SCALARTOSCALAR;
				case eVectorToVector: return IMPLICITNODECONFIGURATION_VECTORTOVECTOR;
				case eMatrixToMatrix: return IMPLICITNODECONFIGURATION_MATRIXTOMATRIX;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static ImplicitNodeConfiguration convertConstToImplicitNodeConfiguration (int value) throws Lib3MFException {
			switch (value) {
				case IMPLICITNODECONFIGURATION_DEFAULT: return ImplicitNodeConfiguration.eDefault;
				case IMPLICITNODECONFIGURATION_SCALARTOSCALAR: return ImplicitNodeConfiguration.eScalarToScalar;
				case IMPLICITNODECONFIGURATION_VECTORTOVECTOR: return ImplicitNodeConfiguration.eVectorToVector;
				case IMPLICITNODECONFIGURATION_MATRIXTOMATRIX: return ImplicitNodeConfiguration.eMatrixToMatrix;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertEncryptionAlgorithmToConst (EncryptionAlgorithm value) throws Lib3MFException {
			switch (value) {
				case eAES256_GCM: return ENCRYPTIONALGORITHM_AES256_GCM;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static EncryptionAlgorithm convertConstToEncryptionAlgorithm (int value) throws Lib3MFException {
			switch (value) {
				case ENCRYPTIONALGORITHM_AES256_GCM: return EncryptionAlgorithm.eAES256_GCM;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertWrappingAlgorithmToConst (WrappingAlgorithm value) throws Lib3MFException {
			switch (value) {
				case eRSA_OAEP: return WRAPPINGALGORITHM_RSA_OAEP;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static WrappingAlgorithm convertConstToWrappingAlgorithm (int value) throws Lib3MFException {
			switch (value) {
				case WRAPPINGALGORITHM_RSA_OAEP: return WrappingAlgorithm.eRSA_OAEP;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertMgfAlgorithmToConst (MgfAlgorithm value) throws Lib3MFException {
			switch (value) {
				case eMGF1_SHA1: return MGFALGORITHM_MGF1_SHA1;
				case eMGF1_SHA224: return MGFALGORITHM_MGF1_SHA224;
				case eMGF1_SHA256: return MGFALGORITHM_MGF1_SHA256;
				case eMGF1_SHA384: return MGFALGORITHM_MGF1_SHA384;
				case eMGF1_SHA512: return MGFALGORITHM_MGF1_SHA512;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static MgfAlgorithm convertConstToMgfAlgorithm (int value) throws Lib3MFException {
			switch (value) {
				case MGFALGORITHM_MGF1_SHA1: return MgfAlgorithm.eMGF1_SHA1;
				case MGFALGORITHM_MGF1_SHA224: return MgfAlgorithm.eMGF1_SHA224;
				case MGFALGORITHM_MGF1_SHA256: return MgfAlgorithm.eMGF1_SHA256;
				case MGFALGORITHM_MGF1_SHA384: return MgfAlgorithm.eMGF1_SHA384;
				case MGFALGORITHM_MGF1_SHA512: return MgfAlgorithm.eMGF1_SHA512;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertDigestMethodToConst (DigestMethod value) throws Lib3MFException {
			switch (value) {
				case eSHA1: return DIGESTMETHOD_SHA1;
				case eSHA256: return DIGESTMETHOD_SHA256;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static DigestMethod convertConstToDigestMethod (int value) throws Lib3MFException {
			switch (value) {
				case DIGESTMETHOD_SHA1: return DigestMethod.eSHA1;
				case DIGESTMETHOD_SHA256: return DigestMethod.eSHA256;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

		public static int convertCompressionToConst (Compression value) throws Lib3MFException {
			switch (value) {
				case eNoCompression: return COMPRESSION_NOCOMPRESSION;
				case eDeflate: return COMPRESSION_DEFLATE;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum value : " + value);
			}
		}

		public static Compression convertConstToCompression (int value) throws Lib3MFException {
			switch (value) {
				case COMPRESSION_NOCOMPRESSION: return Compression.eNoCompression;
				case COMPRESSION_DEFLATE: return Compression.eDeflate;
				default: throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Unknown enum const : " + value);
			}
		}

	}

	public interface ProgressCallback extends Callback {

		void progressCallback (Pointer abort, double progressValue, int progressIdentifier, Pointer userData);

	}

	public interface WriteCallback extends Callback {

		void writeCallback (long byteData, long numBytes, Pointer userData);

	}

	public interface ReadCallback extends Callback {

		void readCallback (long byteData, long numBytes, Pointer userData);

	}

	public interface SeekCallback extends Callback {

		void seekCallback (long position, Pointer userData);

	}

	public interface RandomNumberCallback extends Callback {

		void randomNumberCallback (long byteData, long numBytes, Pointer userData, Pointer bytesWritten);

	}

	public interface KeyWrappingCallback extends Callback {

		void keyWrappingCallback (Pointer kEKParams, int inBufferSize, Pointer inBufferBuffer, int outBufferSize, Pointer outBufferNeededSize, Pointer outBufferBuffer, Pointer userData, Pointer status);

	}

	public interface ContentEncryptionCallback extends Callback {

		void contentEncryptionCallback (Pointer cEKParams, int inputSize, Pointer inputBuffer, int outputSize, Pointer outputNeededSize, Pointer outputBuffer, Pointer userData, Pointer status);

	}

	protected com.sun.jna.Function lib3mf_getlibraryversion;
	protected com.sun.jna.Function lib3mf_getprereleaseinformation;
	protected com.sun.jna.Function lib3mf_getbuildinformation;
	protected com.sun.jna.Function lib3mf_getspecificationversion;
	protected com.sun.jna.Function lib3mf_createmodel;
	protected com.sun.jna.Function lib3mf_release;
	protected com.sun.jna.Function lib3mf_acquire;
	protected com.sun.jna.Function lib3mf_setjournal;
	protected com.sun.jna.Function lib3mf_getlasterror;
	protected com.sun.jna.Function lib3mf_getsymbollookupmethod;
	protected com.sun.jna.Function lib3mf_retrieveprogressmessage;
	protected com.sun.jna.Function lib3mf_rgbatocolor;
	protected com.sun.jna.Function lib3mf_floatrgbatocolor;
	protected com.sun.jna.Function lib3mf_colortorgba;
	protected com.sun.jna.Function lib3mf_colortofloatrgba;
	protected com.sun.jna.Function lib3mf_getidentitytransform;
	protected com.sun.jna.Function lib3mf_getuniformscaletransform;
	protected com.sun.jna.Function lib3mf_getscaletransform;
	protected com.sun.jna.Function lib3mf_gettranslationtransform;
	protected com.sun.jna.Function lib3mf_base_classtypeid;
	protected com.sun.jna.Function lib3mf_writer_writetofile;
	protected com.sun.jna.Function lib3mf_writer_getstreamsize;
	protected com.sun.jna.Function lib3mf_writer_writetobuffer;
	protected com.sun.jna.Function lib3mf_writer_writetocallback;
	protected com.sun.jna.Function lib3mf_writer_setprogresscallback;
	protected com.sun.jna.Function lib3mf_writer_getdecimalprecision;
	protected com.sun.jna.Function lib3mf_writer_setdecimalprecision;
	protected com.sun.jna.Function lib3mf_writer_setstrictmodeactive;
	protected com.sun.jna.Function lib3mf_writer_getstrictmodeactive;
	protected com.sun.jna.Function lib3mf_writer_getwarning;
	protected com.sun.jna.Function lib3mf_writer_getwarningcount;
	protected com.sun.jna.Function lib3mf_writer_addkeywrappingcallback;
	protected com.sun.jna.Function lib3mf_writer_setcontentencryptioncallback;
	protected com.sun.jna.Function lib3mf_reader_readfromfile;
	protected com.sun.jna.Function lib3mf_reader_readfrombuffer;
	protected com.sun.jna.Function lib3mf_reader_readfromcallback;
	protected com.sun.jna.Function lib3mf_reader_setprogresscallback;
	protected com.sun.jna.Function lib3mf_reader_addrelationtoread;
	protected com.sun.jna.Function lib3mf_reader_removerelationtoread;
	protected com.sun.jna.Function lib3mf_reader_setstrictmodeactive;
	protected com.sun.jna.Function lib3mf_reader_getstrictmodeactive;
	protected com.sun.jna.Function lib3mf_reader_getwarning;
	protected com.sun.jna.Function lib3mf_reader_getwarningcount;
	protected com.sun.jna.Function lib3mf_reader_addkeywrappingcallback;
	protected com.sun.jna.Function lib3mf_reader_setcontentencryptioncallback;
	protected com.sun.jna.Function lib3mf_packagepart_getpath;
	protected com.sun.jna.Function lib3mf_packagepart_setpath;
	protected com.sun.jna.Function lib3mf_resource_getresourceid;
	protected com.sun.jna.Function lib3mf_resource_getuniqueresourceid;
	protected com.sun.jna.Function lib3mf_resource_packagepart;
	protected com.sun.jna.Function lib3mf_resource_setpackagepart;
	protected com.sun.jna.Function lib3mf_resource_getmodelresourceid;
	protected com.sun.jna.Function lib3mf_resourceiterator_movenext;
	protected com.sun.jna.Function lib3mf_resourceiterator_moveprevious;
	protected com.sun.jna.Function lib3mf_resourceiterator_getcurrent;
	protected com.sun.jna.Function lib3mf_resourceiterator_clone;
	protected com.sun.jna.Function lib3mf_resourceiterator_count;
	protected com.sun.jna.Function lib3mf_slicestackiterator_getcurrentslicestack;
	protected com.sun.jna.Function lib3mf_objectiterator_getcurrentobject;
	protected com.sun.jna.Function lib3mf_meshobjectiterator_getcurrentmeshobject;
	protected com.sun.jna.Function lib3mf_componentsobjectiterator_getcurrentcomponentsobject;
	protected com.sun.jna.Function lib3mf_texture2diterator_getcurrenttexture2d;
	protected com.sun.jna.Function lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup;
	protected com.sun.jna.Function lib3mf_colorgroupiterator_getcurrentcolorgroup;
	protected com.sun.jna.Function lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup;
	protected com.sun.jna.Function lib3mf_compositematerialsiterator_getcurrentcompositematerials;
	protected com.sun.jna.Function lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup;
	protected com.sun.jna.Function lib3mf_image3diterator_getcurrentimage3d;
	protected com.sun.jna.Function lib3mf_functioniterator_getcurrentfunction;
	protected com.sun.jna.Function lib3mf_levelsetiterator_getcurrentlevelset;
	protected com.sun.jna.Function lib3mf_metadata_getnamespace;
	protected com.sun.jna.Function lib3mf_metadata_setnamespace;
	protected com.sun.jna.Function lib3mf_metadata_getname;
	protected com.sun.jna.Function lib3mf_metadata_setname;
	protected com.sun.jna.Function lib3mf_metadata_getkey;
	protected com.sun.jna.Function lib3mf_metadata_getmustpreserve;
	protected com.sun.jna.Function lib3mf_metadata_setmustpreserve;
	protected com.sun.jna.Function lib3mf_metadata_gettype;
	protected com.sun.jna.Function lib3mf_metadata_settype;
	protected com.sun.jna.Function lib3mf_metadata_getvalue;
	protected com.sun.jna.Function lib3mf_metadata_setvalue;
	protected com.sun.jna.Function lib3mf_metadatagroup_getmetadatacount;
	protected com.sun.jna.Function lib3mf_metadatagroup_getmetadata;
	protected com.sun.jna.Function lib3mf_metadatagroup_getmetadatabykey;
	protected com.sun.jna.Function lib3mf_metadatagroup_removemetadatabyindex;
	protected com.sun.jna.Function lib3mf_metadatagroup_removemetadata;
	protected com.sun.jna.Function lib3mf_metadatagroup_addmetadata;
	protected com.sun.jna.Function lib3mf_triangleset_setname;
	protected com.sun.jna.Function lib3mf_triangleset_getname;
	protected com.sun.jna.Function lib3mf_triangleset_setidentifier;
	protected com.sun.jna.Function lib3mf_triangleset_getidentifier;
	protected com.sun.jna.Function lib3mf_triangleset_addtriangle;
	protected com.sun.jna.Function lib3mf_triangleset_removetriangle;
	protected com.sun.jna.Function lib3mf_triangleset_clear;
	protected com.sun.jna.Function lib3mf_triangleset_settrianglelist;
	protected com.sun.jna.Function lib3mf_triangleset_gettrianglelist;
	protected com.sun.jna.Function lib3mf_triangleset_addtrianglelist;
	protected com.sun.jna.Function lib3mf_triangleset_merge;
	protected com.sun.jna.Function lib3mf_triangleset_deleteset;
	protected com.sun.jna.Function lib3mf_triangleset_duplicate;
	protected com.sun.jna.Function lib3mf_object_gettype;
	protected com.sun.jna.Function lib3mf_object_settype;
	protected com.sun.jna.Function lib3mf_object_getname;
	protected com.sun.jna.Function lib3mf_object_setname;
	protected com.sun.jna.Function lib3mf_object_getpartnumber;
	protected com.sun.jna.Function lib3mf_object_setpartnumber;
	protected com.sun.jna.Function lib3mf_object_ismeshobject;
	protected com.sun.jna.Function lib3mf_object_iscomponentsobject;
	protected com.sun.jna.Function lib3mf_object_islevelsetobject;
	protected com.sun.jna.Function lib3mf_object_isvalid;
	protected com.sun.jna.Function lib3mf_object_setattachmentasthumbnail;
	protected com.sun.jna.Function lib3mf_object_getthumbnailattachment;
	protected com.sun.jna.Function lib3mf_object_clearthumbnailattachment;
	protected com.sun.jna.Function lib3mf_object_getoutbox;
	protected com.sun.jna.Function lib3mf_object_getuuid;
	protected com.sun.jna.Function lib3mf_object_setuuid;
	protected com.sun.jna.Function lib3mf_object_getmetadatagroup;
	protected com.sun.jna.Function lib3mf_object_setslicesmeshresolution;
	protected com.sun.jna.Function lib3mf_object_getslicesmeshresolution;
	protected com.sun.jna.Function lib3mf_object_hasslices;
	protected com.sun.jna.Function lib3mf_object_clearslicestack;
	protected com.sun.jna.Function lib3mf_object_getslicestack;
	protected com.sun.jna.Function lib3mf_object_assignslicestack;
	protected com.sun.jna.Function lib3mf_meshobject_getvertexcount;
	protected com.sun.jna.Function lib3mf_meshobject_gettrianglecount;
	protected com.sun.jna.Function lib3mf_meshobject_getvertex;
	protected com.sun.jna.Function lib3mf_meshobject_setvertex;
	protected com.sun.jna.Function lib3mf_meshobject_addvertex;
	protected com.sun.jna.Function lib3mf_meshobject_getvertices;
	protected com.sun.jna.Function lib3mf_meshobject_gettriangle;
	protected com.sun.jna.Function lib3mf_meshobject_settriangle;
	protected com.sun.jna.Function lib3mf_meshobject_addtriangle;
	protected com.sun.jna.Function lib3mf_meshobject_gettriangleindices;
	protected com.sun.jna.Function lib3mf_meshobject_setobjectlevelproperty;
	protected com.sun.jna.Function lib3mf_meshobject_getobjectlevelproperty;
	protected com.sun.jna.Function lib3mf_meshobject_settriangleproperties;
	protected com.sun.jna.Function lib3mf_meshobject_gettriangleproperties;
	protected com.sun.jna.Function lib3mf_meshobject_setalltriangleproperties;
	protected com.sun.jna.Function lib3mf_meshobject_getalltriangleproperties;
	protected com.sun.jna.Function lib3mf_meshobject_clearallproperties;
	protected com.sun.jna.Function lib3mf_meshobject_setgeometry;
	protected com.sun.jna.Function lib3mf_meshobject_ismanifoldandoriented;
	protected com.sun.jna.Function lib3mf_meshobject_beamlattice;
	protected com.sun.jna.Function lib3mf_meshobject_getvolumedata;
	protected com.sun.jna.Function lib3mf_meshobject_setvolumedata;
	protected com.sun.jna.Function lib3mf_meshobject_addtriangleset;
	protected com.sun.jna.Function lib3mf_meshobject_hastriangleset;
	protected com.sun.jna.Function lib3mf_meshobject_findtriangleset;
	protected com.sun.jna.Function lib3mf_meshobject_gettrianglesetcount;
	protected com.sun.jna.Function lib3mf_meshobject_gettriangleset;
	protected com.sun.jna.Function lib3mf_levelset_getfunction;
	protected com.sun.jna.Function lib3mf_levelset_setfunction;
	protected com.sun.jna.Function lib3mf_levelset_gettransform;
	protected com.sun.jna.Function lib3mf_levelset_settransform;
	protected com.sun.jna.Function lib3mf_levelset_getchannelname;
	protected com.sun.jna.Function lib3mf_levelset_setchannelname;
	protected com.sun.jna.Function lib3mf_levelset_setminfeaturesize;
	protected com.sun.jna.Function lib3mf_levelset_getminfeaturesize;
	protected com.sun.jna.Function lib3mf_levelset_setfallbackvalue;
	protected com.sun.jna.Function lib3mf_levelset_getfallbackvalue;
	protected com.sun.jna.Function lib3mf_levelset_setmeshbboxonly;
	protected com.sun.jna.Function lib3mf_levelset_getmeshbboxonly;
	protected com.sun.jna.Function lib3mf_levelset_setmesh;
	protected com.sun.jna.Function lib3mf_levelset_getmesh;
	protected com.sun.jna.Function lib3mf_levelset_getvolumedata;
	protected com.sun.jna.Function lib3mf_levelset_setvolumedata;
	protected com.sun.jna.Function lib3mf_beamlattice_getminlength;
	protected com.sun.jna.Function lib3mf_beamlattice_setminlength;
	protected com.sun.jna.Function lib3mf_beamlattice_getclipping;
	protected com.sun.jna.Function lib3mf_beamlattice_setclipping;
	protected com.sun.jna.Function lib3mf_beamlattice_getrepresentation;
	protected com.sun.jna.Function lib3mf_beamlattice_setrepresentation;
	protected com.sun.jna.Function lib3mf_beamlattice_getballoptions;
	protected com.sun.jna.Function lib3mf_beamlattice_setballoptions;
	protected com.sun.jna.Function lib3mf_beamlattice_getbeamcount;
	protected com.sun.jna.Function lib3mf_beamlattice_getbeam;
	protected com.sun.jna.Function lib3mf_beamlattice_addbeam;
	protected com.sun.jna.Function lib3mf_beamlattice_setbeam;
	protected com.sun.jna.Function lib3mf_beamlattice_setbeams;
	protected com.sun.jna.Function lib3mf_beamlattice_getbeams;
	protected com.sun.jna.Function lib3mf_beamlattice_getballcount;
	protected com.sun.jna.Function lib3mf_beamlattice_getball;
	protected com.sun.jna.Function lib3mf_beamlattice_addball;
	protected com.sun.jna.Function lib3mf_beamlattice_setball;
	protected com.sun.jna.Function lib3mf_beamlattice_setballs;
	protected com.sun.jna.Function lib3mf_beamlattice_getballs;
	protected com.sun.jna.Function lib3mf_beamlattice_getbeamsetcount;
	protected com.sun.jna.Function lib3mf_beamlattice_addbeamset;
	protected com.sun.jna.Function lib3mf_beamlattice_getbeamset;
	protected com.sun.jna.Function lib3mf_functionreference_getfunctionresourceid;
	protected com.sun.jna.Function lib3mf_functionreference_setfunctionresourceid;
	protected com.sun.jna.Function lib3mf_functionreference_gettransform;
	protected com.sun.jna.Function lib3mf_functionreference_settransform;
	protected com.sun.jna.Function lib3mf_functionreference_getchannelname;
	protected com.sun.jna.Function lib3mf_functionreference_setchannelname;
	protected com.sun.jna.Function lib3mf_functionreference_setminfeaturesize;
	protected com.sun.jna.Function lib3mf_functionreference_getminfeaturesize;
	protected com.sun.jna.Function lib3mf_functionreference_setfallbackvalue;
	protected com.sun.jna.Function lib3mf_functionreference_getfallbackvalue;
	protected com.sun.jna.Function lib3mf_volumedatacomposite_getbasematerialgroup;
	protected com.sun.jna.Function lib3mf_volumedatacomposite_setbasematerialgroup;
	protected com.sun.jna.Function lib3mf_volumedatacomposite_getmaterialmappingcount;
	protected com.sun.jna.Function lib3mf_volumedatacomposite_getmaterialmapping;
	protected com.sun.jna.Function lib3mf_volumedatacomposite_addmaterialmapping;
	protected com.sun.jna.Function lib3mf_volumedatacomposite_removematerialmapping;
	protected com.sun.jna.Function lib3mf_volumedataproperty_getname;
	protected com.sun.jna.Function lib3mf_volumedataproperty_setisrequired;
	protected com.sun.jna.Function lib3mf_volumedataproperty_isrequired;
	protected com.sun.jna.Function lib3mf_volumedata_getcomposite;
	protected com.sun.jna.Function lib3mf_volumedata_createnewcomposite;
	protected com.sun.jna.Function lib3mf_volumedata_removecomposite;
	protected com.sun.jna.Function lib3mf_volumedata_getcolor;
	protected com.sun.jna.Function lib3mf_volumedata_createnewcolor;
	protected com.sun.jna.Function lib3mf_volumedata_removecolor;
	protected com.sun.jna.Function lib3mf_volumedata_getpropertycount;
	protected com.sun.jna.Function lib3mf_volumedata_getproperty;
	protected com.sun.jna.Function lib3mf_volumedata_addpropertyfromfunction;
	protected com.sun.jna.Function lib3mf_volumedata_removeproperty;
	protected com.sun.jna.Function lib3mf_component_getobjectresource;
	protected com.sun.jna.Function lib3mf_component_getobjectresourceid;
	protected com.sun.jna.Function lib3mf_component_getuuid;
	protected com.sun.jna.Function lib3mf_component_setuuid;
	protected com.sun.jna.Function lib3mf_component_hastransform;
	protected com.sun.jna.Function lib3mf_component_gettransform;
	protected com.sun.jna.Function lib3mf_component_settransform;
	protected com.sun.jna.Function lib3mf_componentsobject_addcomponent;
	protected com.sun.jna.Function lib3mf_componentsobject_getcomponent;
	protected com.sun.jna.Function lib3mf_componentsobject_getcomponentcount;
	protected com.sun.jna.Function lib3mf_beamset_setname;
	protected com.sun.jna.Function lib3mf_beamset_getname;
	protected com.sun.jna.Function lib3mf_beamset_setidentifier;
	protected com.sun.jna.Function lib3mf_beamset_getidentifier;
	protected com.sun.jna.Function lib3mf_beamset_getreferencecount;
	protected com.sun.jna.Function lib3mf_beamset_setreferences;
	protected com.sun.jna.Function lib3mf_beamset_getreferences;
	protected com.sun.jna.Function lib3mf_beamset_getballreferencecount;
	protected com.sun.jna.Function lib3mf_beamset_setballreferences;
	protected com.sun.jna.Function lib3mf_beamset_getballreferences;
	protected com.sun.jna.Function lib3mf_basematerialgroup_getcount;
	protected com.sun.jna.Function lib3mf_basematerialgroup_getallpropertyids;
	protected com.sun.jna.Function lib3mf_basematerialgroup_addmaterial;
	protected com.sun.jna.Function lib3mf_basematerialgroup_removematerial;
	protected com.sun.jna.Function lib3mf_basematerialgroup_getname;
	protected com.sun.jna.Function lib3mf_basematerialgroup_setname;
	protected com.sun.jna.Function lib3mf_basematerialgroup_setdisplaycolor;
	protected com.sun.jna.Function lib3mf_basematerialgroup_getdisplaycolor;
	protected com.sun.jna.Function lib3mf_colorgroup_getcount;
	protected com.sun.jna.Function lib3mf_colorgroup_getallpropertyids;
	protected com.sun.jna.Function lib3mf_colorgroup_addcolor;
	protected com.sun.jna.Function lib3mf_colorgroup_removecolor;
	protected com.sun.jna.Function lib3mf_colorgroup_setcolor;
	protected com.sun.jna.Function lib3mf_colorgroup_getcolor;
	protected com.sun.jna.Function lib3mf_texture2dgroup_getcount;
	protected com.sun.jna.Function lib3mf_texture2dgroup_getallpropertyids;
	protected com.sun.jna.Function lib3mf_texture2dgroup_addtex2coord;
	protected com.sun.jna.Function lib3mf_texture2dgroup_gettex2coord;
	protected com.sun.jna.Function lib3mf_texture2dgroup_removetex2coord;
	protected com.sun.jna.Function lib3mf_texture2dgroup_gettexture2d;
	protected com.sun.jna.Function lib3mf_compositematerials_getcount;
	protected com.sun.jna.Function lib3mf_compositematerials_getallpropertyids;
	protected com.sun.jna.Function lib3mf_compositematerials_getbasematerialgroup;
	protected com.sun.jna.Function lib3mf_compositematerials_addcomposite;
	protected com.sun.jna.Function lib3mf_compositematerials_removecomposite;
	protected com.sun.jna.Function lib3mf_compositematerials_getcomposite;
	protected com.sun.jna.Function lib3mf_multipropertygroup_getcount;
	protected com.sun.jna.Function lib3mf_multipropertygroup_getallpropertyids;
	protected com.sun.jna.Function lib3mf_multipropertygroup_addmultiproperty;
	protected com.sun.jna.Function lib3mf_multipropertygroup_setmultiproperty;
	protected com.sun.jna.Function lib3mf_multipropertygroup_getmultiproperty;
	protected com.sun.jna.Function lib3mf_multipropertygroup_removemultiproperty;
	protected com.sun.jna.Function lib3mf_multipropertygroup_getlayercount;
	protected com.sun.jna.Function lib3mf_multipropertygroup_addlayer;
	protected com.sun.jna.Function lib3mf_multipropertygroup_getlayer;
	protected com.sun.jna.Function lib3mf_multipropertygroup_removelayer;
	protected com.sun.jna.Function lib3mf_image3d_getname;
	protected com.sun.jna.Function lib3mf_image3d_setname;
	protected com.sun.jna.Function lib3mf_image3d_isimagestack;
	protected com.sun.jna.Function lib3mf_imagestack_getrowcount;
	protected com.sun.jna.Function lib3mf_imagestack_setrowcount;
	protected com.sun.jna.Function lib3mf_imagestack_getcolumncount;
	protected com.sun.jna.Function lib3mf_imagestack_setcolumncount;
	protected com.sun.jna.Function lib3mf_imagestack_getsheetcount;
	protected com.sun.jna.Function lib3mf_imagestack_getsheet;
	protected com.sun.jna.Function lib3mf_imagestack_setsheet;
	protected com.sun.jna.Function lib3mf_imagestack_createemptysheet;
	protected com.sun.jna.Function lib3mf_imagestack_createsheetfrombuffer;
	protected com.sun.jna.Function lib3mf_imagestack_createsheetfromfile;
	protected com.sun.jna.Function lib3mf_attachment_getpath;
	protected com.sun.jna.Function lib3mf_attachment_setpath;
	protected com.sun.jna.Function lib3mf_attachment_packagepart;
	protected com.sun.jna.Function lib3mf_attachment_getrelationshiptype;
	protected com.sun.jna.Function lib3mf_attachment_setrelationshiptype;
	protected com.sun.jna.Function lib3mf_attachment_writetofile;
	protected com.sun.jna.Function lib3mf_attachment_readfromfile;
	protected com.sun.jna.Function lib3mf_attachment_readfromcallback;
	protected com.sun.jna.Function lib3mf_attachment_getstreamsize;
	protected com.sun.jna.Function lib3mf_attachment_writetobuffer;
	protected com.sun.jna.Function lib3mf_attachment_readfrombuffer;
	protected com.sun.jna.Function lib3mf_texture2d_getattachment;
	protected com.sun.jna.Function lib3mf_texture2d_setattachment;
	protected com.sun.jna.Function lib3mf_texture2d_getcontenttype;
	protected com.sun.jna.Function lib3mf_texture2d_setcontenttype;
	protected com.sun.jna.Function lib3mf_texture2d_gettilestyleuv;
	protected com.sun.jna.Function lib3mf_texture2d_settilestyleuv;
	protected com.sun.jna.Function lib3mf_texture2d_getfilter;
	protected com.sun.jna.Function lib3mf_texture2d_setfilter;
	protected com.sun.jna.Function lib3mf_implicitport_getidentifier;
	protected com.sun.jna.Function lib3mf_implicitport_setidentifier;
	protected com.sun.jna.Function lib3mf_implicitport_getdisplayname;
	protected com.sun.jna.Function lib3mf_implicitport_setdisplayname;
	protected com.sun.jna.Function lib3mf_implicitport_settype;
	protected com.sun.jna.Function lib3mf_implicitport_gettype;
	protected com.sun.jna.Function lib3mf_implicitport_getreference;
	protected com.sun.jna.Function lib3mf_implicitport_setreference;
	protected com.sun.jna.Function lib3mf_iterator_movenext;
	protected com.sun.jna.Function lib3mf_iterator_moveprevious;
	protected com.sun.jna.Function lib3mf_iterator_count;
	protected com.sun.jna.Function lib3mf_implicitportiterator_getcurrent;
	protected com.sun.jna.Function lib3mf_implicitnode_getidentifier;
	protected com.sun.jna.Function lib3mf_implicitnode_setidentifier;
	protected com.sun.jna.Function lib3mf_implicitnode_getdisplayname;
	protected com.sun.jna.Function lib3mf_implicitnode_setdisplayname;
	protected com.sun.jna.Function lib3mf_implicitnode_gettag;
	protected com.sun.jna.Function lib3mf_implicitnode_settag;
	protected com.sun.jna.Function lib3mf_implicitnode_getnodetype;
	protected com.sun.jna.Function lib3mf_implicitnode_addinput;
	protected com.sun.jna.Function lib3mf_implicitnode_getinputs;
	protected com.sun.jna.Function lib3mf_implicitnode_addoutput;
	protected com.sun.jna.Function lib3mf_implicitnode_getoutputs;
	protected com.sun.jna.Function lib3mf_implicitnode_findinput;
	protected com.sun.jna.Function lib3mf_implicitnode_findoutput;
	protected com.sun.jna.Function lib3mf_implicitnode_aretypesvalid;
	protected com.sun.jna.Function lib3mf_oneinputnode_getinputa;
	protected com.sun.jna.Function lib3mf_oneinputnode_getoutputresult;
	protected com.sun.jna.Function lib3mf_resourceidnode_setresource;
	protected com.sun.jna.Function lib3mf_resourceidnode_getresource;
	protected com.sun.jna.Function lib3mf_resourceidnode_getoutputvalue;
	protected com.sun.jna.Function lib3mf_twoinputnode_getinputb;
	protected com.sun.jna.Function lib3mf_selectnode_getinputb;
	protected com.sun.jna.Function lib3mf_selectnode_getinputc;
	protected com.sun.jna.Function lib3mf_selectnode_getinputd;
	protected com.sun.jna.Function lib3mf_clampnode_getinputmin;
	protected com.sun.jna.Function lib3mf_clampnode_getinputmax;
	protected com.sun.jna.Function lib3mf_composevectornode_getinputx;
	protected com.sun.jna.Function lib3mf_composevectornode_getinputy;
	protected com.sun.jna.Function lib3mf_composevectornode_getinputz;
	protected com.sun.jna.Function lib3mf_composevectornode_getoutputresult;
	protected com.sun.jna.Function lib3mf_decomposevectornode_getinputa;
	protected com.sun.jna.Function lib3mf_decomposevectornode_getoutputx;
	protected com.sun.jna.Function lib3mf_decomposevectornode_getoutputy;
	protected com.sun.jna.Function lib3mf_decomposevectornode_getoutputz;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm00;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm01;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm02;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm03;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm10;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm11;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm12;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm13;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm20;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm21;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm22;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm23;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm30;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm31;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm32;
	protected com.sun.jna.Function lib3mf_composematrixnode_getinputm33;
	protected com.sun.jna.Function lib3mf_composematrixnode_getoutputresult;
	protected com.sun.jna.Function lib3mf_matrixfromrowsnode_getinputa;
	protected com.sun.jna.Function lib3mf_matrixfromrowsnode_getinputb;
	protected com.sun.jna.Function lib3mf_matrixfromrowsnode_getinputc;
	protected com.sun.jna.Function lib3mf_matrixfromrowsnode_getinputd;
	protected com.sun.jna.Function lib3mf_matrixfromrowsnode_getoutputresult;
	protected com.sun.jna.Function lib3mf_matrixfromcolumnsnode_getinputa;
	protected com.sun.jna.Function lib3mf_matrixfromcolumnsnode_getinputb;
	protected com.sun.jna.Function lib3mf_matrixfromcolumnsnode_getinputc;
	protected com.sun.jna.Function lib3mf_matrixfromcolumnsnode_getinputd;
	protected com.sun.jna.Function lib3mf_matrixfromcolumnsnode_getoutputresult;
	protected com.sun.jna.Function lib3mf_constantnode_setconstant;
	protected com.sun.jna.Function lib3mf_constantnode_getconstant;
	protected com.sun.jna.Function lib3mf_constantnode_getoutputvalue;
	protected com.sun.jna.Function lib3mf_constvecnode_setvector;
	protected com.sun.jna.Function lib3mf_constvecnode_getvector;
	protected com.sun.jna.Function lib3mf_constvecnode_getoutputvector;
	protected com.sun.jna.Function lib3mf_constmatnode_setmatrix;
	protected com.sun.jna.Function lib3mf_constmatnode_getmatrix;
	protected com.sun.jna.Function lib3mf_constmatnode_getoutputmatrix;
	protected com.sun.jna.Function lib3mf_meshnode_getinputmesh;
	protected com.sun.jna.Function lib3mf_meshnode_getinputpos;
	protected com.sun.jna.Function lib3mf_meshnode_getoutputdistance;
	protected com.sun.jna.Function lib3mf_unsignedmeshnode_getinputmesh;
	protected com.sun.jna.Function lib3mf_unsignedmeshnode_getinputpos;
	protected com.sun.jna.Function lib3mf_unsignedmeshnode_getoutputdistance;
	protected com.sun.jna.Function lib3mf_beamlatticenode_getinputbeamlattice;
	protected com.sun.jna.Function lib3mf_beamlatticenode_getinputpos;
	protected com.sun.jna.Function lib3mf_beamlatticenode_getoutputdistance;
	protected com.sun.jna.Function lib3mf_beamlatticenode_setaccuraterange;
	protected com.sun.jna.Function lib3mf_beamlatticenode_getaccuraterange;
	protected com.sun.jna.Function lib3mf_functiongradientnode_getinputfunctionid;
	protected com.sun.jna.Function lib3mf_functiongradientnode_getinputpos;
	protected com.sun.jna.Function lib3mf_functiongradientnode_getinputstep;
	protected com.sun.jna.Function lib3mf_functiongradientnode_setscalaroutputname;
	protected com.sun.jna.Function lib3mf_functiongradientnode_getscalaroutputname;
	protected com.sun.jna.Function lib3mf_functiongradientnode_setvectorinputname;
	protected com.sun.jna.Function lib3mf_functiongradientnode_getvectorinputname;
	protected com.sun.jna.Function lib3mf_functiongradientnode_getoutputnormalizedgradient;
	protected com.sun.jna.Function lib3mf_functiongradientnode_getoutputgradient;
	protected com.sun.jna.Function lib3mf_functiongradientnode_getoutputmagnitude;
	protected com.sun.jna.Function lib3mf_normalizedistancenode_getinputfunctionid;
	protected com.sun.jna.Function lib3mf_normalizedistancenode_getinputpos;
	protected com.sun.jna.Function lib3mf_normalizedistancenode_getinputstep;
	protected com.sun.jna.Function lib3mf_normalizedistancenode_setscalaroutputname;
	protected com.sun.jna.Function lib3mf_normalizedistancenode_getscalaroutputname;
	protected com.sun.jna.Function lib3mf_normalizedistancenode_setvectorinputname;
	protected com.sun.jna.Function lib3mf_normalizedistancenode_getvectorinputname;
	protected com.sun.jna.Function lib3mf_normalizedistancenode_getoutputresult;
	protected com.sun.jna.Function lib3mf_functioncallnode_getinputfunctionid;
	protected com.sun.jna.Function lib3mf_nodeiterator_getcurrent;
	protected com.sun.jna.Function lib3mf_function_getdisplayname;
	protected com.sun.jna.Function lib3mf_function_setdisplayname;
	protected com.sun.jna.Function lib3mf_function_addinput;
	protected com.sun.jna.Function lib3mf_function_getinputs;
	protected com.sun.jna.Function lib3mf_function_removeinput;
	protected com.sun.jna.Function lib3mf_function_addoutput;
	protected com.sun.jna.Function lib3mf_function_getoutputs;
	protected com.sun.jna.Function lib3mf_function_removeoutput;
	protected com.sun.jna.Function lib3mf_function_findinput;
	protected com.sun.jna.Function lib3mf_function_findoutput;
	protected com.sun.jna.Function lib3mf_implicitfunction_getidentifier;
	protected com.sun.jna.Function lib3mf_implicitfunction_setidentifier;
	protected com.sun.jna.Function lib3mf_implicitfunction_addnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addsinnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addcosnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addtannode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addarcsinnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addarccosnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addarctan2node;
	protected com.sun.jna.Function lib3mf_implicitfunction_addsinhnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addcoshnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addtanhnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addroundnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addceilnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addfloornode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addsignnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addfractnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addabsnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addexpnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addlognode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addlog2node;
	protected com.sun.jna.Function lib3mf_implicitfunction_addlog10node;
	protected com.sun.jna.Function lib3mf_implicitfunction_addlengthnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addtransposenode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addinversenode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addsqrtnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addresourceidnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addadditionnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addsubtractionnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addmultiplicationnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_adddivisionnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_adddotnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addcrossnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addmatvecmultiplicationnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addminnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addmaxnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addfmodnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addpownode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addselectnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addclampnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addcomposevectornode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addvectorfromscalarnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_adddecomposevectornode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addcomposematrixnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addmatrixfromrowsnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addmatrixfromcolumnsnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addconstantnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addconstvecnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addconstmatnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addmeshnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addunsignedmeshnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addbeamlatticenode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addfunctiongradientnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addnormalizedistancenode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addfunctioncallnode;
	protected com.sun.jna.Function lib3mf_implicitfunction_getnodes;
	protected com.sun.jna.Function lib3mf_implicitfunction_removenode;
	protected com.sun.jna.Function lib3mf_implicitfunction_addlink;
	protected com.sun.jna.Function lib3mf_implicitfunction_addlinkbynames;
	protected com.sun.jna.Function lib3mf_implicitfunction_clear;
	protected com.sun.jna.Function lib3mf_implicitfunction_sortnodestopologically;
	protected com.sun.jna.Function lib3mf_functionfromimage3d_getimage3d;
	protected com.sun.jna.Function lib3mf_functionfromimage3d_setimage3d;
	protected com.sun.jna.Function lib3mf_functionfromimage3d_setfilter;
	protected com.sun.jna.Function lib3mf_functionfromimage3d_getfilter;
	protected com.sun.jna.Function lib3mf_functionfromimage3d_settilestyles;
	protected com.sun.jna.Function lib3mf_functionfromimage3d_gettilestyles;
	protected com.sun.jna.Function lib3mf_functionfromimage3d_getoffset;
	protected com.sun.jna.Function lib3mf_functionfromimage3d_setoffset;
	protected com.sun.jna.Function lib3mf_functionfromimage3d_getscale;
	protected com.sun.jna.Function lib3mf_functionfromimage3d_setscale;
	protected com.sun.jna.Function lib3mf_builditem_getobjectresource;
	protected com.sun.jna.Function lib3mf_builditem_getuuid;
	protected com.sun.jna.Function lib3mf_builditem_setuuid;
	protected com.sun.jna.Function lib3mf_builditem_getobjectresourceid;
	protected com.sun.jna.Function lib3mf_builditem_hasobjecttransform;
	protected com.sun.jna.Function lib3mf_builditem_getobjecttransform;
	protected com.sun.jna.Function lib3mf_builditem_setobjecttransform;
	protected com.sun.jna.Function lib3mf_builditem_getpartnumber;
	protected com.sun.jna.Function lib3mf_builditem_setpartnumber;
	protected com.sun.jna.Function lib3mf_builditem_getmetadatagroup;
	protected com.sun.jna.Function lib3mf_builditem_getoutbox;
	protected com.sun.jna.Function lib3mf_builditemiterator_movenext;
	protected com.sun.jna.Function lib3mf_builditemiterator_moveprevious;
	protected com.sun.jna.Function lib3mf_builditemiterator_getcurrent;
	protected com.sun.jna.Function lib3mf_builditemiterator_clone;
	protected com.sun.jna.Function lib3mf_builditemiterator_count;
	protected com.sun.jna.Function lib3mf_slice_setvertices;
	protected com.sun.jna.Function lib3mf_slice_getvertices;
	protected com.sun.jna.Function lib3mf_slice_getvertexcount;
	protected com.sun.jna.Function lib3mf_slice_addpolygon;
	protected com.sun.jna.Function lib3mf_slice_getpolygoncount;
	protected com.sun.jna.Function lib3mf_slice_setpolygonindices;
	protected com.sun.jna.Function lib3mf_slice_getpolygonindices;
	protected com.sun.jna.Function lib3mf_slice_getpolygonindexcount;
	protected com.sun.jna.Function lib3mf_slice_getztop;
	protected com.sun.jna.Function lib3mf_slicestack_getbottomz;
	protected com.sun.jna.Function lib3mf_slicestack_getslicecount;
	protected com.sun.jna.Function lib3mf_slicestack_getslice;
	protected com.sun.jna.Function lib3mf_slicestack_addslice;
	protected com.sun.jna.Function lib3mf_slicestack_getslicerefcount;
	protected com.sun.jna.Function lib3mf_slicestack_addslicestackreference;
	protected com.sun.jna.Function lib3mf_slicestack_getslicestackreference;
	protected com.sun.jna.Function lib3mf_slicestack_collapseslicereferences;
	protected com.sun.jna.Function lib3mf_slicestack_setownpath;
	protected com.sun.jna.Function lib3mf_slicestack_getownpath;
	protected com.sun.jna.Function lib3mf_consumer_getconsumerid;
	protected com.sun.jna.Function lib3mf_consumer_getkeyid;
	protected com.sun.jna.Function lib3mf_consumer_getkeyvalue;
	protected com.sun.jna.Function lib3mf_accessright_getconsumer;
	protected com.sun.jna.Function lib3mf_accessright_getwrappingalgorithm;
	protected com.sun.jna.Function lib3mf_accessright_getmgfalgorithm;
	protected com.sun.jna.Function lib3mf_accessright_getdigestmethod;
	protected com.sun.jna.Function lib3mf_contentencryptionparams_getencryptionalgorithm;
	protected com.sun.jna.Function lib3mf_contentencryptionparams_getkey;
	protected com.sun.jna.Function lib3mf_contentencryptionparams_getinitializationvector;
	protected com.sun.jna.Function lib3mf_contentencryptionparams_getauthenticationtag;
	protected com.sun.jna.Function lib3mf_contentencryptionparams_setauthenticationtag;
	protected com.sun.jna.Function lib3mf_contentencryptionparams_getadditionalauthenticationdata;
	protected com.sun.jna.Function lib3mf_contentencryptionparams_getdescriptor;
	protected com.sun.jna.Function lib3mf_contentencryptionparams_getkeyuuid;
	protected com.sun.jna.Function lib3mf_resourcedata_getpath;
	protected com.sun.jna.Function lib3mf_resourcedata_getencryptionalgorithm;
	protected com.sun.jna.Function lib3mf_resourcedata_getcompression;
	protected com.sun.jna.Function lib3mf_resourcedata_getadditionalauthenticationdata;
	protected com.sun.jna.Function lib3mf_resourcedatagroup_getkeyuuid;
	protected com.sun.jna.Function lib3mf_resourcedatagroup_addaccessright;
	protected com.sun.jna.Function lib3mf_resourcedatagroup_findaccessrightbyconsumer;
	protected com.sun.jna.Function lib3mf_resourcedatagroup_removeaccessright;
	protected com.sun.jna.Function lib3mf_keystore_addconsumer;
	protected com.sun.jna.Function lib3mf_keystore_getconsumercount;
	protected com.sun.jna.Function lib3mf_keystore_getconsumer;
	protected com.sun.jna.Function lib3mf_keystore_removeconsumer;
	protected com.sun.jna.Function lib3mf_keystore_findconsumer;
	protected com.sun.jna.Function lib3mf_keystore_getresourcedatagroupcount;
	protected com.sun.jna.Function lib3mf_keystore_addresourcedatagroup;
	protected com.sun.jna.Function lib3mf_keystore_getresourcedatagroup;
	protected com.sun.jna.Function lib3mf_keystore_removeresourcedatagroup;
	protected com.sun.jna.Function lib3mf_keystore_findresourcedatagroup;
	protected com.sun.jna.Function lib3mf_keystore_addresourcedata;
	protected com.sun.jna.Function lib3mf_keystore_removeresourcedata;
	protected com.sun.jna.Function lib3mf_keystore_findresourcedata;
	protected com.sun.jna.Function lib3mf_keystore_getresourcedatacount;
	protected com.sun.jna.Function lib3mf_keystore_getresourcedata;
	protected com.sun.jna.Function lib3mf_keystore_getuuid;
	protected com.sun.jna.Function lib3mf_keystore_setuuid;
	protected com.sun.jna.Function lib3mf_model_rootmodelpart;
	protected com.sun.jna.Function lib3mf_model_findorcreatepackagepart;
	protected com.sun.jna.Function lib3mf_model_setunit;
	protected com.sun.jna.Function lib3mf_model_getunit;
	protected com.sun.jna.Function lib3mf_model_getlanguage;
	protected com.sun.jna.Function lib3mf_model_setlanguage;
	protected com.sun.jna.Function lib3mf_model_querywriter;
	protected com.sun.jna.Function lib3mf_model_queryreader;
	protected com.sun.jna.Function lib3mf_model_getresourcebyid;
	protected com.sun.jna.Function lib3mf_model_gettexture2dbyid;
	protected com.sun.jna.Function lib3mf_model_getpropertytypebyid;
	protected com.sun.jna.Function lib3mf_model_getbasematerialgroupbyid;
	protected com.sun.jna.Function lib3mf_model_gettexture2dgroupbyid;
	protected com.sun.jna.Function lib3mf_model_getcompositematerialsbyid;
	protected com.sun.jna.Function lib3mf_model_getmultipropertygroupbyid;
	protected com.sun.jna.Function lib3mf_model_getmeshobjectbyid;
	protected com.sun.jna.Function lib3mf_model_getcomponentsobjectbyid;
	protected com.sun.jna.Function lib3mf_model_getcolorgroupbyid;
	protected com.sun.jna.Function lib3mf_model_getslicestackbyid;
	protected com.sun.jna.Function lib3mf_model_getlevelsetbyid;
	protected com.sun.jna.Function lib3mf_model_getbuilduuid;
	protected com.sun.jna.Function lib3mf_model_setbuilduuid;
	protected com.sun.jna.Function lib3mf_model_getbuilditems;
	protected com.sun.jna.Function lib3mf_model_getoutbox;
	protected com.sun.jna.Function lib3mf_model_getresources;
	protected com.sun.jna.Function lib3mf_model_getobjects;
	protected com.sun.jna.Function lib3mf_model_getmeshobjects;
	protected com.sun.jna.Function lib3mf_model_getcomponentsobjects;
	protected com.sun.jna.Function lib3mf_model_gettexture2ds;
	protected com.sun.jna.Function lib3mf_model_getbasematerialgroups;
	protected com.sun.jna.Function lib3mf_model_getcolorgroups;
	protected com.sun.jna.Function lib3mf_model_gettexture2dgroups;
	protected com.sun.jna.Function lib3mf_model_getcompositematerials;
	protected com.sun.jna.Function lib3mf_model_getmultipropertygroups;
	protected com.sun.jna.Function lib3mf_model_getslicestacks;
	protected com.sun.jna.Function lib3mf_model_getimage3ds;
	protected com.sun.jna.Function lib3mf_model_mergetomodel;
	protected com.sun.jna.Function lib3mf_model_mergefrommodel;
	protected com.sun.jna.Function lib3mf_model_addmeshobject;
	protected com.sun.jna.Function lib3mf_model_addcomponentsobject;
	protected com.sun.jna.Function lib3mf_model_addslicestack;
	protected com.sun.jna.Function lib3mf_model_addtexture2dfromattachment;
	protected com.sun.jna.Function lib3mf_model_addbasematerialgroup;
	protected com.sun.jna.Function lib3mf_model_addcolorgroup;
	protected com.sun.jna.Function lib3mf_model_addtexture2dgroup;
	protected com.sun.jna.Function lib3mf_model_addcompositematerials;
	protected com.sun.jna.Function lib3mf_model_addmultipropertygroup;
	protected com.sun.jna.Function lib3mf_model_addimagestack;
	protected com.sun.jna.Function lib3mf_model_getimagestackbyid;
	protected com.sun.jna.Function lib3mf_model_addbuilditem;
	protected com.sun.jna.Function lib3mf_model_removebuilditem;
	protected com.sun.jna.Function lib3mf_model_getmetadatagroup;
	protected com.sun.jna.Function lib3mf_model_addattachment;
	protected com.sun.jna.Function lib3mf_model_removeattachment;
	protected com.sun.jna.Function lib3mf_model_getattachment;
	protected com.sun.jna.Function lib3mf_model_findattachment;
	protected com.sun.jna.Function lib3mf_model_getattachmentcount;
	protected com.sun.jna.Function lib3mf_model_haspackagethumbnailattachment;
	protected com.sun.jna.Function lib3mf_model_createpackagethumbnailattachment;
	protected com.sun.jna.Function lib3mf_model_getpackagethumbnailattachment;
	protected com.sun.jna.Function lib3mf_model_removepackagethumbnailattachment;
	protected com.sun.jna.Function lib3mf_model_addcustomcontenttype;
	protected com.sun.jna.Function lib3mf_model_removecustomcontenttype;
	protected com.sun.jna.Function lib3mf_model_setrandomnumbercallback;
	protected com.sun.jna.Function lib3mf_model_getkeystore;
	protected com.sun.jna.Function lib3mf_model_getfunctions;
	protected com.sun.jna.Function lib3mf_model_addimplicitfunction;
	protected com.sun.jna.Function lib3mf_model_addfunctionfromimage3d;
	protected com.sun.jna.Function lib3mf_model_addvolumedata;
	protected com.sun.jna.Function lib3mf_model_addlevelset;
	protected com.sun.jna.Function lib3mf_model_getlevelsets;
	protected com.sun.jna.Function lib3mf_model_removeresource;

	protected NativeLibrary mLibrary;

	public Lib3MFWrapper(String libraryPath) {
		mLibrary = NativeLibrary.getInstance(libraryPath);
		lib3mf_getlibraryversion = mLibrary.getFunction("lib3mf_getlibraryversion");
		lib3mf_getprereleaseinformation = mLibrary.getFunction("lib3mf_getprereleaseinformation");
		lib3mf_getbuildinformation = mLibrary.getFunction("lib3mf_getbuildinformation");
		lib3mf_getspecificationversion = mLibrary.getFunction("lib3mf_getspecificationversion");
		lib3mf_createmodel = mLibrary.getFunction("lib3mf_createmodel");
		lib3mf_release = mLibrary.getFunction("lib3mf_release");
		lib3mf_acquire = mLibrary.getFunction("lib3mf_acquire");
		lib3mf_setjournal = mLibrary.getFunction("lib3mf_setjournal");
		lib3mf_getlasterror = mLibrary.getFunction("lib3mf_getlasterror");
		lib3mf_getsymbollookupmethod = mLibrary.getFunction("lib3mf_getsymbollookupmethod");
		lib3mf_retrieveprogressmessage = mLibrary.getFunction("lib3mf_retrieveprogressmessage");
		lib3mf_rgbatocolor = mLibrary.getFunction("lib3mf_rgbatocolor");
		lib3mf_floatrgbatocolor = mLibrary.getFunction("lib3mf_floatrgbatocolor");
		lib3mf_colortorgba = mLibrary.getFunction("lib3mf_colortorgba");
		lib3mf_colortofloatrgba = mLibrary.getFunction("lib3mf_colortofloatrgba");
		lib3mf_getidentitytransform = mLibrary.getFunction("lib3mf_getidentitytransform");
		lib3mf_getuniformscaletransform = mLibrary.getFunction("lib3mf_getuniformscaletransform");
		lib3mf_getscaletransform = mLibrary.getFunction("lib3mf_getscaletransform");
		lib3mf_gettranslationtransform = mLibrary.getFunction("lib3mf_gettranslationtransform");
		lib3mf_base_classtypeid = mLibrary.getFunction("lib3mf_base_classtypeid");
		lib3mf_writer_writetofile = mLibrary.getFunction("lib3mf_writer_writetofile");
		lib3mf_writer_getstreamsize = mLibrary.getFunction("lib3mf_writer_getstreamsize");
		lib3mf_writer_writetobuffer = mLibrary.getFunction("lib3mf_writer_writetobuffer");
		lib3mf_writer_writetocallback = mLibrary.getFunction("lib3mf_writer_writetocallback");
		lib3mf_writer_setprogresscallback = mLibrary.getFunction("lib3mf_writer_setprogresscallback");
		lib3mf_writer_getdecimalprecision = mLibrary.getFunction("lib3mf_writer_getdecimalprecision");
		lib3mf_writer_setdecimalprecision = mLibrary.getFunction("lib3mf_writer_setdecimalprecision");
		lib3mf_writer_setstrictmodeactive = mLibrary.getFunction("lib3mf_writer_setstrictmodeactive");
		lib3mf_writer_getstrictmodeactive = mLibrary.getFunction("lib3mf_writer_getstrictmodeactive");
		lib3mf_writer_getwarning = mLibrary.getFunction("lib3mf_writer_getwarning");
		lib3mf_writer_getwarningcount = mLibrary.getFunction("lib3mf_writer_getwarningcount");
		lib3mf_writer_addkeywrappingcallback = mLibrary.getFunction("lib3mf_writer_addkeywrappingcallback");
		lib3mf_writer_setcontentencryptioncallback = mLibrary.getFunction("lib3mf_writer_setcontentencryptioncallback");
		lib3mf_reader_readfromfile = mLibrary.getFunction("lib3mf_reader_readfromfile");
		lib3mf_reader_readfrombuffer = mLibrary.getFunction("lib3mf_reader_readfrombuffer");
		lib3mf_reader_readfromcallback = mLibrary.getFunction("lib3mf_reader_readfromcallback");
		lib3mf_reader_setprogresscallback = mLibrary.getFunction("lib3mf_reader_setprogresscallback");
		lib3mf_reader_addrelationtoread = mLibrary.getFunction("lib3mf_reader_addrelationtoread");
		lib3mf_reader_removerelationtoread = mLibrary.getFunction("lib3mf_reader_removerelationtoread");
		lib3mf_reader_setstrictmodeactive = mLibrary.getFunction("lib3mf_reader_setstrictmodeactive");
		lib3mf_reader_getstrictmodeactive = mLibrary.getFunction("lib3mf_reader_getstrictmodeactive");
		lib3mf_reader_getwarning = mLibrary.getFunction("lib3mf_reader_getwarning");
		lib3mf_reader_getwarningcount = mLibrary.getFunction("lib3mf_reader_getwarningcount");
		lib3mf_reader_addkeywrappingcallback = mLibrary.getFunction("lib3mf_reader_addkeywrappingcallback");
		lib3mf_reader_setcontentencryptioncallback = mLibrary.getFunction("lib3mf_reader_setcontentencryptioncallback");
		lib3mf_packagepart_getpath = mLibrary.getFunction("lib3mf_packagepart_getpath");
		lib3mf_packagepart_setpath = mLibrary.getFunction("lib3mf_packagepart_setpath");
		lib3mf_resource_getresourceid = mLibrary.getFunction("lib3mf_resource_getresourceid");
		lib3mf_resource_getuniqueresourceid = mLibrary.getFunction("lib3mf_resource_getuniqueresourceid");
		lib3mf_resource_packagepart = mLibrary.getFunction("lib3mf_resource_packagepart");
		lib3mf_resource_setpackagepart = mLibrary.getFunction("lib3mf_resource_setpackagepart");
		lib3mf_resource_getmodelresourceid = mLibrary.getFunction("lib3mf_resource_getmodelresourceid");
		lib3mf_resourceiterator_movenext = mLibrary.getFunction("lib3mf_resourceiterator_movenext");
		lib3mf_resourceiterator_moveprevious = mLibrary.getFunction("lib3mf_resourceiterator_moveprevious");
		lib3mf_resourceiterator_getcurrent = mLibrary.getFunction("lib3mf_resourceiterator_getcurrent");
		lib3mf_resourceiterator_clone = mLibrary.getFunction("lib3mf_resourceiterator_clone");
		lib3mf_resourceiterator_count = mLibrary.getFunction("lib3mf_resourceiterator_count");
		lib3mf_slicestackiterator_getcurrentslicestack = mLibrary.getFunction("lib3mf_slicestackiterator_getcurrentslicestack");
		lib3mf_objectiterator_getcurrentobject = mLibrary.getFunction("lib3mf_objectiterator_getcurrentobject");
		lib3mf_meshobjectiterator_getcurrentmeshobject = mLibrary.getFunction("lib3mf_meshobjectiterator_getcurrentmeshobject");
		lib3mf_componentsobjectiterator_getcurrentcomponentsobject = mLibrary.getFunction("lib3mf_componentsobjectiterator_getcurrentcomponentsobject");
		lib3mf_texture2diterator_getcurrenttexture2d = mLibrary.getFunction("lib3mf_texture2diterator_getcurrenttexture2d");
		lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup = mLibrary.getFunction("lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup");
		lib3mf_colorgroupiterator_getcurrentcolorgroup = mLibrary.getFunction("lib3mf_colorgroupiterator_getcurrentcolorgroup");
		lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup = mLibrary.getFunction("lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup");
		lib3mf_compositematerialsiterator_getcurrentcompositematerials = mLibrary.getFunction("lib3mf_compositematerialsiterator_getcurrentcompositematerials");
		lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup = mLibrary.getFunction("lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup");
		lib3mf_image3diterator_getcurrentimage3d = mLibrary.getFunction("lib3mf_image3diterator_getcurrentimage3d");
		lib3mf_functioniterator_getcurrentfunction = mLibrary.getFunction("lib3mf_functioniterator_getcurrentfunction");
		lib3mf_levelsetiterator_getcurrentlevelset = mLibrary.getFunction("lib3mf_levelsetiterator_getcurrentlevelset");
		lib3mf_metadata_getnamespace = mLibrary.getFunction("lib3mf_metadata_getnamespace");
		lib3mf_metadata_setnamespace = mLibrary.getFunction("lib3mf_metadata_setnamespace");
		lib3mf_metadata_getname = mLibrary.getFunction("lib3mf_metadata_getname");
		lib3mf_metadata_setname = mLibrary.getFunction("lib3mf_metadata_setname");
		lib3mf_metadata_getkey = mLibrary.getFunction("lib3mf_metadata_getkey");
		lib3mf_metadata_getmustpreserve = mLibrary.getFunction("lib3mf_metadata_getmustpreserve");
		lib3mf_metadata_setmustpreserve = mLibrary.getFunction("lib3mf_metadata_setmustpreserve");
		lib3mf_metadata_gettype = mLibrary.getFunction("lib3mf_metadata_gettype");
		lib3mf_metadata_settype = mLibrary.getFunction("lib3mf_metadata_settype");
		lib3mf_metadata_getvalue = mLibrary.getFunction("lib3mf_metadata_getvalue");
		lib3mf_metadata_setvalue = mLibrary.getFunction("lib3mf_metadata_setvalue");
		lib3mf_metadatagroup_getmetadatacount = mLibrary.getFunction("lib3mf_metadatagroup_getmetadatacount");
		lib3mf_metadatagroup_getmetadata = mLibrary.getFunction("lib3mf_metadatagroup_getmetadata");
		lib3mf_metadatagroup_getmetadatabykey = mLibrary.getFunction("lib3mf_metadatagroup_getmetadatabykey");
		lib3mf_metadatagroup_removemetadatabyindex = mLibrary.getFunction("lib3mf_metadatagroup_removemetadatabyindex");
		lib3mf_metadatagroup_removemetadata = mLibrary.getFunction("lib3mf_metadatagroup_removemetadata");
		lib3mf_metadatagroup_addmetadata = mLibrary.getFunction("lib3mf_metadatagroup_addmetadata");
		lib3mf_triangleset_setname = mLibrary.getFunction("lib3mf_triangleset_setname");
		lib3mf_triangleset_getname = mLibrary.getFunction("lib3mf_triangleset_getname");
		lib3mf_triangleset_setidentifier = mLibrary.getFunction("lib3mf_triangleset_setidentifier");
		lib3mf_triangleset_getidentifier = mLibrary.getFunction("lib3mf_triangleset_getidentifier");
		lib3mf_triangleset_addtriangle = mLibrary.getFunction("lib3mf_triangleset_addtriangle");
		lib3mf_triangleset_removetriangle = mLibrary.getFunction("lib3mf_triangleset_removetriangle");
		lib3mf_triangleset_clear = mLibrary.getFunction("lib3mf_triangleset_clear");
		lib3mf_triangleset_settrianglelist = mLibrary.getFunction("lib3mf_triangleset_settrianglelist");
		lib3mf_triangleset_gettrianglelist = mLibrary.getFunction("lib3mf_triangleset_gettrianglelist");
		lib3mf_triangleset_addtrianglelist = mLibrary.getFunction("lib3mf_triangleset_addtrianglelist");
		lib3mf_triangleset_merge = mLibrary.getFunction("lib3mf_triangleset_merge");
		lib3mf_triangleset_deleteset = mLibrary.getFunction("lib3mf_triangleset_deleteset");
		lib3mf_triangleset_duplicate = mLibrary.getFunction("lib3mf_triangleset_duplicate");
		lib3mf_object_gettype = mLibrary.getFunction("lib3mf_object_gettype");
		lib3mf_object_settype = mLibrary.getFunction("lib3mf_object_settype");
		lib3mf_object_getname = mLibrary.getFunction("lib3mf_object_getname");
		lib3mf_object_setname = mLibrary.getFunction("lib3mf_object_setname");
		lib3mf_object_getpartnumber = mLibrary.getFunction("lib3mf_object_getpartnumber");
		lib3mf_object_setpartnumber = mLibrary.getFunction("lib3mf_object_setpartnumber");
		lib3mf_object_ismeshobject = mLibrary.getFunction("lib3mf_object_ismeshobject");
		lib3mf_object_iscomponentsobject = mLibrary.getFunction("lib3mf_object_iscomponentsobject");
		lib3mf_object_islevelsetobject = mLibrary.getFunction("lib3mf_object_islevelsetobject");
		lib3mf_object_isvalid = mLibrary.getFunction("lib3mf_object_isvalid");
		lib3mf_object_setattachmentasthumbnail = mLibrary.getFunction("lib3mf_object_setattachmentasthumbnail");
		lib3mf_object_getthumbnailattachment = mLibrary.getFunction("lib3mf_object_getthumbnailattachment");
		lib3mf_object_clearthumbnailattachment = mLibrary.getFunction("lib3mf_object_clearthumbnailattachment");
		lib3mf_object_getoutbox = mLibrary.getFunction("lib3mf_object_getoutbox");
		lib3mf_object_getuuid = mLibrary.getFunction("lib3mf_object_getuuid");
		lib3mf_object_setuuid = mLibrary.getFunction("lib3mf_object_setuuid");
		lib3mf_object_getmetadatagroup = mLibrary.getFunction("lib3mf_object_getmetadatagroup");
		lib3mf_object_setslicesmeshresolution = mLibrary.getFunction("lib3mf_object_setslicesmeshresolution");
		lib3mf_object_getslicesmeshresolution = mLibrary.getFunction("lib3mf_object_getslicesmeshresolution");
		lib3mf_object_hasslices = mLibrary.getFunction("lib3mf_object_hasslices");
		lib3mf_object_clearslicestack = mLibrary.getFunction("lib3mf_object_clearslicestack");
		lib3mf_object_getslicestack = mLibrary.getFunction("lib3mf_object_getslicestack");
		lib3mf_object_assignslicestack = mLibrary.getFunction("lib3mf_object_assignslicestack");
		lib3mf_meshobject_getvertexcount = mLibrary.getFunction("lib3mf_meshobject_getvertexcount");
		lib3mf_meshobject_gettrianglecount = mLibrary.getFunction("lib3mf_meshobject_gettrianglecount");
		lib3mf_meshobject_getvertex = mLibrary.getFunction("lib3mf_meshobject_getvertex");
		lib3mf_meshobject_setvertex = mLibrary.getFunction("lib3mf_meshobject_setvertex");
		lib3mf_meshobject_addvertex = mLibrary.getFunction("lib3mf_meshobject_addvertex");
		lib3mf_meshobject_getvertices = mLibrary.getFunction("lib3mf_meshobject_getvertices");
		lib3mf_meshobject_gettriangle = mLibrary.getFunction("lib3mf_meshobject_gettriangle");
		lib3mf_meshobject_settriangle = mLibrary.getFunction("lib3mf_meshobject_settriangle");
		lib3mf_meshobject_addtriangle = mLibrary.getFunction("lib3mf_meshobject_addtriangle");
		lib3mf_meshobject_gettriangleindices = mLibrary.getFunction("lib3mf_meshobject_gettriangleindices");
		lib3mf_meshobject_setobjectlevelproperty = mLibrary.getFunction("lib3mf_meshobject_setobjectlevelproperty");
		lib3mf_meshobject_getobjectlevelproperty = mLibrary.getFunction("lib3mf_meshobject_getobjectlevelproperty");
		lib3mf_meshobject_settriangleproperties = mLibrary.getFunction("lib3mf_meshobject_settriangleproperties");
		lib3mf_meshobject_gettriangleproperties = mLibrary.getFunction("lib3mf_meshobject_gettriangleproperties");
		lib3mf_meshobject_setalltriangleproperties = mLibrary.getFunction("lib3mf_meshobject_setalltriangleproperties");
		lib3mf_meshobject_getalltriangleproperties = mLibrary.getFunction("lib3mf_meshobject_getalltriangleproperties");
		lib3mf_meshobject_clearallproperties = mLibrary.getFunction("lib3mf_meshobject_clearallproperties");
		lib3mf_meshobject_setgeometry = mLibrary.getFunction("lib3mf_meshobject_setgeometry");
		lib3mf_meshobject_ismanifoldandoriented = mLibrary.getFunction("lib3mf_meshobject_ismanifoldandoriented");
		lib3mf_meshobject_beamlattice = mLibrary.getFunction("lib3mf_meshobject_beamlattice");
		lib3mf_meshobject_getvolumedata = mLibrary.getFunction("lib3mf_meshobject_getvolumedata");
		lib3mf_meshobject_setvolumedata = mLibrary.getFunction("lib3mf_meshobject_setvolumedata");
		lib3mf_meshobject_addtriangleset = mLibrary.getFunction("lib3mf_meshobject_addtriangleset");
		lib3mf_meshobject_hastriangleset = mLibrary.getFunction("lib3mf_meshobject_hastriangleset");
		lib3mf_meshobject_findtriangleset = mLibrary.getFunction("lib3mf_meshobject_findtriangleset");
		lib3mf_meshobject_gettrianglesetcount = mLibrary.getFunction("lib3mf_meshobject_gettrianglesetcount");
		lib3mf_meshobject_gettriangleset = mLibrary.getFunction("lib3mf_meshobject_gettriangleset");
		lib3mf_levelset_getfunction = mLibrary.getFunction("lib3mf_levelset_getfunction");
		lib3mf_levelset_setfunction = mLibrary.getFunction("lib3mf_levelset_setfunction");
		lib3mf_levelset_gettransform = mLibrary.getFunction("lib3mf_levelset_gettransform");
		lib3mf_levelset_settransform = mLibrary.getFunction("lib3mf_levelset_settransform");
		lib3mf_levelset_getchannelname = mLibrary.getFunction("lib3mf_levelset_getchannelname");
		lib3mf_levelset_setchannelname = mLibrary.getFunction("lib3mf_levelset_setchannelname");
		lib3mf_levelset_setminfeaturesize = mLibrary.getFunction("lib3mf_levelset_setminfeaturesize");
		lib3mf_levelset_getminfeaturesize = mLibrary.getFunction("lib3mf_levelset_getminfeaturesize");
		lib3mf_levelset_setfallbackvalue = mLibrary.getFunction("lib3mf_levelset_setfallbackvalue");
		lib3mf_levelset_getfallbackvalue = mLibrary.getFunction("lib3mf_levelset_getfallbackvalue");
		lib3mf_levelset_setmeshbboxonly = mLibrary.getFunction("lib3mf_levelset_setmeshbboxonly");
		lib3mf_levelset_getmeshbboxonly = mLibrary.getFunction("lib3mf_levelset_getmeshbboxonly");
		lib3mf_levelset_setmesh = mLibrary.getFunction("lib3mf_levelset_setmesh");
		lib3mf_levelset_getmesh = mLibrary.getFunction("lib3mf_levelset_getmesh");
		lib3mf_levelset_getvolumedata = mLibrary.getFunction("lib3mf_levelset_getvolumedata");
		lib3mf_levelset_setvolumedata = mLibrary.getFunction("lib3mf_levelset_setvolumedata");
		lib3mf_beamlattice_getminlength = mLibrary.getFunction("lib3mf_beamlattice_getminlength");
		lib3mf_beamlattice_setminlength = mLibrary.getFunction("lib3mf_beamlattice_setminlength");
		lib3mf_beamlattice_getclipping = mLibrary.getFunction("lib3mf_beamlattice_getclipping");
		lib3mf_beamlattice_setclipping = mLibrary.getFunction("lib3mf_beamlattice_setclipping");
		lib3mf_beamlattice_getrepresentation = mLibrary.getFunction("lib3mf_beamlattice_getrepresentation");
		lib3mf_beamlattice_setrepresentation = mLibrary.getFunction("lib3mf_beamlattice_setrepresentation");
		lib3mf_beamlattice_getballoptions = mLibrary.getFunction("lib3mf_beamlattice_getballoptions");
		lib3mf_beamlattice_setballoptions = mLibrary.getFunction("lib3mf_beamlattice_setballoptions");
		lib3mf_beamlattice_getbeamcount = mLibrary.getFunction("lib3mf_beamlattice_getbeamcount");
		lib3mf_beamlattice_getbeam = mLibrary.getFunction("lib3mf_beamlattice_getbeam");
		lib3mf_beamlattice_addbeam = mLibrary.getFunction("lib3mf_beamlattice_addbeam");
		lib3mf_beamlattice_setbeam = mLibrary.getFunction("lib3mf_beamlattice_setbeam");
		lib3mf_beamlattice_setbeams = mLibrary.getFunction("lib3mf_beamlattice_setbeams");
		lib3mf_beamlattice_getbeams = mLibrary.getFunction("lib3mf_beamlattice_getbeams");
		lib3mf_beamlattice_getballcount = mLibrary.getFunction("lib3mf_beamlattice_getballcount");
		lib3mf_beamlattice_getball = mLibrary.getFunction("lib3mf_beamlattice_getball");
		lib3mf_beamlattice_addball = mLibrary.getFunction("lib3mf_beamlattice_addball");
		lib3mf_beamlattice_setball = mLibrary.getFunction("lib3mf_beamlattice_setball");
		lib3mf_beamlattice_setballs = mLibrary.getFunction("lib3mf_beamlattice_setballs");
		lib3mf_beamlattice_getballs = mLibrary.getFunction("lib3mf_beamlattice_getballs");
		lib3mf_beamlattice_getbeamsetcount = mLibrary.getFunction("lib3mf_beamlattice_getbeamsetcount");
		lib3mf_beamlattice_addbeamset = mLibrary.getFunction("lib3mf_beamlattice_addbeamset");
		lib3mf_beamlattice_getbeamset = mLibrary.getFunction("lib3mf_beamlattice_getbeamset");
		lib3mf_functionreference_getfunctionresourceid = mLibrary.getFunction("lib3mf_functionreference_getfunctionresourceid");
		lib3mf_functionreference_setfunctionresourceid = mLibrary.getFunction("lib3mf_functionreference_setfunctionresourceid");
		lib3mf_functionreference_gettransform = mLibrary.getFunction("lib3mf_functionreference_gettransform");
		lib3mf_functionreference_settransform = mLibrary.getFunction("lib3mf_functionreference_settransform");
		lib3mf_functionreference_getchannelname = mLibrary.getFunction("lib3mf_functionreference_getchannelname");
		lib3mf_functionreference_setchannelname = mLibrary.getFunction("lib3mf_functionreference_setchannelname");
		lib3mf_functionreference_setminfeaturesize = mLibrary.getFunction("lib3mf_functionreference_setminfeaturesize");
		lib3mf_functionreference_getminfeaturesize = mLibrary.getFunction("lib3mf_functionreference_getminfeaturesize");
		lib3mf_functionreference_setfallbackvalue = mLibrary.getFunction("lib3mf_functionreference_setfallbackvalue");
		lib3mf_functionreference_getfallbackvalue = mLibrary.getFunction("lib3mf_functionreference_getfallbackvalue");
		lib3mf_volumedatacomposite_getbasematerialgroup = mLibrary.getFunction("lib3mf_volumedatacomposite_getbasematerialgroup");
		lib3mf_volumedatacomposite_setbasematerialgroup = mLibrary.getFunction("lib3mf_volumedatacomposite_setbasematerialgroup");
		lib3mf_volumedatacomposite_getmaterialmappingcount = mLibrary.getFunction("lib3mf_volumedatacomposite_getmaterialmappingcount");
		lib3mf_volumedatacomposite_getmaterialmapping = mLibrary.getFunction("lib3mf_volumedatacomposite_getmaterialmapping");
		lib3mf_volumedatacomposite_addmaterialmapping = mLibrary.getFunction("lib3mf_volumedatacomposite_addmaterialmapping");
		lib3mf_volumedatacomposite_removematerialmapping = mLibrary.getFunction("lib3mf_volumedatacomposite_removematerialmapping");
		lib3mf_volumedataproperty_getname = mLibrary.getFunction("lib3mf_volumedataproperty_getname");
		lib3mf_volumedataproperty_setisrequired = mLibrary.getFunction("lib3mf_volumedataproperty_setisrequired");
		lib3mf_volumedataproperty_isrequired = mLibrary.getFunction("lib3mf_volumedataproperty_isrequired");
		lib3mf_volumedata_getcomposite = mLibrary.getFunction("lib3mf_volumedata_getcomposite");
		lib3mf_volumedata_createnewcomposite = mLibrary.getFunction("lib3mf_volumedata_createnewcomposite");
		lib3mf_volumedata_removecomposite = mLibrary.getFunction("lib3mf_volumedata_removecomposite");
		lib3mf_volumedata_getcolor = mLibrary.getFunction("lib3mf_volumedata_getcolor");
		lib3mf_volumedata_createnewcolor = mLibrary.getFunction("lib3mf_volumedata_createnewcolor");
		lib3mf_volumedata_removecolor = mLibrary.getFunction("lib3mf_volumedata_removecolor");
		lib3mf_volumedata_getpropertycount = mLibrary.getFunction("lib3mf_volumedata_getpropertycount");
		lib3mf_volumedata_getproperty = mLibrary.getFunction("lib3mf_volumedata_getproperty");
		lib3mf_volumedata_addpropertyfromfunction = mLibrary.getFunction("lib3mf_volumedata_addpropertyfromfunction");
		lib3mf_volumedata_removeproperty = mLibrary.getFunction("lib3mf_volumedata_removeproperty");
		lib3mf_component_getobjectresource = mLibrary.getFunction("lib3mf_component_getobjectresource");
		lib3mf_component_getobjectresourceid = mLibrary.getFunction("lib3mf_component_getobjectresourceid");
		lib3mf_component_getuuid = mLibrary.getFunction("lib3mf_component_getuuid");
		lib3mf_component_setuuid = mLibrary.getFunction("lib3mf_component_setuuid");
		lib3mf_component_hastransform = mLibrary.getFunction("lib3mf_component_hastransform");
		lib3mf_component_gettransform = mLibrary.getFunction("lib3mf_component_gettransform");
		lib3mf_component_settransform = mLibrary.getFunction("lib3mf_component_settransform");
		lib3mf_componentsobject_addcomponent = mLibrary.getFunction("lib3mf_componentsobject_addcomponent");
		lib3mf_componentsobject_getcomponent = mLibrary.getFunction("lib3mf_componentsobject_getcomponent");
		lib3mf_componentsobject_getcomponentcount = mLibrary.getFunction("lib3mf_componentsobject_getcomponentcount");
		lib3mf_beamset_setname = mLibrary.getFunction("lib3mf_beamset_setname");
		lib3mf_beamset_getname = mLibrary.getFunction("lib3mf_beamset_getname");
		lib3mf_beamset_setidentifier = mLibrary.getFunction("lib3mf_beamset_setidentifier");
		lib3mf_beamset_getidentifier = mLibrary.getFunction("lib3mf_beamset_getidentifier");
		lib3mf_beamset_getreferencecount = mLibrary.getFunction("lib3mf_beamset_getreferencecount");
		lib3mf_beamset_setreferences = mLibrary.getFunction("lib3mf_beamset_setreferences");
		lib3mf_beamset_getreferences = mLibrary.getFunction("lib3mf_beamset_getreferences");
		lib3mf_beamset_getballreferencecount = mLibrary.getFunction("lib3mf_beamset_getballreferencecount");
		lib3mf_beamset_setballreferences = mLibrary.getFunction("lib3mf_beamset_setballreferences");
		lib3mf_beamset_getballreferences = mLibrary.getFunction("lib3mf_beamset_getballreferences");
		lib3mf_basematerialgroup_getcount = mLibrary.getFunction("lib3mf_basematerialgroup_getcount");
		lib3mf_basematerialgroup_getallpropertyids = mLibrary.getFunction("lib3mf_basematerialgroup_getallpropertyids");
		lib3mf_basematerialgroup_addmaterial = mLibrary.getFunction("lib3mf_basematerialgroup_addmaterial");
		lib3mf_basematerialgroup_removematerial = mLibrary.getFunction("lib3mf_basematerialgroup_removematerial");
		lib3mf_basematerialgroup_getname = mLibrary.getFunction("lib3mf_basematerialgroup_getname");
		lib3mf_basematerialgroup_setname = mLibrary.getFunction("lib3mf_basematerialgroup_setname");
		lib3mf_basematerialgroup_setdisplaycolor = mLibrary.getFunction("lib3mf_basematerialgroup_setdisplaycolor");
		lib3mf_basematerialgroup_getdisplaycolor = mLibrary.getFunction("lib3mf_basematerialgroup_getdisplaycolor");
		lib3mf_colorgroup_getcount = mLibrary.getFunction("lib3mf_colorgroup_getcount");
		lib3mf_colorgroup_getallpropertyids = mLibrary.getFunction("lib3mf_colorgroup_getallpropertyids");
		lib3mf_colorgroup_addcolor = mLibrary.getFunction("lib3mf_colorgroup_addcolor");
		lib3mf_colorgroup_removecolor = mLibrary.getFunction("lib3mf_colorgroup_removecolor");
		lib3mf_colorgroup_setcolor = mLibrary.getFunction("lib3mf_colorgroup_setcolor");
		lib3mf_colorgroup_getcolor = mLibrary.getFunction("lib3mf_colorgroup_getcolor");
		lib3mf_texture2dgroup_getcount = mLibrary.getFunction("lib3mf_texture2dgroup_getcount");
		lib3mf_texture2dgroup_getallpropertyids = mLibrary.getFunction("lib3mf_texture2dgroup_getallpropertyids");
		lib3mf_texture2dgroup_addtex2coord = mLibrary.getFunction("lib3mf_texture2dgroup_addtex2coord");
		lib3mf_texture2dgroup_gettex2coord = mLibrary.getFunction("lib3mf_texture2dgroup_gettex2coord");
		lib3mf_texture2dgroup_removetex2coord = mLibrary.getFunction("lib3mf_texture2dgroup_removetex2coord");
		lib3mf_texture2dgroup_gettexture2d = mLibrary.getFunction("lib3mf_texture2dgroup_gettexture2d");
		lib3mf_compositematerials_getcount = mLibrary.getFunction("lib3mf_compositematerials_getcount");
		lib3mf_compositematerials_getallpropertyids = mLibrary.getFunction("lib3mf_compositematerials_getallpropertyids");
		lib3mf_compositematerials_getbasematerialgroup = mLibrary.getFunction("lib3mf_compositematerials_getbasematerialgroup");
		lib3mf_compositematerials_addcomposite = mLibrary.getFunction("lib3mf_compositematerials_addcomposite");
		lib3mf_compositematerials_removecomposite = mLibrary.getFunction("lib3mf_compositematerials_removecomposite");
		lib3mf_compositematerials_getcomposite = mLibrary.getFunction("lib3mf_compositematerials_getcomposite");
		lib3mf_multipropertygroup_getcount = mLibrary.getFunction("lib3mf_multipropertygroup_getcount");
		lib3mf_multipropertygroup_getallpropertyids = mLibrary.getFunction("lib3mf_multipropertygroup_getallpropertyids");
		lib3mf_multipropertygroup_addmultiproperty = mLibrary.getFunction("lib3mf_multipropertygroup_addmultiproperty");
		lib3mf_multipropertygroup_setmultiproperty = mLibrary.getFunction("lib3mf_multipropertygroup_setmultiproperty");
		lib3mf_multipropertygroup_getmultiproperty = mLibrary.getFunction("lib3mf_multipropertygroup_getmultiproperty");
		lib3mf_multipropertygroup_removemultiproperty = mLibrary.getFunction("lib3mf_multipropertygroup_removemultiproperty");
		lib3mf_multipropertygroup_getlayercount = mLibrary.getFunction("lib3mf_multipropertygroup_getlayercount");
		lib3mf_multipropertygroup_addlayer = mLibrary.getFunction("lib3mf_multipropertygroup_addlayer");
		lib3mf_multipropertygroup_getlayer = mLibrary.getFunction("lib3mf_multipropertygroup_getlayer");
		lib3mf_multipropertygroup_removelayer = mLibrary.getFunction("lib3mf_multipropertygroup_removelayer");
		lib3mf_image3d_getname = mLibrary.getFunction("lib3mf_image3d_getname");
		lib3mf_image3d_setname = mLibrary.getFunction("lib3mf_image3d_setname");
		lib3mf_image3d_isimagestack = mLibrary.getFunction("lib3mf_image3d_isimagestack");
		lib3mf_imagestack_getrowcount = mLibrary.getFunction("lib3mf_imagestack_getrowcount");
		lib3mf_imagestack_setrowcount = mLibrary.getFunction("lib3mf_imagestack_setrowcount");
		lib3mf_imagestack_getcolumncount = mLibrary.getFunction("lib3mf_imagestack_getcolumncount");
		lib3mf_imagestack_setcolumncount = mLibrary.getFunction("lib3mf_imagestack_setcolumncount");
		lib3mf_imagestack_getsheetcount = mLibrary.getFunction("lib3mf_imagestack_getsheetcount");
		lib3mf_imagestack_getsheet = mLibrary.getFunction("lib3mf_imagestack_getsheet");
		lib3mf_imagestack_setsheet = mLibrary.getFunction("lib3mf_imagestack_setsheet");
		lib3mf_imagestack_createemptysheet = mLibrary.getFunction("lib3mf_imagestack_createemptysheet");
		lib3mf_imagestack_createsheetfrombuffer = mLibrary.getFunction("lib3mf_imagestack_createsheetfrombuffer");
		lib3mf_imagestack_createsheetfromfile = mLibrary.getFunction("lib3mf_imagestack_createsheetfromfile");
		lib3mf_attachment_getpath = mLibrary.getFunction("lib3mf_attachment_getpath");
		lib3mf_attachment_setpath = mLibrary.getFunction("lib3mf_attachment_setpath");
		lib3mf_attachment_packagepart = mLibrary.getFunction("lib3mf_attachment_packagepart");
		lib3mf_attachment_getrelationshiptype = mLibrary.getFunction("lib3mf_attachment_getrelationshiptype");
		lib3mf_attachment_setrelationshiptype = mLibrary.getFunction("lib3mf_attachment_setrelationshiptype");
		lib3mf_attachment_writetofile = mLibrary.getFunction("lib3mf_attachment_writetofile");
		lib3mf_attachment_readfromfile = mLibrary.getFunction("lib3mf_attachment_readfromfile");
		lib3mf_attachment_readfromcallback = mLibrary.getFunction("lib3mf_attachment_readfromcallback");
		lib3mf_attachment_getstreamsize = mLibrary.getFunction("lib3mf_attachment_getstreamsize");
		lib3mf_attachment_writetobuffer = mLibrary.getFunction("lib3mf_attachment_writetobuffer");
		lib3mf_attachment_readfrombuffer = mLibrary.getFunction("lib3mf_attachment_readfrombuffer");
		lib3mf_texture2d_getattachment = mLibrary.getFunction("lib3mf_texture2d_getattachment");
		lib3mf_texture2d_setattachment = mLibrary.getFunction("lib3mf_texture2d_setattachment");
		lib3mf_texture2d_getcontenttype = mLibrary.getFunction("lib3mf_texture2d_getcontenttype");
		lib3mf_texture2d_setcontenttype = mLibrary.getFunction("lib3mf_texture2d_setcontenttype");
		lib3mf_texture2d_gettilestyleuv = mLibrary.getFunction("lib3mf_texture2d_gettilestyleuv");
		lib3mf_texture2d_settilestyleuv = mLibrary.getFunction("lib3mf_texture2d_settilestyleuv");
		lib3mf_texture2d_getfilter = mLibrary.getFunction("lib3mf_texture2d_getfilter");
		lib3mf_texture2d_setfilter = mLibrary.getFunction("lib3mf_texture2d_setfilter");
		lib3mf_implicitport_getidentifier = mLibrary.getFunction("lib3mf_implicitport_getidentifier");
		lib3mf_implicitport_setidentifier = mLibrary.getFunction("lib3mf_implicitport_setidentifier");
		lib3mf_implicitport_getdisplayname = mLibrary.getFunction("lib3mf_implicitport_getdisplayname");
		lib3mf_implicitport_setdisplayname = mLibrary.getFunction("lib3mf_implicitport_setdisplayname");
		lib3mf_implicitport_settype = mLibrary.getFunction("lib3mf_implicitport_settype");
		lib3mf_implicitport_gettype = mLibrary.getFunction("lib3mf_implicitport_gettype");
		lib3mf_implicitport_getreference = mLibrary.getFunction("lib3mf_implicitport_getreference");
		lib3mf_implicitport_setreference = mLibrary.getFunction("lib3mf_implicitport_setreference");
		lib3mf_iterator_movenext = mLibrary.getFunction("lib3mf_iterator_movenext");
		lib3mf_iterator_moveprevious = mLibrary.getFunction("lib3mf_iterator_moveprevious");
		lib3mf_iterator_count = mLibrary.getFunction("lib3mf_iterator_count");
		lib3mf_implicitportiterator_getcurrent = mLibrary.getFunction("lib3mf_implicitportiterator_getcurrent");
		lib3mf_implicitnode_getidentifier = mLibrary.getFunction("lib3mf_implicitnode_getidentifier");
		lib3mf_implicitnode_setidentifier = mLibrary.getFunction("lib3mf_implicitnode_setidentifier");
		lib3mf_implicitnode_getdisplayname = mLibrary.getFunction("lib3mf_implicitnode_getdisplayname");
		lib3mf_implicitnode_setdisplayname = mLibrary.getFunction("lib3mf_implicitnode_setdisplayname");
		lib3mf_implicitnode_gettag = mLibrary.getFunction("lib3mf_implicitnode_gettag");
		lib3mf_implicitnode_settag = mLibrary.getFunction("lib3mf_implicitnode_settag");
		lib3mf_implicitnode_getnodetype = mLibrary.getFunction("lib3mf_implicitnode_getnodetype");
		lib3mf_implicitnode_addinput = mLibrary.getFunction("lib3mf_implicitnode_addinput");
		lib3mf_implicitnode_getinputs = mLibrary.getFunction("lib3mf_implicitnode_getinputs");
		lib3mf_implicitnode_addoutput = mLibrary.getFunction("lib3mf_implicitnode_addoutput");
		lib3mf_implicitnode_getoutputs = mLibrary.getFunction("lib3mf_implicitnode_getoutputs");
		lib3mf_implicitnode_findinput = mLibrary.getFunction("lib3mf_implicitnode_findinput");
		lib3mf_implicitnode_findoutput = mLibrary.getFunction("lib3mf_implicitnode_findoutput");
		lib3mf_implicitnode_aretypesvalid = mLibrary.getFunction("lib3mf_implicitnode_aretypesvalid");
		lib3mf_oneinputnode_getinputa = mLibrary.getFunction("lib3mf_oneinputnode_getinputa");
		lib3mf_oneinputnode_getoutputresult = mLibrary.getFunction("lib3mf_oneinputnode_getoutputresult");
		lib3mf_resourceidnode_setresource = mLibrary.getFunction("lib3mf_resourceidnode_setresource");
		lib3mf_resourceidnode_getresource = mLibrary.getFunction("lib3mf_resourceidnode_getresource");
		lib3mf_resourceidnode_getoutputvalue = mLibrary.getFunction("lib3mf_resourceidnode_getoutputvalue");
		lib3mf_twoinputnode_getinputb = mLibrary.getFunction("lib3mf_twoinputnode_getinputb");
		lib3mf_selectnode_getinputb = mLibrary.getFunction("lib3mf_selectnode_getinputb");
		lib3mf_selectnode_getinputc = mLibrary.getFunction("lib3mf_selectnode_getinputc");
		lib3mf_selectnode_getinputd = mLibrary.getFunction("lib3mf_selectnode_getinputd");
		lib3mf_clampnode_getinputmin = mLibrary.getFunction("lib3mf_clampnode_getinputmin");
		lib3mf_clampnode_getinputmax = mLibrary.getFunction("lib3mf_clampnode_getinputmax");
		lib3mf_composevectornode_getinputx = mLibrary.getFunction("lib3mf_composevectornode_getinputx");
		lib3mf_composevectornode_getinputy = mLibrary.getFunction("lib3mf_composevectornode_getinputy");
		lib3mf_composevectornode_getinputz = mLibrary.getFunction("lib3mf_composevectornode_getinputz");
		lib3mf_composevectornode_getoutputresult = mLibrary.getFunction("lib3mf_composevectornode_getoutputresult");
		lib3mf_decomposevectornode_getinputa = mLibrary.getFunction("lib3mf_decomposevectornode_getinputa");
		lib3mf_decomposevectornode_getoutputx = mLibrary.getFunction("lib3mf_decomposevectornode_getoutputx");
		lib3mf_decomposevectornode_getoutputy = mLibrary.getFunction("lib3mf_decomposevectornode_getoutputy");
		lib3mf_decomposevectornode_getoutputz = mLibrary.getFunction("lib3mf_decomposevectornode_getoutputz");
		lib3mf_composematrixnode_getinputm00 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm00");
		lib3mf_composematrixnode_getinputm01 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm01");
		lib3mf_composematrixnode_getinputm02 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm02");
		lib3mf_composematrixnode_getinputm03 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm03");
		lib3mf_composematrixnode_getinputm10 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm10");
		lib3mf_composematrixnode_getinputm11 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm11");
		lib3mf_composematrixnode_getinputm12 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm12");
		lib3mf_composematrixnode_getinputm13 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm13");
		lib3mf_composematrixnode_getinputm20 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm20");
		lib3mf_composematrixnode_getinputm21 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm21");
		lib3mf_composematrixnode_getinputm22 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm22");
		lib3mf_composematrixnode_getinputm23 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm23");
		lib3mf_composematrixnode_getinputm30 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm30");
		lib3mf_composematrixnode_getinputm31 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm31");
		lib3mf_composematrixnode_getinputm32 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm32");
		lib3mf_composematrixnode_getinputm33 = mLibrary.getFunction("lib3mf_composematrixnode_getinputm33");
		lib3mf_composematrixnode_getoutputresult = mLibrary.getFunction("lib3mf_composematrixnode_getoutputresult");
		lib3mf_matrixfromrowsnode_getinputa = mLibrary.getFunction("lib3mf_matrixfromrowsnode_getinputa");
		lib3mf_matrixfromrowsnode_getinputb = mLibrary.getFunction("lib3mf_matrixfromrowsnode_getinputb");
		lib3mf_matrixfromrowsnode_getinputc = mLibrary.getFunction("lib3mf_matrixfromrowsnode_getinputc");
		lib3mf_matrixfromrowsnode_getinputd = mLibrary.getFunction("lib3mf_matrixfromrowsnode_getinputd");
		lib3mf_matrixfromrowsnode_getoutputresult = mLibrary.getFunction("lib3mf_matrixfromrowsnode_getoutputresult");
		lib3mf_matrixfromcolumnsnode_getinputa = mLibrary.getFunction("lib3mf_matrixfromcolumnsnode_getinputa");
		lib3mf_matrixfromcolumnsnode_getinputb = mLibrary.getFunction("lib3mf_matrixfromcolumnsnode_getinputb");
		lib3mf_matrixfromcolumnsnode_getinputc = mLibrary.getFunction("lib3mf_matrixfromcolumnsnode_getinputc");
		lib3mf_matrixfromcolumnsnode_getinputd = mLibrary.getFunction("lib3mf_matrixfromcolumnsnode_getinputd");
		lib3mf_matrixfromcolumnsnode_getoutputresult = mLibrary.getFunction("lib3mf_matrixfromcolumnsnode_getoutputresult");
		lib3mf_constantnode_setconstant = mLibrary.getFunction("lib3mf_constantnode_setconstant");
		lib3mf_constantnode_getconstant = mLibrary.getFunction("lib3mf_constantnode_getconstant");
		lib3mf_constantnode_getoutputvalue = mLibrary.getFunction("lib3mf_constantnode_getoutputvalue");
		lib3mf_constvecnode_setvector = mLibrary.getFunction("lib3mf_constvecnode_setvector");
		lib3mf_constvecnode_getvector = mLibrary.getFunction("lib3mf_constvecnode_getvector");
		lib3mf_constvecnode_getoutputvector = mLibrary.getFunction("lib3mf_constvecnode_getoutputvector");
		lib3mf_constmatnode_setmatrix = mLibrary.getFunction("lib3mf_constmatnode_setmatrix");
		lib3mf_constmatnode_getmatrix = mLibrary.getFunction("lib3mf_constmatnode_getmatrix");
		lib3mf_constmatnode_getoutputmatrix = mLibrary.getFunction("lib3mf_constmatnode_getoutputmatrix");
		lib3mf_meshnode_getinputmesh = mLibrary.getFunction("lib3mf_meshnode_getinputmesh");
		lib3mf_meshnode_getinputpos = mLibrary.getFunction("lib3mf_meshnode_getinputpos");
		lib3mf_meshnode_getoutputdistance = mLibrary.getFunction("lib3mf_meshnode_getoutputdistance");
		lib3mf_unsignedmeshnode_getinputmesh = mLibrary.getFunction("lib3mf_unsignedmeshnode_getinputmesh");
		lib3mf_unsignedmeshnode_getinputpos = mLibrary.getFunction("lib3mf_unsignedmeshnode_getinputpos");
		lib3mf_unsignedmeshnode_getoutputdistance = mLibrary.getFunction("lib3mf_unsignedmeshnode_getoutputdistance");
		lib3mf_beamlatticenode_getinputbeamlattice = mLibrary.getFunction("lib3mf_beamlatticenode_getinputbeamlattice");
		lib3mf_beamlatticenode_getinputpos = mLibrary.getFunction("lib3mf_beamlatticenode_getinputpos");
		lib3mf_beamlatticenode_getoutputdistance = mLibrary.getFunction("lib3mf_beamlatticenode_getoutputdistance");
		lib3mf_beamlatticenode_setaccuraterange = mLibrary.getFunction("lib3mf_beamlatticenode_setaccuraterange");
		lib3mf_beamlatticenode_getaccuraterange = mLibrary.getFunction("lib3mf_beamlatticenode_getaccuraterange");
		lib3mf_functiongradientnode_getinputfunctionid = mLibrary.getFunction("lib3mf_functiongradientnode_getinputfunctionid");
		lib3mf_functiongradientnode_getinputpos = mLibrary.getFunction("lib3mf_functiongradientnode_getinputpos");
		lib3mf_functiongradientnode_getinputstep = mLibrary.getFunction("lib3mf_functiongradientnode_getinputstep");
		lib3mf_functiongradientnode_setscalaroutputname = mLibrary.getFunction("lib3mf_functiongradientnode_setscalaroutputname");
		lib3mf_functiongradientnode_getscalaroutputname = mLibrary.getFunction("lib3mf_functiongradientnode_getscalaroutputname");
		lib3mf_functiongradientnode_setvectorinputname = mLibrary.getFunction("lib3mf_functiongradientnode_setvectorinputname");
		lib3mf_functiongradientnode_getvectorinputname = mLibrary.getFunction("lib3mf_functiongradientnode_getvectorinputname");
		lib3mf_functiongradientnode_getoutputnormalizedgradient = mLibrary.getFunction("lib3mf_functiongradientnode_getoutputnormalizedgradient");
		lib3mf_functiongradientnode_getoutputgradient = mLibrary.getFunction("lib3mf_functiongradientnode_getoutputgradient");
		lib3mf_functiongradientnode_getoutputmagnitude = mLibrary.getFunction("lib3mf_functiongradientnode_getoutputmagnitude");
		lib3mf_normalizedistancenode_getinputfunctionid = mLibrary.getFunction("lib3mf_normalizedistancenode_getinputfunctionid");
		lib3mf_normalizedistancenode_getinputpos = mLibrary.getFunction("lib3mf_normalizedistancenode_getinputpos");
		lib3mf_normalizedistancenode_getinputstep = mLibrary.getFunction("lib3mf_normalizedistancenode_getinputstep");
		lib3mf_normalizedistancenode_setscalaroutputname = mLibrary.getFunction("lib3mf_normalizedistancenode_setscalaroutputname");
		lib3mf_normalizedistancenode_getscalaroutputname = mLibrary.getFunction("lib3mf_normalizedistancenode_getscalaroutputname");
		lib3mf_normalizedistancenode_setvectorinputname = mLibrary.getFunction("lib3mf_normalizedistancenode_setvectorinputname");
		lib3mf_normalizedistancenode_getvectorinputname = mLibrary.getFunction("lib3mf_normalizedistancenode_getvectorinputname");
		lib3mf_normalizedistancenode_getoutputresult = mLibrary.getFunction("lib3mf_normalizedistancenode_getoutputresult");
		lib3mf_functioncallnode_getinputfunctionid = mLibrary.getFunction("lib3mf_functioncallnode_getinputfunctionid");
		lib3mf_nodeiterator_getcurrent = mLibrary.getFunction("lib3mf_nodeiterator_getcurrent");
		lib3mf_function_getdisplayname = mLibrary.getFunction("lib3mf_function_getdisplayname");
		lib3mf_function_setdisplayname = mLibrary.getFunction("lib3mf_function_setdisplayname");
		lib3mf_function_addinput = mLibrary.getFunction("lib3mf_function_addinput");
		lib3mf_function_getinputs = mLibrary.getFunction("lib3mf_function_getinputs");
		lib3mf_function_removeinput = mLibrary.getFunction("lib3mf_function_removeinput");
		lib3mf_function_addoutput = mLibrary.getFunction("lib3mf_function_addoutput");
		lib3mf_function_getoutputs = mLibrary.getFunction("lib3mf_function_getoutputs");
		lib3mf_function_removeoutput = mLibrary.getFunction("lib3mf_function_removeoutput");
		lib3mf_function_findinput = mLibrary.getFunction("lib3mf_function_findinput");
		lib3mf_function_findoutput = mLibrary.getFunction("lib3mf_function_findoutput");
		lib3mf_implicitfunction_getidentifier = mLibrary.getFunction("lib3mf_implicitfunction_getidentifier");
		lib3mf_implicitfunction_setidentifier = mLibrary.getFunction("lib3mf_implicitfunction_setidentifier");
		lib3mf_implicitfunction_addnode = mLibrary.getFunction("lib3mf_implicitfunction_addnode");
		lib3mf_implicitfunction_addsinnode = mLibrary.getFunction("lib3mf_implicitfunction_addsinnode");
		lib3mf_implicitfunction_addcosnode = mLibrary.getFunction("lib3mf_implicitfunction_addcosnode");
		lib3mf_implicitfunction_addtannode = mLibrary.getFunction("lib3mf_implicitfunction_addtannode");
		lib3mf_implicitfunction_addarcsinnode = mLibrary.getFunction("lib3mf_implicitfunction_addarcsinnode");
		lib3mf_implicitfunction_addarccosnode = mLibrary.getFunction("lib3mf_implicitfunction_addarccosnode");
		lib3mf_implicitfunction_addarctan2node = mLibrary.getFunction("lib3mf_implicitfunction_addarctan2node");
		lib3mf_implicitfunction_addsinhnode = mLibrary.getFunction("lib3mf_implicitfunction_addsinhnode");
		lib3mf_implicitfunction_addcoshnode = mLibrary.getFunction("lib3mf_implicitfunction_addcoshnode");
		lib3mf_implicitfunction_addtanhnode = mLibrary.getFunction("lib3mf_implicitfunction_addtanhnode");
		lib3mf_implicitfunction_addroundnode = mLibrary.getFunction("lib3mf_implicitfunction_addroundnode");
		lib3mf_implicitfunction_addceilnode = mLibrary.getFunction("lib3mf_implicitfunction_addceilnode");
		lib3mf_implicitfunction_addfloornode = mLibrary.getFunction("lib3mf_implicitfunction_addfloornode");
		lib3mf_implicitfunction_addsignnode = mLibrary.getFunction("lib3mf_implicitfunction_addsignnode");
		lib3mf_implicitfunction_addfractnode = mLibrary.getFunction("lib3mf_implicitfunction_addfractnode");
		lib3mf_implicitfunction_addabsnode = mLibrary.getFunction("lib3mf_implicitfunction_addabsnode");
		lib3mf_implicitfunction_addexpnode = mLibrary.getFunction("lib3mf_implicitfunction_addexpnode");
		lib3mf_implicitfunction_addlognode = mLibrary.getFunction("lib3mf_implicitfunction_addlognode");
		lib3mf_implicitfunction_addlog2node = mLibrary.getFunction("lib3mf_implicitfunction_addlog2node");
		lib3mf_implicitfunction_addlog10node = mLibrary.getFunction("lib3mf_implicitfunction_addlog10node");
		lib3mf_implicitfunction_addlengthnode = mLibrary.getFunction("lib3mf_implicitfunction_addlengthnode");
		lib3mf_implicitfunction_addtransposenode = mLibrary.getFunction("lib3mf_implicitfunction_addtransposenode");
		lib3mf_implicitfunction_addinversenode = mLibrary.getFunction("lib3mf_implicitfunction_addinversenode");
		lib3mf_implicitfunction_addsqrtnode = mLibrary.getFunction("lib3mf_implicitfunction_addsqrtnode");
		lib3mf_implicitfunction_addresourceidnode = mLibrary.getFunction("lib3mf_implicitfunction_addresourceidnode");
		lib3mf_implicitfunction_addadditionnode = mLibrary.getFunction("lib3mf_implicitfunction_addadditionnode");
		lib3mf_implicitfunction_addsubtractionnode = mLibrary.getFunction("lib3mf_implicitfunction_addsubtractionnode");
		lib3mf_implicitfunction_addmultiplicationnode = mLibrary.getFunction("lib3mf_implicitfunction_addmultiplicationnode");
		lib3mf_implicitfunction_adddivisionnode = mLibrary.getFunction("lib3mf_implicitfunction_adddivisionnode");
		lib3mf_implicitfunction_adddotnode = mLibrary.getFunction("lib3mf_implicitfunction_adddotnode");
		lib3mf_implicitfunction_addcrossnode = mLibrary.getFunction("lib3mf_implicitfunction_addcrossnode");
		lib3mf_implicitfunction_addmatvecmultiplicationnode = mLibrary.getFunction("lib3mf_implicitfunction_addmatvecmultiplicationnode");
		lib3mf_implicitfunction_addminnode = mLibrary.getFunction("lib3mf_implicitfunction_addminnode");
		lib3mf_implicitfunction_addmaxnode = mLibrary.getFunction("lib3mf_implicitfunction_addmaxnode");
		lib3mf_implicitfunction_addfmodnode = mLibrary.getFunction("lib3mf_implicitfunction_addfmodnode");
		lib3mf_implicitfunction_addpownode = mLibrary.getFunction("lib3mf_implicitfunction_addpownode");
		lib3mf_implicitfunction_addselectnode = mLibrary.getFunction("lib3mf_implicitfunction_addselectnode");
		lib3mf_implicitfunction_addclampnode = mLibrary.getFunction("lib3mf_implicitfunction_addclampnode");
		lib3mf_implicitfunction_addcomposevectornode = mLibrary.getFunction("lib3mf_implicitfunction_addcomposevectornode");
		lib3mf_implicitfunction_addvectorfromscalarnode = mLibrary.getFunction("lib3mf_implicitfunction_addvectorfromscalarnode");
		lib3mf_implicitfunction_adddecomposevectornode = mLibrary.getFunction("lib3mf_implicitfunction_adddecomposevectornode");
		lib3mf_implicitfunction_addcomposematrixnode = mLibrary.getFunction("lib3mf_implicitfunction_addcomposematrixnode");
		lib3mf_implicitfunction_addmatrixfromrowsnode = mLibrary.getFunction("lib3mf_implicitfunction_addmatrixfromrowsnode");
		lib3mf_implicitfunction_addmatrixfromcolumnsnode = mLibrary.getFunction("lib3mf_implicitfunction_addmatrixfromcolumnsnode");
		lib3mf_implicitfunction_addconstantnode = mLibrary.getFunction("lib3mf_implicitfunction_addconstantnode");
		lib3mf_implicitfunction_addconstvecnode = mLibrary.getFunction("lib3mf_implicitfunction_addconstvecnode");
		lib3mf_implicitfunction_addconstmatnode = mLibrary.getFunction("lib3mf_implicitfunction_addconstmatnode");
		lib3mf_implicitfunction_addmeshnode = mLibrary.getFunction("lib3mf_implicitfunction_addmeshnode");
		lib3mf_implicitfunction_addunsignedmeshnode = mLibrary.getFunction("lib3mf_implicitfunction_addunsignedmeshnode");
		lib3mf_implicitfunction_addbeamlatticenode = mLibrary.getFunction("lib3mf_implicitfunction_addbeamlatticenode");
		lib3mf_implicitfunction_addfunctiongradientnode = mLibrary.getFunction("lib3mf_implicitfunction_addfunctiongradientnode");
		lib3mf_implicitfunction_addnormalizedistancenode = mLibrary.getFunction("lib3mf_implicitfunction_addnormalizedistancenode");
		lib3mf_implicitfunction_addfunctioncallnode = mLibrary.getFunction("lib3mf_implicitfunction_addfunctioncallnode");
		lib3mf_implicitfunction_getnodes = mLibrary.getFunction("lib3mf_implicitfunction_getnodes");
		lib3mf_implicitfunction_removenode = mLibrary.getFunction("lib3mf_implicitfunction_removenode");
		lib3mf_implicitfunction_addlink = mLibrary.getFunction("lib3mf_implicitfunction_addlink");
		lib3mf_implicitfunction_addlinkbynames = mLibrary.getFunction("lib3mf_implicitfunction_addlinkbynames");
		lib3mf_implicitfunction_clear = mLibrary.getFunction("lib3mf_implicitfunction_clear");
		lib3mf_implicitfunction_sortnodestopologically = mLibrary.getFunction("lib3mf_implicitfunction_sortnodestopologically");
		lib3mf_functionfromimage3d_getimage3d = mLibrary.getFunction("lib3mf_functionfromimage3d_getimage3d");
		lib3mf_functionfromimage3d_setimage3d = mLibrary.getFunction("lib3mf_functionfromimage3d_setimage3d");
		lib3mf_functionfromimage3d_setfilter = mLibrary.getFunction("lib3mf_functionfromimage3d_setfilter");
		lib3mf_functionfromimage3d_getfilter = mLibrary.getFunction("lib3mf_functionfromimage3d_getfilter");
		lib3mf_functionfromimage3d_settilestyles = mLibrary.getFunction("lib3mf_functionfromimage3d_settilestyles");
		lib3mf_functionfromimage3d_gettilestyles = mLibrary.getFunction("lib3mf_functionfromimage3d_gettilestyles");
		lib3mf_functionfromimage3d_getoffset = mLibrary.getFunction("lib3mf_functionfromimage3d_getoffset");
		lib3mf_functionfromimage3d_setoffset = mLibrary.getFunction("lib3mf_functionfromimage3d_setoffset");
		lib3mf_functionfromimage3d_getscale = mLibrary.getFunction("lib3mf_functionfromimage3d_getscale");
		lib3mf_functionfromimage3d_setscale = mLibrary.getFunction("lib3mf_functionfromimage3d_setscale");
		lib3mf_builditem_getobjectresource = mLibrary.getFunction("lib3mf_builditem_getobjectresource");
		lib3mf_builditem_getuuid = mLibrary.getFunction("lib3mf_builditem_getuuid");
		lib3mf_builditem_setuuid = mLibrary.getFunction("lib3mf_builditem_setuuid");
		lib3mf_builditem_getobjectresourceid = mLibrary.getFunction("lib3mf_builditem_getobjectresourceid");
		lib3mf_builditem_hasobjecttransform = mLibrary.getFunction("lib3mf_builditem_hasobjecttransform");
		lib3mf_builditem_getobjecttransform = mLibrary.getFunction("lib3mf_builditem_getobjecttransform");
		lib3mf_builditem_setobjecttransform = mLibrary.getFunction("lib3mf_builditem_setobjecttransform");
		lib3mf_builditem_getpartnumber = mLibrary.getFunction("lib3mf_builditem_getpartnumber");
		lib3mf_builditem_setpartnumber = mLibrary.getFunction("lib3mf_builditem_setpartnumber");
		lib3mf_builditem_getmetadatagroup = mLibrary.getFunction("lib3mf_builditem_getmetadatagroup");
		lib3mf_builditem_getoutbox = mLibrary.getFunction("lib3mf_builditem_getoutbox");
		lib3mf_builditemiterator_movenext = mLibrary.getFunction("lib3mf_builditemiterator_movenext");
		lib3mf_builditemiterator_moveprevious = mLibrary.getFunction("lib3mf_builditemiterator_moveprevious");
		lib3mf_builditemiterator_getcurrent = mLibrary.getFunction("lib3mf_builditemiterator_getcurrent");
		lib3mf_builditemiterator_clone = mLibrary.getFunction("lib3mf_builditemiterator_clone");
		lib3mf_builditemiterator_count = mLibrary.getFunction("lib3mf_builditemiterator_count");
		lib3mf_slice_setvertices = mLibrary.getFunction("lib3mf_slice_setvertices");
		lib3mf_slice_getvertices = mLibrary.getFunction("lib3mf_slice_getvertices");
		lib3mf_slice_getvertexcount = mLibrary.getFunction("lib3mf_slice_getvertexcount");
		lib3mf_slice_addpolygon = mLibrary.getFunction("lib3mf_slice_addpolygon");
		lib3mf_slice_getpolygoncount = mLibrary.getFunction("lib3mf_slice_getpolygoncount");
		lib3mf_slice_setpolygonindices = mLibrary.getFunction("lib3mf_slice_setpolygonindices");
		lib3mf_slice_getpolygonindices = mLibrary.getFunction("lib3mf_slice_getpolygonindices");
		lib3mf_slice_getpolygonindexcount = mLibrary.getFunction("lib3mf_slice_getpolygonindexcount");
		lib3mf_slice_getztop = mLibrary.getFunction("lib3mf_slice_getztop");
		lib3mf_slicestack_getbottomz = mLibrary.getFunction("lib3mf_slicestack_getbottomz");
		lib3mf_slicestack_getslicecount = mLibrary.getFunction("lib3mf_slicestack_getslicecount");
		lib3mf_slicestack_getslice = mLibrary.getFunction("lib3mf_slicestack_getslice");
		lib3mf_slicestack_addslice = mLibrary.getFunction("lib3mf_slicestack_addslice");
		lib3mf_slicestack_getslicerefcount = mLibrary.getFunction("lib3mf_slicestack_getslicerefcount");
		lib3mf_slicestack_addslicestackreference = mLibrary.getFunction("lib3mf_slicestack_addslicestackreference");
		lib3mf_slicestack_getslicestackreference = mLibrary.getFunction("lib3mf_slicestack_getslicestackreference");
		lib3mf_slicestack_collapseslicereferences = mLibrary.getFunction("lib3mf_slicestack_collapseslicereferences");
		lib3mf_slicestack_setownpath = mLibrary.getFunction("lib3mf_slicestack_setownpath");
		lib3mf_slicestack_getownpath = mLibrary.getFunction("lib3mf_slicestack_getownpath");
		lib3mf_consumer_getconsumerid = mLibrary.getFunction("lib3mf_consumer_getconsumerid");
		lib3mf_consumer_getkeyid = mLibrary.getFunction("lib3mf_consumer_getkeyid");
		lib3mf_consumer_getkeyvalue = mLibrary.getFunction("lib3mf_consumer_getkeyvalue");
		lib3mf_accessright_getconsumer = mLibrary.getFunction("lib3mf_accessright_getconsumer");
		lib3mf_accessright_getwrappingalgorithm = mLibrary.getFunction("lib3mf_accessright_getwrappingalgorithm");
		lib3mf_accessright_getmgfalgorithm = mLibrary.getFunction("lib3mf_accessright_getmgfalgorithm");
		lib3mf_accessright_getdigestmethod = mLibrary.getFunction("lib3mf_accessright_getdigestmethod");
		lib3mf_contentencryptionparams_getencryptionalgorithm = mLibrary.getFunction("lib3mf_contentencryptionparams_getencryptionalgorithm");
		lib3mf_contentencryptionparams_getkey = mLibrary.getFunction("lib3mf_contentencryptionparams_getkey");
		lib3mf_contentencryptionparams_getinitializationvector = mLibrary.getFunction("lib3mf_contentencryptionparams_getinitializationvector");
		lib3mf_contentencryptionparams_getauthenticationtag = mLibrary.getFunction("lib3mf_contentencryptionparams_getauthenticationtag");
		lib3mf_contentencryptionparams_setauthenticationtag = mLibrary.getFunction("lib3mf_contentencryptionparams_setauthenticationtag");
		lib3mf_contentencryptionparams_getadditionalauthenticationdata = mLibrary.getFunction("lib3mf_contentencryptionparams_getadditionalauthenticationdata");
		lib3mf_contentencryptionparams_getdescriptor = mLibrary.getFunction("lib3mf_contentencryptionparams_getdescriptor");
		lib3mf_contentencryptionparams_getkeyuuid = mLibrary.getFunction("lib3mf_contentencryptionparams_getkeyuuid");
		lib3mf_resourcedata_getpath = mLibrary.getFunction("lib3mf_resourcedata_getpath");
		lib3mf_resourcedata_getencryptionalgorithm = mLibrary.getFunction("lib3mf_resourcedata_getencryptionalgorithm");
		lib3mf_resourcedata_getcompression = mLibrary.getFunction("lib3mf_resourcedata_getcompression");
		lib3mf_resourcedata_getadditionalauthenticationdata = mLibrary.getFunction("lib3mf_resourcedata_getadditionalauthenticationdata");
		lib3mf_resourcedatagroup_getkeyuuid = mLibrary.getFunction("lib3mf_resourcedatagroup_getkeyuuid");
		lib3mf_resourcedatagroup_addaccessright = mLibrary.getFunction("lib3mf_resourcedatagroup_addaccessright");
		lib3mf_resourcedatagroup_findaccessrightbyconsumer = mLibrary.getFunction("lib3mf_resourcedatagroup_findaccessrightbyconsumer");
		lib3mf_resourcedatagroup_removeaccessright = mLibrary.getFunction("lib3mf_resourcedatagroup_removeaccessright");
		lib3mf_keystore_addconsumer = mLibrary.getFunction("lib3mf_keystore_addconsumer");
		lib3mf_keystore_getconsumercount = mLibrary.getFunction("lib3mf_keystore_getconsumercount");
		lib3mf_keystore_getconsumer = mLibrary.getFunction("lib3mf_keystore_getconsumer");
		lib3mf_keystore_removeconsumer = mLibrary.getFunction("lib3mf_keystore_removeconsumer");
		lib3mf_keystore_findconsumer = mLibrary.getFunction("lib3mf_keystore_findconsumer");
		lib3mf_keystore_getresourcedatagroupcount = mLibrary.getFunction("lib3mf_keystore_getresourcedatagroupcount");
		lib3mf_keystore_addresourcedatagroup = mLibrary.getFunction("lib3mf_keystore_addresourcedatagroup");
		lib3mf_keystore_getresourcedatagroup = mLibrary.getFunction("lib3mf_keystore_getresourcedatagroup");
		lib3mf_keystore_removeresourcedatagroup = mLibrary.getFunction("lib3mf_keystore_removeresourcedatagroup");
		lib3mf_keystore_findresourcedatagroup = mLibrary.getFunction("lib3mf_keystore_findresourcedatagroup");
		lib3mf_keystore_addresourcedata = mLibrary.getFunction("lib3mf_keystore_addresourcedata");
		lib3mf_keystore_removeresourcedata = mLibrary.getFunction("lib3mf_keystore_removeresourcedata");
		lib3mf_keystore_findresourcedata = mLibrary.getFunction("lib3mf_keystore_findresourcedata");
		lib3mf_keystore_getresourcedatacount = mLibrary.getFunction("lib3mf_keystore_getresourcedatacount");
		lib3mf_keystore_getresourcedata = mLibrary.getFunction("lib3mf_keystore_getresourcedata");
		lib3mf_keystore_getuuid = mLibrary.getFunction("lib3mf_keystore_getuuid");
		lib3mf_keystore_setuuid = mLibrary.getFunction("lib3mf_keystore_setuuid");
		lib3mf_model_rootmodelpart = mLibrary.getFunction("lib3mf_model_rootmodelpart");
		lib3mf_model_findorcreatepackagepart = mLibrary.getFunction("lib3mf_model_findorcreatepackagepart");
		lib3mf_model_setunit = mLibrary.getFunction("lib3mf_model_setunit");
		lib3mf_model_getunit = mLibrary.getFunction("lib3mf_model_getunit");
		lib3mf_model_getlanguage = mLibrary.getFunction("lib3mf_model_getlanguage");
		lib3mf_model_setlanguage = mLibrary.getFunction("lib3mf_model_setlanguage");
		lib3mf_model_querywriter = mLibrary.getFunction("lib3mf_model_querywriter");
		lib3mf_model_queryreader = mLibrary.getFunction("lib3mf_model_queryreader");
		lib3mf_model_getresourcebyid = mLibrary.getFunction("lib3mf_model_getresourcebyid");
		lib3mf_model_gettexture2dbyid = mLibrary.getFunction("lib3mf_model_gettexture2dbyid");
		lib3mf_model_getpropertytypebyid = mLibrary.getFunction("lib3mf_model_getpropertytypebyid");
		lib3mf_model_getbasematerialgroupbyid = mLibrary.getFunction("lib3mf_model_getbasematerialgroupbyid");
		lib3mf_model_gettexture2dgroupbyid = mLibrary.getFunction("lib3mf_model_gettexture2dgroupbyid");
		lib3mf_model_getcompositematerialsbyid = mLibrary.getFunction("lib3mf_model_getcompositematerialsbyid");
		lib3mf_model_getmultipropertygroupbyid = mLibrary.getFunction("lib3mf_model_getmultipropertygroupbyid");
		lib3mf_model_getmeshobjectbyid = mLibrary.getFunction("lib3mf_model_getmeshobjectbyid");
		lib3mf_model_getcomponentsobjectbyid = mLibrary.getFunction("lib3mf_model_getcomponentsobjectbyid");
		lib3mf_model_getcolorgroupbyid = mLibrary.getFunction("lib3mf_model_getcolorgroupbyid");
		lib3mf_model_getslicestackbyid = mLibrary.getFunction("lib3mf_model_getslicestackbyid");
		lib3mf_model_getlevelsetbyid = mLibrary.getFunction("lib3mf_model_getlevelsetbyid");
		lib3mf_model_getbuilduuid = mLibrary.getFunction("lib3mf_model_getbuilduuid");
		lib3mf_model_setbuilduuid = mLibrary.getFunction("lib3mf_model_setbuilduuid");
		lib3mf_model_getbuilditems = mLibrary.getFunction("lib3mf_model_getbuilditems");
		lib3mf_model_getoutbox = mLibrary.getFunction("lib3mf_model_getoutbox");
		lib3mf_model_getresources = mLibrary.getFunction("lib3mf_model_getresources");
		lib3mf_model_getobjects = mLibrary.getFunction("lib3mf_model_getobjects");
		lib3mf_model_getmeshobjects = mLibrary.getFunction("lib3mf_model_getmeshobjects");
		lib3mf_model_getcomponentsobjects = mLibrary.getFunction("lib3mf_model_getcomponentsobjects");
		lib3mf_model_gettexture2ds = mLibrary.getFunction("lib3mf_model_gettexture2ds");
		lib3mf_model_getbasematerialgroups = mLibrary.getFunction("lib3mf_model_getbasematerialgroups");
		lib3mf_model_getcolorgroups = mLibrary.getFunction("lib3mf_model_getcolorgroups");
		lib3mf_model_gettexture2dgroups = mLibrary.getFunction("lib3mf_model_gettexture2dgroups");
		lib3mf_model_getcompositematerials = mLibrary.getFunction("lib3mf_model_getcompositematerials");
		lib3mf_model_getmultipropertygroups = mLibrary.getFunction("lib3mf_model_getmultipropertygroups");
		lib3mf_model_getslicestacks = mLibrary.getFunction("lib3mf_model_getslicestacks");
		lib3mf_model_getimage3ds = mLibrary.getFunction("lib3mf_model_getimage3ds");
		lib3mf_model_mergetomodel = mLibrary.getFunction("lib3mf_model_mergetomodel");
		lib3mf_model_mergefrommodel = mLibrary.getFunction("lib3mf_model_mergefrommodel");
		lib3mf_model_addmeshobject = mLibrary.getFunction("lib3mf_model_addmeshobject");
		lib3mf_model_addcomponentsobject = mLibrary.getFunction("lib3mf_model_addcomponentsobject");
		lib3mf_model_addslicestack = mLibrary.getFunction("lib3mf_model_addslicestack");
		lib3mf_model_addtexture2dfromattachment = mLibrary.getFunction("lib3mf_model_addtexture2dfromattachment");
		lib3mf_model_addbasematerialgroup = mLibrary.getFunction("lib3mf_model_addbasematerialgroup");
		lib3mf_model_addcolorgroup = mLibrary.getFunction("lib3mf_model_addcolorgroup");
		lib3mf_model_addtexture2dgroup = mLibrary.getFunction("lib3mf_model_addtexture2dgroup");
		lib3mf_model_addcompositematerials = mLibrary.getFunction("lib3mf_model_addcompositematerials");
		lib3mf_model_addmultipropertygroup = mLibrary.getFunction("lib3mf_model_addmultipropertygroup");
		lib3mf_model_addimagestack = mLibrary.getFunction("lib3mf_model_addimagestack");
		lib3mf_model_getimagestackbyid = mLibrary.getFunction("lib3mf_model_getimagestackbyid");
		lib3mf_model_addbuilditem = mLibrary.getFunction("lib3mf_model_addbuilditem");
		lib3mf_model_removebuilditem = mLibrary.getFunction("lib3mf_model_removebuilditem");
		lib3mf_model_getmetadatagroup = mLibrary.getFunction("lib3mf_model_getmetadatagroup");
		lib3mf_model_addattachment = mLibrary.getFunction("lib3mf_model_addattachment");
		lib3mf_model_removeattachment = mLibrary.getFunction("lib3mf_model_removeattachment");
		lib3mf_model_getattachment = mLibrary.getFunction("lib3mf_model_getattachment");
		lib3mf_model_findattachment = mLibrary.getFunction("lib3mf_model_findattachment");
		lib3mf_model_getattachmentcount = mLibrary.getFunction("lib3mf_model_getattachmentcount");
		lib3mf_model_haspackagethumbnailattachment = mLibrary.getFunction("lib3mf_model_haspackagethumbnailattachment");
		lib3mf_model_createpackagethumbnailattachment = mLibrary.getFunction("lib3mf_model_createpackagethumbnailattachment");
		lib3mf_model_getpackagethumbnailattachment = mLibrary.getFunction("lib3mf_model_getpackagethumbnailattachment");
		lib3mf_model_removepackagethumbnailattachment = mLibrary.getFunction("lib3mf_model_removepackagethumbnailattachment");
		lib3mf_model_addcustomcontenttype = mLibrary.getFunction("lib3mf_model_addcustomcontenttype");
		lib3mf_model_removecustomcontenttype = mLibrary.getFunction("lib3mf_model_removecustomcontenttype");
		lib3mf_model_setrandomnumbercallback = mLibrary.getFunction("lib3mf_model_setrandomnumbercallback");
		lib3mf_model_getkeystore = mLibrary.getFunction("lib3mf_model_getkeystore");
		lib3mf_model_getfunctions = mLibrary.getFunction("lib3mf_model_getfunctions");
		lib3mf_model_addimplicitfunction = mLibrary.getFunction("lib3mf_model_addimplicitfunction");
		lib3mf_model_addfunctionfromimage3d = mLibrary.getFunction("lib3mf_model_addfunctionfromimage3d");
		lib3mf_model_addvolumedata = mLibrary.getFunction("lib3mf_model_addvolumedata");
		lib3mf_model_addlevelset = mLibrary.getFunction("lib3mf_model_addlevelset");
		lib3mf_model_getlevelsets = mLibrary.getFunction("lib3mf_model_getlevelsets");
		lib3mf_model_removeresource = mLibrary.getFunction("lib3mf_model_removeresource");
	}

	public Lib3MFWrapper(Pointer lookupPointer) throws Lib3MFException {
		com.sun.jna.Function lookupMethod = com.sun.jna.Function.getFunction(lookupPointer);
		lib3mf_getlibraryversion = loadFunctionByLookup(lookupMethod, "lib3mf_getlibraryversion");
		lib3mf_getprereleaseinformation = loadFunctionByLookup(lookupMethod, "lib3mf_getprereleaseinformation");
		lib3mf_getbuildinformation = loadFunctionByLookup(lookupMethod, "lib3mf_getbuildinformation");
		lib3mf_getspecificationversion = loadFunctionByLookup(lookupMethod, "lib3mf_getspecificationversion");
		lib3mf_createmodel = loadFunctionByLookup(lookupMethod, "lib3mf_createmodel");
		lib3mf_release = loadFunctionByLookup(lookupMethod, "lib3mf_release");
		lib3mf_acquire = loadFunctionByLookup(lookupMethod, "lib3mf_acquire");
		lib3mf_setjournal = loadFunctionByLookup(lookupMethod, "lib3mf_setjournal");
		lib3mf_getlasterror = loadFunctionByLookup(lookupMethod, "lib3mf_getlasterror");
		lib3mf_getsymbollookupmethod = loadFunctionByLookup(lookupMethod, "lib3mf_getsymbollookupmethod");
		lib3mf_retrieveprogressmessage = loadFunctionByLookup(lookupMethod, "lib3mf_retrieveprogressmessage");
		lib3mf_rgbatocolor = loadFunctionByLookup(lookupMethod, "lib3mf_rgbatocolor");
		lib3mf_floatrgbatocolor = loadFunctionByLookup(lookupMethod, "lib3mf_floatrgbatocolor");
		lib3mf_colortorgba = loadFunctionByLookup(lookupMethod, "lib3mf_colortorgba");
		lib3mf_colortofloatrgba = loadFunctionByLookup(lookupMethod, "lib3mf_colortofloatrgba");
		lib3mf_getidentitytransform = loadFunctionByLookup(lookupMethod, "lib3mf_getidentitytransform");
		lib3mf_getuniformscaletransform = loadFunctionByLookup(lookupMethod, "lib3mf_getuniformscaletransform");
		lib3mf_getscaletransform = loadFunctionByLookup(lookupMethod, "lib3mf_getscaletransform");
		lib3mf_gettranslationtransform = loadFunctionByLookup(lookupMethod, "lib3mf_gettranslationtransform");
		lib3mf_base_classtypeid = loadFunctionByLookup(lookupMethod, "lib3mf_base_classtypeid");
		lib3mf_writer_writetofile = loadFunctionByLookup(lookupMethod, "lib3mf_writer_writetofile");
		lib3mf_writer_getstreamsize = loadFunctionByLookup(lookupMethod, "lib3mf_writer_getstreamsize");
		lib3mf_writer_writetobuffer = loadFunctionByLookup(lookupMethod, "lib3mf_writer_writetobuffer");
		lib3mf_writer_writetocallback = loadFunctionByLookup(lookupMethod, "lib3mf_writer_writetocallback");
		lib3mf_writer_setprogresscallback = loadFunctionByLookup(lookupMethod, "lib3mf_writer_setprogresscallback");
		lib3mf_writer_getdecimalprecision = loadFunctionByLookup(lookupMethod, "lib3mf_writer_getdecimalprecision");
		lib3mf_writer_setdecimalprecision = loadFunctionByLookup(lookupMethod, "lib3mf_writer_setdecimalprecision");
		lib3mf_writer_setstrictmodeactive = loadFunctionByLookup(lookupMethod, "lib3mf_writer_setstrictmodeactive");
		lib3mf_writer_getstrictmodeactive = loadFunctionByLookup(lookupMethod, "lib3mf_writer_getstrictmodeactive");
		lib3mf_writer_getwarning = loadFunctionByLookup(lookupMethod, "lib3mf_writer_getwarning");
		lib3mf_writer_getwarningcount = loadFunctionByLookup(lookupMethod, "lib3mf_writer_getwarningcount");
		lib3mf_writer_addkeywrappingcallback = loadFunctionByLookup(lookupMethod, "lib3mf_writer_addkeywrappingcallback");
		lib3mf_writer_setcontentencryptioncallback = loadFunctionByLookup(lookupMethod, "lib3mf_writer_setcontentencryptioncallback");
		lib3mf_reader_readfromfile = loadFunctionByLookup(lookupMethod, "lib3mf_reader_readfromfile");
		lib3mf_reader_readfrombuffer = loadFunctionByLookup(lookupMethod, "lib3mf_reader_readfrombuffer");
		lib3mf_reader_readfromcallback = loadFunctionByLookup(lookupMethod, "lib3mf_reader_readfromcallback");
		lib3mf_reader_setprogresscallback = loadFunctionByLookup(lookupMethod, "lib3mf_reader_setprogresscallback");
		lib3mf_reader_addrelationtoread = loadFunctionByLookup(lookupMethod, "lib3mf_reader_addrelationtoread");
		lib3mf_reader_removerelationtoread = loadFunctionByLookup(lookupMethod, "lib3mf_reader_removerelationtoread");
		lib3mf_reader_setstrictmodeactive = loadFunctionByLookup(lookupMethod, "lib3mf_reader_setstrictmodeactive");
		lib3mf_reader_getstrictmodeactive = loadFunctionByLookup(lookupMethod, "lib3mf_reader_getstrictmodeactive");
		lib3mf_reader_getwarning = loadFunctionByLookup(lookupMethod, "lib3mf_reader_getwarning");
		lib3mf_reader_getwarningcount = loadFunctionByLookup(lookupMethod, "lib3mf_reader_getwarningcount");
		lib3mf_reader_addkeywrappingcallback = loadFunctionByLookup(lookupMethod, "lib3mf_reader_addkeywrappingcallback");
		lib3mf_reader_setcontentencryptioncallback = loadFunctionByLookup(lookupMethod, "lib3mf_reader_setcontentencryptioncallback");
		lib3mf_packagepart_getpath = loadFunctionByLookup(lookupMethod, "lib3mf_packagepart_getpath");
		lib3mf_packagepart_setpath = loadFunctionByLookup(lookupMethod, "lib3mf_packagepart_setpath");
		lib3mf_resource_getresourceid = loadFunctionByLookup(lookupMethod, "lib3mf_resource_getresourceid");
		lib3mf_resource_getuniqueresourceid = loadFunctionByLookup(lookupMethod, "lib3mf_resource_getuniqueresourceid");
		lib3mf_resource_packagepart = loadFunctionByLookup(lookupMethod, "lib3mf_resource_packagepart");
		lib3mf_resource_setpackagepart = loadFunctionByLookup(lookupMethod, "lib3mf_resource_setpackagepart");
		lib3mf_resource_getmodelresourceid = loadFunctionByLookup(lookupMethod, "lib3mf_resource_getmodelresourceid");
		lib3mf_resourceiterator_movenext = loadFunctionByLookup(lookupMethod, "lib3mf_resourceiterator_movenext");
		lib3mf_resourceiterator_moveprevious = loadFunctionByLookup(lookupMethod, "lib3mf_resourceiterator_moveprevious");
		lib3mf_resourceiterator_getcurrent = loadFunctionByLookup(lookupMethod, "lib3mf_resourceiterator_getcurrent");
		lib3mf_resourceiterator_clone = loadFunctionByLookup(lookupMethod, "lib3mf_resourceiterator_clone");
		lib3mf_resourceiterator_count = loadFunctionByLookup(lookupMethod, "lib3mf_resourceiterator_count");
		lib3mf_slicestackiterator_getcurrentslicestack = loadFunctionByLookup(lookupMethod, "lib3mf_slicestackiterator_getcurrentslicestack");
		lib3mf_objectiterator_getcurrentobject = loadFunctionByLookup(lookupMethod, "lib3mf_objectiterator_getcurrentobject");
		lib3mf_meshobjectiterator_getcurrentmeshobject = loadFunctionByLookup(lookupMethod, "lib3mf_meshobjectiterator_getcurrentmeshobject");
		lib3mf_componentsobjectiterator_getcurrentcomponentsobject = loadFunctionByLookup(lookupMethod, "lib3mf_componentsobjectiterator_getcurrentcomponentsobject");
		lib3mf_texture2diterator_getcurrenttexture2d = loadFunctionByLookup(lookupMethod, "lib3mf_texture2diterator_getcurrenttexture2d");
		lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup = loadFunctionByLookup(lookupMethod, "lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup");
		lib3mf_colorgroupiterator_getcurrentcolorgroup = loadFunctionByLookup(lookupMethod, "lib3mf_colorgroupiterator_getcurrentcolorgroup");
		lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup = loadFunctionByLookup(lookupMethod, "lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup");
		lib3mf_compositematerialsiterator_getcurrentcompositematerials = loadFunctionByLookup(lookupMethod, "lib3mf_compositematerialsiterator_getcurrentcompositematerials");
		lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup = loadFunctionByLookup(lookupMethod, "lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup");
		lib3mf_image3diterator_getcurrentimage3d = loadFunctionByLookup(lookupMethod, "lib3mf_image3diterator_getcurrentimage3d");
		lib3mf_functioniterator_getcurrentfunction = loadFunctionByLookup(lookupMethod, "lib3mf_functioniterator_getcurrentfunction");
		lib3mf_levelsetiterator_getcurrentlevelset = loadFunctionByLookup(lookupMethod, "lib3mf_levelsetiterator_getcurrentlevelset");
		lib3mf_metadata_getnamespace = loadFunctionByLookup(lookupMethod, "lib3mf_metadata_getnamespace");
		lib3mf_metadata_setnamespace = loadFunctionByLookup(lookupMethod, "lib3mf_metadata_setnamespace");
		lib3mf_metadata_getname = loadFunctionByLookup(lookupMethod, "lib3mf_metadata_getname");
		lib3mf_metadata_setname = loadFunctionByLookup(lookupMethod, "lib3mf_metadata_setname");
		lib3mf_metadata_getkey = loadFunctionByLookup(lookupMethod, "lib3mf_metadata_getkey");
		lib3mf_metadata_getmustpreserve = loadFunctionByLookup(lookupMethod, "lib3mf_metadata_getmustpreserve");
		lib3mf_metadata_setmustpreserve = loadFunctionByLookup(lookupMethod, "lib3mf_metadata_setmustpreserve");
		lib3mf_metadata_gettype = loadFunctionByLookup(lookupMethod, "lib3mf_metadata_gettype");
		lib3mf_metadata_settype = loadFunctionByLookup(lookupMethod, "lib3mf_metadata_settype");
		lib3mf_metadata_getvalue = loadFunctionByLookup(lookupMethod, "lib3mf_metadata_getvalue");
		lib3mf_metadata_setvalue = loadFunctionByLookup(lookupMethod, "lib3mf_metadata_setvalue");
		lib3mf_metadatagroup_getmetadatacount = loadFunctionByLookup(lookupMethod, "lib3mf_metadatagroup_getmetadatacount");
		lib3mf_metadatagroup_getmetadata = loadFunctionByLookup(lookupMethod, "lib3mf_metadatagroup_getmetadata");
		lib3mf_metadatagroup_getmetadatabykey = loadFunctionByLookup(lookupMethod, "lib3mf_metadatagroup_getmetadatabykey");
		lib3mf_metadatagroup_removemetadatabyindex = loadFunctionByLookup(lookupMethod, "lib3mf_metadatagroup_removemetadatabyindex");
		lib3mf_metadatagroup_removemetadata = loadFunctionByLookup(lookupMethod, "lib3mf_metadatagroup_removemetadata");
		lib3mf_metadatagroup_addmetadata = loadFunctionByLookup(lookupMethod, "lib3mf_metadatagroup_addmetadata");
		lib3mf_triangleset_setname = loadFunctionByLookup(lookupMethod, "lib3mf_triangleset_setname");
		lib3mf_triangleset_getname = loadFunctionByLookup(lookupMethod, "lib3mf_triangleset_getname");
		lib3mf_triangleset_setidentifier = loadFunctionByLookup(lookupMethod, "lib3mf_triangleset_setidentifier");
		lib3mf_triangleset_getidentifier = loadFunctionByLookup(lookupMethod, "lib3mf_triangleset_getidentifier");
		lib3mf_triangleset_addtriangle = loadFunctionByLookup(lookupMethod, "lib3mf_triangleset_addtriangle");
		lib3mf_triangleset_removetriangle = loadFunctionByLookup(lookupMethod, "lib3mf_triangleset_removetriangle");
		lib3mf_triangleset_clear = loadFunctionByLookup(lookupMethod, "lib3mf_triangleset_clear");
		lib3mf_triangleset_settrianglelist = loadFunctionByLookup(lookupMethod, "lib3mf_triangleset_settrianglelist");
		lib3mf_triangleset_gettrianglelist = loadFunctionByLookup(lookupMethod, "lib3mf_triangleset_gettrianglelist");
		lib3mf_triangleset_addtrianglelist = loadFunctionByLookup(lookupMethod, "lib3mf_triangleset_addtrianglelist");
		lib3mf_triangleset_merge = loadFunctionByLookup(lookupMethod, "lib3mf_triangleset_merge");
		lib3mf_triangleset_deleteset = loadFunctionByLookup(lookupMethod, "lib3mf_triangleset_deleteset");
		lib3mf_triangleset_duplicate = loadFunctionByLookup(lookupMethod, "lib3mf_triangleset_duplicate");
		lib3mf_object_gettype = loadFunctionByLookup(lookupMethod, "lib3mf_object_gettype");
		lib3mf_object_settype = loadFunctionByLookup(lookupMethod, "lib3mf_object_settype");
		lib3mf_object_getname = loadFunctionByLookup(lookupMethod, "lib3mf_object_getname");
		lib3mf_object_setname = loadFunctionByLookup(lookupMethod, "lib3mf_object_setname");
		lib3mf_object_getpartnumber = loadFunctionByLookup(lookupMethod, "lib3mf_object_getpartnumber");
		lib3mf_object_setpartnumber = loadFunctionByLookup(lookupMethod, "lib3mf_object_setpartnumber");
		lib3mf_object_ismeshobject = loadFunctionByLookup(lookupMethod, "lib3mf_object_ismeshobject");
		lib3mf_object_iscomponentsobject = loadFunctionByLookup(lookupMethod, "lib3mf_object_iscomponentsobject");
		lib3mf_object_islevelsetobject = loadFunctionByLookup(lookupMethod, "lib3mf_object_islevelsetobject");
		lib3mf_object_isvalid = loadFunctionByLookup(lookupMethod, "lib3mf_object_isvalid");
		lib3mf_object_setattachmentasthumbnail = loadFunctionByLookup(lookupMethod, "lib3mf_object_setattachmentasthumbnail");
		lib3mf_object_getthumbnailattachment = loadFunctionByLookup(lookupMethod, "lib3mf_object_getthumbnailattachment");
		lib3mf_object_clearthumbnailattachment = loadFunctionByLookup(lookupMethod, "lib3mf_object_clearthumbnailattachment");
		lib3mf_object_getoutbox = loadFunctionByLookup(lookupMethod, "lib3mf_object_getoutbox");
		lib3mf_object_getuuid = loadFunctionByLookup(lookupMethod, "lib3mf_object_getuuid");
		lib3mf_object_setuuid = loadFunctionByLookup(lookupMethod, "lib3mf_object_setuuid");
		lib3mf_object_getmetadatagroup = loadFunctionByLookup(lookupMethod, "lib3mf_object_getmetadatagroup");
		lib3mf_object_setslicesmeshresolution = loadFunctionByLookup(lookupMethod, "lib3mf_object_setslicesmeshresolution");
		lib3mf_object_getslicesmeshresolution = loadFunctionByLookup(lookupMethod, "lib3mf_object_getslicesmeshresolution");
		lib3mf_object_hasslices = loadFunctionByLookup(lookupMethod, "lib3mf_object_hasslices");
		lib3mf_object_clearslicestack = loadFunctionByLookup(lookupMethod, "lib3mf_object_clearslicestack");
		lib3mf_object_getslicestack = loadFunctionByLookup(lookupMethod, "lib3mf_object_getslicestack");
		lib3mf_object_assignslicestack = loadFunctionByLookup(lookupMethod, "lib3mf_object_assignslicestack");
		lib3mf_meshobject_getvertexcount = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_getvertexcount");
		lib3mf_meshobject_gettrianglecount = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_gettrianglecount");
		lib3mf_meshobject_getvertex = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_getvertex");
		lib3mf_meshobject_setvertex = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_setvertex");
		lib3mf_meshobject_addvertex = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_addvertex");
		lib3mf_meshobject_getvertices = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_getvertices");
		lib3mf_meshobject_gettriangle = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_gettriangle");
		lib3mf_meshobject_settriangle = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_settriangle");
		lib3mf_meshobject_addtriangle = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_addtriangle");
		lib3mf_meshobject_gettriangleindices = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_gettriangleindices");
		lib3mf_meshobject_setobjectlevelproperty = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_setobjectlevelproperty");
		lib3mf_meshobject_getobjectlevelproperty = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_getobjectlevelproperty");
		lib3mf_meshobject_settriangleproperties = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_settriangleproperties");
		lib3mf_meshobject_gettriangleproperties = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_gettriangleproperties");
		lib3mf_meshobject_setalltriangleproperties = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_setalltriangleproperties");
		lib3mf_meshobject_getalltriangleproperties = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_getalltriangleproperties");
		lib3mf_meshobject_clearallproperties = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_clearallproperties");
		lib3mf_meshobject_setgeometry = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_setgeometry");
		lib3mf_meshobject_ismanifoldandoriented = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_ismanifoldandoriented");
		lib3mf_meshobject_beamlattice = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_beamlattice");
		lib3mf_meshobject_getvolumedata = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_getvolumedata");
		lib3mf_meshobject_setvolumedata = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_setvolumedata");
		lib3mf_meshobject_addtriangleset = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_addtriangleset");
		lib3mf_meshobject_hastriangleset = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_hastriangleset");
		lib3mf_meshobject_findtriangleset = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_findtriangleset");
		lib3mf_meshobject_gettrianglesetcount = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_gettrianglesetcount");
		lib3mf_meshobject_gettriangleset = loadFunctionByLookup(lookupMethod, "lib3mf_meshobject_gettriangleset");
		lib3mf_levelset_getfunction = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_getfunction");
		lib3mf_levelset_setfunction = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_setfunction");
		lib3mf_levelset_gettransform = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_gettransform");
		lib3mf_levelset_settransform = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_settransform");
		lib3mf_levelset_getchannelname = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_getchannelname");
		lib3mf_levelset_setchannelname = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_setchannelname");
		lib3mf_levelset_setminfeaturesize = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_setminfeaturesize");
		lib3mf_levelset_getminfeaturesize = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_getminfeaturesize");
		lib3mf_levelset_setfallbackvalue = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_setfallbackvalue");
		lib3mf_levelset_getfallbackvalue = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_getfallbackvalue");
		lib3mf_levelset_setmeshbboxonly = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_setmeshbboxonly");
		lib3mf_levelset_getmeshbboxonly = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_getmeshbboxonly");
		lib3mf_levelset_setmesh = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_setmesh");
		lib3mf_levelset_getmesh = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_getmesh");
		lib3mf_levelset_getvolumedata = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_getvolumedata");
		lib3mf_levelset_setvolumedata = loadFunctionByLookup(lookupMethod, "lib3mf_levelset_setvolumedata");
		lib3mf_beamlattice_getminlength = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_getminlength");
		lib3mf_beamlattice_setminlength = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_setminlength");
		lib3mf_beamlattice_getclipping = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_getclipping");
		lib3mf_beamlattice_setclipping = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_setclipping");
		lib3mf_beamlattice_getrepresentation = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_getrepresentation");
		lib3mf_beamlattice_setrepresentation = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_setrepresentation");
		lib3mf_beamlattice_getballoptions = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_getballoptions");
		lib3mf_beamlattice_setballoptions = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_setballoptions");
		lib3mf_beamlattice_getbeamcount = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_getbeamcount");
		lib3mf_beamlattice_getbeam = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_getbeam");
		lib3mf_beamlattice_addbeam = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_addbeam");
		lib3mf_beamlattice_setbeam = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_setbeam");
		lib3mf_beamlattice_setbeams = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_setbeams");
		lib3mf_beamlattice_getbeams = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_getbeams");
		lib3mf_beamlattice_getballcount = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_getballcount");
		lib3mf_beamlattice_getball = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_getball");
		lib3mf_beamlattice_addball = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_addball");
		lib3mf_beamlattice_setball = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_setball");
		lib3mf_beamlattice_setballs = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_setballs");
		lib3mf_beamlattice_getballs = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_getballs");
		lib3mf_beamlattice_getbeamsetcount = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_getbeamsetcount");
		lib3mf_beamlattice_addbeamset = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_addbeamset");
		lib3mf_beamlattice_getbeamset = loadFunctionByLookup(lookupMethod, "lib3mf_beamlattice_getbeamset");
		lib3mf_functionreference_getfunctionresourceid = loadFunctionByLookup(lookupMethod, "lib3mf_functionreference_getfunctionresourceid");
		lib3mf_functionreference_setfunctionresourceid = loadFunctionByLookup(lookupMethod, "lib3mf_functionreference_setfunctionresourceid");
		lib3mf_functionreference_gettransform = loadFunctionByLookup(lookupMethod, "lib3mf_functionreference_gettransform");
		lib3mf_functionreference_settransform = loadFunctionByLookup(lookupMethod, "lib3mf_functionreference_settransform");
		lib3mf_functionreference_getchannelname = loadFunctionByLookup(lookupMethod, "lib3mf_functionreference_getchannelname");
		lib3mf_functionreference_setchannelname = loadFunctionByLookup(lookupMethod, "lib3mf_functionreference_setchannelname");
		lib3mf_functionreference_setminfeaturesize = loadFunctionByLookup(lookupMethod, "lib3mf_functionreference_setminfeaturesize");
		lib3mf_functionreference_getminfeaturesize = loadFunctionByLookup(lookupMethod, "lib3mf_functionreference_getminfeaturesize");
		lib3mf_functionreference_setfallbackvalue = loadFunctionByLookup(lookupMethod, "lib3mf_functionreference_setfallbackvalue");
		lib3mf_functionreference_getfallbackvalue = loadFunctionByLookup(lookupMethod, "lib3mf_functionreference_getfallbackvalue");
		lib3mf_volumedatacomposite_getbasematerialgroup = loadFunctionByLookup(lookupMethod, "lib3mf_volumedatacomposite_getbasematerialgroup");
		lib3mf_volumedatacomposite_setbasematerialgroup = loadFunctionByLookup(lookupMethod, "lib3mf_volumedatacomposite_setbasematerialgroup");
		lib3mf_volumedatacomposite_getmaterialmappingcount = loadFunctionByLookup(lookupMethod, "lib3mf_volumedatacomposite_getmaterialmappingcount");
		lib3mf_volumedatacomposite_getmaterialmapping = loadFunctionByLookup(lookupMethod, "lib3mf_volumedatacomposite_getmaterialmapping");
		lib3mf_volumedatacomposite_addmaterialmapping = loadFunctionByLookup(lookupMethod, "lib3mf_volumedatacomposite_addmaterialmapping");
		lib3mf_volumedatacomposite_removematerialmapping = loadFunctionByLookup(lookupMethod, "lib3mf_volumedatacomposite_removematerialmapping");
		lib3mf_volumedataproperty_getname = loadFunctionByLookup(lookupMethod, "lib3mf_volumedataproperty_getname");
		lib3mf_volumedataproperty_setisrequired = loadFunctionByLookup(lookupMethod, "lib3mf_volumedataproperty_setisrequired");
		lib3mf_volumedataproperty_isrequired = loadFunctionByLookup(lookupMethod, "lib3mf_volumedataproperty_isrequired");
		lib3mf_volumedata_getcomposite = loadFunctionByLookup(lookupMethod, "lib3mf_volumedata_getcomposite");
		lib3mf_volumedata_createnewcomposite = loadFunctionByLookup(lookupMethod, "lib3mf_volumedata_createnewcomposite");
		lib3mf_volumedata_removecomposite = loadFunctionByLookup(lookupMethod, "lib3mf_volumedata_removecomposite");
		lib3mf_volumedata_getcolor = loadFunctionByLookup(lookupMethod, "lib3mf_volumedata_getcolor");
		lib3mf_volumedata_createnewcolor = loadFunctionByLookup(lookupMethod, "lib3mf_volumedata_createnewcolor");
		lib3mf_volumedata_removecolor = loadFunctionByLookup(lookupMethod, "lib3mf_volumedata_removecolor");
		lib3mf_volumedata_getpropertycount = loadFunctionByLookup(lookupMethod, "lib3mf_volumedata_getpropertycount");
		lib3mf_volumedata_getproperty = loadFunctionByLookup(lookupMethod, "lib3mf_volumedata_getproperty");
		lib3mf_volumedata_addpropertyfromfunction = loadFunctionByLookup(lookupMethod, "lib3mf_volumedata_addpropertyfromfunction");
		lib3mf_volumedata_removeproperty = loadFunctionByLookup(lookupMethod, "lib3mf_volumedata_removeproperty");
		lib3mf_component_getobjectresource = loadFunctionByLookup(lookupMethod, "lib3mf_component_getobjectresource");
		lib3mf_component_getobjectresourceid = loadFunctionByLookup(lookupMethod, "lib3mf_component_getobjectresourceid");
		lib3mf_component_getuuid = loadFunctionByLookup(lookupMethod, "lib3mf_component_getuuid");
		lib3mf_component_setuuid = loadFunctionByLookup(lookupMethod, "lib3mf_component_setuuid");
		lib3mf_component_hastransform = loadFunctionByLookup(lookupMethod, "lib3mf_component_hastransform");
		lib3mf_component_gettransform = loadFunctionByLookup(lookupMethod, "lib3mf_component_gettransform");
		lib3mf_component_settransform = loadFunctionByLookup(lookupMethod, "lib3mf_component_settransform");
		lib3mf_componentsobject_addcomponent = loadFunctionByLookup(lookupMethod, "lib3mf_componentsobject_addcomponent");
		lib3mf_componentsobject_getcomponent = loadFunctionByLookup(lookupMethod, "lib3mf_componentsobject_getcomponent");
		lib3mf_componentsobject_getcomponentcount = loadFunctionByLookup(lookupMethod, "lib3mf_componentsobject_getcomponentcount");
		lib3mf_beamset_setname = loadFunctionByLookup(lookupMethod, "lib3mf_beamset_setname");
		lib3mf_beamset_getname = loadFunctionByLookup(lookupMethod, "lib3mf_beamset_getname");
		lib3mf_beamset_setidentifier = loadFunctionByLookup(lookupMethod, "lib3mf_beamset_setidentifier");
		lib3mf_beamset_getidentifier = loadFunctionByLookup(lookupMethod, "lib3mf_beamset_getidentifier");
		lib3mf_beamset_getreferencecount = loadFunctionByLookup(lookupMethod, "lib3mf_beamset_getreferencecount");
		lib3mf_beamset_setreferences = loadFunctionByLookup(lookupMethod, "lib3mf_beamset_setreferences");
		lib3mf_beamset_getreferences = loadFunctionByLookup(lookupMethod, "lib3mf_beamset_getreferences");
		lib3mf_beamset_getballreferencecount = loadFunctionByLookup(lookupMethod, "lib3mf_beamset_getballreferencecount");
		lib3mf_beamset_setballreferences = loadFunctionByLookup(lookupMethod, "lib3mf_beamset_setballreferences");
		lib3mf_beamset_getballreferences = loadFunctionByLookup(lookupMethod, "lib3mf_beamset_getballreferences");
		lib3mf_basematerialgroup_getcount = loadFunctionByLookup(lookupMethod, "lib3mf_basematerialgroup_getcount");
		lib3mf_basematerialgroup_getallpropertyids = loadFunctionByLookup(lookupMethod, "lib3mf_basematerialgroup_getallpropertyids");
		lib3mf_basematerialgroup_addmaterial = loadFunctionByLookup(lookupMethod, "lib3mf_basematerialgroup_addmaterial");
		lib3mf_basematerialgroup_removematerial = loadFunctionByLookup(lookupMethod, "lib3mf_basematerialgroup_removematerial");
		lib3mf_basematerialgroup_getname = loadFunctionByLookup(lookupMethod, "lib3mf_basematerialgroup_getname");
		lib3mf_basematerialgroup_setname = loadFunctionByLookup(lookupMethod, "lib3mf_basematerialgroup_setname");
		lib3mf_basematerialgroup_setdisplaycolor = loadFunctionByLookup(lookupMethod, "lib3mf_basematerialgroup_setdisplaycolor");
		lib3mf_basematerialgroup_getdisplaycolor = loadFunctionByLookup(lookupMethod, "lib3mf_basematerialgroup_getdisplaycolor");
		lib3mf_colorgroup_getcount = loadFunctionByLookup(lookupMethod, "lib3mf_colorgroup_getcount");
		lib3mf_colorgroup_getallpropertyids = loadFunctionByLookup(lookupMethod, "lib3mf_colorgroup_getallpropertyids");
		lib3mf_colorgroup_addcolor = loadFunctionByLookup(lookupMethod, "lib3mf_colorgroup_addcolor");
		lib3mf_colorgroup_removecolor = loadFunctionByLookup(lookupMethod, "lib3mf_colorgroup_removecolor");
		lib3mf_colorgroup_setcolor = loadFunctionByLookup(lookupMethod, "lib3mf_colorgroup_setcolor");
		lib3mf_colorgroup_getcolor = loadFunctionByLookup(lookupMethod, "lib3mf_colorgroup_getcolor");
		lib3mf_texture2dgroup_getcount = loadFunctionByLookup(lookupMethod, "lib3mf_texture2dgroup_getcount");
		lib3mf_texture2dgroup_getallpropertyids = loadFunctionByLookup(lookupMethod, "lib3mf_texture2dgroup_getallpropertyids");
		lib3mf_texture2dgroup_addtex2coord = loadFunctionByLookup(lookupMethod, "lib3mf_texture2dgroup_addtex2coord");
		lib3mf_texture2dgroup_gettex2coord = loadFunctionByLookup(lookupMethod, "lib3mf_texture2dgroup_gettex2coord");
		lib3mf_texture2dgroup_removetex2coord = loadFunctionByLookup(lookupMethod, "lib3mf_texture2dgroup_removetex2coord");
		lib3mf_texture2dgroup_gettexture2d = loadFunctionByLookup(lookupMethod, "lib3mf_texture2dgroup_gettexture2d");
		lib3mf_compositematerials_getcount = loadFunctionByLookup(lookupMethod, "lib3mf_compositematerials_getcount");
		lib3mf_compositematerials_getallpropertyids = loadFunctionByLookup(lookupMethod, "lib3mf_compositematerials_getallpropertyids");
		lib3mf_compositematerials_getbasematerialgroup = loadFunctionByLookup(lookupMethod, "lib3mf_compositematerials_getbasematerialgroup");
		lib3mf_compositematerials_addcomposite = loadFunctionByLookup(lookupMethod, "lib3mf_compositematerials_addcomposite");
		lib3mf_compositematerials_removecomposite = loadFunctionByLookup(lookupMethod, "lib3mf_compositematerials_removecomposite");
		lib3mf_compositematerials_getcomposite = loadFunctionByLookup(lookupMethod, "lib3mf_compositematerials_getcomposite");
		lib3mf_multipropertygroup_getcount = loadFunctionByLookup(lookupMethod, "lib3mf_multipropertygroup_getcount");
		lib3mf_multipropertygroup_getallpropertyids = loadFunctionByLookup(lookupMethod, "lib3mf_multipropertygroup_getallpropertyids");
		lib3mf_multipropertygroup_addmultiproperty = loadFunctionByLookup(lookupMethod, "lib3mf_multipropertygroup_addmultiproperty");
		lib3mf_multipropertygroup_setmultiproperty = loadFunctionByLookup(lookupMethod, "lib3mf_multipropertygroup_setmultiproperty");
		lib3mf_multipropertygroup_getmultiproperty = loadFunctionByLookup(lookupMethod, "lib3mf_multipropertygroup_getmultiproperty");
		lib3mf_multipropertygroup_removemultiproperty = loadFunctionByLookup(lookupMethod, "lib3mf_multipropertygroup_removemultiproperty");
		lib3mf_multipropertygroup_getlayercount = loadFunctionByLookup(lookupMethod, "lib3mf_multipropertygroup_getlayercount");
		lib3mf_multipropertygroup_addlayer = loadFunctionByLookup(lookupMethod, "lib3mf_multipropertygroup_addlayer");
		lib3mf_multipropertygroup_getlayer = loadFunctionByLookup(lookupMethod, "lib3mf_multipropertygroup_getlayer");
		lib3mf_multipropertygroup_removelayer = loadFunctionByLookup(lookupMethod, "lib3mf_multipropertygroup_removelayer");
		lib3mf_image3d_getname = loadFunctionByLookup(lookupMethod, "lib3mf_image3d_getname");
		lib3mf_image3d_setname = loadFunctionByLookup(lookupMethod, "lib3mf_image3d_setname");
		lib3mf_image3d_isimagestack = loadFunctionByLookup(lookupMethod, "lib3mf_image3d_isimagestack");
		lib3mf_imagestack_getrowcount = loadFunctionByLookup(lookupMethod, "lib3mf_imagestack_getrowcount");
		lib3mf_imagestack_setrowcount = loadFunctionByLookup(lookupMethod, "lib3mf_imagestack_setrowcount");
		lib3mf_imagestack_getcolumncount = loadFunctionByLookup(lookupMethod, "lib3mf_imagestack_getcolumncount");
		lib3mf_imagestack_setcolumncount = loadFunctionByLookup(lookupMethod, "lib3mf_imagestack_setcolumncount");
		lib3mf_imagestack_getsheetcount = loadFunctionByLookup(lookupMethod, "lib3mf_imagestack_getsheetcount");
		lib3mf_imagestack_getsheet = loadFunctionByLookup(lookupMethod, "lib3mf_imagestack_getsheet");
		lib3mf_imagestack_setsheet = loadFunctionByLookup(lookupMethod, "lib3mf_imagestack_setsheet");
		lib3mf_imagestack_createemptysheet = loadFunctionByLookup(lookupMethod, "lib3mf_imagestack_createemptysheet");
		lib3mf_imagestack_createsheetfrombuffer = loadFunctionByLookup(lookupMethod, "lib3mf_imagestack_createsheetfrombuffer");
		lib3mf_imagestack_createsheetfromfile = loadFunctionByLookup(lookupMethod, "lib3mf_imagestack_createsheetfromfile");
		lib3mf_attachment_getpath = loadFunctionByLookup(lookupMethod, "lib3mf_attachment_getpath");
		lib3mf_attachment_setpath = loadFunctionByLookup(lookupMethod, "lib3mf_attachment_setpath");
		lib3mf_attachment_packagepart = loadFunctionByLookup(lookupMethod, "lib3mf_attachment_packagepart");
		lib3mf_attachment_getrelationshiptype = loadFunctionByLookup(lookupMethod, "lib3mf_attachment_getrelationshiptype");
		lib3mf_attachment_setrelationshiptype = loadFunctionByLookup(lookupMethod, "lib3mf_attachment_setrelationshiptype");
		lib3mf_attachment_writetofile = loadFunctionByLookup(lookupMethod, "lib3mf_attachment_writetofile");
		lib3mf_attachment_readfromfile = loadFunctionByLookup(lookupMethod, "lib3mf_attachment_readfromfile");
		lib3mf_attachment_readfromcallback = loadFunctionByLookup(lookupMethod, "lib3mf_attachment_readfromcallback");
		lib3mf_attachment_getstreamsize = loadFunctionByLookup(lookupMethod, "lib3mf_attachment_getstreamsize");
		lib3mf_attachment_writetobuffer = loadFunctionByLookup(lookupMethod, "lib3mf_attachment_writetobuffer");
		lib3mf_attachment_readfrombuffer = loadFunctionByLookup(lookupMethod, "lib3mf_attachment_readfrombuffer");
		lib3mf_texture2d_getattachment = loadFunctionByLookup(lookupMethod, "lib3mf_texture2d_getattachment");
		lib3mf_texture2d_setattachment = loadFunctionByLookup(lookupMethod, "lib3mf_texture2d_setattachment");
		lib3mf_texture2d_getcontenttype = loadFunctionByLookup(lookupMethod, "lib3mf_texture2d_getcontenttype");
		lib3mf_texture2d_setcontenttype = loadFunctionByLookup(lookupMethod, "lib3mf_texture2d_setcontenttype");
		lib3mf_texture2d_gettilestyleuv = loadFunctionByLookup(lookupMethod, "lib3mf_texture2d_gettilestyleuv");
		lib3mf_texture2d_settilestyleuv = loadFunctionByLookup(lookupMethod, "lib3mf_texture2d_settilestyleuv");
		lib3mf_texture2d_getfilter = loadFunctionByLookup(lookupMethod, "lib3mf_texture2d_getfilter");
		lib3mf_texture2d_setfilter = loadFunctionByLookup(lookupMethod, "lib3mf_texture2d_setfilter");
		lib3mf_implicitport_getidentifier = loadFunctionByLookup(lookupMethod, "lib3mf_implicitport_getidentifier");
		lib3mf_implicitport_setidentifier = loadFunctionByLookup(lookupMethod, "lib3mf_implicitport_setidentifier");
		lib3mf_implicitport_getdisplayname = loadFunctionByLookup(lookupMethod, "lib3mf_implicitport_getdisplayname");
		lib3mf_implicitport_setdisplayname = loadFunctionByLookup(lookupMethod, "lib3mf_implicitport_setdisplayname");
		lib3mf_implicitport_settype = loadFunctionByLookup(lookupMethod, "lib3mf_implicitport_settype");
		lib3mf_implicitport_gettype = loadFunctionByLookup(lookupMethod, "lib3mf_implicitport_gettype");
		lib3mf_implicitport_getreference = loadFunctionByLookup(lookupMethod, "lib3mf_implicitport_getreference");
		lib3mf_implicitport_setreference = loadFunctionByLookup(lookupMethod, "lib3mf_implicitport_setreference");
		lib3mf_iterator_movenext = loadFunctionByLookup(lookupMethod, "lib3mf_iterator_movenext");
		lib3mf_iterator_moveprevious = loadFunctionByLookup(lookupMethod, "lib3mf_iterator_moveprevious");
		lib3mf_iterator_count = loadFunctionByLookup(lookupMethod, "lib3mf_iterator_count");
		lib3mf_implicitportiterator_getcurrent = loadFunctionByLookup(lookupMethod, "lib3mf_implicitportiterator_getcurrent");
		lib3mf_implicitnode_getidentifier = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_getidentifier");
		lib3mf_implicitnode_setidentifier = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_setidentifier");
		lib3mf_implicitnode_getdisplayname = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_getdisplayname");
		lib3mf_implicitnode_setdisplayname = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_setdisplayname");
		lib3mf_implicitnode_gettag = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_gettag");
		lib3mf_implicitnode_settag = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_settag");
		lib3mf_implicitnode_getnodetype = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_getnodetype");
		lib3mf_implicitnode_addinput = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_addinput");
		lib3mf_implicitnode_getinputs = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_getinputs");
		lib3mf_implicitnode_addoutput = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_addoutput");
		lib3mf_implicitnode_getoutputs = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_getoutputs");
		lib3mf_implicitnode_findinput = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_findinput");
		lib3mf_implicitnode_findoutput = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_findoutput");
		lib3mf_implicitnode_aretypesvalid = loadFunctionByLookup(lookupMethod, "lib3mf_implicitnode_aretypesvalid");
		lib3mf_oneinputnode_getinputa = loadFunctionByLookup(lookupMethod, "lib3mf_oneinputnode_getinputa");
		lib3mf_oneinputnode_getoutputresult = loadFunctionByLookup(lookupMethod, "lib3mf_oneinputnode_getoutputresult");
		lib3mf_resourceidnode_setresource = loadFunctionByLookup(lookupMethod, "lib3mf_resourceidnode_setresource");
		lib3mf_resourceidnode_getresource = loadFunctionByLookup(lookupMethod, "lib3mf_resourceidnode_getresource");
		lib3mf_resourceidnode_getoutputvalue = loadFunctionByLookup(lookupMethod, "lib3mf_resourceidnode_getoutputvalue");
		lib3mf_twoinputnode_getinputb = loadFunctionByLookup(lookupMethod, "lib3mf_twoinputnode_getinputb");
		lib3mf_selectnode_getinputb = loadFunctionByLookup(lookupMethod, "lib3mf_selectnode_getinputb");
		lib3mf_selectnode_getinputc = loadFunctionByLookup(lookupMethod, "lib3mf_selectnode_getinputc");
		lib3mf_selectnode_getinputd = loadFunctionByLookup(lookupMethod, "lib3mf_selectnode_getinputd");
		lib3mf_clampnode_getinputmin = loadFunctionByLookup(lookupMethod, "lib3mf_clampnode_getinputmin");
		lib3mf_clampnode_getinputmax = loadFunctionByLookup(lookupMethod, "lib3mf_clampnode_getinputmax");
		lib3mf_composevectornode_getinputx = loadFunctionByLookup(lookupMethod, "lib3mf_composevectornode_getinputx");
		lib3mf_composevectornode_getinputy = loadFunctionByLookup(lookupMethod, "lib3mf_composevectornode_getinputy");
		lib3mf_composevectornode_getinputz = loadFunctionByLookup(lookupMethod, "lib3mf_composevectornode_getinputz");
		lib3mf_composevectornode_getoutputresult = loadFunctionByLookup(lookupMethod, "lib3mf_composevectornode_getoutputresult");
		lib3mf_decomposevectornode_getinputa = loadFunctionByLookup(lookupMethod, "lib3mf_decomposevectornode_getinputa");
		lib3mf_decomposevectornode_getoutputx = loadFunctionByLookup(lookupMethod, "lib3mf_decomposevectornode_getoutputx");
		lib3mf_decomposevectornode_getoutputy = loadFunctionByLookup(lookupMethod, "lib3mf_decomposevectornode_getoutputy");
		lib3mf_decomposevectornode_getoutputz = loadFunctionByLookup(lookupMethod, "lib3mf_decomposevectornode_getoutputz");
		lib3mf_composematrixnode_getinputm00 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm00");
		lib3mf_composematrixnode_getinputm01 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm01");
		lib3mf_composematrixnode_getinputm02 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm02");
		lib3mf_composematrixnode_getinputm03 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm03");
		lib3mf_composematrixnode_getinputm10 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm10");
		lib3mf_composematrixnode_getinputm11 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm11");
		lib3mf_composematrixnode_getinputm12 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm12");
		lib3mf_composematrixnode_getinputm13 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm13");
		lib3mf_composematrixnode_getinputm20 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm20");
		lib3mf_composematrixnode_getinputm21 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm21");
		lib3mf_composematrixnode_getinputm22 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm22");
		lib3mf_composematrixnode_getinputm23 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm23");
		lib3mf_composematrixnode_getinputm30 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm30");
		lib3mf_composematrixnode_getinputm31 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm31");
		lib3mf_composematrixnode_getinputm32 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm32");
		lib3mf_composematrixnode_getinputm33 = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getinputm33");
		lib3mf_composematrixnode_getoutputresult = loadFunctionByLookup(lookupMethod, "lib3mf_composematrixnode_getoutputresult");
		lib3mf_matrixfromrowsnode_getinputa = loadFunctionByLookup(lookupMethod, "lib3mf_matrixfromrowsnode_getinputa");
		lib3mf_matrixfromrowsnode_getinputb = loadFunctionByLookup(lookupMethod, "lib3mf_matrixfromrowsnode_getinputb");
		lib3mf_matrixfromrowsnode_getinputc = loadFunctionByLookup(lookupMethod, "lib3mf_matrixfromrowsnode_getinputc");
		lib3mf_matrixfromrowsnode_getinputd = loadFunctionByLookup(lookupMethod, "lib3mf_matrixfromrowsnode_getinputd");
		lib3mf_matrixfromrowsnode_getoutputresult = loadFunctionByLookup(lookupMethod, "lib3mf_matrixfromrowsnode_getoutputresult");
		lib3mf_matrixfromcolumnsnode_getinputa = loadFunctionByLookup(lookupMethod, "lib3mf_matrixfromcolumnsnode_getinputa");
		lib3mf_matrixfromcolumnsnode_getinputb = loadFunctionByLookup(lookupMethod, "lib3mf_matrixfromcolumnsnode_getinputb");
		lib3mf_matrixfromcolumnsnode_getinputc = loadFunctionByLookup(lookupMethod, "lib3mf_matrixfromcolumnsnode_getinputc");
		lib3mf_matrixfromcolumnsnode_getinputd = loadFunctionByLookup(lookupMethod, "lib3mf_matrixfromcolumnsnode_getinputd");
		lib3mf_matrixfromcolumnsnode_getoutputresult = loadFunctionByLookup(lookupMethod, "lib3mf_matrixfromcolumnsnode_getoutputresult");
		lib3mf_constantnode_setconstant = loadFunctionByLookup(lookupMethod, "lib3mf_constantnode_setconstant");
		lib3mf_constantnode_getconstant = loadFunctionByLookup(lookupMethod, "lib3mf_constantnode_getconstant");
		lib3mf_constantnode_getoutputvalue = loadFunctionByLookup(lookupMethod, "lib3mf_constantnode_getoutputvalue");
		lib3mf_constvecnode_setvector = loadFunctionByLookup(lookupMethod, "lib3mf_constvecnode_setvector");
		lib3mf_constvecnode_getvector = loadFunctionByLookup(lookupMethod, "lib3mf_constvecnode_getvector");
		lib3mf_constvecnode_getoutputvector = loadFunctionByLookup(lookupMethod, "lib3mf_constvecnode_getoutputvector");
		lib3mf_constmatnode_setmatrix = loadFunctionByLookup(lookupMethod, "lib3mf_constmatnode_setmatrix");
		lib3mf_constmatnode_getmatrix = loadFunctionByLookup(lookupMethod, "lib3mf_constmatnode_getmatrix");
		lib3mf_constmatnode_getoutputmatrix = loadFunctionByLookup(lookupMethod, "lib3mf_constmatnode_getoutputmatrix");
		lib3mf_meshnode_getinputmesh = loadFunctionByLookup(lookupMethod, "lib3mf_meshnode_getinputmesh");
		lib3mf_meshnode_getinputpos = loadFunctionByLookup(lookupMethod, "lib3mf_meshnode_getinputpos");
		lib3mf_meshnode_getoutputdistance = loadFunctionByLookup(lookupMethod, "lib3mf_meshnode_getoutputdistance");
		lib3mf_unsignedmeshnode_getinputmesh = loadFunctionByLookup(lookupMethod, "lib3mf_unsignedmeshnode_getinputmesh");
		lib3mf_unsignedmeshnode_getinputpos = loadFunctionByLookup(lookupMethod, "lib3mf_unsignedmeshnode_getinputpos");
		lib3mf_unsignedmeshnode_getoutputdistance = loadFunctionByLookup(lookupMethod, "lib3mf_unsignedmeshnode_getoutputdistance");
		lib3mf_beamlatticenode_getinputbeamlattice = loadFunctionByLookup(lookupMethod, "lib3mf_beamlatticenode_getinputbeamlattice");
		lib3mf_beamlatticenode_getinputpos = loadFunctionByLookup(lookupMethod, "lib3mf_beamlatticenode_getinputpos");
		lib3mf_beamlatticenode_getoutputdistance = loadFunctionByLookup(lookupMethod, "lib3mf_beamlatticenode_getoutputdistance");
		lib3mf_beamlatticenode_setaccuraterange = loadFunctionByLookup(lookupMethod, "lib3mf_beamlatticenode_setaccuraterange");
		lib3mf_beamlatticenode_getaccuraterange = loadFunctionByLookup(lookupMethod, "lib3mf_beamlatticenode_getaccuraterange");
		lib3mf_functiongradientnode_getinputfunctionid = loadFunctionByLookup(lookupMethod, "lib3mf_functiongradientnode_getinputfunctionid");
		lib3mf_functiongradientnode_getinputpos = loadFunctionByLookup(lookupMethod, "lib3mf_functiongradientnode_getinputpos");
		lib3mf_functiongradientnode_getinputstep = loadFunctionByLookup(lookupMethod, "lib3mf_functiongradientnode_getinputstep");
		lib3mf_functiongradientnode_setscalaroutputname = loadFunctionByLookup(lookupMethod, "lib3mf_functiongradientnode_setscalaroutputname");
		lib3mf_functiongradientnode_getscalaroutputname = loadFunctionByLookup(lookupMethod, "lib3mf_functiongradientnode_getscalaroutputname");
		lib3mf_functiongradientnode_setvectorinputname = loadFunctionByLookup(lookupMethod, "lib3mf_functiongradientnode_setvectorinputname");
		lib3mf_functiongradientnode_getvectorinputname = loadFunctionByLookup(lookupMethod, "lib3mf_functiongradientnode_getvectorinputname");
		lib3mf_functiongradientnode_getoutputnormalizedgradient = loadFunctionByLookup(lookupMethod, "lib3mf_functiongradientnode_getoutputnormalizedgradient");
		lib3mf_functiongradientnode_getoutputgradient = loadFunctionByLookup(lookupMethod, "lib3mf_functiongradientnode_getoutputgradient");
		lib3mf_functiongradientnode_getoutputmagnitude = loadFunctionByLookup(lookupMethod, "lib3mf_functiongradientnode_getoutputmagnitude");
		lib3mf_normalizedistancenode_getinputfunctionid = loadFunctionByLookup(lookupMethod, "lib3mf_normalizedistancenode_getinputfunctionid");
		lib3mf_normalizedistancenode_getinputpos = loadFunctionByLookup(lookupMethod, "lib3mf_normalizedistancenode_getinputpos");
		lib3mf_normalizedistancenode_getinputstep = loadFunctionByLookup(lookupMethod, "lib3mf_normalizedistancenode_getinputstep");
		lib3mf_normalizedistancenode_setscalaroutputname = loadFunctionByLookup(lookupMethod, "lib3mf_normalizedistancenode_setscalaroutputname");
		lib3mf_normalizedistancenode_getscalaroutputname = loadFunctionByLookup(lookupMethod, "lib3mf_normalizedistancenode_getscalaroutputname");
		lib3mf_normalizedistancenode_setvectorinputname = loadFunctionByLookup(lookupMethod, "lib3mf_normalizedistancenode_setvectorinputname");
		lib3mf_normalizedistancenode_getvectorinputname = loadFunctionByLookup(lookupMethod, "lib3mf_normalizedistancenode_getvectorinputname");
		lib3mf_normalizedistancenode_getoutputresult = loadFunctionByLookup(lookupMethod, "lib3mf_normalizedistancenode_getoutputresult");
		lib3mf_functioncallnode_getinputfunctionid = loadFunctionByLookup(lookupMethod, "lib3mf_functioncallnode_getinputfunctionid");
		lib3mf_nodeiterator_getcurrent = loadFunctionByLookup(lookupMethod, "lib3mf_nodeiterator_getcurrent");
		lib3mf_function_getdisplayname = loadFunctionByLookup(lookupMethod, "lib3mf_function_getdisplayname");
		lib3mf_function_setdisplayname = loadFunctionByLookup(lookupMethod, "lib3mf_function_setdisplayname");
		lib3mf_function_addinput = loadFunctionByLookup(lookupMethod, "lib3mf_function_addinput");
		lib3mf_function_getinputs = loadFunctionByLookup(lookupMethod, "lib3mf_function_getinputs");
		lib3mf_function_removeinput = loadFunctionByLookup(lookupMethod, "lib3mf_function_removeinput");
		lib3mf_function_addoutput = loadFunctionByLookup(lookupMethod, "lib3mf_function_addoutput");
		lib3mf_function_getoutputs = loadFunctionByLookup(lookupMethod, "lib3mf_function_getoutputs");
		lib3mf_function_removeoutput = loadFunctionByLookup(lookupMethod, "lib3mf_function_removeoutput");
		lib3mf_function_findinput = loadFunctionByLookup(lookupMethod, "lib3mf_function_findinput");
		lib3mf_function_findoutput = loadFunctionByLookup(lookupMethod, "lib3mf_function_findoutput");
		lib3mf_implicitfunction_getidentifier = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_getidentifier");
		lib3mf_implicitfunction_setidentifier = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_setidentifier");
		lib3mf_implicitfunction_addnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addnode");
		lib3mf_implicitfunction_addsinnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addsinnode");
		lib3mf_implicitfunction_addcosnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addcosnode");
		lib3mf_implicitfunction_addtannode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addtannode");
		lib3mf_implicitfunction_addarcsinnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addarcsinnode");
		lib3mf_implicitfunction_addarccosnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addarccosnode");
		lib3mf_implicitfunction_addarctan2node = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addarctan2node");
		lib3mf_implicitfunction_addsinhnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addsinhnode");
		lib3mf_implicitfunction_addcoshnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addcoshnode");
		lib3mf_implicitfunction_addtanhnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addtanhnode");
		lib3mf_implicitfunction_addroundnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addroundnode");
		lib3mf_implicitfunction_addceilnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addceilnode");
		lib3mf_implicitfunction_addfloornode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addfloornode");
		lib3mf_implicitfunction_addsignnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addsignnode");
		lib3mf_implicitfunction_addfractnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addfractnode");
		lib3mf_implicitfunction_addabsnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addabsnode");
		lib3mf_implicitfunction_addexpnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addexpnode");
		lib3mf_implicitfunction_addlognode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addlognode");
		lib3mf_implicitfunction_addlog2node = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addlog2node");
		lib3mf_implicitfunction_addlog10node = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addlog10node");
		lib3mf_implicitfunction_addlengthnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addlengthnode");
		lib3mf_implicitfunction_addtransposenode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addtransposenode");
		lib3mf_implicitfunction_addinversenode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addinversenode");
		lib3mf_implicitfunction_addsqrtnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addsqrtnode");
		lib3mf_implicitfunction_addresourceidnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addresourceidnode");
		lib3mf_implicitfunction_addadditionnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addadditionnode");
		lib3mf_implicitfunction_addsubtractionnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addsubtractionnode");
		lib3mf_implicitfunction_addmultiplicationnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addmultiplicationnode");
		lib3mf_implicitfunction_adddivisionnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_adddivisionnode");
		lib3mf_implicitfunction_adddotnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_adddotnode");
		lib3mf_implicitfunction_addcrossnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addcrossnode");
		lib3mf_implicitfunction_addmatvecmultiplicationnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addmatvecmultiplicationnode");
		lib3mf_implicitfunction_addminnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addminnode");
		lib3mf_implicitfunction_addmaxnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addmaxnode");
		lib3mf_implicitfunction_addfmodnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addfmodnode");
		lib3mf_implicitfunction_addpownode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addpownode");
		lib3mf_implicitfunction_addselectnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addselectnode");
		lib3mf_implicitfunction_addclampnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addclampnode");
		lib3mf_implicitfunction_addcomposevectornode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addcomposevectornode");
		lib3mf_implicitfunction_addvectorfromscalarnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addvectorfromscalarnode");
		lib3mf_implicitfunction_adddecomposevectornode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_adddecomposevectornode");
		lib3mf_implicitfunction_addcomposematrixnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addcomposematrixnode");
		lib3mf_implicitfunction_addmatrixfromrowsnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addmatrixfromrowsnode");
		lib3mf_implicitfunction_addmatrixfromcolumnsnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addmatrixfromcolumnsnode");
		lib3mf_implicitfunction_addconstantnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addconstantnode");
		lib3mf_implicitfunction_addconstvecnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addconstvecnode");
		lib3mf_implicitfunction_addconstmatnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addconstmatnode");
		lib3mf_implicitfunction_addmeshnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addmeshnode");
		lib3mf_implicitfunction_addunsignedmeshnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addunsignedmeshnode");
		lib3mf_implicitfunction_addbeamlatticenode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addbeamlatticenode");
		lib3mf_implicitfunction_addfunctiongradientnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addfunctiongradientnode");
		lib3mf_implicitfunction_addnormalizedistancenode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addnormalizedistancenode");
		lib3mf_implicitfunction_addfunctioncallnode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addfunctioncallnode");
		lib3mf_implicitfunction_getnodes = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_getnodes");
		lib3mf_implicitfunction_removenode = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_removenode");
		lib3mf_implicitfunction_addlink = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addlink");
		lib3mf_implicitfunction_addlinkbynames = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_addlinkbynames");
		lib3mf_implicitfunction_clear = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_clear");
		lib3mf_implicitfunction_sortnodestopologically = loadFunctionByLookup(lookupMethod, "lib3mf_implicitfunction_sortnodestopologically");
		lib3mf_functionfromimage3d_getimage3d = loadFunctionByLookup(lookupMethod, "lib3mf_functionfromimage3d_getimage3d");
		lib3mf_functionfromimage3d_setimage3d = loadFunctionByLookup(lookupMethod, "lib3mf_functionfromimage3d_setimage3d");
		lib3mf_functionfromimage3d_setfilter = loadFunctionByLookup(lookupMethod, "lib3mf_functionfromimage3d_setfilter");
		lib3mf_functionfromimage3d_getfilter = loadFunctionByLookup(lookupMethod, "lib3mf_functionfromimage3d_getfilter");
		lib3mf_functionfromimage3d_settilestyles = loadFunctionByLookup(lookupMethod, "lib3mf_functionfromimage3d_settilestyles");
		lib3mf_functionfromimage3d_gettilestyles = loadFunctionByLookup(lookupMethod, "lib3mf_functionfromimage3d_gettilestyles");
		lib3mf_functionfromimage3d_getoffset = loadFunctionByLookup(lookupMethod, "lib3mf_functionfromimage3d_getoffset");
		lib3mf_functionfromimage3d_setoffset = loadFunctionByLookup(lookupMethod, "lib3mf_functionfromimage3d_setoffset");
		lib3mf_functionfromimage3d_getscale = loadFunctionByLookup(lookupMethod, "lib3mf_functionfromimage3d_getscale");
		lib3mf_functionfromimage3d_setscale = loadFunctionByLookup(lookupMethod, "lib3mf_functionfromimage3d_setscale");
		lib3mf_builditem_getobjectresource = loadFunctionByLookup(lookupMethod, "lib3mf_builditem_getobjectresource");
		lib3mf_builditem_getuuid = loadFunctionByLookup(lookupMethod, "lib3mf_builditem_getuuid");
		lib3mf_builditem_setuuid = loadFunctionByLookup(lookupMethod, "lib3mf_builditem_setuuid");
		lib3mf_builditem_getobjectresourceid = loadFunctionByLookup(lookupMethod, "lib3mf_builditem_getobjectresourceid");
		lib3mf_builditem_hasobjecttransform = loadFunctionByLookup(lookupMethod, "lib3mf_builditem_hasobjecttransform");
		lib3mf_builditem_getobjecttransform = loadFunctionByLookup(lookupMethod, "lib3mf_builditem_getobjecttransform");
		lib3mf_builditem_setobjecttransform = loadFunctionByLookup(lookupMethod, "lib3mf_builditem_setobjecttransform");
		lib3mf_builditem_getpartnumber = loadFunctionByLookup(lookupMethod, "lib3mf_builditem_getpartnumber");
		lib3mf_builditem_setpartnumber = loadFunctionByLookup(lookupMethod, "lib3mf_builditem_setpartnumber");
		lib3mf_builditem_getmetadatagroup = loadFunctionByLookup(lookupMethod, "lib3mf_builditem_getmetadatagroup");
		lib3mf_builditem_getoutbox = loadFunctionByLookup(lookupMethod, "lib3mf_builditem_getoutbox");
		lib3mf_builditemiterator_movenext = loadFunctionByLookup(lookupMethod, "lib3mf_builditemiterator_movenext");
		lib3mf_builditemiterator_moveprevious = loadFunctionByLookup(lookupMethod, "lib3mf_builditemiterator_moveprevious");
		lib3mf_builditemiterator_getcurrent = loadFunctionByLookup(lookupMethod, "lib3mf_builditemiterator_getcurrent");
		lib3mf_builditemiterator_clone = loadFunctionByLookup(lookupMethod, "lib3mf_builditemiterator_clone");
		lib3mf_builditemiterator_count = loadFunctionByLookup(lookupMethod, "lib3mf_builditemiterator_count");
		lib3mf_slice_setvertices = loadFunctionByLookup(lookupMethod, "lib3mf_slice_setvertices");
		lib3mf_slice_getvertices = loadFunctionByLookup(lookupMethod, "lib3mf_slice_getvertices");
		lib3mf_slice_getvertexcount = loadFunctionByLookup(lookupMethod, "lib3mf_slice_getvertexcount");
		lib3mf_slice_addpolygon = loadFunctionByLookup(lookupMethod, "lib3mf_slice_addpolygon");
		lib3mf_slice_getpolygoncount = loadFunctionByLookup(lookupMethod, "lib3mf_slice_getpolygoncount");
		lib3mf_slice_setpolygonindices = loadFunctionByLookup(lookupMethod, "lib3mf_slice_setpolygonindices");
		lib3mf_slice_getpolygonindices = loadFunctionByLookup(lookupMethod, "lib3mf_slice_getpolygonindices");
		lib3mf_slice_getpolygonindexcount = loadFunctionByLookup(lookupMethod, "lib3mf_slice_getpolygonindexcount");
		lib3mf_slice_getztop = loadFunctionByLookup(lookupMethod, "lib3mf_slice_getztop");
		lib3mf_slicestack_getbottomz = loadFunctionByLookup(lookupMethod, "lib3mf_slicestack_getbottomz");
		lib3mf_slicestack_getslicecount = loadFunctionByLookup(lookupMethod, "lib3mf_slicestack_getslicecount");
		lib3mf_slicestack_getslice = loadFunctionByLookup(lookupMethod, "lib3mf_slicestack_getslice");
		lib3mf_slicestack_addslice = loadFunctionByLookup(lookupMethod, "lib3mf_slicestack_addslice");
		lib3mf_slicestack_getslicerefcount = loadFunctionByLookup(lookupMethod, "lib3mf_slicestack_getslicerefcount");
		lib3mf_slicestack_addslicestackreference = loadFunctionByLookup(lookupMethod, "lib3mf_slicestack_addslicestackreference");
		lib3mf_slicestack_getslicestackreference = loadFunctionByLookup(lookupMethod, "lib3mf_slicestack_getslicestackreference");
		lib3mf_slicestack_collapseslicereferences = loadFunctionByLookup(lookupMethod, "lib3mf_slicestack_collapseslicereferences");
		lib3mf_slicestack_setownpath = loadFunctionByLookup(lookupMethod, "lib3mf_slicestack_setownpath");
		lib3mf_slicestack_getownpath = loadFunctionByLookup(lookupMethod, "lib3mf_slicestack_getownpath");
		lib3mf_consumer_getconsumerid = loadFunctionByLookup(lookupMethod, "lib3mf_consumer_getconsumerid");
		lib3mf_consumer_getkeyid = loadFunctionByLookup(lookupMethod, "lib3mf_consumer_getkeyid");
		lib3mf_consumer_getkeyvalue = loadFunctionByLookup(lookupMethod, "lib3mf_consumer_getkeyvalue");
		lib3mf_accessright_getconsumer = loadFunctionByLookup(lookupMethod, "lib3mf_accessright_getconsumer");
		lib3mf_accessright_getwrappingalgorithm = loadFunctionByLookup(lookupMethod, "lib3mf_accessright_getwrappingalgorithm");
		lib3mf_accessright_getmgfalgorithm = loadFunctionByLookup(lookupMethod, "lib3mf_accessright_getmgfalgorithm");
		lib3mf_accessright_getdigestmethod = loadFunctionByLookup(lookupMethod, "lib3mf_accessright_getdigestmethod");
		lib3mf_contentencryptionparams_getencryptionalgorithm = loadFunctionByLookup(lookupMethod, "lib3mf_contentencryptionparams_getencryptionalgorithm");
		lib3mf_contentencryptionparams_getkey = loadFunctionByLookup(lookupMethod, "lib3mf_contentencryptionparams_getkey");
		lib3mf_contentencryptionparams_getinitializationvector = loadFunctionByLookup(lookupMethod, "lib3mf_contentencryptionparams_getinitializationvector");
		lib3mf_contentencryptionparams_getauthenticationtag = loadFunctionByLookup(lookupMethod, "lib3mf_contentencryptionparams_getauthenticationtag");
		lib3mf_contentencryptionparams_setauthenticationtag = loadFunctionByLookup(lookupMethod, "lib3mf_contentencryptionparams_setauthenticationtag");
		lib3mf_contentencryptionparams_getadditionalauthenticationdata = loadFunctionByLookup(lookupMethod, "lib3mf_contentencryptionparams_getadditionalauthenticationdata");
		lib3mf_contentencryptionparams_getdescriptor = loadFunctionByLookup(lookupMethod, "lib3mf_contentencryptionparams_getdescriptor");
		lib3mf_contentencryptionparams_getkeyuuid = loadFunctionByLookup(lookupMethod, "lib3mf_contentencryptionparams_getkeyuuid");
		lib3mf_resourcedata_getpath = loadFunctionByLookup(lookupMethod, "lib3mf_resourcedata_getpath");
		lib3mf_resourcedata_getencryptionalgorithm = loadFunctionByLookup(lookupMethod, "lib3mf_resourcedata_getencryptionalgorithm");
		lib3mf_resourcedata_getcompression = loadFunctionByLookup(lookupMethod, "lib3mf_resourcedata_getcompression");
		lib3mf_resourcedata_getadditionalauthenticationdata = loadFunctionByLookup(lookupMethod, "lib3mf_resourcedata_getadditionalauthenticationdata");
		lib3mf_resourcedatagroup_getkeyuuid = loadFunctionByLookup(lookupMethod, "lib3mf_resourcedatagroup_getkeyuuid");
		lib3mf_resourcedatagroup_addaccessright = loadFunctionByLookup(lookupMethod, "lib3mf_resourcedatagroup_addaccessright");
		lib3mf_resourcedatagroup_findaccessrightbyconsumer = loadFunctionByLookup(lookupMethod, "lib3mf_resourcedatagroup_findaccessrightbyconsumer");
		lib3mf_resourcedatagroup_removeaccessright = loadFunctionByLookup(lookupMethod, "lib3mf_resourcedatagroup_removeaccessright");
		lib3mf_keystore_addconsumer = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_addconsumer");
		lib3mf_keystore_getconsumercount = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_getconsumercount");
		lib3mf_keystore_getconsumer = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_getconsumer");
		lib3mf_keystore_removeconsumer = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_removeconsumer");
		lib3mf_keystore_findconsumer = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_findconsumer");
		lib3mf_keystore_getresourcedatagroupcount = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_getresourcedatagroupcount");
		lib3mf_keystore_addresourcedatagroup = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_addresourcedatagroup");
		lib3mf_keystore_getresourcedatagroup = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_getresourcedatagroup");
		lib3mf_keystore_removeresourcedatagroup = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_removeresourcedatagroup");
		lib3mf_keystore_findresourcedatagroup = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_findresourcedatagroup");
		lib3mf_keystore_addresourcedata = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_addresourcedata");
		lib3mf_keystore_removeresourcedata = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_removeresourcedata");
		lib3mf_keystore_findresourcedata = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_findresourcedata");
		lib3mf_keystore_getresourcedatacount = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_getresourcedatacount");
		lib3mf_keystore_getresourcedata = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_getresourcedata");
		lib3mf_keystore_getuuid = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_getuuid");
		lib3mf_keystore_setuuid = loadFunctionByLookup(lookupMethod, "lib3mf_keystore_setuuid");
		lib3mf_model_rootmodelpart = loadFunctionByLookup(lookupMethod, "lib3mf_model_rootmodelpart");
		lib3mf_model_findorcreatepackagepart = loadFunctionByLookup(lookupMethod, "lib3mf_model_findorcreatepackagepart");
		lib3mf_model_setunit = loadFunctionByLookup(lookupMethod, "lib3mf_model_setunit");
		lib3mf_model_getunit = loadFunctionByLookup(lookupMethod, "lib3mf_model_getunit");
		lib3mf_model_getlanguage = loadFunctionByLookup(lookupMethod, "lib3mf_model_getlanguage");
		lib3mf_model_setlanguage = loadFunctionByLookup(lookupMethod, "lib3mf_model_setlanguage");
		lib3mf_model_querywriter = loadFunctionByLookup(lookupMethod, "lib3mf_model_querywriter");
		lib3mf_model_queryreader = loadFunctionByLookup(lookupMethod, "lib3mf_model_queryreader");
		lib3mf_model_getresourcebyid = loadFunctionByLookup(lookupMethod, "lib3mf_model_getresourcebyid");
		lib3mf_model_gettexture2dbyid = loadFunctionByLookup(lookupMethod, "lib3mf_model_gettexture2dbyid");
		lib3mf_model_getpropertytypebyid = loadFunctionByLookup(lookupMethod, "lib3mf_model_getpropertytypebyid");
		lib3mf_model_getbasematerialgroupbyid = loadFunctionByLookup(lookupMethod, "lib3mf_model_getbasematerialgroupbyid");
		lib3mf_model_gettexture2dgroupbyid = loadFunctionByLookup(lookupMethod, "lib3mf_model_gettexture2dgroupbyid");
		lib3mf_model_getcompositematerialsbyid = loadFunctionByLookup(lookupMethod, "lib3mf_model_getcompositematerialsbyid");
		lib3mf_model_getmultipropertygroupbyid = loadFunctionByLookup(lookupMethod, "lib3mf_model_getmultipropertygroupbyid");
		lib3mf_model_getmeshobjectbyid = loadFunctionByLookup(lookupMethod, "lib3mf_model_getmeshobjectbyid");
		lib3mf_model_getcomponentsobjectbyid = loadFunctionByLookup(lookupMethod, "lib3mf_model_getcomponentsobjectbyid");
		lib3mf_model_getcolorgroupbyid = loadFunctionByLookup(lookupMethod, "lib3mf_model_getcolorgroupbyid");
		lib3mf_model_getslicestackbyid = loadFunctionByLookup(lookupMethod, "lib3mf_model_getslicestackbyid");
		lib3mf_model_getlevelsetbyid = loadFunctionByLookup(lookupMethod, "lib3mf_model_getlevelsetbyid");
		lib3mf_model_getbuilduuid = loadFunctionByLookup(lookupMethod, "lib3mf_model_getbuilduuid");
		lib3mf_model_setbuilduuid = loadFunctionByLookup(lookupMethod, "lib3mf_model_setbuilduuid");
		lib3mf_model_getbuilditems = loadFunctionByLookup(lookupMethod, "lib3mf_model_getbuilditems");
		lib3mf_model_getoutbox = loadFunctionByLookup(lookupMethod, "lib3mf_model_getoutbox");
		lib3mf_model_getresources = loadFunctionByLookup(lookupMethod, "lib3mf_model_getresources");
		lib3mf_model_getobjects = loadFunctionByLookup(lookupMethod, "lib3mf_model_getobjects");
		lib3mf_model_getmeshobjects = loadFunctionByLookup(lookupMethod, "lib3mf_model_getmeshobjects");
		lib3mf_model_getcomponentsobjects = loadFunctionByLookup(lookupMethod, "lib3mf_model_getcomponentsobjects");
		lib3mf_model_gettexture2ds = loadFunctionByLookup(lookupMethod, "lib3mf_model_gettexture2ds");
		lib3mf_model_getbasematerialgroups = loadFunctionByLookup(lookupMethod, "lib3mf_model_getbasematerialgroups");
		lib3mf_model_getcolorgroups = loadFunctionByLookup(lookupMethod, "lib3mf_model_getcolorgroups");
		lib3mf_model_gettexture2dgroups = loadFunctionByLookup(lookupMethod, "lib3mf_model_gettexture2dgroups");
		lib3mf_model_getcompositematerials = loadFunctionByLookup(lookupMethod, "lib3mf_model_getcompositematerials");
		lib3mf_model_getmultipropertygroups = loadFunctionByLookup(lookupMethod, "lib3mf_model_getmultipropertygroups");
		lib3mf_model_getslicestacks = loadFunctionByLookup(lookupMethod, "lib3mf_model_getslicestacks");
		lib3mf_model_getimage3ds = loadFunctionByLookup(lookupMethod, "lib3mf_model_getimage3ds");
		lib3mf_model_mergetomodel = loadFunctionByLookup(lookupMethod, "lib3mf_model_mergetomodel");
		lib3mf_model_mergefrommodel = loadFunctionByLookup(lookupMethod, "lib3mf_model_mergefrommodel");
		lib3mf_model_addmeshobject = loadFunctionByLookup(lookupMethod, "lib3mf_model_addmeshobject");
		lib3mf_model_addcomponentsobject = loadFunctionByLookup(lookupMethod, "lib3mf_model_addcomponentsobject");
		lib3mf_model_addslicestack = loadFunctionByLookup(lookupMethod, "lib3mf_model_addslicestack");
		lib3mf_model_addtexture2dfromattachment = loadFunctionByLookup(lookupMethod, "lib3mf_model_addtexture2dfromattachment");
		lib3mf_model_addbasematerialgroup = loadFunctionByLookup(lookupMethod, "lib3mf_model_addbasematerialgroup");
		lib3mf_model_addcolorgroup = loadFunctionByLookup(lookupMethod, "lib3mf_model_addcolorgroup");
		lib3mf_model_addtexture2dgroup = loadFunctionByLookup(lookupMethod, "lib3mf_model_addtexture2dgroup");
		lib3mf_model_addcompositematerials = loadFunctionByLookup(lookupMethod, "lib3mf_model_addcompositematerials");
		lib3mf_model_addmultipropertygroup = loadFunctionByLookup(lookupMethod, "lib3mf_model_addmultipropertygroup");
		lib3mf_model_addimagestack = loadFunctionByLookup(lookupMethod, "lib3mf_model_addimagestack");
		lib3mf_model_getimagestackbyid = loadFunctionByLookup(lookupMethod, "lib3mf_model_getimagestackbyid");
		lib3mf_model_addbuilditem = loadFunctionByLookup(lookupMethod, "lib3mf_model_addbuilditem");
		lib3mf_model_removebuilditem = loadFunctionByLookup(lookupMethod, "lib3mf_model_removebuilditem");
		lib3mf_model_getmetadatagroup = loadFunctionByLookup(lookupMethod, "lib3mf_model_getmetadatagroup");
		lib3mf_model_addattachment = loadFunctionByLookup(lookupMethod, "lib3mf_model_addattachment");
		lib3mf_model_removeattachment = loadFunctionByLookup(lookupMethod, "lib3mf_model_removeattachment");
		lib3mf_model_getattachment = loadFunctionByLookup(lookupMethod, "lib3mf_model_getattachment");
		lib3mf_model_findattachment = loadFunctionByLookup(lookupMethod, "lib3mf_model_findattachment");
		lib3mf_model_getattachmentcount = loadFunctionByLookup(lookupMethod, "lib3mf_model_getattachmentcount");
		lib3mf_model_haspackagethumbnailattachment = loadFunctionByLookup(lookupMethod, "lib3mf_model_haspackagethumbnailattachment");
		lib3mf_model_createpackagethumbnailattachment = loadFunctionByLookup(lookupMethod, "lib3mf_model_createpackagethumbnailattachment");
		lib3mf_model_getpackagethumbnailattachment = loadFunctionByLookup(lookupMethod, "lib3mf_model_getpackagethumbnailattachment");
		lib3mf_model_removepackagethumbnailattachment = loadFunctionByLookup(lookupMethod, "lib3mf_model_removepackagethumbnailattachment");
		lib3mf_model_addcustomcontenttype = loadFunctionByLookup(lookupMethod, "lib3mf_model_addcustomcontenttype");
		lib3mf_model_removecustomcontenttype = loadFunctionByLookup(lookupMethod, "lib3mf_model_removecustomcontenttype");
		lib3mf_model_setrandomnumbercallback = loadFunctionByLookup(lookupMethod, "lib3mf_model_setrandomnumbercallback");
		lib3mf_model_getkeystore = loadFunctionByLookup(lookupMethod, "lib3mf_model_getkeystore");
		lib3mf_model_getfunctions = loadFunctionByLookup(lookupMethod, "lib3mf_model_getfunctions");
		lib3mf_model_addimplicitfunction = loadFunctionByLookup(lookupMethod, "lib3mf_model_addimplicitfunction");
		lib3mf_model_addfunctionfromimage3d = loadFunctionByLookup(lookupMethod, "lib3mf_model_addfunctionfromimage3d");
		lib3mf_model_addvolumedata = loadFunctionByLookup(lookupMethod, "lib3mf_model_addvolumedata");
		lib3mf_model_addlevelset = loadFunctionByLookup(lookupMethod, "lib3mf_model_addlevelset");
		lib3mf_model_getlevelsets = loadFunctionByLookup(lookupMethod, "lib3mf_model_getlevelsets");
		lib3mf_model_removeresource = loadFunctionByLookup(lookupMethod, "lib3mf_model_removeresource");
	}

	protected void checkError(Base instance, int errorCode) throws Lib3MFException {
		if (instance != null && instance.mWrapper != this) {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDCAST, "invalid wrapper call");
		}
		if (errorCode != Lib3MFException.LIB3MF_SUCCESS) {
			if (instance != null) {
				GetLastErrorResult result = getLastError(instance);
				throw new Lib3MFException(errorCode, result.LastErrorString);
			} else {
				throw new Lib3MFException(errorCode, "");
			}
		}
	}

	private com.sun.jna.Function loadFunctionByLookup(com.sun.jna.Function lookupMethod, String functionName) throws Lib3MFException {
		byte[] bytes = functionName.getBytes(StandardCharsets.UTF_8);
		Memory name = new Memory(bytes.length+1);
		name.write(0, bytes, 0, bytes.length);
		name.setByte(bytes.length, (byte)0);
		Pointer address = new Memory(8);
		java.lang.Object[] addressParam = new java.lang.Object[]{name, address};
		checkError(null, lookupMethod.invokeInt(addressParam));
		return com.sun.jna.Function.getFunction(address.getPointer(0));
	}

	/**
	 * retrieves the binary version of this library.
	 *
	 * @return GetLibraryVersion Result Tuple
	 * @throws Lib3MFException
	 */
	public GetLibraryVersionResult getLibraryVersion() throws Lib3MFException {
		Pointer bufferMajor = new Memory(4);
		Pointer bufferMinor = new Memory(4);
		Pointer bufferMicro = new Memory(4);
		checkError(null, lib3mf_getlibraryversion.invokeInt(new java.lang.Object[]{bufferMajor, bufferMinor, bufferMicro}));
		GetLibraryVersionResult returnTuple = new GetLibraryVersionResult();
		returnTuple.Major = bufferMajor.getInt(0);
		returnTuple.Minor = bufferMinor.getInt(0);
		returnTuple.Micro = bufferMicro.getInt(0);
		return returnTuple;
	}

	public static class GetLibraryVersionResult {
		/**
		 * returns the major version of this library
		 */
		public int Major;

		/**
		 * returns the minor version of this library
		 */
		public int Minor;

		/**
		 * returns the micro version of this library
		 */
		public int Micro;

	}
	/**
	 * retrieves prerelease information of this library.
	 *
	 * @return GetPrereleaseInformation Result Tuple
	 * @throws Lib3MFException
	 */
	public GetPrereleaseInformationResult getPrereleaseInformation() throws Lib3MFException {
		Pointer bufferHasPrereleaseInfo = new Memory(1);
		Pointer bytesNeededPrereleaseInfo = new Memory(4);
		checkError(null, lib3mf_getprereleaseinformation.invokeInt(new java.lang.Object[]{bufferHasPrereleaseInfo, 0, bytesNeededPrereleaseInfo, null}));
		int sizePrereleaseInfo = bytesNeededPrereleaseInfo.getInt(0);
		Pointer bufferPrereleaseInfo = new Memory(sizePrereleaseInfo);
		checkError(null, lib3mf_getprereleaseinformation.invokeInt(new java.lang.Object[]{bufferHasPrereleaseInfo, sizePrereleaseInfo, bytesNeededPrereleaseInfo, bufferPrereleaseInfo}));
		GetPrereleaseInformationResult returnTuple = new GetPrereleaseInformationResult();
		returnTuple.HasPrereleaseInfo = bufferHasPrereleaseInfo.getByte(0) != 0;
		returnTuple.PrereleaseInfo = new String(bufferPrereleaseInfo.getByteArray(0, sizePrereleaseInfo - 1), StandardCharsets.UTF_8);
		return returnTuple;
	}

	public static class GetPrereleaseInformationResult {
		/**
		 * Does the library provide prerelease version?
		 */
		public boolean HasPrereleaseInfo;

		/**
		 * retrieves prerelease information of this library.
		 */
		public String PrereleaseInfo;

	}
	/**
	 * retrieves build information of this library.
	 *
	 * @return GetBuildInformation Result Tuple
	 * @throws Lib3MFException
	 */
	public GetBuildInformationResult getBuildInformation() throws Lib3MFException {
		Pointer bufferHasBuildInfo = new Memory(1);
		Pointer bytesNeededBuildInformation = new Memory(4);
		checkError(null, lib3mf_getbuildinformation.invokeInt(new java.lang.Object[]{bufferHasBuildInfo, 0, bytesNeededBuildInformation, null}));
		int sizeBuildInformation = bytesNeededBuildInformation.getInt(0);
		Pointer bufferBuildInformation = new Memory(sizeBuildInformation);
		checkError(null, lib3mf_getbuildinformation.invokeInt(new java.lang.Object[]{bufferHasBuildInfo, sizeBuildInformation, bytesNeededBuildInformation, bufferBuildInformation}));
		GetBuildInformationResult returnTuple = new GetBuildInformationResult();
		returnTuple.HasBuildInfo = bufferHasBuildInfo.getByte(0) != 0;
		returnTuple.BuildInformation = new String(bufferBuildInformation.getByteArray(0, sizeBuildInformation - 1), StandardCharsets.UTF_8);
		return returnTuple;
	}

	public static class GetBuildInformationResult {
		/**
		 * Does the library provide build version?
		 */
		public boolean HasBuildInfo;

		/**
		 * retrieves build information of this library.
		 */
		public String BuildInformation;

	}
	/**
	 * retrieves whether a specification is supported, and if so, which version.
	 *
	 * @param specificationURL URL of extension to check
	 * @return GetSpecificationVersion Result Tuple
	 * @throws Lib3MFException
	 */
	public GetSpecificationVersionResult getSpecificationVersion(String specificationURL) throws Lib3MFException {
		byte[] bytesSpecificationURL = specificationURL.getBytes(StandardCharsets.UTF_8);
		Memory bufferSpecificationURL = new Memory(bytesSpecificationURL.length + 1);
		bufferSpecificationURL.write(0, bytesSpecificationURL, 0, bytesSpecificationURL.length);
		bufferSpecificationURL.setByte(bytesSpecificationURL.length, (byte)0);
		Pointer bufferIsSupported = new Memory(1);
		Pointer bufferMajor = new Memory(4);
		Pointer bufferMinor = new Memory(4);
		Pointer bufferMicro = new Memory(4);
		checkError(null, lib3mf_getspecificationversion.invokeInt(new java.lang.Object[]{bufferSpecificationURL, bufferIsSupported, bufferMajor, bufferMinor, bufferMicro}));
		GetSpecificationVersionResult returnTuple = new GetSpecificationVersionResult();
		returnTuple.IsSupported = bufferIsSupported.getByte(0) != 0;
		returnTuple.Major = bufferMajor.getInt(0);
		returnTuple.Minor = bufferMinor.getInt(0);
		returnTuple.Micro = bufferMicro.getInt(0);
		return returnTuple;
	}

	public static class GetSpecificationVersionResult {
		/**
		 * returns whether this specification is supported
		 */
		public boolean IsSupported;

		/**
		 * returns the major version of the extension (if IsSupported)
		 */
		public int Major;

		/**
		 * returns the minor version of the extension (if IsSupported)
		 */
		public int Minor;

		/**
		 * returns the micro version of the extension (if IsSupported)
		 */
		public int Micro;

	}
	/**
	 * creates an empty model instance.
	 *
	 * @return returns an empty model instance
	 * @throws Lib3MFException
	 */
	public Model createModel() throws Lib3MFException {
		Pointer bufferModel = new Memory(8);
		checkError(null, lib3mf_createmodel.invokeInt(new java.lang.Object[]{bufferModel}));
		Pointer valueModel = bufferModel.getPointer(0);
		Model model = null;
		if (valueModel == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Model was a null pointer");
		}
		model = this.PolymorphicFactory(valueModel, Model.class);
		return model;
	}

	/**
	 * releases shared ownership of an object instance
	 *
	 * @param instance the object instance to release
	 * @throws Lib3MFException
	 */
	public void release(Base instance) throws Lib3MFException {
		Pointer instanceHandle = null;
		if (instance != null) {
			instanceHandle = instance.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Instance is a null value.");
		}
		checkError(null, lib3mf_release.invokeInt(new java.lang.Object[]{instanceHandle}));
	}

	/**
	 * acquires shared ownership of an object instance
	 *
	 * @param instance the object instance to acquire
	 * @throws Lib3MFException
	 */
	public void acquire(Base instance) throws Lib3MFException {
		Pointer instanceHandle = null;
		if (instance != null) {
			instanceHandle = instance.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Instance is a null value.");
		}
		checkError(null, lib3mf_acquire.invokeInt(new java.lang.Object[]{instanceHandle}));
	}

	/**
	 * Sets the journal file path
	 *
	 * @param journalPath File name of the journal file
	 * @throws Lib3MFException
	 */
	public void setJournal(String journalPath) throws Lib3MFException {
		byte[] bytesJournalPath = journalPath.getBytes(StandardCharsets.UTF_8);
		Memory bufferJournalPath = new Memory(bytesJournalPath.length + 1);
		bufferJournalPath.write(0, bytesJournalPath, 0, bytesJournalPath.length);
		bufferJournalPath.setByte(bytesJournalPath.length, (byte)0);
		checkError(null, lib3mf_setjournal.invokeInt(new java.lang.Object[]{bufferJournalPath}));
	}

	/**
	 * Retrieves the last error string of an instance
	 *
	 * @param instance Object where the error occured.
	 * @return GetLastError Result Tuple
	 * @throws Lib3MFException
	 */
	public GetLastErrorResult getLastError(Base instance) throws Lib3MFException {
		Pointer instanceHandle = null;
		if (instance != null) {
			instanceHandle = instance.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Instance is a null value.");
		}
		Pointer bytesNeededLastErrorString = new Memory(4);
		Pointer bufferHasLastError = new Memory(1);
		checkError(null, lib3mf_getlasterror.invokeInt(new java.lang.Object[]{instanceHandle, 0, bytesNeededLastErrorString, null, bufferHasLastError}));
		int sizeLastErrorString = bytesNeededLastErrorString.getInt(0);
		Pointer bufferLastErrorString = new Memory(sizeLastErrorString);
		checkError(null, lib3mf_getlasterror.invokeInt(new java.lang.Object[]{instanceHandle, sizeLastErrorString, bytesNeededLastErrorString, bufferLastErrorString, bufferHasLastError}));
		GetLastErrorResult returnTuple = new GetLastErrorResult();
		returnTuple.LastErrorString = new String(bufferLastErrorString.getByteArray(0, sizeLastErrorString - 1), StandardCharsets.UTF_8);
		returnTuple.HasLastError = bufferHasLastError.getByte(0) != 0;
		return returnTuple;
	}

	public static class GetLastErrorResult {
		/**
		 * Last Error String
		 */
		public String LastErrorString;

		/**
		 * Returns if the instance has a last error.
		 */
		public boolean HasLastError;

	}
	/**
	 * Returns the address of the SymbolLookupMethod
	 *
	 * @return Address of the SymbolAddressMethod
	 * @throws Lib3MFException
	 */
	public Pointer getSymbolLookupMethod() throws Lib3MFException {
		Pointer bufferSymbolLookupMethod = new Memory(8);
		checkError(null, lib3mf_getsymbollookupmethod.invokeInt(new java.lang.Object[]{bufferSymbolLookupMethod}));
		return bufferSymbolLookupMethod.getPointer(0);
	}

	/**
	 * Return an English text for a progress identifier.|Note: this is the only function you can call from your callback function.
	 *
	 * @param theProgressIdentifier the progress identifier that is passed to the callback function
	 * @return English text for the progress identifier
	 * @throws Lib3MFException
	 */
	public String retrieveProgressMessage(Lib3MFWrapper.ProgressIdentifier theProgressIdentifier) throws Lib3MFException {
		Pointer bytesNeededProgressMessage = new Memory(4);
		checkError(null, lib3mf_retrieveprogressmessage.invokeInt(new java.lang.Object[]{Lib3MFWrapper.EnumConversion.convertProgressIdentifierToConst(theProgressIdentifier), 0, bytesNeededProgressMessage, null}));
		int sizeProgressMessage = bytesNeededProgressMessage.getInt(0);
		Pointer bufferProgressMessage = new Memory(sizeProgressMessage);
		checkError(null, lib3mf_retrieveprogressmessage.invokeInt(new java.lang.Object[]{Lib3MFWrapper.EnumConversion.convertProgressIdentifierToConst(theProgressIdentifier), sizeProgressMessage, bytesNeededProgressMessage, bufferProgressMessage}));
		return new String(bufferProgressMessage.getByteArray(0, sizeProgressMessage - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Creates a Color from uint8 RGBA values
	 *
	 * @param red Red value of color (0-255)
	 * @param green Green value of color (0-255)
	 * @param blue Blue value of color (0-255)
	 * @param alpha Alpha value of color (0-255)
	 * @return Assembled color
	 * @throws Lib3MFException
	 */
	public Color rGBAToColor(byte red, byte green, byte blue, byte alpha) throws Lib3MFException {
		Pointer bufferTheColor = new Memory(Color.SIZE);
		checkError(null, lib3mf_rgbatocolor.invokeInt(new java.lang.Object[]{red, green, blue, alpha, bufferTheColor}));
		Color theColor = new Color();
		theColor.readFromPointer(bufferTheColor, 0);
		return theColor;
	}

	/**
	 * Creates a Color from uint8 RGBA values
	 *
	 * @param red Red value of color (0-1)
	 * @param green Green value of color (0-1)
	 * @param blue Blue value of color (0-1)
	 * @param alpha Alpha value of color (0-1)
	 * @return Assembled color
	 * @throws Lib3MFException
	 */
	public Color floatRGBAToColor(float red, float green, float blue, float alpha) throws Lib3MFException {
		Pointer bufferTheColor = new Memory(Color.SIZE);
		checkError(null, lib3mf_floatrgbatocolor.invokeInt(new java.lang.Object[]{red, green, blue, alpha, bufferTheColor}));
		Color theColor = new Color();
		theColor.readFromPointer(bufferTheColor, 0);
		return theColor;
	}

	/**
	 * Calculates uint8-RGBA-values from a Color
	 *
	 * @param theColor Color to handle
	 * @return ColorToRGBA Result Tuple
	 * @throws Lib3MFException
	 */
	public ColorToRGBAResult colorToRGBA(Color theColor) throws Lib3MFException {
		Pointer bufferTheColor = new Memory(Color.SIZE);
		theColor.writeToPointer(bufferTheColor, 0);
		Pointer bufferRed = new Memory(1);
		Pointer bufferGreen = new Memory(1);
		Pointer bufferBlue = new Memory(1);
		Pointer bufferAlpha = new Memory(1);
		checkError(null, lib3mf_colortorgba.invokeInt(new java.lang.Object[]{bufferTheColor, bufferRed, bufferGreen, bufferBlue, bufferAlpha}));
		ColorToRGBAResult returnTuple = new ColorToRGBAResult();
		returnTuple.Red = bufferRed.getByte(0);
		returnTuple.Green = bufferGreen.getByte(0);
		returnTuple.Blue = bufferBlue.getByte(0);
		returnTuple.Alpha = bufferAlpha.getByte(0);
		return returnTuple;
	}

	public static class ColorToRGBAResult {
		/**
		 * Red value of color (0-255)
		 */
		public byte Red;

		/**
		 * Green value of color (0-255)
		 */
		public byte Green;

		/**
		 * Blue value of color (0-255)
		 */
		public byte Blue;

		/**
		 * Alpha value of color (0-255)
		 */
		public byte Alpha;

	}
	/**
	 * Calculates float-RGBA-values from a Color
	 *
	 * @param theColor Color to handle
	 * @return ColorToFloatRGBA Result Tuple
	 * @throws Lib3MFException
	 */
	public ColorToFloatRGBAResult colorToFloatRGBA(Color theColor) throws Lib3MFException {
		Pointer bufferTheColor = new Memory(Color.SIZE);
		theColor.writeToPointer(bufferTheColor, 0);
		Pointer bufferRed = new Memory(4);
		Pointer bufferGreen = new Memory(4);
		Pointer bufferBlue = new Memory(4);
		Pointer bufferAlpha = new Memory(4);
		checkError(null, lib3mf_colortofloatrgba.invokeInt(new java.lang.Object[]{bufferTheColor, bufferRed, bufferGreen, bufferBlue, bufferAlpha}));
		ColorToFloatRGBAResult returnTuple = new ColorToFloatRGBAResult();
		returnTuple.Red = bufferRed.getFloat(0);
		returnTuple.Green = bufferGreen.getFloat(0);
		returnTuple.Blue = bufferBlue.getFloat(0);
		returnTuple.Alpha = bufferAlpha.getFloat(0);
		return returnTuple;
	}

	public static class ColorToFloatRGBAResult {
		/**
		 * Red value of color (0-1)
		 */
		public float Red;

		/**
		 * Green value of color (0-1)
		 */
		public float Green;

		/**
		 * Blue value of color (0-1)
		 */
		public float Blue;

		/**
		 * Alpha value of color (0-1)
		 */
		public float Alpha;

	}
	/**
	 * Creates an identity transform
	 *
	 * @return Transformation matrix.
	 * @throws Lib3MFException
	 */
	public Transform getIdentityTransform() throws Lib3MFException {
		Pointer bufferTransform = new Memory(Transform.SIZE);
		checkError(null, lib3mf_getidentitytransform.invokeInt(new java.lang.Object[]{bufferTransform}));
		Transform transform = new Transform();
		transform.readFromPointer(bufferTransform, 0);
		return transform;
	}

	/**
	 * Creates a uniform scale transform
	 *
	 * @param factor Factor in X, Y and Z
	 * @return Transformation matrix.
	 * @throws Lib3MFException
	 */
	public Transform getUniformScaleTransform(float factor) throws Lib3MFException {
		Pointer bufferTransform = new Memory(Transform.SIZE);
		checkError(null, lib3mf_getuniformscaletransform.invokeInt(new java.lang.Object[]{factor, bufferTransform}));
		Transform transform = new Transform();
		transform.readFromPointer(bufferTransform, 0);
		return transform;
	}

	/**
	 * Creates a scale transform
	 *
	 * @param factorX Factor in X
	 * @param factorY Factor in Y
	 * @param factorZ Factor in Z
	 * @return Transformation matrix.
	 * @throws Lib3MFException
	 */
	public Transform getScaleTransform(float factorX, float factorY, float factorZ) throws Lib3MFException {
		Pointer bufferTransform = new Memory(Transform.SIZE);
		checkError(null, lib3mf_getscaletransform.invokeInt(new java.lang.Object[]{factorX, factorY, factorZ, bufferTransform}));
		Transform transform = new Transform();
		transform.readFromPointer(bufferTransform, 0);
		return transform;
	}

	/**
	 * Creates an translation transform
	 *
	 * @param vectorX Translation in X
	 * @param vectorY Translation in Y
	 * @param vectorZ Translation in Z
	 * @return Transformation matrix.
	 * @throws Lib3MFException
	 */
	public Transform getTranslationTransform(float vectorX, float vectorY, float vectorZ) throws Lib3MFException {
		Pointer bufferTransform = new Memory(Transform.SIZE);
		checkError(null, lib3mf_gettranslationtransform.invokeInt(new java.lang.Object[]{vectorX, vectorY, vectorZ, bufferTransform}));
		Transform transform = new Transform();
		transform.readFromPointer(bufferTransform, 0);
		return transform;
	}

	/**
	 * IMPORTANT: PolymorphicFactory method should not be used by application directly.
	 *            It's designed to be used on Lib3MFHandle object only once.
	 *            If it's used on any existing object as a form of dynamic cast then
	 *            Lib3MFWrapper::acquireInstance(Base object) must be called after instantiating new object.
	 *            This is important to keep reference count matching between application and library sides.
	*/
	public <T> T PolymorphicFactory(Pointer handle, Class<T> cls) {
		if (handle == Pointer.NULL)
		 return null;
		 Class[] cArg = new Class[2];
		 cArg[0] = Lib3MFWrapper.class;
		 cArg[1] = Pointer.class;
			
			try {
		   T obj = null;
		   Pointer bufferClassTypeId = new Memory(8);
		   checkError(null, lib3mf_base_classtypeid.invokeInt(new java.lang.Object[]{handle, bufferClassTypeId}));
		   long classTypeId = bufferClassTypeId.getLong(0);
		   
		   int msbId = (int)(classTypeId >> 32); 
		   int lsbId = (int)classTypeId; 
			switch(msbId) {
				case 0x0070021D: 
					switch(lsbId) {
						case 0x73AA89FD: obj = (T)(new LogNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::LogNode"
					}
				break;
				case 0x0437E27A: 
					switch(lsbId) {
						case 0xEF740121: obj = (T)(new FunctionGradientNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionGradientNode"
					}
				break;
				case 0x073F9103: 
					switch(lsbId) {
						case 0x81BF250D: obj = (T)(new MaxNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MaxNode"
					}
				break;
				case 0x0765C17C: 
					switch(lsbId) {
						case 0x952F24E3: obj = (T)(new FunctionCallNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionCallNode"
					}
				break;
				case 0x0C3B8536: 
					switch(lsbId) {
						case 0x9E9B25D3: obj = (T)(new MetaDataGroup(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MetaDataGroup"
					}
				break;
				case 0x0DCBEAFC: 
					switch(lsbId) {
						case 0xF83F3AAC: obj = (T)(new MatrixFromColumnsNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MatrixFromColumnsNode"
					}
				break;
				case 0x0E55A826: 
					switch(lsbId) {
						case 0xD377483E: obj = (T)(new PackagePart(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::PackagePart"
					}
				break;
				case 0x0F3A4EE9: 
					switch(lsbId) {
						case 0x8F7FEC0C: obj = (T)(new BeamLatticeNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::BeamLatticeNode"
					}
				break;
				case 0x10274A17: 
					switch(lsbId) {
						case 0x57C729C0: obj = (T)(new ColorGroupIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ColorGroupIterator"
					}
				break;
				case 0x106182D3: 
					switch(lsbId) {
						case 0x8CA5CFE3: obj = (T)(new CrossNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::CrossNode"
					}
				break;
				case 0x1127ED71: 
					switch(lsbId) {
						case 0xE05A9BD4: obj = (T)(new SelectNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::SelectNode"
					}
				break;
				case 0x13A2561F: 
					switch(lsbId) {
						case 0x0CFB712A: obj = (T)(new ImageStack(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ImageStack"
					}
				break;
				case 0x1A47A5E2: 
					switch(lsbId) {
						case 0x58E22EF9: obj = (T)(new ResourceData(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceData"
					}
				break;
				case 0x1CC9E0CC: 
					switch(lsbId) {
						case 0x082253C6: obj = (T)(new KeyStore(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::KeyStore"
					}
				break;
				case 0x1EF703D2: 
					switch(lsbId) {
						case 0x98223F2A: obj = (T)(new FmodNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::FmodNode"
					}
				break;
				case 0x2198BCF4: 
					switch(lsbId) {
						case 0xD8DF9C40: obj = (T)(new Slice(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Slice"
					}
				break;
				case 0x241FE6B4: 
					switch(lsbId) {
						case 0x817C3FE4: obj = (T)(new MaterialMapping(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MaterialMapping"
					}
				break;
				case 0x2614CC57: 
					switch(lsbId) {
						case 0x2AF350B7: obj = (T)(new TanNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::TanNode"
					}
				break;
				case 0x29985A62: 
					switch(lsbId) {
						case 0x8251A9CD: obj = (T)(new UnsignedMeshNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::UnsignedMeshNode"
					}
				break;
				case 0x2D86831D: 
					switch(lsbId) {
						case 0xA59FBE72: obj = (T)(new Reader(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Reader"
					}
				break;
				case 0x2DA2136F: 
					switch(lsbId) {
						case 0x577A779C: obj = (T)(new Object(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Object"
					}
				break;
				case 0x2E417B93: 
					switch(lsbId) {
						case 0x351375E2: obj = (T)(new VectorFromScalarNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::VectorFromScalarNode"
					}
				break;
				case 0x30CCDBE9: 
					switch(lsbId) {
						case 0x0E00B55B: obj = (T)(new BeamSet(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::BeamSet"
					}
				break;
				case 0x30D55F4D: 
					switch(lsbId) {
						case 0xB88FE0CA: obj = (T)(new Texture2DGroupIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroupIterator"
					}
				break;
				case 0x3390243A: 
					switch(lsbId) {
						case 0x8E2410F3: obj = (T)(new ExpNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ExpNode"
					}
				break;
				case 0x385C42FC: 
					switch(lsbId) {
						case 0x5609498A: obj = (T)(new AccessRight(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::AccessRight"
					}
				break;
				case 0x392A0F4C: 
					switch(lsbId) {
						case 0x041D249C: obj = (T)(new FloorNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::FloorNode"
					}
				break;
				case 0x3B3A6DC6: 
					switch(lsbId) {
						case 0xEC610497: obj = (T)(new MeshObject(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MeshObject"
					}
				break;
				case 0x3C7756A4: 
					switch(lsbId) {
						case 0x56F2D089: obj = (T)(new SinhNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::SinhNode"
					}
				break;
				case 0x3F8E5D08: 
					switch(lsbId) {
						case 0x2F966B1B: obj = (T)(new ConstantNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ConstantNode"
					}
				break;
				case 0x40E90353: 
					switch(lsbId) {
						case 0x63ACE65E: obj = (T)(new FunctionIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionIterator"
					}
				break;
				case 0x460F3515: 
					switch(lsbId) {
						case 0xE2621DBE: obj = (T)(new ResourceIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceIterator"
					}
				break;
				case 0x46F1DAC4: 
					switch(lsbId) {
						case 0x0581B304: obj = (T)(new VolumeDataComposite(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataComposite"
					}
				break;
				case 0x49C24B88: 
					switch(lsbId) {
						case 0x40C01F7E: obj = (T)(new ComposeVectorNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ComposeVectorNode"
					}
				break;
				case 0x4A993F91: 
					switch(lsbId) {
						case 0xE1DE256D: obj = (T)(new CoshNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::CoshNode"
					}
				break;
				case 0x4BD32B48: 
					switch(lsbId) {
						case 0x70FFC03B: obj = (T)(new Texture2DIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DIterator"
					}
				break;
				case 0x4DF17E76: 
					switch(lsbId) {
						case 0x926221C2: obj = (T)(new FunctionReference(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionReference"
					}
				break;
				case 0x4ECDB6A6: 
					switch(lsbId) {
						case 0xF69F2BEB: obj = (T)(new Component(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Component"
					}
				break;
				case 0x52F06268: 
					switch(lsbId) {
						case 0xCD098EFE: obj = (T)(new Iterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Iterator"
					}
				break;
				case 0x53601FD4: 
					switch(lsbId) {
						case 0x32E3DEF4: obj = (T)(new MeshNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MeshNode"
					}
				break;
				case 0x53E62FD6: 
					switch(lsbId) {
						case 0x7F4D9A65: obj = (T)(new FractNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::FractNode"
					}
				break;
				case 0x564DE421: 
					switch(lsbId) {
						case 0x7ED7614A: obj = (T)(new ComponentsObjectIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObjectIterator"
					}
				break;
				case 0x57A22369: 
					switch(lsbId) {
						case 0x98DF5248: obj = (T)(new AdditionNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::AdditionNode"
					}
				break;
				case 0x5950BB3E: 
					switch(lsbId) {
						case 0xE8A82090: obj = (T)(new TriangleSet(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::TriangleSet"
					}
				break;
				case 0x59BC328F: 
					switch(lsbId) {
						case 0x6FB5C5FF: obj = (T)(new CosNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::CosNode"
					}
				break;
				case 0x5A8164EC: 
					switch(lsbId) {
						case 0xEDB03F09: obj = (T)(new Model(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Model"
					}
				break;
				case 0x6079B12F: 
					switch(lsbId) {
						case 0xFF345D02: obj = (T)(new SubtractionNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::SubtractionNode"
					}
				break;
				case 0x627E2116: 
					switch(lsbId) {
						case 0x53E11D93: obj = (T)(new CeilNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::CeilNode"
					}
				break;
				case 0x63B3B461: 
					switch(lsbId) {
						case 0xB30B4BA5: obj = (T)(new BeamLattice(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::BeamLattice"
					}
				break;
				case 0x6522CF04: 
					switch(lsbId) {
						case 0xEB283FED: obj = (T)(new ComponentsObject(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObject"
					}
				break;
				case 0x6594B031: 
					switch(lsbId) {
						case 0xB6096238: obj = (T)(new SliceStack(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::SliceStack"
					}
				break;
				case 0x65E6EDD9: 
					switch(lsbId) {
						case 0x362C79CB: obj = (T)(new BaseMaterialGroupIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroupIterator"
					}
				break;
				case 0x68FB2D5F: 
					switch(lsbId) {
						case 0xFC4BA12A: obj = (T)(new BuildItem(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::BuildItem"
					}
				break;
				case 0x69684DB9: 
					switch(lsbId) {
						case 0x9FA813F6: obj = (T)(new SliceStackIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::SliceStackIterator"
					}
				break;
				case 0x6B641C70: 
					switch(lsbId) {
						case 0x60040BE3: obj = (T)(new AbsNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::AbsNode"
					}
				break;
				case 0x6CE54469: 
					switch(lsbId) {
						case 0xEEA83BC1: obj = (T)(new ImplicitFunction(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitFunction"
					}
				break;
				case 0x7570C43B: 
					switch(lsbId) {
						case 0x9721D0C0: obj = (T)(new MatVecMultiplicationNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MatVecMultiplicationNode"
					}
				break;
				case 0x7700AA17: 
					switch(lsbId) {
						case 0xCA1AC0F8: obj = (T)(new PowNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::PowNode"
					}
				break;
				case 0x77AF68C9: 
					switch(lsbId) {
						case 0x71B1485F: obj = (T)(new ClampNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ClampNode"
					}
				break;
				case 0x7DE3951B: 
					switch(lsbId) {
						case 0xA4C1064C: obj = (T)(new TwoInputNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::TwoInputNode"
					}
				break;
				case 0x7FB36B91: 
					switch(lsbId) {
						case 0xD4CE4671: obj = (T)(new ContentEncryptionParams(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ContentEncryptionParams"
					}
				break;
				case 0x817D2E56: 
					switch(lsbId) {
						case 0x6E73AA8F: obj = (T)(new NormalizeDistanceNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::NormalizeDistanceNode"
					}
				break;
				case 0x846AFDE9: 
					switch(lsbId) {
						case 0xA091E997: obj = (T)(new MinNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MinNode"
					}
				break;
				case 0x856632D0: 
					switch(lsbId) {
						case 0xBAF1D8B7: obj = (T)(new Base(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Base"
					}
				break;
				case 0x87740AD5: 
					switch(lsbId) {
						case 0x3454E0DF: obj = (T)(new Log10Node(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Log10Node"
					}
				break;
				case 0x8A45165E: 
					switch(lsbId) {
						case 0x6C9646D7: obj = (T)(new SignNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::SignNode"
					}
				break;
				case 0x8CE7A119: 
					switch(lsbId) {
						case 0x1A63A35D: obj = (T)(new Attachment(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Attachment"
					}
				break;
				case 0x9200586F: 
					switch(lsbId) {
						case 0xB91587A7: obj = (T)(new VolumeData(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeData"
					}
				break;
				case 0x943AF6AE: 
					switch(lsbId) {
						case 0x0EFD2B8A: obj = (T)(new ArcCosNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ArcCosNode"
					}
				break;
				case 0x9BD7D3C2: 
					switch(lsbId) {
						case 0x026B8CE8: obj = (T)(new FunctionFromImage3D(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionFromImage3D"
					}
				break;
				case 0x9C9363B3: 
					switch(lsbId) {
						case 0xF708D556: obj = (T)(new ConstVecNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ConstVecNode"
					}
				break;
				case 0x9EF9EB54: 
					switch(lsbId) {
						case 0xA53AA40D: obj = (T)(new ComposeMatrixNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ComposeMatrixNode"
					}
				break;
				case 0x9EFB2757: 
					switch(lsbId) {
						case 0xCA1A5231: obj = (T)(new Function(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Function"
					}
				break;
				case 0x9F831944: 
					switch(lsbId) {
						case 0xA3DE31DA: obj = (T)(new SqrtNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::SqrtNode"
					}
				break;
				case 0xA0C005C0: 
					switch(lsbId) {
						case 0x35D5371D: obj = (T)(new LevelSetIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::LevelSetIterator"
					}
				break;
				case 0xA3C27CF5: 
					switch(lsbId) {
						case 0x4C2AA76C: obj = (T)(new MultiplicationNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MultiplicationNode"
					}
				break;
				case 0xA7D21BD3: 
					switch(lsbId) {
						case 0x64910860: obj = (T)(new BuildItemIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::BuildItemIterator"
					}
				break;
				case 0xA808B759: 
					switch(lsbId) {
						case 0x9C158CE6: obj = (T)(new TransposeNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::TransposeNode"
					}
				break;
				case 0xA99CC6C3: 
					switch(lsbId) {
						case 0xF70FB6F9: obj = (T)(new CompositeMaterialsIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterialsIterator"
					}
				break;
				case 0xB19B9FDA: 
					switch(lsbId) {
						case 0x94B0A5E7: obj = (T)(new OneInputNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::OneInputNode"
					}
				break;
				case 0xB27D4656: 
					switch(lsbId) {
						case 0xE16609FA: obj = (T)(new BaseMaterialGroup(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroup"
					}
				break;
				case 0xB6153EF5: 
					switch(lsbId) {
						case 0xDE7E5E11: obj = (T)(new ArcTan2Node(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ArcTan2Node"
					}
				break;
				case 0xB896B641: 
					switch(lsbId) {
						case 0x3C08CF39: obj = (T)(new DivisionNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::DivisionNode"
					}
				break;
				case 0xB989E02E: 
					switch(lsbId) {
						case 0x43158FE6: obj = (T)(new MultiPropertyGroup(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroup"
					}
				break;
				case 0xBC120839: 
					switch(lsbId) {
						case 0x7E37055D: obj = (T)(new Texture2DGroup(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroup"
					}
				break;
				case 0xBD938FF2: 
					switch(lsbId) {
						case 0xD2663D61: obj = (T)(new Image3D(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Image3D"
					}
				break;
				case 0xC2BDF5D8: 
					switch(lsbId) {
						case 0xCBBDB1F0: obj = (T)(new MultiPropertyGroupIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroupIterator"
					}
				break;
				case 0xC4B8EC00: 
					switch(lsbId) {
						case 0xA82BF336: obj = (T)(new Image3DIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Image3DIterator"
					}
				break;
				case 0xC62268F2: 
					switch(lsbId) {
						case 0xD7C7012C: obj = (T)(new ImplicitPortIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitPortIterator"
					}
				break;
				case 0xCA86A77C: 
					switch(lsbId) {
						case 0x71CD3FAE: obj = (T)(new ResourceIdNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceIdNode"
					}
				break;
				case 0xCC4F8D56: 
					switch(lsbId) {
						case 0x1CCE35D4: obj = (T)(new DecomposeVectorNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::DecomposeVectorNode"
					}
				break;
				case 0xCE16224D: 
					switch(lsbId) {
						case 0x688B86F2: obj = (T)(new CompositeMaterials(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterials"
					}
				break;
				case 0xCF077B19: 
					switch(lsbId) {
						case 0xB0B78E9D: obj = (T)(new TanhNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::TanhNode"
					}
				break;
				case 0xD085FB2E: 
					switch(lsbId) {
						case 0x49CDB5B1: obj = (T)(new ColorGroup(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ColorGroup"
					}
				break;
				case 0xD17716D0: 
					switch(lsbId) {
						case 0x63DE2C22: obj = (T)(new MetaData(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MetaData"
					}
				break;
				case 0xD5906722: 
					switch(lsbId) {
						case 0x7E428AA4: obj = (T)(new ResourceDataGroup(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceDataGroup"
					}
				break;
				case 0xD5AEA50A: 
					switch(lsbId) {
						case 0x56306722: obj = (T)(new SinNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::SinNode"
					}
				break;
				case 0xD5C49B04: 
					switch(lsbId) {
						case 0xAF1963CD: obj = (T)(new ImplicitPort(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitPort"
					}
				break;
				case 0xD6DFD0A7: 
					switch(lsbId) {
						case 0xEB64AC33: obj = (T)(new MatrixFromRowsNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MatrixFromRowsNode"
					}
				break;
				case 0xD85889E2: 
					switch(lsbId) {
						case 0x739A74B1: obj = (T)(new LengthNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::LengthNode"
					}
				break;
				case 0xD85B5B61: 
					switch(lsbId) {
						case 0x43E787E3: obj = (T)(new VolumeDataColor(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataColor"
					}
				break;
				case 0xD9E46D5E: 
					switch(lsbId) {
						case 0x6D8118EE: obj = (T)(new Consumer(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Consumer"
					}
				break;
				case 0xD9F5A53C: 
					switch(lsbId) {
						case 0x657765AE: obj = (T)(new RoundNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::RoundNode"
					}
				break;
				case 0xDE92510B: 
					switch(lsbId) {
						case 0xD2112288: obj = (T)(new ObjectIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ObjectIterator"
					}
				break;
				case 0xDFE3889D: 
					switch(lsbId) {
						case 0x1B269CBB: obj = (T)(new Resource(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Resource"
					}
				break;
				case 0xE0441CF9: 
					switch(lsbId) {
						case 0x76B36319: obj = (T)(new Texture2D(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2D"
					}
				break;
				case 0xE47D5476: 
					switch(lsbId) {
						case 0x15816BAD: obj = (T)(new ArcTanNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ArcTanNode"
					}
				break;
				case 0xE554C8A7: 
					switch(lsbId) {
						case 0xE72AAF4D: obj = (T)(new ArcSinNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ArcSinNode"
					}
				break;
				case 0xE72592A7: 
					switch(lsbId) {
						case 0x725AB29B: obj = (T)(new ImplicitNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitNode"
					}
				break;
				case 0xE76F642F: 
					switch(lsbId) {
						case 0x363FD7E9: obj = (T)(new Writer(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Writer"
					}
				break;
				case 0xE8601F66: 
					switch(lsbId) {
						case 0xA23A0540: obj = (T)(new InverseNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::InverseNode"
					}
				break;
				case 0xE8A7D9C1: 
					switch(lsbId) {
						case 0x92EFD0E2: obj = (T)(new LevelSet(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::LevelSet"
					}
				break;
				case 0xE8C0ABF7: 
					switch(lsbId) {
						case 0xC5DC7068: obj = (T)(new Log2Node(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::Log2Node"
					}
				break;
				case 0xEA573358: 
					switch(lsbId) {
						case 0x49379F22: obj = (T)(new ModNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ModNode"
					}
				break;
				case 0xF4196034: 
					switch(lsbId) {
						case 0xE2B9FDE6: obj = (T)(new MeshObjectIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::MeshObjectIterator"
					}
				break;
				case 0xF85C90ED: 
					switch(lsbId) {
						case 0xCE6F90A4: obj = (T)(new ConstMatNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::ConstMatNode"
					}
				break;
				case 0xFC006BC8: 
					switch(lsbId) {
						case 0x88CAB4D0: obj = (T)(new NodeIterator(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::NodeIterator"
					}
				break;
				case 0xFC368AA4: 
					switch(lsbId) {
						case 0x4ACE42DA: obj = (T)(new VolumeDataProperty(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataProperty"
					}
				break;
				case 0xFE60932A: 
					switch(lsbId) {
						case 0x66375FAD: obj = (T)(new DotNode(this, handle)); break; // First 64 bits of SHA1 of a string: "Lib3MF::DotNode"
					}
				break;
				default: obj = cls.getDeclaredConstructor(cArg).newInstance(this, handle); break;
			}
			return obj;
		}
		catch(Exception e) {
			return null;
		}
	}
}

