/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class ResourceDataGroup extends Base {

	public ResourceDataGroup(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Sets the resourcedatagroup keyuuid
	 *
	 * @return The new resourcedatagroup keyuuid.
	 * @throws Lib3MFException
	 */
	public String getKeyUUID() throws Lib3MFException {
		Pointer bytesNeededUUID = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_resourcedatagroup_getkeyuuid.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededUUID, null}));
		int sizeUUID = bytesNeededUUID.getInt(0);
		Pointer bufferUUID = new Memory(sizeUUID);
		mWrapper.checkError(this, mWrapper.lib3mf_resourcedatagroup_getkeyuuid.invokeInt(new java.lang.Object[]{mHandle, sizeUUID, bytesNeededUUID, bufferUUID}));
		return new String(bufferUUID.getByteArray(0, sizeUUID - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Add accessright to resourcedatagroup element
	 *
	 * @param consumer The Consumer reference
	 * @param wrappingAlgorithm The key wrapping algorithm to be used
	 * @param mgfAlgorithm The mask generation function to be used
	 * @param digestMethod The digest mechanism to be used
	 * @return The acess right instance
	 * @throws Lib3MFException
	 */
	public AccessRight addAccessRight(Consumer consumer, Lib3MFWrapper.WrappingAlgorithm wrappingAlgorithm, Lib3MFWrapper.MgfAlgorithm mgfAlgorithm, Lib3MFWrapper.DigestMethod digestMethod) throws Lib3MFException {
		Pointer consumerHandle = null;
		if (consumer != null) {
			consumerHandle = consumer.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Consumer is a null value.");
		}
		Pointer bufferTheAccessRight = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_resourcedatagroup_addaccessright.invokeInt(new java.lang.Object[]{mHandle, consumerHandle, Lib3MFWrapper.EnumConversion.convertWrappingAlgorithmToConst(wrappingAlgorithm), Lib3MFWrapper.EnumConversion.convertMgfAlgorithmToConst(mgfAlgorithm), Lib3MFWrapper.EnumConversion.convertDigestMethodToConst(digestMethod), bufferTheAccessRight}));
		Pointer valueTheAccessRight = bufferTheAccessRight.getPointer(0);
		AccessRight theAccessRight = null;
		if (valueTheAccessRight == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "TheAccessRight was a null pointer");
		}
		theAccessRight = mWrapper.PolymorphicFactory(valueTheAccessRight, AccessRight.class);
		return theAccessRight;
	}

	/**
	 * Finds the AccessRight associated with a Consumer
	 *
	 * @param consumer The Consumer instance
	 * @return The AcessRight instance
	 * @throws Lib3MFException
	 */
	public AccessRight findAccessRightByConsumer(Consumer consumer) throws Lib3MFException {
		Pointer consumerHandle = null;
		if (consumer != null) {
			consumerHandle = consumer.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Consumer is a null value.");
		}
		Pointer bufferTheAccessRight = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_resourcedatagroup_findaccessrightbyconsumer.invokeInt(new java.lang.Object[]{mHandle, consumerHandle, bufferTheAccessRight}));
		Pointer valueTheAccessRight = bufferTheAccessRight.getPointer(0);
		AccessRight theAccessRight = null;
		if (valueTheAccessRight != Pointer.NULL) {
		  theAccessRight = mWrapper.PolymorphicFactory(valueTheAccessRight, AccessRight.class);
		}
		return theAccessRight;
	}

	/**
	 * Removes access from a Consumer on this resource data group
	 *
	 * @param consumer The Consumer instance
	 * @throws Lib3MFException
	 */
	public void removeAccessRight(Consumer consumer) throws Lib3MFException {
		Pointer consumerHandle = null;
		if (consumer != null) {
			consumerHandle = consumer.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Consumer is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_resourcedatagroup_removeaccessright.invokeInt(new java.lang.Object[]{mHandle, consumerHandle}));
	}


}

