local function choose( t ) return t[rnd.rnd(1,#t)] end
local function rnd_colour() return 'rgb('..rnd.rnd(0,255)..', '..rnd.rnd(0,255)..', '..rnd.rnd(0,255)..')' end
--local clothes_colour = { '#656565', '#BEBEBE', '#D78331', '#626769', '#4F9998', '#B9E0EB', '#3F3131', '#3A683B', '#304B72' }
local skin_colour = { '#F7C4C4', '#E6C7B8', '#c89393', '#B19878', '#975e5e', '#5e4024' }
local metal_colour = { '#5A6266', '#dc970f', '#aaa59c', '#995607', '#494C47' }
local eye_colour = { '#97CDEF', '#662e18', '#67b974', '#d6a568', '#7A5529', '#FF00FF' }
local hair_colour = { '#513928', '#b2a295', '#a99427', '#341f1f', '#8FB383', '#C31C1C', '#8FB383', '#C31C1C', rnd_colour() }
local nails_colour = { '#8FB383', '#C31C1C', rnd_colour() }
local lips_colour = { "#4F1B3F", "#E2AFAF", rnd_colour()}
local hair_svgs = {
   { back = "0_hair_back_ver1.svg", mid = "4_head_5_hair_mid_ver1.svg", front = false, },
   { back = "0_hair_back_ver2.svg", mid = "4_head_5_hair_mid_ver2.svg", front = "6_hair_front_ver2.svg", },
   { back = "0_hair_back_ver3.svg", mid = "4_head_5_hair_mid_ver3.svg", front = false, },
   { back = false,               mid = "4_head_5_hair_mid_ver4.svg", front = false, },
   { back = "0_hair_back_ver5.svg", mid = "4_head_5_hair_mid_ver5.svg", front = false, },
}
local clothes_svgs = {
   {
      back = false,
      mid = "3_clothes_ver1.svg",
      front = "5_hands_front_clothes_ver1.svg",
      lfront = false,
   }, {
      back = false,
      mid = "3_clothes_ver2.svg",
      front = "5_hands_front_clothes_ver2.svg",
      lfront = false,
   }, {
      back = false,
      mid = "3_clothes_ver3.svg",
      front = "5_hands_front_clothes_ver3.svg",
      lfront = false,
   }
}
return function ()
   local hair = choose(hair_svgs)
   local clothes = choose(clothes_svgs)
   local skin_index = rnd.rnd(1,#skin_colour)

   return {
      portraitview = {
         --Viewport is reference to the image coordinates
         viewxs = 50,
         viewys = 150,
         viewxe = 800,
         viewye = 600,
         -- Width and height are final render
         width  = 400,
         height = 300,
      },
      replace = {
         {"#aaaaaa", skin_colour[skin_index]}, -- skin
         {"#aaaaa0", "#F7C4C4"}, -- palm
         {"#cccccc", choose(hair_colour)}, -- hair
         {"#bbbbbb", choose(eye_colour)}, -- eye colour
         {"#ff0000", rnd_colour()}, -- clothes main
         {"#00ff00", rnd_colour()}, -- clothes secondary
         {"#0000ff", rnd_colour()}, -- clothes trim
         {"#0ffff0", choose(metal_colour)}, -- clothes metal
         {"#f0000f", choose(metal_colour)}, -- clothes dmetal
         {"#ababab", choose(lips_colour)}, -- lips
         {"#abcabc", choose(nails_colour)}, -- nails
      },
      hair.back,
      choose{
         "1_hand_right_back.svg",
      },
      clothes.back,
      choose{
         "2_body.svg",
      },
      clothes.mid,
      choose{
         "4_head_0_base_ver1.svg",
         "4_head_0_base_ver2.svg",
         "4_head_0_base_ver3.svg",
         "4_head_0_base_ver4.svg",
      }, choose{
         "4_head_1_mouth_ver1.svg",
         "4_head_1_mouth_ver2.svg",
         "4_head_1_mouth_ver3.svg",
         "4_head_1_mouth_ver4.svg",
      },
      choose{
         "4_head_2_eyes_ver1.svg",
         "4_head_2_eyes_ver2.svg",
         "4_head_2_eyes_ver3.svg",
         "4_head_2_eyes_ver4.svg",
      },
      choose{
         "4_head_3_nose_ver1.svg",
         "4_head_3_nose_ver2.svg",
         "4_head_3_nose_ver3.svg",
         "4_head_3_nose_ver4.svg",
      }, choose{
         "4_head_4_brows_holder_ver1.svg",
         "4_head_4_brows_holder_ver2.svg",
         "4_head_4_brows_holder_ver3.svg",
         "4_head_4_brows_holder_ver4.svg",
      },
      hair.mid,
      choose{
         "5_hands_front_base.svg",
      },
      clothes.front,
      hair.front,
   }
end
