local function choose( t ) return t[rnd.rnd(1,#t)] end
local function rnd_colour() return 'rgb('..rnd.rnd(0,255)..', '..rnd.rnd(0,255)..', '..rnd.rnd(0,255)..')' end
local clothes_colour = { '#656565', '#BEBEBE', '#D78331', '#626769', '#4F9998', '#B9E0EB', '#cbe3ee', '#e0893d', '#4362e5', '#3F3131', '#3A683B', '#304B72', '#e6dbbd', '#ad7d62', '#2b4f5e' }
local skin_colour = { '#F7C4C4', '#E6C7B8', '#c89393', '#B19878', '#975e5e', '#5e4024' }
local metal_colour = { '#5A6266', '#dc970f', '#aaa59c', '#995607', '#494C47' }
local eye_colour = { '#97CDEF', '#662e18', '#67b974', '#d6a568', '#7A5529', '#FF00FF' }
local hair_colour = { '#513928', '#b2a295', '#a99427', '#341f1f', '#8FB383', '#C31C1C', rnd_colour() }
local lips_colour = { "#4F1B3F", "#E2AFAF", rnd_colour()}
local hair_svgs = {
   { back = "0_hair_back_ver1.svg", mid = "7_head_5_hair_mid_ver1.svg", front = "8_hair_front_ver1.svg", },
   { back = "0_hair_back_ver2.svg", mid = false,                        front = "8_hair_front_ver2.svg", },
   { back = "0_hair_back_ver3.svg", mid = "7_head_5_hair_mid_ver3.svg", front = "8_hair_front_ver3.svg", },
   { back = "0_hair_back_ver4.svg", mid = "7_head_5_hair_mid_ver4.svg", front = "8_hair_front_ver4.svg", },
   { back = false, mid = false, front = false, },
}
local clothes_svgs = {
   {
      back = "1_hand_left_3_clothes_civ1.svg",
      mid = "3_clothes_civ1.svg",
      front = "5_right_hand_3_clothes_civ1.svg",
      lfront = false,
   }, {
      back = "1_hand_left_3_clothes_civ2.svg",
      mid = "3_clothes_civ2.svg",
      front = "5_right_hand_3_clothes_civ2.svg",
      lfront = "6_hand_left_front_3_clothes_civ2.svg",
   }, {
      back = false,
      mid = "3_clothes_civ3.svg",
      front = false,
      lfront = false,
   }
}
local skin_texture = {
   {
      tex_colour = 'transparent',
      hands_left = false,
      hands_right = false,
      hands_lfront = false,
      mouth = false,
      eyes = false,
   },
   {
      tex_colour = '#CEB6AA',
      hands_left = "1_hand_left_1_texture.svg",
      hands_right = "5_right_hand_1_texture.svg",
      hands_lfront = "6_hand_left_front_1_texture.svg",
      mouth = "7_head_1_mouth_texture.svg",
      eyes = "7_head_2_eyes_texture.svg",
   },
}
return function ()
   local hair = choose(hair_svgs)
   local clothes = choose(clothes_svgs)
   local texture = choose(skin_texture)
   return {
      portraitview = {
         --Viewport is reference to the image coordinates
         viewxs = 100,
         viewys = 50,
         viewxe = 800,
         viewye = 400,
         -- Width and height are final render
         width  = 400,
         height = 300,
      },
      replace = {
         {"#aaaaaa", choose(skin_colour)}, -- skin
         {"#cccccc", choose(hair_colour)}, -- hair
         {"#bbbbbb", choose(eye_colour)}, -- eye colour
         {"#ff0000", rnd_colour()}, -- clothes main
         {"#00ff00", rnd_colour()}, -- clothes secondary
         {"#0000ff", rnd_colour()}, -- clothes trim
         {"#0ffff0", choose(metal_colour)}, -- clothes metal
         {"#f0000f", choose(metal_colour)}, -- clothes dmetal
         {"#ababab", choose(lips_colour)}, -- lips
         {"#CEB6AA", texture.tex_colour}, -- texture
      },
      hair.back,
      choose{
         "1_hand_left_0_skin.svg",
      },
      texture.hands_left,
      choose{
         "1_hand_left_2_lines.svg",
      },
      clothes.back,
      choose{
         "2_body.svg",
      },
      clothes.mid,
      choose{
         false,
         "4_accessories_v1.svg",
         "4_accessories_v2.svg",
         "4_accessories_v3.svg",
      },
      choose{
         "5_right_hand_0_skin.svg",
      },
      texture.hands_right,
      choose{
         "5_right_hand_2_lines.svg",
      },
      clothes.front,
      choose{
         "6_hand_left_front_0_skin.svg",
      },
      texture.hands_lfront,
      choose{
         "6_hand_left_front_2_lines.svg",
      },
      clothes.lfront,
      choose{
         "7_head_0_base.svg",
      }, choose{
         "7_head_1_mouth_ver1.svg",
         "7_head_1_mouth_ver2.svg",
         "7_head_1_mouth_ver3.svg",
         "7_head_1_mouth_ver4.svg",
         "7_head_1_mouth_ver5.svg",
      },
      texture.mouth,
      choose{
         "7_head_2_eyes_ver1.svg",
         "7_head_2_eyes_ver2.svg",
         "7_head_2_eyes_ver3.svg",
      },
      texture.eyes,
      choose{
         "7_head_3_nose_ver1.svg",
         "7_head_3_nose_ver2.svg",
         "7_head_3_nose_ver3.svg",
      }, choose{
         "7_head_4_brows_holder_ver1.svg",
         "7_head_4_brows_holder_ver2.svg",
         "7_head_4_brows_holder_ver3.svg",
      },
      hair.mid,
      choose{
         "7_head_6_ears_ver1.svg",
         "7_head_6_ears_ver2.svg",
         "7_head_6_ears_ver3.svg",
      },
      hair.front,
   }
end
