---
title: "Base Ripper MK2"
cond: "return outfit.get([[Base Ripper MK2]]):known()"
---
<% o = outfit.get([[Base Ripper MK2]]) %>

<%
local lg = require "love.graphics"
local luatk = require "luatk"
function mainimg ( mw )
   return luatk.newImage( nil, -10, 0, 256, 256, lg.newImage(o:icon()), {
      frame = {0.05,0.05,0.05},
      bkg = {0,0,0},
   } )
end

function wgtdescription( mw, tw )
   return luatk.newText( nil, 10, 0, tw, nil, o:description( nil ) )
end

function wgtsummary( mw, tw )
   return luatk.newText( nil, 10, 0, tw, nil, o:summary( nil, true ) )
end
%>
<widget mainimg />

# <%= o:name() %>

<widget wgtdescription />

## Properties

<widget wgtsummary />

## Availability

<%
   local availability = {}
   for i,sys in ipairs(system.getAll()) do
      for j,spb in ipairs(sys:spobs()) do
         if spb:known() and inlist( spb:outfitsSold(), o ) then
            table.insert( availability, sys )
            break
         end
      end
   end
   table.sort( availability, function ( a, b )
      return a:jumpDist() < b:jumpDist()
   end )
%>
<% if #availability > 0 then %>
Places where <%= o:name() %> are sold are shown in #ggreen#0.
<% function map ( mw, tw )
   local luatk_map = require "luatk.map"
   local w = math.min( mw-200, tw-20 )
   local m = luatk_map.newMap( nil, 10, 0, w, w * 9 / 16, {
      binaryhighlight = function ( sys )
         if inlist( availability, sys ) then
            return true
         end
         return false
      end
   } )
   if #availability > 0 then
      m:center( availability[1]:pos(), true )
   end
   return m
end %>
<widget map />
<% else %>
You are not aware of anywhere where <%= o:name() %> are available for purchase.
<% end %>
