/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.VectorUtil;

public class KnnFloatVectorField
extends Field {
    private static FieldType createType(float[] v, VectorSimilarityFunction similarityFunction) {
        if (v == null) {
            throw new IllegalArgumentException("vector value must not be null");
        }
        int dimension = v.length;
        if (dimension == 0) {
            throw new IllegalArgumentException("cannot index an empty vector");
        }
        if (similarityFunction == null) {
            throw new IllegalArgumentException("similarity function must not be null");
        }
        FieldType type = new FieldType();
        type.setVectorAttributes(dimension, VectorEncoding.FLOAT32, similarityFunction);
        type.freeze();
        return type;
    }

    public static FieldType createFieldType(int dimension, VectorSimilarityFunction similarityFunction) {
        FieldType type = new FieldType();
        type.setVectorAttributes(dimension, VectorEncoding.FLOAT32, similarityFunction);
        type.freeze();
        return type;
    }

    public static Query newVectorQuery(String field, float[] queryVector, int k) {
        return new KnnFloatVectorQuery(field, queryVector, k);
    }

    public KnnFloatVectorField(String name, float[] vector, VectorSimilarityFunction similarityFunction) {
        super(name, KnnFloatVectorField.createType(vector, similarityFunction));
        this.fieldsData = VectorUtil.checkFinite(vector);
    }

    public KnnFloatVectorField(String name, float[] vector) {
        this(name, vector, VectorSimilarityFunction.EUCLIDEAN);
    }

    public KnnFloatVectorField(String name, float[] vector, FieldType fieldType) {
        super(name, fieldType);
        if (fieldType.vectorEncoding() != VectorEncoding.FLOAT32) {
            throw new IllegalArgumentException("Attempt to create a vector for field " + name + " using float[] but the field encoding is " + String.valueOf((Object)fieldType.vectorEncoding()));
        }
        Objects.requireNonNull(vector, "vector value must not be null");
        if (vector.length != fieldType.vectorDimension()) {
            throw new IllegalArgumentException("The number of vector dimensions does not match the field type");
        }
        this.fieldsData = VectorUtil.checkFinite(vector);
    }

    public float[] vectorValue() {
        return (float[])this.fieldsData;
    }

    public void setVectorValue(float[] value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (value.length != this.type.vectorDimension()) {
            throw new IllegalArgumentException("value length " + value.length + " must match field dimension " + this.type.vectorDimension());
        }
        this.fieldsData = value;
    }
}

