/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.agent;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.contextmanager.ContextManagementTemplate;

public class MLRegisterAgentRequest
extends ActionRequest {
    private final MLAgent mlAgent;

    public MLRegisterAgentRequest(MLAgent mlAgent) {
        this.mlAgent = mlAgent;
    }

    public MLRegisterAgentRequest(StreamInput in) throws IOException {
        super(in);
        this.mlAgent = new MLAgent(in);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.mlAgent == null) {
            exception = ValidateActions.addValidationError((String)"ML agent can't be null", exception);
        } else {
            if (this.mlAgent.getContextManagementName() != null && this.mlAgent.getContextManagement() != null) {
                exception = ValidateActions.addValidationError((String)"Cannot specify both context_management_name and context_management", (ActionRequestValidationException)exception);
            }
            if (this.mlAgent.getContextManagementName() != null) {
                exception = this.validateContextManagementTemplateName(this.mlAgent.getContextManagementName(), exception);
            }
            if (this.mlAgent.getContextManagement() != null) {
                exception = this.validateInlineContextManagement(this.mlAgent.getContextManagement(), exception);
            }
        }
        return exception;
    }

    private ActionRequestValidationException validateContextManagementTemplateName(String templateName, ActionRequestValidationException exception) {
        if (templateName == null || templateName.trim().isEmpty()) {
            exception = ValidateActions.addValidationError((String)"Context management template name cannot be null or empty", (ActionRequestValidationException)exception);
        } else if (templateName.length() > 256) {
            exception = ValidateActions.addValidationError((String)"Context management template name cannot exceed 256 characters", (ActionRequestValidationException)exception);
        } else if (!templateName.matches("^[a-zA-Z0-9._-]+$")) {
            exception = ValidateActions.addValidationError((String)"Context management template name can only contain letters, numbers, underscores, hyphens, and dots", (ActionRequestValidationException)exception);
        }
        return exception;
    }

    private ActionRequestValidationException validateInlineContextManagement(ContextManagementTemplate contextManagement, ActionRequestValidationException exception) {
        if (contextManagement.getHooks() != null) {
            for (String hookName : contextManagement.getHooks().keySet()) {
                if (this.isValidHookName(hookName)) continue;
                exception = ValidateActions.addValidationError((String)("Invalid hook name: " + hookName), (ActionRequestValidationException)exception);
            }
        }
        return exception;
    }

    private boolean isValidHookName(String hookName) {
        return hookName.equals("POST_TOOL") || hookName.equals("PRE_LLM") || hookName.equals("PRE_TOOL") || hookName.equals("POST_LLM");
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.mlAgent.writeTo(out);
    }

    /*
     * Exception decompiling
     */
    public static MLRegisterAgentRequest fromActionRequest(ActionRequest actionRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Generated
    public static MLRegisterAgentRequestBuilder builder() {
        return new MLRegisterAgentRequestBuilder();
    }

    @Generated
    public MLAgent getMlAgent() {
        return this.mlAgent;
    }

    @Generated
    public String toString() {
        return "MLRegisterAgentRequest(mlAgent=" + String.valueOf(this.getMlAgent()) + ")";
    }

    @Generated
    public static class MLRegisterAgentRequestBuilder {
        @Generated
        private MLAgent mlAgent;

        @Generated
        MLRegisterAgentRequestBuilder() {
        }

        @Generated
        public MLRegisterAgentRequestBuilder mlAgent(MLAgent mlAgent) {
            this.mlAgent = mlAgent;
            return this;
        }

        @Generated
        public MLRegisterAgentRequest build() {
            return new MLRegisterAgentRequest(this.mlAgent);
        }

        @Generated
        public String toString() {
            return "MLRegisterAgentRequest.MLRegisterAgentRequestBuilder(mlAgent=" + String.valueOf(this.mlAgent) + ")";
        }
    }
}

