/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework;

import com.intellij.ide.plugins.DependsSubDescriptor;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginDescriptorLoadingContext;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.testFramework.plugins.DslKt;
import com.intellij.platform.testFramework.plugins.PackagingKt;
import com.intellij.platform.testFramework.plugins.PluginSpec;
import com.intellij.platform.testFramework.plugins.PluginSpecBuilder;
import com.intellij.testFramework.IndexingTestUtil;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0005H\u0007\u001a\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0007\u001a\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u001a\u000e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u001b\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"StubBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "getStubBuildNumber", "()Lcom/intellij/openapi/util/BuildNumber;", "StubPluginDescriptorLoadingContext", "Lcom/intellij/ide/plugins/PluginDescriptorLoadingContext;", "getStubPluginDescriptorLoadingContext", "()Lcom/intellij/ide/plugins/PluginDescriptorLoadingContext;", "loadDescriptorInTest", "Lcom/intellij/ide/plugins/PluginMainDescriptor;", "fileOrDir", "Ljava/nio/file/Path;", "isBundled", "", "loadingContext", "loadExtensionWithText", "Lcom/intellij/openapi/Disposable;", "extensionTag", "", "ns", "loadPluginWithText", "pluginSpec", "Lcom/intellij/platform/testFramework/plugins/PluginSpec;", "pluginsDir", "setPluginClassLoaderForMainAndSubPlugins", "", "rootDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "classLoader", "Ljava/lang/ClassLoader;", "unloadAndUninstallPlugin", "descriptor", "intellij.platform.testFramework"})
public final class DynamicPluginTestUtilsKt {
    @NotNull
    public static final BuildNumber getStubBuildNumber() {
        BuildNumber buildNumber = BuildNumber.fromString((String)"2042.42");
        Intrinsics.checkNotNull((Object)buildNumber);
        return buildNumber;
    }

    @NotNull
    public static final PluginDescriptorLoadingContext getStubPluginDescriptorLoadingContext() {
        return new PluginDescriptorLoadingContext(DynamicPluginTestUtilsKt::_get_StubPluginDescriptorLoadingContext_$lambda$0, false, false, false, 14, null);
    }

    @JvmOverloads
    @NotNull
    public static final PluginMainDescriptor loadDescriptorInTest(@NotNull Path fileOrDir, boolean isBundled, @NotNull PluginDescriptorLoadingContext loadingContext) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        Intrinsics.checkNotNullParameter((Object)loadingContext, (String)"loadingContext");
        Assertions.assertThat((Path)fileOrDir).exists();
        PluginManagerCore.INSTANCE.getAndClearPluginLoadingErrors();
        PluginMainDescriptor result = PluginDescriptorLoader.loadDescriptorFromFileOrDirInTests((Path)fileOrDir, (PluginDescriptorLoadingContext)loadingContext, (boolean)isBundled);
        if (result == null) {
            Assertions.assertThat((List)PluginManagerCore.INSTANCE.getAndClearPluginLoadingErrors()).isNotEmpty();
            throw new AssertionError((Object)("Cannot load plugin from " + fileOrDir));
        }
        return result;
    }

    public static /* synthetic */ PluginMainDescriptor loadDescriptorInTest$default(Path path, boolean bl, PluginDescriptorLoadingContext pluginDescriptorLoadingContext, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            pluginDescriptorLoadingContext = DynamicPluginTestUtilsKt.getStubPluginDescriptorLoadingContext();
        }
        return DynamicPluginTestUtilsKt.loadDescriptorInTest(path, bl, pluginDescriptorLoadingContext);
    }

    @JvmOverloads
    @NotNull
    public static final Disposable loadExtensionWithText(@NotNull String extensionTag, @NotNull String ns) {
        Disposable disposable;
        Intrinsics.checkNotNullParameter((Object)extensionTag, (String)"extensionTag");
        Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
        PluginSpec pluginSpec = DslKt.plugin$default(null, arg_0 -> DynamicPluginTestUtilsKt.loadExtensionWithText$lambda$0(extensionTag, ns, arg_0), 1, null);
        Path path = FileUtil.createTempDirectory((String)"test", (String)"test", (boolean)true).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Disposable it = disposable = DynamicPluginTestUtilsKt.loadPluginWithText(pluginSpec, path);
        boolean bl = false;
        IndexingTestUtil.Companion.waitUntilIndexesAreReadyInAllOpenedProjects$default(IndexingTestUtil.Companion, null, 1, null);
        return disposable;
    }

    public static /* synthetic */ Disposable loadExtensionWithText$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "com.intellij";
        }
        return DynamicPluginTestUtilsKt.loadExtensionWithText(string, string2);
    }

    @NotNull
    public static final Disposable loadPluginWithText(@NotNull PluginSpec pluginSpec, @NotNull Path pluginsDir) {
        Intrinsics.checkNotNullParameter((Object)pluginSpec, (String)"pluginSpec");
        Intrinsics.checkNotNullParameter((Object)pluginsDir, (String)"pluginsDir");
        PluginMainDescriptor descriptor = DynamicPluginTestUtilsKt.loadDescriptorInTest(pluginSpec, pluginsDir);
        Assertions.assertThat((String)DynamicPlugins.INSTANCE.checkCanUnloadWithoutRestart((IdeaPluginDescriptorImpl)descriptor)).isNull();
        try {
            DynamicPlugins.loadPlugin$default((DynamicPlugins)DynamicPlugins.INSTANCE, (IdeaPluginDescriptorImpl)((IdeaPluginDescriptorImpl)descriptor), null, (int)2, null);
            IndexingTestUtil.Companion.waitUntilIndexesAreReadyInAllOpenedProjects$default(IndexingTestUtil.Companion, null, 1, null);
        }
        catch (Exception e) {
            DynamicPluginTestUtilsKt.unloadAndUninstallPlugin((IdeaPluginDescriptorImpl)descriptor);
            throw e;
        }
        return () -> DynamicPluginTestUtilsKt.loadPluginWithText$lambda$0(descriptor);
    }

    @NotNull
    public static final PluginMainDescriptor loadDescriptorInTest(@NotNull PluginSpec pluginSpec, @NotNull Path pluginsDir) {
        Intrinsics.checkNotNullParameter((Object)pluginSpec, (String)"pluginSpec");
        Intrinsics.checkNotNullParameter((Object)pluginsDir, (String)"pluginsDir");
        Path path = PackagingKt.buildDistribution$default(pluginSpec, pluginsDir, null, 2, null);
        return DynamicPluginTestUtilsKt.loadDescriptorInTest$default(path, false, null, 6, null);
    }

    public static final void setPluginClassLoaderForMainAndSubPlugins(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @Nullable ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)rootDescriptor, (String)"rootDescriptor");
        rootDescriptor.setPluginClassLoader(classLoader);
        for (PluginDependency dependency : rootDescriptor.getDependencies()) {
            DependsSubDescriptor it;
            if (dependency.getSubDescriptor() == null) continue;
            boolean bl = false;
            it.setPluginClassLoader(classLoader);
        }
    }

    public static final boolean unloadAndUninstallPlugin(@NotNull IdeaPluginDescriptorImpl descriptor) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        boolean it = bl = DynamicPlugins.INSTANCE.unloadPlugin(descriptor, new DynamicPlugins.UnloadPluginOptions(false, false, false, false, false, false, null, 126, null));
        boolean bl2 = false;
        IndexingTestUtil.Companion.waitUntilIndexesAreReadyInAllOpenedProjects$default(IndexingTestUtil.Companion, null, 1, null);
        return bl;
    }

    @JvmOverloads
    @NotNull
    public static final PluginMainDescriptor loadDescriptorInTest(@NotNull Path fileOrDir, boolean isBundled) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        return DynamicPluginTestUtilsKt.loadDescriptorInTest$default(fileOrDir, isBundled, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final PluginMainDescriptor loadDescriptorInTest(@NotNull Path fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        return DynamicPluginTestUtilsKt.loadDescriptorInTest$default(fileOrDir, false, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static final Disposable loadExtensionWithText(@NotNull String extensionTag) {
        Intrinsics.checkNotNullParameter((Object)extensionTag, (String)"extensionTag");
        return DynamicPluginTestUtilsKt.loadExtensionWithText$default(extensionTag, null, 2, null);
    }

    private static final BuildNumber _get_StubPluginDescriptorLoadingContext_$lambda$0() {
        return DynamicPluginTestUtilsKt.getStubBuildNumber();
    }

    private static final Unit loadExtensionWithText$lambda$0(String $extensionTag, String $ns, PluginSpecBuilder $this$plugin) {
        Intrinsics.checkNotNullParameter((Object)$this$plugin, (String)"$this$plugin");
        DslKt.dependsIntellijModulesLang($this$plugin);
        DslKt.extensions($this$plugin, $extensionTag, $ns);
        return Unit.INSTANCE;
    }

    private static final void loadPluginWithText$lambda$0(PluginMainDescriptor $descriptor) {
        String reason = DynamicPlugins.INSTANCE.checkCanUnloadWithoutRestart((IdeaPluginDescriptorImpl)$descriptor);
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> DynamicPluginTestUtilsKt.loadPluginWithText$lambda$0$0($descriptor), (int)1, null);
        Assertions.assertThat((String)reason).isNull();
    }

    private static final boolean loadPluginWithText$lambda$0$0(PluginMainDescriptor $descriptor) {
        return DynamicPluginTestUtilsKt.unloadAndUninstallPlugin((IdeaPluginDescriptorImpl)$descriptor);
    }
}

