/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridWidget;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.ui.table.TableGoToRowHelper;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class TablePositionWidgetHelper
implements GridWidget.GridWidgetHelper {
    private final TableResultView myTable;
    private final DataGrid myGrid;

    public TablePositionWidgetHelper(@NotNull TableResultView table2, @NotNull DataGrid grid) {
        if (table2 == null) {
            TablePositionWidgetHelper.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            TablePositionWidgetHelper.$$$reportNull$$$0(1);
        }
        this.myTable = table2;
        this.myGrid = grid;
        table2.putClientProperty("ResultViewPositionWidgetHelper", this);
    }

    @Override
    public @NotNull CompletableFuture<@NlsContexts.Label String> getText() {
        @NlsSafe StringBuilder sb = new StringBuilder();
        SelectionModel model2 = this.myGrid.getSelectionModel();
        int colNum = model2.getSelectedColumnCount();
        int rowNum = model2.getSelectedRowCount();
        if (colNum == 0 || rowNum == 0) {
            CompletableFuture<String> completableFuture = CompletableFuture.completedFuture("");
            if (completableFuture == null) {
                TablePositionWidgetHelper.$$$reportNull$$$0(2);
            }
            return completableFuture;
        }
        boolean editing = this.myGrid.isEditing();
        if (colNum > 1 || rowNum > 1) {
            int cellCount = colNum * rowNum;
            sb.append(cellCount).append(" ").append(DataGridBundle.message((String)"TablePositionWidgetHelper.cell", (Object[])new Object[]{Math.min(cellCount, 2)})).append(", ").append(rowNum).append(" ").append(DataGridBundle.message((String)"TablePositionWidgetHelper.row", (Object[])new Object[]{Math.min(rowNum, 2)}));
            if (editing) {
                CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(sb.toString());
                if (completableFuture == null) {
                    TablePositionWidgetHelper.$$$reportNull$$$0(3);
                }
                return completableFuture;
            }
            sb.append("     ");
        }
        if (editing) {
            CompletableFuture.completedFuture("");
        }
        TableGoToRowHelper.Counter counter = TableGoToRowHelper.Counter.get(this.myTable);
        int minRow = counter.verticalUnit(this.myGrid);
        int minColumn = counter.horizontalUnit(this.myGrid);
        if (minColumn == -1 || minRow == -1) {
            CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(sb.toString());
            if (completableFuture == null) {
                TablePositionWidgetHelper.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        sb.append(minRow + 1).append(":").append(minColumn + 1);
        CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(sb.toString());
        if (completableFuture == null) {
            TablePositionWidgetHelper.$$$reportNull$$$0(5);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/table/TablePositionWidgetHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/table/TablePositionWidgetHelper";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

