/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.json;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.Version;
import tools.jackson.core.base.ParserBase;
import tools.jackson.core.exc.InputCoercionException;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.io.NumberInput;
import tools.jackson.core.json.DupDetector;
import tools.jackson.core.json.JsonReadContext;
import tools.jackson.core.json.JsonReadFeature;
import tools.jackson.core.json.PackageVersion;
import tools.jackson.core.util.JacksonFeatureSet;

public abstract class JsonParserBase
extends ParserBase {
    private static final char[] NO_CHARS = new char[0];
    protected int _formatReadFeatures;
    protected JsonReadContext _streamReadContext;
    protected JsonToken _nextToken;
    private char[] _nameCopyBuffer = NO_CHARS;
    protected boolean _nameCopied;

    protected JsonParserBase(ObjectReadContext readCtxt, IOContext ctxt, int streamReadFeatures, int formatReadFeatures) {
        super(readCtxt, ctxt, streamReadFeatures);
        this._formatReadFeatures = formatReadFeatures;
        DupDetector dups = StreamReadFeature.STRICT_DUPLICATE_DETECTION.enabledIn(streamReadFeatures) ? DupDetector.rootDetector(this) : null;
        this._streamReadContext = JsonReadContext.createRootContext(dups);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> streamReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    @Override
    public TokenStreamContext streamReadContext() {
        return this._streamReadContext;
    }

    @Override
    public Object currentValue() {
        return this._streamReadContext.currentValue();
    }

    @Override
    public void assignCurrentValue(Object v) {
        this._streamReadContext.assignCurrentValue(v);
    }

    @Override
    public String currentName() {
        JsonReadContext parent;
        if ((this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) && (parent = this._streamReadContext.getParent()) != null) {
            return parent.currentName();
        }
        return this._streamReadContext.currentName();
    }

    @Override
    public boolean hasStringCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return true;
        }
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    protected void createChildArrayContext(int lineNr, int colNr) throws JacksonException {
        this._streamReadContext = this._streamReadContext.createChildArrayContext(lineNr, colNr);
        this._streamReadConstraints.validateNestingDepth(this._streamReadContext.getNestingDepth());
    }

    protected void createChildObjectContext(int lineNr, int colNr) throws JacksonException {
        this._streamReadContext = this._streamReadContext.createChildObjectContext(lineNr, colNr);
        this._streamReadConstraints.validateNestingDepth(this._streamReadContext.getNestingDepth());
    }

    @Override
    protected void _parseNumericValue(int expType) throws JacksonException, InputCoercionException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            int len = this._intLength;
            if (len <= 9) {
                int i;
                this._numberInt = i = this._textBuffer.contentsAsInt(this._numberNegative);
                this._numTypesValid = 1;
                return;
            }
            if (len <= 18) {
                long l = this._textBuffer.contentsAsLong(this._numberNegative);
                if (len == 10) {
                    if (this._numberNegative) {
                        if (l >= Integer.MIN_VALUE) {
                            this._numberInt = (int)l;
                            this._numTypesValid = 1;
                            return;
                        }
                    } else if (l <= Integer.MAX_VALUE) {
                        this._numberInt = (int)l;
                        this._numTypesValid = 1;
                        return;
                    }
                }
                this._numberLong = l;
                this._numTypesValid = 2;
                return;
            }
            if (len == 19) {
                char[] buf = this._textBuffer.getTextBuffer();
                int offset = this._textBuffer.getTextOffset();
                if (this._numberNegative) {
                    ++offset;
                }
                if (NumberInput.inLongRange(buf, offset, len, this._numberNegative)) {
                    this._numberLong = NumberInput.parseLong19(buf, offset, this._numberNegative);
                    this._numTypesValid = 2;
                    return;
                }
            }
            this._parseSlowInt(expType);
            return;
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            this._parseSlowFloat(expType);
            return;
        }
        throw this._constructNotNumericType(this._currToken, expType);
    }

    @Override
    protected int _parseIntValue() throws JacksonException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT && this._intLength <= 9) {
            int i;
            this._numberInt = i = this._textBuffer.contentsAsInt(this._numberNegative);
            this._numTypesValid = 1;
            return i;
        }
        this._parseNumericValue(1);
        if ((this._numTypesValid & 1) == 0) {
            this.convertNumberToInt();
        }
        return this._numberInt;
    }

    private void _parseSlowFloat(int expType) throws JacksonException {
        if (expType == 16) {
            this._numberBigDecimal = this._textBuffer.contentsAsDecimal(this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
            this._numTypesValid = 16;
        } else if (expType == 8) {
            this._numberDouble = this._textBuffer.contentsAsDouble(this.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
            this._numTypesValid = 8;
        } else if (expType == 32) {
            this._numberFloat = this._textBuffer.contentsAsFloat(this.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
            this._numTypesValid = 32;
        } else {
            this._numberDouble = 0.0;
            this._numberString = this._textBuffer.contentsAsString();
            this._numTypesValid = 8;
        }
    }

    private void _parseSlowInt(int expType) throws JacksonException {
        String numStr = this._textBuffer.contentsAsString();
        if (expType == 1 || expType == 2) {
            this._reportTooLongIntegral(expType, numStr);
        }
        if (expType == 8 || expType == 32) {
            this._numberString = numStr;
            this._numTypesValid = 8;
        } else {
            this._numberBigInt = null;
            this._numberString = numStr;
            this._numTypesValid = 4;
        }
    }

    protected void _reportTooLongIntegral(int expType, String rawNum) throws JacksonException {
        if (expType == 1) {
            this._reportOverflowInt(rawNum);
        }
        this._reportOverflowLong(rawNum);
    }

    public boolean isEnabled(JsonReadFeature f) {
        return f.enabledIn(this._formatReadFeatures);
    }

    protected char[] currentNameInBuffer() {
        if (this._nameCopied) {
            return this._nameCopyBuffer;
        }
        String name = this._streamReadContext.currentName();
        int nameLen = name.length();
        if (this._nameCopyBuffer.length < nameLen) {
            this._nameCopyBuffer = new char[Math.max(32, nameLen)];
        }
        name.getChars(0, nameLen, this._nameCopyBuffer, 0);
        this._nameCopied = true;
        return this._nameCopyBuffer;
    }

    protected char _handleUnrecognizedCharacterEscape(char ch) throws StreamReadException {
        if (this.isEnabled(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return ch;
        }
        if (ch == '\'' && this.isEnabled(JsonReadFeature.ALLOW_SINGLE_QUOTES)) {
            return ch;
        }
        throw this._constructReadException("Unrecognized character escape " + JsonParserBase._getCharDesc(ch), this._currentLocationMinusOne());
    }

    protected void _reportMismatchedEndMarker(int actCh, char expCh) throws StreamReadException {
        TokenStreamContext ctxt = this.streamReadContext();
        if (ctxt.inRoot()) {
            this._reportExtraEndMarker(actCh);
            return;
        }
        String msg = String.format("Unexpected close marker '%s': expected '%c' (for %s starting at %s)", Character.valueOf((char)actCh), Character.valueOf(expCh), ctxt.typeDesc(), ctxt.startLocation(this._contentReference()));
        throw this._constructReadException(msg, this._currentLocationMinusOne());
    }

    protected void _reportExtraEndMarker(int actCh) throws StreamReadException {
        String scopeDesc = actCh == 125 ? "Object" : "Array";
        String msg = String.format("Unexpected close marker '%s': no open %s to close", Character.valueOf((char)actCh), scopeDesc);
        throw this._constructReadException(msg, this._currentLocationMinusOne());
    }

    protected void _throwUnquotedSpace(int i, String ctxtDesc) throws StreamReadException {
        if (!this.isEnabled(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS) || i > 32) {
            char c = (char)i;
            String msg = "Illegal unquoted character (" + JsonParserBase._getCharDesc(c) + "): has to be escaped using backslash to be included in " + ctxtDesc;
            throw this._constructReadException(msg, this._currentLocationMinusOne());
        }
    }

    protected String _validJsonTokenList() {
        return this._validJsonValueList();
    }

    protected String _validJsonValueList() {
        if (this.isEnabled(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS)) {
            return "(JSON String, Number (or 'NaN'/'+INF'/'-INF'), Array, Object or token 'null', 'true' or 'false')";
        }
        return "(JSON String, Number, Array, Object or token 'null', 'true' or 'false')";
    }

    protected boolean _isAllowedCtrlCharRS(int i) {
        return i == 30 && JsonReadFeature.ALLOW_RS_CONTROL_CHAR.enabledIn(this._formatReadFeatures);
    }
}

