/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.help;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.SwingHelpUtilities;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.AddOnInstallationStatusListener;
import org.zaproxy.zap.extension.help.BasicOnlineContentViewerUI;
import org.zaproxy.zap.extension.help.ZapBasicSearchNavigatorUI;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.LocaleUtils;
import org.zaproxy.zap.utils.Stats;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionHelp
extends ExtensionAdaptor {
    private static final String HELP_SET_PROPERTY = "HelpSet";
    private static final String HELP_ID_PROPERTY = "HelpID";
    public static final String HELP_SET_FILE_NAME = "helpset";
    public static final String HELP_SET_FILE_EXTENSION = "hs";
    @Deprecated
    public static final ImageIcon HELP_ICON = View.isInitialised() ? ExtensionHelp.getHelpIcon() : null;
    private static ImageIcon helpIcon;
    private static final String NAME = "ExtensionHelp";
    private ZapMenuItem menuHelpZap = null;
    private JButton helpButton = null;
    private static HelpSet hs;
    private static HelpBroker hb;
    private static ActionListener showHelpActionListener;
    private static WeakHashMap<JComponent, String> componentsWithHelp;
    private static Map<AddOn, List<HelpSet>> addOnHelpSets;
    private static final Logger LOGGER;

    public ExtensionHelp() {
        super(NAME);
        this.setOrder(10000);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("help.name");
    }

    @Override
    public void initView(ViewDelegate view) {
        SwingHelpUtilities.setContentViewerUI((String)BasicOnlineContentViewerUI.class.getCanonicalName());
        UIManager.getDefaults().put("ZapHelpSearchNavigatorUI", ZapBasicSearchNavigatorUI.class.getCanonicalName());
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addHelpMenuItem(this.getMenuHelpZapUserGuide());
            extensionHook.getHookView().addMainToolBarComponent(new JToolBar.Separator());
            extensionHook.getHookView().addMainToolBarComponent(this.getHelpButton());
            ExtensionHelp.enableHelpKey(this.getView().getSiteTreePanel(), "ui.tabs.sites");
            ExtensionHelp.enableHelpKey(this.getView().getRequestPanel(), "ui.tabs.request");
            ExtensionHelp.enableHelpKey(this.getView().getResponsePanel(), "ui.tabs.response");
            this.setHelpEnabled(ExtensionHelp.getHelpBroker() != null);
            extensionHook.addAddOnInstallationStatusListener(new AddOnInstallationStatusListenerImpl());
        }
    }

    public boolean isHelpAvailable() {
        return hb != null;
    }

    private void setHelpEnabled(boolean enabled) {
        if (this.getView() == null) {
            return;
        }
        JRootPane rootPane = this.getView().getMainFrame().getRootPane();
        if (enabled && ExtensionHelp.findHelpSetUrl() != null) {
            ExtensionHelp.createHelpBroker();
            ExtensionHelp.loadAddOnHelpSets(ExtensionFactory.getAddOnLoader().getAddOnCollection().getInstalledAddOns());
            this.getMenuHelpZapUserGuide().addActionListener(showHelpActionListener);
            this.getMenuHelpZapUserGuide().setToolTipText(null);
            this.getMenuHelpZapUserGuide().setEnabled(true);
            hb.enableHelpKey((Component)rootPane, "zap.intro", hs, "javax.help.SecondaryWindow", null);
            for (Map.Entry<JComponent, String> entry : componentsWithHelp.entrySet()) {
                hb.enableHelp((Component)entry.getKey(), entry.getValue(), hs);
            }
            this.getHelpButton().setToolTipText(Constant.messages.getString("help.button.tooltip"));
            this.getHelpButton().setEnabled(true);
        } else {
            String toolTipNoHelp = Constant.messages.getString("help.error.nohelp");
            this.getMenuHelpZapUserGuide().setEnabled(false);
            this.getMenuHelpZapUserGuide().setToolTipText(toolTipNoHelp);
            this.getMenuHelpZapUserGuide().removeActionListener(showHelpActionListener);
            rootPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(156, 0));
            rootPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0));
            this.removeHelpProperties(rootPane);
            for (JComponent component : componentsWithHelp.keySet()) {
                this.removeHelpProperties(component);
            }
            this.getHelpButton().setEnabled(false);
            this.getHelpButton().setToolTipText(toolTipNoHelp);
            hb = null;
            hs = null;
            showHelpActionListener = null;
        }
    }

    private static void loadAddOnHelpSets(List<AddOn> addOns) {
        addOns.forEach(ExtensionHelp::loadAddOnHelpSet);
    }

    private static void loadAddOnHelpSet(AddOn addOn) {
        addOn.getLoadedExtensions().forEach(ExtensionHelp::loadExtensionHelpSet);
        AddOn.HelpSetData helpSetData = addOn.getHelpSetData();
        if (helpSetData.isEmpty()) {
            return;
        }
        ClassLoader classLoader = addOn.getClassLoader();
        URL helpSetUrl = LocaleUtils.findResource(helpSetData.getBaseName(), HELP_SET_FILE_EXTENSION, helpSetData.getLocaleToken(), Constant.getLocale(), classLoader::getResource);
        if (helpSetUrl == null) {
            LOGGER.error("Declared helpset not found for '{}' add-on, with base name: {} {}", (Object)addOn.getId(), (Object)helpSetData.getBaseName(), helpSetData.getLocaleToken().isEmpty() ? "" : " and locale token: " + helpSetData.getLocaleToken());
            return;
        }
        try {
            LOGGER.debug("Loading help for '{}' add-on and merging with core help.", (Object)addOn.getId());
            ExtensionHelp.addHelpSet(addOn, new HelpSet(classLoader, helpSetUrl));
        }
        catch (HelpSetException e) {
            LOGGER.error("An error occurred while adding help for '{}' add-on:", (Object)addOn.getId(), (Object)e);
        }
    }

    private static void addHelpSet(AddOn addOn, HelpSet helpSet) {
        hb.getHelpSet().add(helpSet);
        addOnHelpSets.computeIfAbsent(addOn, k -> new ArrayList()).add(helpSet);
    }

    private static void loadExtensionHelpSet(Extension ext) {
        URL helpSetUrl = ExtensionHelp.getExtensionHelpSetUrl(ext);
        if (helpSetUrl != null) {
            try {
                LOGGER.debug("Load help files for extension '{}' and merge with core help.", (Object)ext.getName());
                ExtensionHelp.addHelpSet(ext.getAddOn(), new HelpSet(ext.getClass().getClassLoader(), helpSetUrl));
            }
            catch (HelpSetException e) {
                LOGGER.error("An error occurred while adding help file of extension '{}': {}", (Object)ext.getName(), (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static URL getExtensionHelpSetUrl(Extension extension) {
        Package extPackage = extension.getClass().getPackage();
        String extensionPackage = extPackage != null ? extPackage.getName() + "." : "";
        String localeToken = "%LC%";
        Function<String, URL> getResource = extension.getClass().getClassLoader()::getResource;
        URL helpSetUrl = LocaleUtils.findResource(extensionPackage + "resources.help" + localeToken + ".helpset", HELP_SET_FILE_EXTENSION, localeToken, Constant.getLocale(), getResource);
        if (helpSetUrl == null) {
            helpSetUrl = LocaleUtils.findResource(extensionPackage + "resource.help" + localeToken + ".helpset", HELP_SET_FILE_EXTENSION, localeToken, Constant.getLocale(), getResource);
        }
        return helpSetUrl;
    }

    private void removeHelpProperties(JComponent component) {
        component.putClientProperty(HELP_ID_PROPERTY, null);
        component.putClientProperty(HELP_SET_PROPERTY, null);
    }

    public static HelpBroker getHelpBroker() {
        if (hb == null) {
            ExtensionHelp.createHelpBroker();
        }
        return hb;
    }

    private static synchronized void createHelpBroker() {
        if (hb == null) {
            try {
                URL hsUrl = ExtensionHelp.findHelpSetUrl();
                if (hsUrl != null) {
                    hs = new HelpSet((ClassLoader)ExtensionFactory.getAddOnLoader(), hsUrl);
                    hb = hs.createHelpBroker();
                    showHelpActionListener = new CSH.DisplayHelpFromFocus(hb);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static URL findHelpSetUrl() {
        return LocaleUtils.findResource(HELP_SET_FILE_NAME, HELP_SET_FILE_EXTENSION, Constant.getLocale(), r -> ExtensionFactory.getAddOnLoader().getResource((String)r));
    }

    public static void enableHelpKey(Component component, String id) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (componentsWithHelp == null) {
                componentsWithHelp = new WeakHashMap();
            }
            componentsWithHelp.put(jComponent, id);
        }
        if (hb != null) {
            hb.enableHelp(component, id, hs);
        }
    }

    public static void showHelp() {
        ExtensionHelp.showHelp("zap.intro");
    }

    public static void showHelp(String helpindex) {
        if (ExtensionHelp.getHelpBroker() == null) {
            return;
        }
        try {
            ExtensionHelp.getHelpBroker().showID(helpindex, "javax.help.SecondaryWindow", null);
        }
        catch (Exception e) {
            LOGGER.error("error loading help with index: {}", (Object)helpindex, (Object)e);
        }
    }

    private ZapMenuItem getMenuHelpZapUserGuide() {
        if (this.menuHelpZap == null) {
            this.menuHelpZap = new ZapMenuItem("help.menu.guide", KeyStroke.getKeyStroke(112, 0, false));
        }
        return this.menuHelpZap;
    }

    private JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton();
            this.helpButton.setIcon(ExtensionHelp.getHelpIcon());
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionHelp.showHelp();
                    Stats.incCounter("stats.ui.maintoolbar.button.help");
                }
            });
        }
        return this.helpButton;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("help.desc");
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    public static ImageIcon getHelpIcon() {
        if (helpIcon == null) {
            helpIcon = DisplayUtils.getScaledIcon(new ImageIcon(ExtensionHelp.class.getResource("/resource/icon/16/201.png")));
        }
        return helpIcon;
    }

    static {
        hs = null;
        hb = null;
        addOnHelpSets = new HashMap<AddOn, List<HelpSet>>();
        LOGGER = LogManager.getLogger(ExtensionHelp.class);
    }

    private class AddOnInstallationStatusListenerImpl
    implements AddOnInstallationStatusListener {
        private AddOnInstallationStatusListenerImpl() {
        }

        @Override
        public void update(AddOnInstallationStatusListener.StatusUpdate statusUpdate) {
            switch (statusUpdate.getStatus()) {
                case INSTALLED: {
                    this.installed(statusUpdate.getAddOn());
                    break;
                }
                case SOFT_UNINSTALLED: 
                case UNINSTALLED: {
                    this.uninstalled(statusUpdate.getAddOn());
                    break;
                }
            }
        }

        private void installed(AddOn addOn) {
            if (hb == null) {
                if (ExtensionHelp.findHelpSetUrl() != null) {
                    ExtensionHelp.this.setHelpEnabled(true);
                }
            } else {
                ExtensionHelp.loadAddOnHelpSet(addOn);
            }
        }

        private void uninstalled(AddOn addOn) {
            HelpBroker hbLocal = hb;
            if (hbLocal == null) {
                return;
            }
            if (ExtensionHelp.findHelpSetUrl() == null) {
                ExtensionHelp.this.setHelpEnabled(false);
            } else {
                addOnHelpSets.computeIfPresent(addOn, (k, helpsets) -> {
                    EventQueue.invokeLater(() -> helpsets.forEach(arg_0 -> ((HelpSet)hbLocal.getHelpSet()).remove(arg_0)));
                    return null;
                });
            }
        }
    }
}

