/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Namer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.internal.NamedDomainObjectContainerConfigureDelegate;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.Cast;
import org.gradle.internal.metaobject.ConfigureDelegate;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.internal.ConfigureUtil;
import org.jspecify.annotations.Nullable;

public abstract class AbstractNamedDomainObjectContainer<T>
extends DefaultNamedDomainObjectSet<T>
implements NamedDomainObjectContainer<T>,
HasPublicType {
    protected AbstractNamedDomainObjectContainer(Class<T> type, Instantiator instantiator, Namer<? super T> namer, CollectionCallbackActionDecorator callbackDecorator) {
        super(type, instantiator, namer, callbackDecorator);
    }

    protected AbstractNamedDomainObjectContainer(Class<T> type, Instantiator instantiator, CollectionCallbackActionDecorator callbackActionDecorator) {
        super(type, instantiator, Named.Namer.forType(type), callbackActionDecorator);
    }

    protected abstract T doCreate(String var1);

    public T create(String name) {
        this.assertCanMutate("create(String)");
        this.assertElementNotPresent(name);
        T object = this.doCreate(name);
        this.doAdd(object, this.getEventRegister().getAddActions());
        return object;
    }

    public T maybeCreate(String name) {
        Object item = this.findByName(name);
        if (item != null) {
            return item;
        }
        return this.create(name);
    }

    public T create(String name, Closure configureClosure) {
        this.assertCanMutate("create(String, Closure)");
        this.assertElementNotPresent(name);
        T object = this.doCreate(name);
        this.doAdd(object, this.getEventRegister().getAddActions());
        ConfigureUtil.configureUsing((Closure)configureClosure).execute(object);
        return object;
    }

    public T create(String name, Action<? super T> configureAction) throws InvalidUserDataException {
        this.assertCanMutate("create(String, Action)");
        this.assertElementNotPresent(name);
        T object = this.doCreate(name);
        this.doAdd(object, this.getEventRegister().getAddActions());
        configureAction.execute(object);
        return object;
    }

    protected ConfigureDelegate createConfigureDelegate(Closure configureClosure) {
        return new NamedDomainObjectContainerConfigureDelegate(configureClosure, this);
    }

    public AbstractNamedDomainObjectContainer<T> configure(Closure configureClosure) {
        ConfigureDelegate delegate = this.createConfigureDelegate(configureClosure);
        ConfigureUtil.configureSelf((Closure)configureClosure, (Object)this, (ConfigureDelegate)delegate);
        return this;
    }

    @Override
    public String getDisplayName() {
        return this.getTypeDisplayName() + " container";
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.parameterizedTypeOf((TypeOf)new TypeOf<NamedDomainObjectContainer<?>>(){}, (TypeOf[])new TypeOf[]{TypeOf.typeOf(this.getType())});
    }

    public NamedDomainObjectProvider<T> register(String name) throws InvalidUserDataException {
        this.assertCanMutate("register(String)");
        return this.createDomainObjectProvider(name, null);
    }

    public NamedDomainObjectProvider<T> register(String name, Action<? super T> configurationAction) throws InvalidUserDataException {
        this.assertCanMutate("register(String, Action)");
        return this.createDomainObjectProvider(name, configurationAction);
    }

    protected NamedDomainObjectProvider<T> createDomainObjectProvider(String name, @Nullable Action<? super T> configurationAction) {
        this.assertElementNotPresent(name);
        NamedDomainObjectProvider provider = (NamedDomainObjectProvider)Cast.uncheckedCast((Object)this.getInstantiator().newInstance(NamedDomainObjectCreatingProvider.class, new Object[]{this, name, this.getType(), configurationAction}));
        this.doAddLater(provider);
        return provider;
    }

    public class NamedDomainObjectCreatingProvider<I extends T>
    extends DefaultNamedDomainObjectCollection.AbstractDomainObjectCreatingProvider<I> {
        public NamedDomainObjectCreatingProvider(String name, @Nullable Class<I> type, Action<? super I> configureAction) {
            super(AbstractNamedDomainObjectContainer.this, name, type, configureAction);
        }

        @Override
        protected I createDomainObject() {
            return (I)Cast.uncheckedCast(AbstractNamedDomainObjectContainer.this.doCreate(this.getName()));
        }
    }
}

