/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.idea.AppMode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class AppModeAssertions {
    private AppModeAssertions() {
    }

    public static boolean isFrontend() {
        return PlatformUtils.isJetBrainsClient();
    }

    public static boolean isBackend() {
        return AppMode.isRemoteDevHost();
    }

    public static boolean isMonolith() {
        return !AppModeAssertions.isFrontend() && !AppModeAssertions.isBackend();
    }

    public static boolean checkFrontend() {
        return !AppModeAssertions.isBackend();
    }

    public static void assertFrontend(boolean hard) {
        if (AppModeAssertions.checkFrontend()) {
            return;
        }
        AppModeAssertionError e = new AppModeAssertionError("frontend");
        if (hard) {
            throw e;
        }
        Holder.LOG.error((Throwable)((Object)e));
    }

    public static boolean checkBackend() {
        return !AppModeAssertions.isFrontend();
    }

    public static void assertBackend(boolean hard) {
        if (AppModeAssertions.checkBackend()) {
            return;
        }
        AppModeAssertionError e = new AppModeAssertionError("backend");
        if (hard) {
            throw e;
        }
        Holder.LOG.error((Throwable)((Object)e));
    }

    static final class AppModeAssertionError
    extends AssertionError {
        AppModeAssertionError(@NotNull String expectedMode) {
            if (expectedMode == null) {
                AppModeAssertionError.$$$reportNull$$$0(0);
            }
            super((Object)("The operations is allowed only in " + expectedMode + "; Platform prefix: " + System.getProperty("idea.platform.prefix", "not defined") + "; getPlatformPrefix: " + PlatformUtils.getPlatformPrefix()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedMode", "com/intellij/idea/AppModeAssertions$AppModeAssertionError", "<init>"));
        }
    }

    private static final class Holder {
        private static final Logger LOG = Logger.getInstance(AppModeAssertions.class);

        private Holder() {
        }
    }
}

