/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Enhance pixels associated with a bright object (identified by a seed
pixel) where the bright object is surrounded by a darker object.


GrayscaleConnectedOpeningImageFilter is useful for enhancing bright objects that are surrounded by dark
borders. This filter makes it easier to threshold the image and
extract just the object of interest.

Geodesic morphology and the connected opening algorithm is described
in Chapter 6 of Pierre Soille's book "Morphological Image Analysis:
Principles and Applications", Second Edition, Springer, 2003.


See:
 GrayscaleGeodesicDilateImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::GrayscaleConnectedOpening for the procedural interface

 itk::GrayscaleConnectedOpeningImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleConnectedOpeningImageFilter.h
*/
public class GrayscaleConnectedOpeningImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected GrayscaleConnectedOpeningImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GrayscaleConnectedOpeningImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GrayscaleConnectedOpeningImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GrayscaleConnectedOpeningImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GrayscaleConnectedOpeningImageFilter::~GrayscaleConnectedOpeningImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GrayscaleConnectedOpeningImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GrayscaleConnectedOpeningImageFilter::GrayscaleConnectedOpeningImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GrayscaleConnectedOpeningImageFilter() {
    this(SimpleITKJNI.new_GrayscaleConnectedOpeningImageFilter(), true);
  }

  /**
Self&amp; itk::simple::GrayscaleConnectedOpeningImageFilter::SetSeed(std::vector&lt; unsigned int &gt; Seed)

Set/Get the seed pixel for the segmentation

*/
public  void setSeed(VectorUInt32 Seed) {
    SimpleITKJNI.GrayscaleConnectedOpeningImageFilter_setSeed(swigCPtr, this, VectorUInt32.getCPtr(Seed), Seed);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::GrayscaleConnectedOpeningImageFilter::GetSeed() const

Set/Get the seed pixel for the segmentation

*/
public  VectorUInt32 getSeed() {
    return new VectorUInt32(SimpleITKJNI.GrayscaleConnectedOpeningImageFilter_getSeed(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GrayscaleConnectedOpeningImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.GrayscaleConnectedOpeningImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::GrayscaleConnectedOpeningImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.GrayscaleConnectedOpeningImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GrayscaleConnectedOpeningImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.GrayscaleConnectedOpeningImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::GrayscaleConnectedOpeningImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.GrayscaleConnectedOpeningImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleConnectedOpeningImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GrayscaleConnectedOpeningImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleConnectedOpeningImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GrayscaleConnectedOpeningImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GrayscaleConnectedOpeningImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.GrayscaleConnectedOpeningImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
