/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryTransformer;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public interface SqmToSqlAstConverter
extends SemanticQueryWalker<Object>,
SqlAstCreationState {
    public Stack<Clause> getCurrentClauseStack();

    public Stack<SqmQueryPart> getSqmQueryPartStack();

    default public SqmQueryPart<?> getCurrentSqmQueryPart() {
        return this.getSqmQueryPartStack().getCurrent();
    }

    public void registerQueryTransformer(QueryTransformer var1);

    public @Nullable SqlAstJoinType getCurrentlyProcessingJoinType();

    public boolean isInTypeInference();

    public @Nullable MappingModelExpressible<?> resolveFunctionImpliedReturnType();

    public MappingModelExpressible<?> determineValueMapping(SqmExpression<?> var1);

    public Object visitWithInferredType(SqmVisitableNode var1, Supplier<MappingModelExpressible<?>> var2);

    public List<Expression> expandSelfRenderingFunctionMultiValueParameter(SqmParameter<?> var1);

    public Predicate visitNestedTopLevelPredicate(SqmPredicate var1);

    default public <S, M> M resolveMetadata(S source, Function<S, M> producer) {
        return producer.apply(source);
    }
}

