/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.JWTAuthorizationGrantValidationContext;
import org.keycloak.protocol.oidc.TokenExchangeContext;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.JWTAuthorizationGrantContext;
import org.keycloak.services.clientpolicy.context.TokenExchangeRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.utils.StringUtil;

public class JWTClaimEnforcerExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private final KeycloakSession session;
    private Configuration configuration;

    public JWTClaimEnforcerExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public String getProviderId() {
        return "jwt-claim-enforcer";
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case JWT_AUTHORIZATION_GRANT: {
                JWTAuthorizationGrantContext jwtAuthnGrantContext = (JWTAuthorizationGrantContext)context;
                JWTAuthorizationGrantValidationContext jwtContext = jwtAuthnGrantContext.getAuthorizationGrantContext();
                this.checkClaims(this.getAccessTokenMapFromJWTString(jwtContext.getAssertion()));
                break;
            }
            case TOKEN_EXCHANGE_REQUEST: {
                TokenExchangeContext tokenExchangeContext = ((TokenExchangeRequestContext)context).getTokenExchangeContext();
                if (!"urn:ietf:params:oauth:token-type:access_token".equals(tokenExchangeContext.getParams().getSubjectTokenType())) {
                    throw new ClientPolicyException("invalid_request", "Parameter 'subject_token' should be access_token for the executor");
                }
                this.checkClaims(this.getAccessTokenMapFromJWTString(tokenExchangeContext.getParams().getSubjectToken()));
            }
        }
    }

    private Map<String, Object> getAccessTokenMapFromJWTString(String jwt) throws ClientPolicyException {
        try {
            return (Map)new JWSInput(jwt).readJsonContent((TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JWSInputException e) {
            throw new ClientPolicyException("invalid_request", "JWT is not valid");
        }
    }

    private void checkClaims(Map<String, Object> tokenMap) throws ClientPolicyException {
        String claimName = this.configuration.getClaimName();
        if (claimName == null) {
            throw new ClientPolicyException("invalid_request", "Invalid configuration");
        }
        String allowedValue = this.configuration.getAllowedValue();
        Object claimValue = tokenMap.get(claimName);
        if (claimValue == null) {
            throw new ClientPolicyException("invalid_request", "Required claim '" + claimName + "' is missing from the token");
        }
        if (StringUtil.isBlank((String)allowedValue)) {
            return;
        }
        if (!this.isAllowedClaimType(claimValue)) {
            throw new ClientPolicyException("invalid_request", "Value type for claim '" + claimName + "' not allowed");
        }
        String stringValue = String.valueOf(claimValue);
        if (!stringValue.matches(allowedValue)) {
            throw new ClientPolicyException("invalid_request", "Value for claim '" + claimName + "' not allowed");
        }
    }

    private boolean isAllowedClaimType(Object claimValue) {
        return claimValue instanceof String || claimValue instanceof Number;
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="claim-name")
        protected String claimName;
        @JsonProperty(value="allowed-value")
        protected String allowedValue;

        public String getClaimName() {
            return this.claimName;
        }

        public void setClaimName(String claimName) {
            this.claimName = claimName;
        }

        public String getAllowedValue() {
            return this.allowedValue;
        }

        public void setAllowedValue(String allowedValue) {
            this.allowedValue = allowedValue;
        }
    }
}

