/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandRepeatWhile3
extends SingleLineCommand2<ActivityDiagram3> {
    public CommandRepeatWhile3() {
        super(CommandRepeatWhile3.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandRepeatWhile3.class.getName(), RegexLeaf.start(), new RegexLeaf("repeat"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("while"), RegexLeaf.spaceZeroOrMore(), new RegexOr(new RegexConcat(new RegexLeaf(1, "TEST3", "\\((.*?)\\)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "(is|equals?)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "WHEN3", "\\((.+?)\\)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "(not)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "OUT3", "\\((.+?)\\)")), new RegexConcat(new RegexLeaf(1, "TEST4", "\\((.*?)\\)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "(not)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "OUT4", "\\((.+?)\\)")), new RegexConcat(new RegexLeaf(1, "TEST2", "\\((.*?)\\)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "(is|equals?)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "WHEN2", "\\((.+?)\\)")), new RegexOptional((IRegex)new RegexLeaf(1, "TEST1", "\\((.*)\\)"))), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexOr(new RegexLeaf("->"), new RegexLeaf(1, "XCOLOR", "-\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|node|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,node|,thickness=\\d+)*(?:(?:;(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|node|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,node|,thickness=\\d+)*)*)*)\\]->")), RegexLeaf.spaceZeroOrMore(), new RegexOr(new RegexLeaf(1, "LABEL", "(.*)"), new RegexLeaf("")))), new RegexLeaf(";?"), RegexLeaf.spaceZeroOrMore(), StereotypePattern.optional("STEREO"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        Display test = Display.getWithNewlines(diagram.getPragma(), arg.getLazzy("TEST", 0));
        Display yes = Display.getWithNewlines(diagram.getPragma(), arg.getLazzy("WHEN", 0));
        Display out = Display.getWithNewlines(diagram.getPragma(), arg.getLazzy("OUT", 0));
        String colorString = arg.get("XCOLOR", 0);
        Rainbow rainbow = colorString == null ? Rainbow.none() : Rainbow.build(diagram.getSkinParam(), colorString, diagram.getSkinParam().colorArrowSeparationSpace());
        String stereo = arg.get("STEREO", 0);
        Stereotype stereotype = stereo != null ? Stereotype.build(stereo) : null;
        Display linkLabel = Display.getWithNewlines(diagram.getPragma(), arg.get("LABEL", 0));
        return diagram.repeatWhile(test, yes, out, linkLabel, rainbow, null, stereotype);
    }
}

