/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl.jcef;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefBrowserBuilder;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.ui.jcef.JBCefScrollbarsHelper;
import com.intellij.ui.jcef.utils.JBCefLocalRequestHandler;
import com.intellij.ui.jcef.utils.JBCefStreamResourceHandler;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceHandler;
import org.intellij.images.ImagesBundle;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.editor.impl.ImageFileEditorState;
import org.intellij.images.editor.impl.jcef.JCefImageViewer$ViewerState$;
import org.intellij.images.editor.impl.jcef.JCefImageViewer$ViewerState$Size$;
import org.intellij.images.editor.impl.jcef.JCefImageViewerUI;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.options.ZoomOptions;
import org.intellij.images.thumbnail.actions.ShowBorderAction;
import org.intellij.images.ui.ImageComponentDecorator;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 Q2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002QRB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0019\u0010\u001e\u001a\u00130\b\u00a2\u0006\u000e\b\u001f\u0012\n\b \u0012\u0006\b\n0!8\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020\u0006H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020-H\u0016J\b\u00102\u001a\u00020'H\u0016J\u0010\u00103\u001a\u00020'2\u0006\u00104\u001a\u000205H\u0016J\u0016\u00106\u001a\u00020'2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020$H\u0016J\u0010\u0010=\u001a\u00020'2\u0006\u0010<\u001a\u00020$H\u0016J\u0010\u0010>\u001a\u00020'2\u0006\u0010<\u001a\u00020$H\u0016J\b\u0010?\u001a\u00020$H\u0016J\u0010\u0010@\u001a\u00020$2\u0006\u0010A\u001a\u00020\bH\u0016J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020$H\u0016J\u0006\u0010E\u001a\u000208J\u0012\u0010F\u001a\u00020'2\b\b\u0001\u0010G\u001a\u00020\bH\u0002J\u0010\u0010K\u001a\u00020\b2\u0006\u0010L\u001a\u00020MH\u0002J\b\u0010N\u001a\u00020\bH\u0002J\b\u0010O\u001a\u00020\bH\u0002J\b\u0010P\u001a\u00020'H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020JX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lorg/intellij/images/editor/impl/jcef/JCefImageViewer;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lorg/intellij/images/ui/ImageComponentDecorator;", "myFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "mimeType", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "myDocument", "Lcom/intellij/openapi/editor/Document;", "myBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "myUIComponent", "Lorg/intellij/images/editor/impl/jcef/JCefImageViewerUI;", "myViewerStateJSQuery", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "myRequestHandler", "Lorg/cef/handler/CefRequestHandler;", "myLoadHandler", "Lorg/cef/handler/CefLoadHandler;", "myState", "Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState;", "myEditorState", "Lorg/intellij/images/editor/impl/ImageFileEditorState;", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getName", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "isModified", "", "isValid", "addPropertyChangeListener", "", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "getFile", "getState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "setState", "state", "dispose", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "setZoom", "scale", "", "at", "Ljava/awt/Point;", "setTransparencyChessboardVisible", "visible", "setGridVisible", "setBorderVisible", "isTransparencyChessboardVisible", "isEnabledForActionPlace", "place", "getZoomModel", "Lorg/intellij/images/editor/ImageZoomModel;", "isGridVisible", "getZoom", "execute", "script", "ZOOM_MODEL", "jsonParser", "Lkotlinx/serialization/json/Json;", "colorToCSS", "color", "Ljava/awt/Color;", "buildChessboardStyle", "buildGridStyle", "reloadStyles", "Companion", "ViewerState", "intellij.platform.images"})
@SourceDebugExtension(value={"SMAP\nJCefImageViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JCefImageViewer.kt\norg/intellij/images/editor/impl/jcef/JCefImageViewer\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,366:1\n222#2:367\n*S KotlinDebug\n*F\n+ 1 JCefImageViewer.kt\norg/intellij/images/editor/impl/jcef/JCefImageViewer\n*L\n247#1:367\n*E\n"})
public final class JCefImageViewer
extends UserDataHolderBase
implements FileEditor,
DocumentListener,
ImageComponentDecorator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final JBCefBrowser myBrowser;
    @NotNull
    private final JCefImageViewerUI myUIComponent;
    @NotNull
    private final JBCefJSQuery myViewerStateJSQuery;
    @NotNull
    private final CefRequestHandler myRequestHandler;
    @NotNull
    private final CefLoadHandler myLoadHandler;
    @NotNull
    private ViewerState myState;
    @NotNull
    private ImageFileEditorState myEditorState;
    @NotNull
    private final ImageZoomModel ZOOM_MODEL;
    @NotNull
    private final Json jsonParser;
    @NotNull
    private static final String NAME = "SvgViewer";
    @NotNull
    private static final String HOST_NAME = "localhost";
    @NotNull
    private static final String PROTOCOL = "http";
    @NotNull
    private static final String OVERLAY_SCROLLBARS_CSS_PATH = "/overlayscrollbars.css";
    @NotNull
    private static final String OVERLAY_SCROLLBARS_JS_PATH = "/overlayscrollbars.browser.es6.js";
    @NotNull
    private static final String VIEWER_PATH = "/index.html";
    @NotNull
    private static final String IMAGE_PATH = "/image";
    @NotNull
    private static final String SCROLLBARS_CSS_PATH = "/scrollbars.css";
    @NotNull
    private static final String CHESSBOARD_CSS_PATH = "/chessboard.css";
    @NotNull
    private static final String GRID_CSS_PATH = "/pixel_grid.css";
    @NotNull
    private static final String VIEWER_URL = "http://localhost/index.html";
    @NotNull
    private static final String IMAGE_URL = "http://localhost/image";
    @NotNull
    private static final String SCROLLBARS_STYLE_URL = "http://localhost/scrollbars.css";
    @NotNull
    private static final String CHESSBOARD_STYLE_URL = "http://localhost/chessboard.css";
    @NotNull
    private static final String GRID_STYLE_URL = "http://localhost/pixel_grid.css";
    @NotNull
    private static final JBCefClient ourCefClient;

    public JCefImageViewer(@NotNull VirtualFile myFile, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        this.myFile = myFile;
        Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
        Intrinsics.checkNotNull((Object)document);
        this.myDocument = document;
        JBCefBrowser jBCefBrowser = new JBCefBrowserBuilder().setClient(ourCefClient).setEnableOpenDevToolsMenuItem(Companion.isDebugMode()).build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        this.myBrowser = jBCefBrowser;
        this.myState = new ViewerState(null, 0.0, null, null, false, false, false, false, false, false, 1023, null);
        this.myEditorState = new ImageFileEditorState(OptionsManager.getInstance().getOptions().getEditorOptions().getTransparencyChessboardOptions().isShowDefault(), OptionsManager.getInstance().getOptions().getEditorOptions().getGridOptions().isShowDefault(), 1.0, false);
        this.ZOOM_MODEL = new ImageZoomModel(this){
            final /* synthetic */ JCefImageViewer this$0;
            {
                this.this$0 = $receiver;
            }

            public double getZoomFactor() {
                return JCefImageViewer.access$getMyState$p(this.this$0).getZoom();
            }

            public void setZoomFactor(double zoomFactor) {
                JCefImageViewer.access$execute(this.this$0, "setZoom(" + zoomFactor + ");");
            }

            public void fitZoomToWindow() {
                JCefImageViewer.access$execute(this.this$0, "fitToViewport();");
            }

            public void zoomOut() {
                JCefImageViewer.access$execute(this.this$0, "zoomOut();");
            }

            public void zoomIn() {
                JCefImageViewer.access$execute(this.this$0, "zoomIn();");
            }

            public void setZoomLevelChanged(boolean value) {
            }

            public boolean canZoomOut() {
                return JCefImageViewer.access$getMyState$p(this.this$0).getStatus() == ViewerState.Status.OK && JCefImageViewer.access$getMyState$p(this.this$0).getZoomOutPossible();
            }

            public boolean canZoomIn() {
                return JCefImageViewer.access$getMyState$p(this.this$0).getStatus() == ViewerState.Status.OK && JCefImageViewer.access$getMyState$p(this.this$0).getZoomInPossible();
            }

            public boolean isZoomLevelChanged() {
                return JCefImageViewer.access$getMyState$p(this.this$0).getStatus() == ViewerState.Status.ERROR || !JCefImageViewer.access$getMyState$p(this.this$0).getFittedToViewport();
            }
        };
        this.jsonParser = JsonKt.Json$default(null, JCefImageViewer::jsonParser$lambda$0, (int)1, null);
        this.myDocument.addDocumentListener((DocumentListener)this);
        this.myRequestHandler = (CefRequestHandler)new JBCefLocalRequestHandler(PROTOCOL, HOST_NAME);
        ((JBCefLocalRequestHandler)this.myRequestHandler).addResource(VIEWER_PATH, () -> JCefImageViewer._init_$lambda$0(this));
        ((JBCefLocalRequestHandler)this.myRequestHandler).addResource(OVERLAY_SCROLLBARS_CSS_PATH, () -> JCefImageViewer._init_$lambda$1(this));
        ((JBCefLocalRequestHandler)this.myRequestHandler).addResource(OVERLAY_SCROLLBARS_JS_PATH, () -> JCefImageViewer._init_$lambda$2(this));
        ((JBCefLocalRequestHandler)this.myRequestHandler).addResource(SCROLLBARS_CSS_PATH, () -> JCefImageViewer._init_$lambda$3(this));
        ((JBCefLocalRequestHandler)this.myRequestHandler).addResource(CHESSBOARD_CSS_PATH, () -> JCefImageViewer._init_$lambda$4(this));
        ((JBCefLocalRequestHandler)this.myRequestHandler).addResource(GRID_CSS_PATH, () -> JCefImageViewer._init_$lambda$5(this));
        ((JBCefLocalRequestHandler)this.myRequestHandler).addResource(IMAGE_PATH, () -> JCefImageViewer._init_$lambda$6(this, mimeType));
        ourCefClient.addRequestHandler(this.myRequestHandler, this.myBrowser.getCefBrowser());
        JComponent jComponent = this.myBrowser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        this.myUIComponent = new JCefImageViewerUI(jComponent, this);
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.myUIComponent);
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.myBrowser));
        JBCefBrowser jBCefBrowser2 = this.myBrowser;
        Intrinsics.checkNotNull((Object)jBCefBrowser2, (String)"null cannot be cast to non-null type com.intellij.ui.jcef.JBCefBrowserBase");
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)jBCefBrowser2));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        this.myViewerStateJSQuery = jBCefJSQuery;
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.myViewerStateJSQuery));
        this.myViewerStateJSQuery.addHandler(arg_0 -> JCefImageViewer._init_$lambda$8(arg_0 -> JCefImageViewer._init_$lambda$7(this, arg_0), arg_0));
        this.myLoadHandler = (CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                if (frame.isMain()) {
                    this.reloadStyles();
                    this.execute("sendInfo = function(info_text) {" + myViewerStateJSQuery.inject("info_text") + ";}");
                    this.execute("setImageUrl('http://localhost/image');");
                    this.setGridVisible(myEditorState.isGridVisible());
                    this.setTransparencyChessboardVisible(myEditorState.isBackgroundVisible());
                    this.setBorderVisible(ShowBorderAction.isBorderVisible());
                }
            }
        };
        ourCefClient.addLoadHandler(this.myLoadHandler, this.myBrowser.getCefBrowser());
        if (Companion.isDebugMode()) {
            this.myBrowser.loadURL("http://localhost/index.html?debug");
        } else {
            this.myBrowser.loadURL(VIEWER_URL);
        }
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        busConnection.subscribe(topic, arg_0 -> JCefImageViewer._init_$lambda$9(this, arg_0));
        Topic topic2 = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        busConnection.subscribe(topic2, arg_0 -> JCefImageViewer._init_$lambda$10(this, arg_0));
    }

    @NotNull
    public JComponent getComponent() {
        return this.myUIComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Component component = this.myBrowser.getCefBrowser().getUIComponent();
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        return (JComponent)component;
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return (FileEditorState)new ImageFileEditorState(this.myState.getChessboardEnabled(), this.myState.getGridEnabled(), this.myState.getZoom(), !this.myState.getRealSize());
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> JCefImageViewer.setState$lambda$0(this, state));
            return;
        }
        if (state instanceof ImageFileEditorState) {
            ZoomOptions options = OptionsManager.getInstance().getOptions().getEditorOptions().getZoomOptions();
            this.setTransparencyChessboardVisible(((ImageFileEditorState)state).isBackgroundVisible());
            this.setGridVisible(((ImageFileEditorState)state).isGridVisible());
            if (this.myState.getStatus() == ViewerState.Status.INIT) {
                this.myEditorState = (ImageFileEditorState)state;
                return;
            }
            if (!options.isSmartZooming()) {
                this.execute("setZoom(" + ((ImageFileEditorState)state).getZoomFactor() + ");");
            }
        }
    }

    public void dispose() {
        ourCefClient.removeRequestHandler(this.myRequestHandler, this.myBrowser.getCefBrowser());
        ourCefClient.removeLoadHandler(this.myLoadHandler, this.myBrowser.getCefBrowser());
        this.myDocument.removeDocumentListener((DocumentListener)this);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.execute("reload()");
    }

    public final void setZoom(double scale, @NotNull Point at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        this.execute("setZoom(" + scale + ", {'x': " + at.x + ", 'y': " + at.y + "});");
    }

    @Override
    public void setTransparencyChessboardVisible(boolean visible) {
        if (this.myState.getStatus() == ViewerState.Status.ERROR) {
            return;
        }
        this.execute("setChessboardVisible(" + (visible ? "true" : "false") + ");");
    }

    @Override
    public void setGridVisible(boolean visible) {
        if (this.myState.getStatus() == ViewerState.Status.ERROR) {
            return;
        }
        this.execute("setGridVisible(" + (visible ? "true" : "false") + ");");
    }

    @Override
    public void setBorderVisible(boolean visible) {
        this.execute("setBorderVisible(" + (visible ? "true" : "false") + ");");
    }

    @Override
    public boolean isTransparencyChessboardVisible() {
        return this.myState.getChessboardEnabled();
    }

    @Override
    public boolean isEnabledForActionPlace(@NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return !Intrinsics.areEqual((Object)"Images.Thumbnails", (Object)place);
    }

    @Override
    @NotNull
    public ImageZoomModel getZoomModel() {
        return this.ZOOM_MODEL;
    }

    @Override
    public boolean isGridVisible() {
        return this.myState.getStatus() == ViewerState.Status.OK && this.myState.getGridEnabled();
    }

    public final double getZoom() {
        return this.myState.getZoom();
    }

    private final void execute(@Language(value="javascript") String script) {
        this.myBrowser.runJavaScript(script, this.myBrowser.getCefBrowser().getURL(), 0);
    }

    private final String colorToCSS(Color color) {
        return "rgba(" + color.getRed() + ", " + color.getBlue() + ", " + color.getGreen() + ", " + (double)color.getAlpha() / 255.0 + ")";
    }

    private final String buildChessboardStyle() {
        TransparencyChessboardOptions options = OptionsManager.getInstance().getOptions().getEditorOptions().getTransparencyChessboardOptions();
        int cellSize = JBCefApp.normalizeScaledSize((int)options.getCellSize());
        Color color = options.getBlackColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBlackColor(...)");
        String blackColor = this.colorToCSS(color);
        Color color2 = options.getWhiteColor();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getWhiteColor(...)");
        String whiteColor = this.colorToCSS(color2);
        return StringsKt.trimIndent((String)("\n      #chessboard {\n        position: absolute;\n        width: 100%;\n        height: 100%;\n        background: repeating-conic-gradient(" + blackColor + " 0% 25%, " + whiteColor + " 0% 50%) 50% / " + cellSize * 2 + "px " + cellSize * 2 + "px;\n        background-position: 0 0;\n      }\n    "));
    }

    private final String buildGridStyle() {
        Color color = OptionsManager.getInstance().getOptions().getEditorOptions().getGridOptions().getLineColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getLineColor(...)");
        String color2 = this.colorToCSS(color);
        return StringsKt.trimIndent((String)("\n      #pixel_grid {\n        position: absolute;\n        width: 100%;\n        height: 100%;\n        margin: 0;\n        background-image: linear-gradient(to right, " + color2 + " 1px, transparent 1px),\n        linear-gradient(to bottom, " + color2 + " 1px, transparent 1px);\n        background-size: 1px 1px;\n        mix-blend-mode: normal;\n      }\n      "));
    }

    private final void reloadStyles() {
        this.execute("loadScrollbarsStyle('http://localhost/scrollbars.css');\nloadChessboardStyle('http://localhost/chessboard.css');\nloadPixelGridStyle('http://localhost/pixel_grid.css');");
    }

    private static final void setState$lambda$0(JCefImageViewer this$0, FileEditorState $state) {
        this$0.setState($state);
    }

    private static final Unit jsonParser$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    private static final CefResourceHandler _init_$lambda$0(JCefImageViewer this$0) {
        JBCefStreamResourceHandler jBCefStreamResourceHandler;
        InputStream inputStream = this$0.getClass().getResourceAsStream("resources/image_viewer.html");
        if (inputStream != null) {
            InputStream it = inputStream;
            boolean bl = false;
            jBCefStreamResourceHandler = new JBCefStreamResourceHandler(it, "text/html", (Disposable)this$0, null, 8, null);
        } else {
            jBCefStreamResourceHandler = null;
        }
        return (CefResourceHandler)jBCefStreamResourceHandler;
    }

    private static final CefResourceHandler _init_$lambda$1(JCefImageViewer this$0) {
        String string = JBCefScrollbarsHelper.getOverlayScrollbarsSourceCSS();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOverlayScrollbarsSourceCSS(...)");
        String string2 = string;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return (CefResourceHandler)new JBCefStreamResourceHandler((InputStream)new ByteArrayInputStream(byArray), "text/css", (Disposable)this$0, null, 8, null);
    }

    private static final CefResourceHandler _init_$lambda$2(JCefImageViewer this$0) {
        String string = JBCefScrollbarsHelper.getOverlayScrollbarsSourceJS();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOverlayScrollbarsSourceJS(...)");
        String string2 = string;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return (CefResourceHandler)new JBCefStreamResourceHandler((InputStream)new ByteArrayInputStream(byArray), "text/css", (Disposable)this$0, null, 8, null);
    }

    private static final CefResourceHandler _init_$lambda$3(JCefImageViewer this$0) {
        String string = JBCefScrollbarsHelper.getOverlayScrollbarStyle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOverlayScrollbarStyle(...)");
        String string2 = string;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return (CefResourceHandler)new JBCefStreamResourceHandler((InputStream)new ByteArrayInputStream(byArray), "text/css", (Disposable)this$0, null, 8, null);
    }

    private static final CefResourceHandler _init_$lambda$4(JCefImageViewer this$0) {
        String string = this$0.buildChessboardStyle();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return (CefResourceHandler)new JBCefStreamResourceHandler((InputStream)new ByteArrayInputStream(byArray), "text/css", (Disposable)this$0, null, 8, null);
    }

    private static final CefResourceHandler _init_$lambda$5(JCefImageViewer this$0) {
        String string = this$0.buildGridStyle();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return (CefResourceHandler)new JBCefStreamResourceHandler((InputStream)new ByteArrayInputStream(byArray), "text/css", (Disposable)this$0, null, 8, null);
    }

    private static final CefResourceHandler _init_$lambda$6(JCefImageViewer this$0, String $mimeType) {
        InputStream stream = null;
        try {
            InputStream inputStream;
            if (VirtualFileUtil.isTooLarge((VirtualFile)this$0.myFile)) {
                inputStream = this$0.myFile.getInputStream();
            } else {
                String string = this$0.myDocument.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = string;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                inputStream = new ByteArrayInputStream(byArray);
            }
            stream = inputStream;
        }
        catch (IOException e) {
            Logger.getInstance(JCefImageViewer.class).warn("Failed to read the file", (Throwable)e);
        }
        JBCefStreamResourceHandler resourceHandler = null;
        InputStream inputStream = stream;
        if (inputStream != null) {
            InputStream it = inputStream;
            boolean bl = false;
            try {
                resourceHandler = new JBCefStreamResourceHandler(it, $mimeType, (Disposable)this$0, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Security-Policy", (Object)"script-src 'none'")));
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            return (CefResourceHandler)resourceHandler;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final JBCefJSQuery.Response _init_$lambda$7(JCefImageViewer this$0, String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        ViewerState oldState = this$0.myState;
        try {
            void this_$iv;
            Json json = this$0.jsonParser;
            String string$iv = s;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            this$0.myState = (ViewerState)this_$iv.decodeFromString((DeserializationStrategy)ViewerState.Companion.serializer(), string$iv);
        }
        catch (Exception exception) {
            SwingUtilities.invokeLater(() -> JCefImageViewer.lambda$7$0(this$0));
            return new JBCefJSQuery.Response(null, 255, "Failed to parse the viewer state");
        }
        ZoomOptions zoomOptions = OptionsManager.getInstance().getOptions().getEditorOptions().getZoomOptions();
        if (oldState.getStatus() == ViewerState.Status.INIT && zoomOptions.isSmartZooming()) {
            Double zoomFactor = zoomOptions.getSmartZoomFactor(new Rectangle(new Point(0, 0), new Dimension(this$0.myState.getImageSize().getWidth(), this$0.myState.getImageSize().getHeight())), new Dimension(this$0.myState.getViewportSize().getWidth(), this$0.myState.getViewportSize().getHeight()), 5);
            this$0.execute("setZoom(" + zoomFactor + ");");
        }
        SwingUtilities.invokeLater(() -> JCefImageViewer.lambda$7$1(this$0));
        return new JBCefJSQuery.Response(null);
    }

    private static final void lambda$7$0(JCefImageViewer this$0) {
        this$0.myUIComponent.showError();
    }

    private static final void lambda$7$1(JCefImageViewer this$0) {
        if (this$0.myState.getStatus() == ViewerState.Status.OK) {
            JCefImageViewerUI jCefImageViewerUI = this$0.myUIComponent;
            Object[] objectArray = new Object[]{this$0.myState.getImageSize().getWidth(), this$0.myState.getImageSize().getHeight(), StringUtil.formatFileSize((long)this$0.myFile.getLength())};
            String string = ImagesBundle.message("image.info.svg", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            jCefImageViewerUI.setInfo(string);
        }
        if (this$0.myState.getStatus() == ViewerState.Status.ERROR) {
            this$0.myUIComponent.showError();
        } else {
            this$0.myUIComponent.showImage();
        }
    }

    private static final JBCefJSQuery.Response _init_$lambda$8(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$9(JCefImageViewer this$0, EditorColorsScheme it) {
        this$0.reloadStyles();
    }

    private static final void _init_$lambda$10(JCefImageViewer this$0, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.reloadStyles();
    }

    @JvmStatic
    public static final boolean isDebugMode() {
        return Companion.isDebugMode();
    }

    public static final /* synthetic */ ViewerState access$getMyState$p(JCefImageViewer $this) {
        return $this.myState;
    }

    static {
        JBCefClient jBCefClient = JBCefApp.getInstance().createClient();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefClient, (String)"createClient(...)");
        ourCefClient = jBCefClient;
        Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), (Disposable)((Disposable)ourCefClient));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$Companion;", "", "<init>", "()V", "NAME", "", "HOST_NAME", "PROTOCOL", "OVERLAY_SCROLLBARS_CSS_PATH", "OVERLAY_SCROLLBARS_JS_PATH", "VIEWER_PATH", "IMAGE_PATH", "SCROLLBARS_CSS_PATH", "CHESSBOARD_CSS_PATH", "GRID_CSS_PATH", "VIEWER_URL", "IMAGE_URL", "SCROLLBARS_STYLE_URL", "CHESSBOARD_STYLE_URL", "GRID_STYLE_URL", "ourCefClient", "Lcom/intellij/ui/jcef/JBCefClient;", "Lorg/jetbrains/annotations/NotNull;", "isDebugMode", "", "intellij.platform.images"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isDebugMode() {
            return RegistryManager.Companion.getInstance().is("ide.browser.jcef.svg-viewer.debug");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0083\b\u0018\u0000 @2\u00020\u0001:\u0004=>?@Bk\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\n\u0012\b\b\u0002\u0010\u000e\u001a\u00020\n\u0012\b\b\u0002\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011Bq\b\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0010\u0010\u0016J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0007H\u00c6\u0003J\t\u0010(\u001a\u00020\u0007H\u00c6\u0003J\t\u0010)\u001a\u00020\nH\u00c6\u0003J\t\u0010*\u001a\u00020\nH\u00c6\u0003J\t\u0010+\u001a\u00020\nH\u00c6\u0003J\t\u0010,\u001a\u00020\nH\u00c6\u0003J\t\u0010-\u001a\u00020\nH\u00c6\u0003J\t\u0010.\u001a\u00020\nH\u00c6\u0003Jm\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\nH\u00c6\u0001J\u0013\u00100\u001a\u00020\n2\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u00020\u0013H\u00d6\u0001J\t\u00103\u001a\u000204H\u00d6\u0001J%\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0001\u00a2\u0006\u0002\b<R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001fR\u0011\u0010\u000e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001f\u00a8\u0006A"}, d2={"Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState;", "", "status", "Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Status;", "zoom", "", "viewportSize", "Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Size;", "imageSize", "zoomInPossible", "", "zoomOutPossible", "fittedToViewport", "realSize", "gridEnabled", "chessboardEnabled", "<init>", "(Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Status;DLorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Size;Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Size;ZZZZZZ)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Status;DLorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Size;Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Size;ZZZZZZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getStatus", "()Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Status;", "getZoom", "()D", "getViewportSize", "()Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Size;", "getImageSize", "getZoomInPossible", "()Z", "getZoomOutPossible", "getFittedToViewport", "getRealSize", "getGridEnabled", "getChessboardEnabled", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_platform_images", "Status", "Size", "$serializer", "Companion", "intellij.platform.images"})
    private static final class ViewerState {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Status status;
        private final double zoom;
        @NotNull
        private final Size viewportSize;
        @NotNull
        private final Size imageSize;
        private final boolean zoomInPossible;
        private final boolean zoomOutPossible;
        private final boolean fittedToViewport;
        private final boolean realSize;
        private final boolean gridEnabled;
        private final boolean chessboardEnabled;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public ViewerState(@NotNull Status status, double zoom, @NotNull Size viewportSize, @NotNull Size imageSize, boolean zoomInPossible, boolean zoomOutPossible, boolean fittedToViewport, boolean realSize, boolean gridEnabled, boolean chessboardEnabled) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter((Object)viewportSize, (String)"viewportSize");
            Intrinsics.checkNotNullParameter((Object)imageSize, (String)"imageSize");
            this.status = status;
            this.zoom = zoom;
            this.viewportSize = viewportSize;
            this.imageSize = imageSize;
            this.zoomInPossible = zoomInPossible;
            this.zoomOutPossible = zoomOutPossible;
            this.fittedToViewport = fittedToViewport;
            this.realSize = realSize;
            this.gridEnabled = gridEnabled;
            this.chessboardEnabled = chessboardEnabled;
        }

        public /* synthetic */ ViewerState(Status status, double d, Size size, Size size2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                status = Status.INIT;
            }
            if ((n & 2) != 0) {
                d = 0.0;
            }
            if ((n & 4) != 0) {
                size = new Size(0, 0);
            }
            if ((n & 8) != 0) {
                size2 = new Size(0, 0);
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x20) != 0) {
                bl2 = false;
            }
            if ((n & 0x40) != 0) {
                bl3 = false;
            }
            if ((n & 0x80) != 0) {
                bl4 = false;
            }
            if ((n & 0x100) != 0) {
                bl5 = false;
            }
            if ((n & 0x200) != 0) {
                bl6 = false;
            }
            this(status, d, size, size2, bl, bl2, bl3, bl4, bl5, bl6);
        }

        @NotNull
        public final Status getStatus() {
            return this.status;
        }

        public final double getZoom() {
            return this.zoom;
        }

        @NotNull
        public final Size getViewportSize() {
            return this.viewportSize;
        }

        @NotNull
        public final Size getImageSize() {
            return this.imageSize;
        }

        public final boolean getZoomInPossible() {
            return this.zoomInPossible;
        }

        public final boolean getZoomOutPossible() {
            return this.zoomOutPossible;
        }

        public final boolean getFittedToViewport() {
            return this.fittedToViewport;
        }

        public final boolean getRealSize() {
            return this.realSize;
        }

        public final boolean getGridEnabled() {
            return this.gridEnabled;
        }

        public final boolean getChessboardEnabled() {
            return this.chessboardEnabled;
        }

        @NotNull
        public final Status component1() {
            return this.status;
        }

        public final double component2() {
            return this.zoom;
        }

        @NotNull
        public final Size component3() {
            return this.viewportSize;
        }

        @NotNull
        public final Size component4() {
            return this.imageSize;
        }

        public final boolean component5() {
            return this.zoomInPossible;
        }

        public final boolean component6() {
            return this.zoomOutPossible;
        }

        public final boolean component7() {
            return this.fittedToViewport;
        }

        public final boolean component8() {
            return this.realSize;
        }

        public final boolean component9() {
            return this.gridEnabled;
        }

        public final boolean component10() {
            return this.chessboardEnabled;
        }

        @NotNull
        public final ViewerState copy(@NotNull Status status, double zoom, @NotNull Size viewportSize, @NotNull Size imageSize, boolean zoomInPossible, boolean zoomOutPossible, boolean fittedToViewport, boolean realSize, boolean gridEnabled, boolean chessboardEnabled) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter((Object)viewportSize, (String)"viewportSize");
            Intrinsics.checkNotNullParameter((Object)imageSize, (String)"imageSize");
            return new ViewerState(status, zoom, viewportSize, imageSize, zoomInPossible, zoomOutPossible, fittedToViewport, realSize, gridEnabled, chessboardEnabled);
        }

        public static /* synthetic */ ViewerState copy$default(ViewerState viewerState, Status status, double d, Size size, Size size2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, Object object) {
            if ((n & 1) != 0) {
                status = viewerState.status;
            }
            if ((n & 2) != 0) {
                d = viewerState.zoom;
            }
            if ((n & 4) != 0) {
                size = viewerState.viewportSize;
            }
            if ((n & 8) != 0) {
                size2 = viewerState.imageSize;
            }
            if ((n & 0x10) != 0) {
                bl = viewerState.zoomInPossible;
            }
            if ((n & 0x20) != 0) {
                bl2 = viewerState.zoomOutPossible;
            }
            if ((n & 0x40) != 0) {
                bl3 = viewerState.fittedToViewport;
            }
            if ((n & 0x80) != 0) {
                bl4 = viewerState.realSize;
            }
            if ((n & 0x100) != 0) {
                bl5 = viewerState.gridEnabled;
            }
            if ((n & 0x200) != 0) {
                bl6 = viewerState.chessboardEnabled;
            }
            return viewerState.copy(status, d, size, size2, bl, bl2, bl3, bl4, bl5, bl6);
        }

        @NotNull
        public String toString() {
            return "ViewerState(status=" + this.status + ", zoom=" + this.zoom + ", viewportSize=" + this.viewportSize + ", imageSize=" + this.imageSize + ", zoomInPossible=" + this.zoomInPossible + ", zoomOutPossible=" + this.zoomOutPossible + ", fittedToViewport=" + this.fittedToViewport + ", realSize=" + this.realSize + ", gridEnabled=" + this.gridEnabled + ", chessboardEnabled=" + this.chessboardEnabled + ")";
        }

        public int hashCode() {
            int result = this.status.hashCode();
            result = result * 31 + Double.hashCode(this.zoom);
            result = result * 31 + this.viewportSize.hashCode();
            result = result * 31 + this.imageSize.hashCode();
            result = result * 31 + Boolean.hashCode(this.zoomInPossible);
            result = result * 31 + Boolean.hashCode(this.zoomOutPossible);
            result = result * 31 + Boolean.hashCode(this.fittedToViewport);
            result = result * 31 + Boolean.hashCode(this.realSize);
            result = result * 31 + Boolean.hashCode(this.gridEnabled);
            result = result * 31 + Boolean.hashCode(this.chessboardEnabled);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ViewerState)) {
                return false;
            }
            ViewerState viewerState = (ViewerState)other;
            if (this.status != viewerState.status) {
                return false;
            }
            if (Double.compare(this.zoom, viewerState.zoom) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.viewportSize, (Object)viewerState.viewportSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.imageSize, (Object)viewerState.imageSize)) {
                return false;
            }
            if (this.zoomInPossible != viewerState.zoomInPossible) {
                return false;
            }
            if (this.zoomOutPossible != viewerState.zoomOutPossible) {
                return false;
            }
            if (this.fittedToViewport != viewerState.fittedToViewport) {
                return false;
            }
            if (this.realSize != viewerState.realSize) {
                return false;
            }
            if (this.gridEnabled != viewerState.gridEnabled) {
                return false;
            }
            return this.chessboardEnabled == viewerState.chessboardEnabled;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_platform_images(ViewerState self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.status != Status.INIT) {
                output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), (Object)self.status);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : Double.compare(self.zoom, 0.0) != 0) {
                output.encodeDoubleElement(serialDesc, 1, self.zoom);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : !Intrinsics.areEqual((Object)self.viewportSize, (Object)new Size(0, 0))) {
                output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)ViewerState$Size$$serializer.INSTANCE, (Object)self.viewportSize);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : !Intrinsics.areEqual((Object)self.imageSize, (Object)new Size(0, 0))) {
                output.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)ViewerState$Size$$serializer.INSTANCE, (Object)self.imageSize);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.zoomInPossible) {
                output.encodeBooleanElement(serialDesc, 4, self.zoomInPossible);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.zoomOutPossible) {
                output.encodeBooleanElement(serialDesc, 5, self.zoomOutPossible);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 6) ? true : self.fittedToViewport) {
                output.encodeBooleanElement(serialDesc, 6, self.fittedToViewport);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : self.realSize) {
                output.encodeBooleanElement(serialDesc, 7, self.realSize);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 8) ? true : self.gridEnabled) {
                output.encodeBooleanElement(serialDesc, 8, self.gridEnabled);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 9) ? true : self.chessboardEnabled) {
                output.encodeBooleanElement(serialDesc, 9, self.chessboardEnabled);
            }
        }

        public /* synthetic */ ViewerState(int seen0, Status status, double zoom, Size viewportSize, Size imageSize, boolean zoomInPossible, boolean zoomOutPossible, boolean fittedToViewport, boolean realSize, boolean gridEnabled, boolean chessboardEnabled, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)ViewerState$$serializer.INSTANCE.getDescriptor());
            }
            this.status = (seen0 & 1) == 0 ? Status.INIT : status;
            this.zoom = (seen0 & 2) == 0 ? 0.0 : zoom;
            this.viewportSize = (seen0 & 4) == 0 ? new Size(0, 0) : viewportSize;
            this.imageSize = (seen0 & 8) == 0 ? new Size(0, 0) : imageSize;
            this.zoomInPossible = (seen0 & 0x10) == 0 ? false : zoomInPossible;
            this.zoomOutPossible = (seen0 & 0x20) == 0 ? false : zoomOutPossible;
            this.fittedToViewport = (seen0 & 0x40) == 0 ? false : fittedToViewport;
            this.realSize = (seen0 & 0x80) == 0 ? false : realSize;
            this.gridEnabled = (seen0 & 0x100) == 0 ? false : gridEnabled;
            this.chessboardEnabled = (seen0 & 0x200) == 0 ? false : chessboardEnabled;
        }

        public ViewerState() {
            this(null, 0.0, null, null, false, false, false, false, false, false, 1023, null);
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> Status.Companion.serializer()), null, null, null, null, null, null, null, null, null};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState;", "intellij.platform.images"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<ViewerState> serializer() {
                return (KSerializer)ViewerState$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Serializable
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0005\u0010\nJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006!"}, d2={"Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Size;", "", "width", "", "height", "<init>", "(II)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IIILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getWidth", "()I", "getHeight", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_platform_images", "$serializer", "Companion", "intellij.platform.images"})
        public static final class Size {
            @NotNull
            public static final Companion Companion = new Companion(null);
            private final int width;
            private final int height;

            public Size(int width, int height) {
                this.width = width;
                this.height = height;
            }

            public final int getWidth() {
                return this.width;
            }

            public final int getHeight() {
                return this.height;
            }

            public final int component1() {
                return this.width;
            }

            public final int component2() {
                return this.height;
            }

            @NotNull
            public final Size copy(int width, int height) {
                return new Size(width, height);
            }

            public static /* synthetic */ Size copy$default(Size size, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = size.width;
                }
                if ((n3 & 2) != 0) {
                    n2 = size.height;
                }
                return size.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "Size(width=" + this.width + ", height=" + this.height + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.width);
                result = result * 31 + Integer.hashCode(this.height);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Size)) {
                    return false;
                }
                Size size = (Size)other;
                if (this.width != size.width) {
                    return false;
                }
                return this.height == size.height;
            }

            @JvmStatic
            public static final /* synthetic */ void write$Self$intellij_platform_images(Size self, CompositeEncoder output, SerialDescriptor serialDesc) {
                output.encodeIntElement(serialDesc, 0, self.width);
                output.encodeIntElement(serialDesc, 1, self.height);
            }

            public /* synthetic */ Size(int seen0, int width, int height, SerializationConstructorMarker serializationConstructorMarker) {
                if (3 != (3 & seen0)) {
                    PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)ViewerState$Size$$serializer.INSTANCE.getDescriptor());
                }
                this.width = width;
                this.height = height;
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Size$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Size;", "intellij.platform.images"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final KSerializer<Size> serializer() {
                    return (KSerializer)ViewerState$Size$$serializer.INSTANCE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Serializable
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0087\u0081\u0002\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Status;", "", "<init>", "(Ljava/lang/String;I)V", "OK", "ERROR", "INIT", "Companion", "intellij.platform.images"})
        public static final class Status
        extends Enum<Status> {
            @NotNull
            public static final Companion Companion;
            @NotNull
            private static final Lazy<KSerializer<Object>> $cachedSerializer$delegate;
            public static final /* enum */ Status OK;
            public static final /* enum */ Status ERROR;
            public static final /* enum */ Status INIT;
            private static final /* synthetic */ Status[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Status[] values() {
                return (Status[])$VALUES.clone();
            }

            public static Status valueOf(String value) {
                return Enum.valueOf(Status.class, value);
            }

            @NotNull
            public static EnumEntries<Status> getEntries() {
                return $ENTRIES;
            }

            static {
                OK = new Status();
                ERROR = new Status();
                INIT = new Status();
                $VALUES = statusArray = new Status[]{Status.OK, Status.ERROR, Status.INIT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
                $cachedSerializer$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> EnumsKt.createSimpleEnumSerializer((String)"org.intellij.images.editor.impl.jcef.JCefImageViewer.ViewerState.Status", (Enum[])Status.values()));
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Status$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/intellij/images/editor/impl/jcef/JCefImageViewer$ViewerState$Status;", "intellij.platform.images"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final KSerializer<Status> serializer() {
                    return this.get$cachedSerializer();
                }

                private final /* synthetic */ KSerializer get$cachedSerializer() {
                    return (KSerializer)$cachedSerializer$delegate.getValue();
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

