/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.border.Border;
import org.jdesktop.swingx.graphics.GraphicsUtilities;

public class DropShadowBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 715287754750604058L;
    private static final Map<Double, Map<Position, BufferedImage>> CACHE = new HashMap<Double, Map<Position, BufferedImage>>();
    private Color shadowColor;
    private int shadowSize;
    private float shadowOpacity;
    private int cornerSize;
    private boolean showTopShadow;
    private boolean showLeftShadow;
    private boolean showBottomShadow;
    private boolean showRightShadow;

    public DropShadowBorder() {
        this(Color.BLACK, 5);
    }

    public DropShadowBorder(Color shadowColor, int shadowSize) {
        this(shadowColor, shadowSize, 0.5f, 12, false, false, true, true);
    }

    public DropShadowBorder(boolean showLeftShadow) {
        this(Color.BLACK, 5, 0.5f, 12, false, showLeftShadow, true, true);
    }

    public DropShadowBorder(Color shadowColor, int shadowSize, float shadowOpacity, int cornerSize, boolean showTopShadow, boolean showLeftShadow, boolean showBottomShadow, boolean showRightShadow) {
        this.shadowColor = shadowColor;
        this.shadowSize = shadowSize;
        this.shadowOpacity = shadowOpacity;
        this.cornerSize = cornerSize;
        this.showTopShadow = showTopShadow;
        this.showLeftShadow = showLeftShadow;
        this.showBottomShadow = showBottomShadow;
        this.showRightShadow = showRightShadow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics graphics, int x, int y, int width, int height) {
        long time = System.currentTimeMillis();
        Map<Position, BufferedImage> images = this.getImages((Graphics2D)graphics);
        Graphics2D g2 = (Graphics2D)graphics.create();
        try {
            int shadowOffset = 2;
            Point topLeftShadowPoint = null;
            if (this.showLeftShadow || this.showTopShadow) {
                topLeftShadowPoint = new Point();
                if (this.showLeftShadow && !this.showTopShadow) {
                    topLeftShadowPoint.setLocation(x, y + shadowOffset);
                } else if (this.showLeftShadow && this.showTopShadow) {
                    topLeftShadowPoint.setLocation(x, y);
                } else if (!this.showLeftShadow && this.showTopShadow) {
                    topLeftShadowPoint.setLocation(x + this.shadowSize, y);
                }
            }
            Point bottomLeftShadowPoint = null;
            if (this.showLeftShadow || this.showBottomShadow) {
                bottomLeftShadowPoint = new Point();
                if (this.showLeftShadow && !this.showBottomShadow) {
                    bottomLeftShadowPoint.setLocation(x, y + height - this.shadowSize - this.shadowSize);
                } else if (this.showLeftShadow && this.showBottomShadow) {
                    bottomLeftShadowPoint.setLocation(x, y + height - this.shadowSize);
                } else if (!this.showLeftShadow && this.showBottomShadow) {
                    bottomLeftShadowPoint.setLocation(x + this.shadowSize, y + height - this.shadowSize);
                }
            }
            Point bottomRightShadowPoint = null;
            if (this.showRightShadow || this.showBottomShadow) {
                bottomRightShadowPoint = new Point();
                if (this.showRightShadow && !this.showBottomShadow) {
                    bottomRightShadowPoint.setLocation(x + width - this.shadowSize, y + height - this.shadowSize - this.shadowSize);
                } else if (this.showRightShadow && this.showBottomShadow) {
                    bottomRightShadowPoint.setLocation(x + width - this.shadowSize, y + height - this.shadowSize);
                } else if (!this.showRightShadow && this.showBottomShadow) {
                    bottomRightShadowPoint.setLocation(x + width - this.shadowSize - this.shadowSize, y + height - this.shadowSize);
                }
            }
            Point topRightShadowPoint = null;
            if (this.showRightShadow || this.showTopShadow) {
                topRightShadowPoint = new Point();
                if (this.showRightShadow && !this.showTopShadow) {
                    topRightShadowPoint.setLocation(x + width - this.shadowSize, y + shadowOffset);
                } else if (this.showRightShadow && this.showTopShadow) {
                    topRightShadowPoint.setLocation(x + width - this.shadowSize, y);
                } else if (!this.showRightShadow && this.showTopShadow) {
                    topRightShadowPoint.setLocation(x + width - this.shadowSize - this.shadowSize, y);
                }
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            if (this.showLeftShadow) {
                Rectangle leftShadowRect = new Rectangle(x, topLeftShadowPoint.y + this.shadowSize, this.shadowSize, bottomLeftShadowPoint.y - topLeftShadowPoint.y - this.shadowSize);
                g2.drawImage(images.get((Object)Position.LEFT), leftShadowRect.x, leftShadowRect.y, leftShadowRect.width, leftShadowRect.height, null);
            }
            if (this.showBottomShadow) {
                Rectangle bottomShadowRect = new Rectangle(bottomLeftShadowPoint.x + this.shadowSize, y + height - this.shadowSize, bottomRightShadowPoint.x - bottomLeftShadowPoint.x - this.shadowSize, this.shadowSize);
                g2.drawImage(images.get((Object)Position.BOTTOM), bottomShadowRect.x, bottomShadowRect.y, bottomShadowRect.width, bottomShadowRect.height, null);
            }
            if (this.showRightShadow) {
                Rectangle rightShadowRect = new Rectangle(x + width - this.shadowSize, topRightShadowPoint.y + this.shadowSize, this.shadowSize, bottomRightShadowPoint.y - topRightShadowPoint.y - this.shadowSize);
                g2.drawImage(images.get((Object)Position.RIGHT), rightShadowRect.x, rightShadowRect.y, rightShadowRect.width, rightShadowRect.height, null);
            }
            if (this.showTopShadow) {
                Rectangle topShadowRect = new Rectangle(topLeftShadowPoint.x + this.shadowSize, y, topRightShadowPoint.x - topLeftShadowPoint.x - this.shadowSize, this.shadowSize);
                g2.drawImage(images.get((Object)Position.TOP), topShadowRect.x, topShadowRect.y, topShadowRect.width, topShadowRect.height, null);
            }
            if (this.showLeftShadow || this.showTopShadow) {
                g2.drawImage((Image)images.get((Object)Position.TOP_LEFT), topLeftShadowPoint.x, topLeftShadowPoint.y, null);
            }
            if (this.showLeftShadow || this.showBottomShadow) {
                g2.drawImage((Image)images.get((Object)Position.BOTTOM_LEFT), bottomLeftShadowPoint.x, bottomLeftShadowPoint.y, null);
            }
            if (this.showRightShadow || this.showBottomShadow) {
                g2.drawImage((Image)images.get((Object)Position.BOTTOM_RIGHT), bottomRightShadowPoint.x, bottomRightShadowPoint.y, null);
            }
            if (this.showRightShadow || this.showTopShadow) {
                g2.drawImage((Image)images.get((Object)Position.TOP_RIGHT), topRightShadowPoint.x, topRightShadowPoint.y, null);
            }
        }
        finally {
            g2.dispose();
        }
        System.out.println(System.currentTimeMillis() - time + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Position, BufferedImage> getImages(Graphics2D g2) {
        Map<Position, BufferedImage> images = CACHE.get((double)this.shadowSize + (double)this.shadowColor.hashCode() * 0.3 + (double)this.shadowOpacity * 0.12);
        if (images == null) {
            images = new HashMap<Position, BufferedImage>();
            int rectWidth = this.cornerSize + 1;
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, rectWidth, rectWidth, this.cornerSize, this.cornerSize);
            int imageWidth = rectWidth + this.shadowSize * 2;
            BufferedImage image = GraphicsUtilities.createCompatibleTranslucentImage(imageWidth, imageWidth);
            Graphics2D buffer = (Graphics2D)image.getGraphics();
            try {
                buffer.setPaint(new Color(this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), (int)(this.shadowOpacity * 255.0f)));
                buffer.translate(this.shadowSize, this.shadowSize);
                buffer.fill(rect);
            }
            finally {
                buffer.dispose();
            }
            float blurry = 1.0f / (float)(this.shadowSize * this.shadowSize);
            float[] blurKernel = new float[this.shadowSize * this.shadowSize];
            for (int i2 = 0; i2 < blurKernel.length; ++i2) {
                blurKernel[i2] = blurry;
            }
            ConvolveOp blur = new ConvolveOp(new Kernel(this.shadowSize, this.shadowSize, blurKernel));
            BufferedImage targetImage = GraphicsUtilities.createCompatibleTranslucentImage(imageWidth, imageWidth);
            ((Graphics2D)targetImage.getGraphics()).drawImage(image, blur, -(this.shadowSize / 2), -(this.shadowSize / 2));
            int x = 1;
            int y = 1;
            int w = this.shadowSize;
            int h = this.shadowSize;
            images.put(Position.TOP_LEFT, this.getSubImage(targetImage, x, y, w, h));
            x = 1;
            y = h;
            w = this.shadowSize;
            h = 1;
            images.put(Position.LEFT, this.getSubImage(targetImage, x, y, w, h));
            x = 1;
            y = rectWidth;
            w = this.shadowSize;
            h = this.shadowSize;
            images.put(Position.BOTTOM_LEFT, this.getSubImage(targetImage, x, y, w, h));
            x = this.cornerSize + 1;
            y = rectWidth;
            w = 1;
            h = this.shadowSize;
            images.put(Position.BOTTOM, this.getSubImage(targetImage, x, y, w, h));
            y = x = rectWidth;
            w = this.shadowSize;
            h = this.shadowSize;
            images.put(Position.BOTTOM_RIGHT, this.getSubImage(targetImage, x, y, w, h));
            x = rectWidth;
            y = this.cornerSize + 1;
            w = this.shadowSize;
            h = 1;
            images.put(Position.RIGHT, this.getSubImage(targetImage, x, y, w, h));
            x = rectWidth;
            y = 1;
            w = this.shadowSize;
            h = this.shadowSize;
            images.put(Position.TOP_RIGHT, this.getSubImage(targetImage, x, y, w, h));
            x = this.shadowSize;
            y = 1;
            w = 1;
            h = this.shadowSize;
            images.put(Position.TOP, this.getSubImage(targetImage, x, y, w, h));
            image.flush();
            CACHE.put((double)this.shadowSize + (double)this.shadowColor.hashCode() * 0.3 + (double)this.shadowOpacity * 0.12, images);
        }
        return images;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getSubImage(BufferedImage img, int x, int y, int w, int h) {
        BufferedImage ret = GraphicsUtilities.createCompatibleTranslucentImage(w, h);
        Graphics2D g2 = ret.createGraphics();
        try {
            g2.drawImage(img, 0, 0, w, h, x, y, x + w, y + h, null);
        }
        finally {
            g2.dispose();
        }
        return ret;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int top = this.showTopShadow ? this.shadowSize : 0;
        int left = this.showLeftShadow ? this.shadowSize : 0;
        int bottom = this.showBottomShadow ? this.shadowSize : 0;
        int right = this.showRightShadow ? this.shadowSize : 0;
        return new Insets(top, left, bottom, right);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public boolean isShowTopShadow() {
        return this.showTopShadow;
    }

    public boolean isShowLeftShadow() {
        return this.showLeftShadow;
    }

    public boolean isShowRightShadow() {
        return this.showRightShadow;
    }

    public boolean isShowBottomShadow() {
        return this.showBottomShadow;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    public void setShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
    }

    public void setShadowSize(int shadowSize) {
        this.shadowSize = shadowSize;
    }

    public void setShadowOpacity(float shadowOpacity) {
        this.shadowOpacity = shadowOpacity;
    }

    public void setCornerSize(int cornerSize) {
        this.cornerSize = cornerSize;
    }

    public void setShowTopShadow(boolean showTopShadow) {
        this.showTopShadow = showTopShadow;
    }

    public void setShowLeftShadow(boolean showLeftShadow) {
        this.showLeftShadow = showLeftShadow;
    }

    public void setShowBottomShadow(boolean showBottomShadow) {
        this.showBottomShadow = showBottomShadow;
    }

    public void setShowRightShadow(boolean showRightShadow) {
        this.showRightShadow = showRightShadow;
    }

    private static enum Position {
        TOP,
        TOP_LEFT,
        LEFT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT,
        RIGHT,
        TOP_RIGHT;

    }
}

